%
% Author: Juergen Vigna
%
% Defining some modifications and some new Commands for an
% italian version to write letters.
%
\LoadClass[a4paper,12pt,final]{letter}
\ProvidesClass{iletter}
              [1996/07/31 v1.1 Standard LaTeX document class]
%Grundzeilenabstand 1/6in = 4,23mm (DIN 2107,2142)
\newdimen\GZA
\GZA=1in
\divide\GZA by 6
\newcommand{\citta}[1]{\def\citta{\ignorespaces #1}}
\newcommand{\oggetto}[1]{\def\oggetto{\ignorespaces #1}}
%Nuova definizione del commando opening
\renewcommand*{\opening}[1]{\thispagestyle{empty}%
 \unitlength1mm
 \begin{picture}(0,0)
   %Absenderadresse und Datum
   \put(0,12.69){%
   \parbox[t]{1\textwidth}{\parbox[t]{3in}{\fromaddress}}}
   %Empfaengeradresse
   \put(90,-21.15){\parbox[t]{3in}{\mbox{}\par\toname \\ \toaddress}}
 \end{picture}%
 %Anpassung fuer Oggetto
 \mbox{}\par
 \vspace{-1\parskip}
 \vspace{14\GZA}
 \ifx\@empty\citta
 \relax
 \else \citta \fi
 , \@date

 %Anpassung wegen der verschiedenen Grundzeilenabstaende
 \ifcase\@ptsize\vspace{0.045pt}\or\vspace{-1.555pt}\or\vspace{-2.955pt}\or\fi
 Oggetto: \oggetto \mbox{} \par
 \vspace{-1\parskip}
 \vspace{2\GZA}
 %Anpassung wegen der verschiedenen Grundzeilenabstaende
 \ifcase\@ptsize\vspace{0.045pt}\or\vspace{-1.555pt}\or\vspace{-2.955pt}\or\fi
 \newcommand{\Apertura}{#1}
 \ifx\Apertura\empty \else #1\par\fi\nobreak}
% Redefinizione del commando closing
\renewcommand{\closing}[1]{\par\nobreak\vspace{\parskip}%
  \stopbreaks
  \noindent
  \ignorespaces #1\\[6\medskipamount]%
  \ifx\@empty\fromaddress\else
  \hspace*{\longindentation}\fi
  \parbox{\indentedwidth}{\raggedright
       \ifx\@empty\fromsig
           \fromname
       \else \fromsig \fi\strut}%
   \par}
