.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.00",
.\"     date            = "12 March 1995",
.\"     time            = "11:28:55 MST",
.\"     filename        = "dcl2inc.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "46539 162 737 5565",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "Fortran, type declarations",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the dcl2inc utility, a program for
.\"                        postprocessing ftnchek .dcl files to
.\"                        extract COMMON blocks into separate include
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.TH DCL2INC 1 "12 March 1995" "Version 1.00"
.\"======================================================================
.SH NAME
dcl2inc \- postprocess ftnchek .dcl files to create separate INCLUDE files
.\"======================================================================
.SH SYNOPSIS
.B dcl2inc
.I *.dcl
.\"======================================================================
.SH DESCRIPTION
.B dcl2inc
postprocessing declaration files output by
.BR ftnchek (1),
replacing unique COMMON block definitions by Fortran
.I INCLUDE
statements.  For each
input
.I .dcl
file, a modified output
.I .dcn
file is produced, together with include files named by the COMMON
block name, with filename extension
.IR .inc .
.PP
In addition,
.B dcl2inc
produces on
.I stdout
a list of
.I Makefile
dependencies for the UNIX
.BR make (1)
utility.  These can be appended to the project
.I Makefile
to ensure that any subsequent changes to
.I .inc
files provoke recompilation of source files that include them.
.PP
.B dcl2inc
warns about COMMONs which differ from their first occurrence, and
simply copies them to the output
.I .dcn
file, instead of replacing them with an INCLUDE statement.  Thus, any
COMMON statements that are found in the output
.I .dcn
files should be examined carefully to determine why they differ: they
may well be in error.
.PP
Replication of identical data, and bugs arising from subsequent
modification of only part of it, is a significant reason why Fortran
programming projects should
.I require
that COMMON declarations occur in separate include files, so that
there is only a
.I single
point of definition of any global object.
.PP
Even though the Fortran
.I INCLUDE
statement was tragically omitted from the 1977 Standard, it has long
been implemented by virtually all compiler vendors, and is part of the
1990 Standard.  In practice, there is therefore no portability problem
associated with use of INCLUDE statements,
.I provided
that one avoids nonportable file names.  As long as the code obeys
Fortran's limit of six-character alphanumeric names, the filenames
generated by
.B dcl2inc
will be acceptable on all current popular operating systems.
.PP
Fortran's default, or IMPLICIT, variable typing is deprecated in
modern programming languages, because it encourages sloppy
documentation, and worse, bugs due to misspelled variables, or
variables that have been truncated because they extend past column 72.
If all variables used are explicitly typed, and a compiler option is
used to reject all program units with untyped variables, variable
spelling and truncation errors can be eliminated.
.PP
Variable declarations that have been produced automatically by a tool
like
.BR ftnchek (1)
or
.BR pfort (1)
have a consistent format that facilitates application of stream
editors (e.g. to change array dimensions or rename variables), and
simple floating-point precision conversion tools like
.BR d2s (1),
.BR dtoq (1),
.BR dtos (1),
.BR qtod (1),
.BR s2d (1),
and
.BR stod (1).
.\"======================================================================
.SH CAVEAT
The current version (2.8.2) of
.BR ftnchek (1)
does not produce Fortran EQUIVALENCE statements in
.I .dcl
files, so you must be careful to preserve them when replacing original
declarations with new ones from
.I .dcl
or
.I .dcn
files.
.\"======================================================================
.SH "SEE ALSO"
.BR d2s (1),
.BR dtoq (1),
.BR dtos (1),
.BR ftnchek (1),
.BR make (1),
.BR pfort (1),
.BR qtod (1),
.BR s2d (1),
.BR stod (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe, Ph.D.
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"==============================[The End]==============================
