/**
 *
 * $Id: ToggleB.c,v 1.17 1996/04/22 22:56:03 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: ToggleB.c,v 1.17 1996/04/22 22:56:03 miers Exp $";

#include <LTconfig.h>
#include <Xm/XmP.h>
#include <Xm/XmI.h>
#include <Xm/ToggleBP.h>
#include <Xm/RowColumnP.h>
#include <Xm/MenuUtilP.h>
#include <Xm/MenuShell.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <stdio.h>

/* Forward Declarations */

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static void expose(Widget w, XEvent *event, Region region);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

/*
 * Resources for the toggleButton class
 */
#define Offset(field) XtOffsetOf(XmToggleButtonRec, toggle.field)
static XtResource resources[] = {
    {
	XmNindicatorSize, XmCIndicatorSize, XmRVerticalDimension,
	sizeof(Dimension), Offset(indicator_dim),
	XmRImmediate,(XtPointer) XmINVALID_DIMENSION
    },
    {
	XmNindicatorType, XmCIndicatorType, XmRIndicatorType,
	sizeof(unsigned char), Offset(ind_type),
	XmRImmediate, (XtPointer)((unsigned char)XmUNSPECIFIED)
    },
    {
	XmNvisibleWhenOff, XmCVisibleWhenOff, XmRBoolean,
	sizeof(Boolean), Offset(visible),
	XmRImmediate,(XtPointer)85 /* don't ask me */
    },
    {
	XmNspacing, XmCSpacing, XmRHorizontalDimension,
	sizeof(Dimension), Offset(spacing),
	XtRImmediate, (XtPointer)4
    },
    {
	XmNselectPixmap, XmCSelectPixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(on_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNselectInsensitivePixmap, XmCSelectInsensitivePixmap, XmRPrimForegroundPixmap,
	sizeof(Pixmap), Offset(insen_pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNset, XmCSet, XmRBoolean,
	sizeof(Boolean), Offset(set),
	XmRImmediate, (XtPointer)False
    },
    {
	XmNindicatorOn, XmCIndicatorOn, XmRBoolean,
	sizeof(Boolean), Offset(ind_on),
	XtRImmediate,(XtPointer)True
    },
    {
	XmNfillOnSelect, XmCFillOnSelect, XmRBoolean,
	sizeof(Boolean), Offset(fill_on_select),
	XtRImmediate, (XtPointer)85 /* I don't know why */
    },
    {
	XmNselectColor, XmCSelectColor, XmRPixel,
	sizeof(Pixel), Offset(select_color),
	XmRCallProc, (XtPointer)_XmSelectColorDefault
    },
    {
	XmNvalueChangedCallback, XmCValueChangedCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(value_changed_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNarmCallback, XmCArmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(arm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNdisarmCallback, XmCDisarmCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(disarm_CB),
	XmRPointer, (XtPointer)NULL
    },
    {
	XmNtraversalOn, XmCTraversalOn, XmRBoolean,
	sizeof(Boolean), XtOffsetOf(XmToggleButtonRec, primitive.traversal_on),
	XmRImmediate, (XtPointer)True
    },
    {
	XmNhighlightThickness, XmCHighlightThickness, XmRHorizontalDimension,
	sizeof(Dimension), XtOffsetOf(XmToggleButtonRec, primitive.highlight_thickness),
	XmRImmediate, (XtPointer)2
    }
};

static XmSyntheticResource syn_resources[] = {
    {
	XmNspacing,
	sizeof(Dimension), Offset(spacing),
	_XmFromHorizontalPixels, _XmToHorizontalPixels
    },
    {
	XmNindicatorSize,
	sizeof(Dimension), Offset(spacing),
	_XmFromVerticalPixels, _XmToVerticalPixels
    }
};

static void Arm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Disarm(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ArmAndActivate(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Help(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void EnterWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void LeaveWindow(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Select(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void ButtonDown(Widget w, XEvent *event, String *params, Cardinal *num_params);

char _XmToggleB_defaultTranslations[] =
    "<EnterWindow>:Enter()\n\
     <LeaveWindow>:Leave()\n\
     <Btn1Down>:Arm()\n\
     <Btn1Up>:Select() Disarm()\n\
     <Btn2Down>:ProcessDrag()\n\
     :<Key>osfActivate:PrimitiveParentActivate()\n\
     :<Key>osfCancel:PrimitiveParentCancel()\n\
     :<Key>osfSelect:ArmAndActivate()\n\
     :<Key>osfHelp:Help()\n\
     ~s ~m ~a <Key>Return:PrimitiveParentActivate()\n\
     ~s ~m ~a <Key>space:ArmAndActivate()";

char _XmToggleB_menuTranslations[] =
    "<EnterWindow>:Enter()\n\
     <LeaveWindow>:Leave()\n\
     <BtnDown>:BtnDown()\n\
     <BtnUp>:BtnUp()\n\
     :<Key>osfSelect:ArmAndActivate()\n\
     :<Key>osfActivate:ArmAndActivate()\n\
     :<Key>osfHelp:Help()\n\
     :<Key>osfCancel:MenuEscape()\n\
     ~s ~m ~a <Key>Return:ArmAndActivate()\n\
     ~s ~m ~a <Key>space:ArmAndActivate()";

static XtActionsRec actions[] = {
    {"Arm", Arm},
    {"ArmAndActivate", ArmAndActivate},
    {"Disarm", Disarm},
    {"Select", Select},
    {"Help", Help},
    {"BtnDown", ButtonDown},
    {"BtnUp", ButtonUp},
    {"Enter", EnterWindow},
    {"Leave", LeaveWindow},
};

static XmBaseClassExtRec _XmToggleBCoreClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL, /* FIXME */
    /* set_values_prehook        */ NULL, /* FIXME */
    /* initialize_posthook       */ NULL, /* FIXME */
    /* set_values_posthook       */ NULL, /* FIXME */
    /* secondary_object_class    */ NULL, /* FIXME */
    /* secondary_object_create   */ NULL, /* FIXME */
    /* get_secondary_resources   */ NULL, /* FIXME */
    /* fast_subclass             */ { 0 }, /* FIXME */
    /* get_values_prehook        */ NULL, /* FIXME */
    /* get_values_posthook       */ NULL, /* FIXME */
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ FALSE,
    /* widget_navigable          */ XmInheritWidgetNavigable,
    /* focus_change              */ XmInheritFocusChange,
    /* wrapper_data              */ NULL
};

XmPrimitiveClassExtRec _XmToggleBPrimClassExtRec = {
    /* next_extension      */ NULL,
    /* record_type         */ NULLQUARK,
    /* version             */ XmPrimitiveClassExtVersion,
    /* record_size         */ sizeof(XmPrimitiveClassExtRec),
    /* widget_baseline     */ NULL, /* FIX ME */
    /* widget_display_rect */ NULL, /* FIX ME */
    /* widget_margins      */ NULL  /* FIX ME */
};

XmToggleButtonClassRec xmToggleButtonClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmLabelClassRec,
        /* class_name            */ "XmToggleButton",
	/* widget_size           */ sizeof(XmToggleButtonRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ TRUE,
	/* compress_exposure     */ XtExposeCompressMultiple,
	/* compress_enterleave   */ TRUE,
	/* visible_interest      */ FALSE,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ expose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ _XmToggleB_defaultTranslations,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ XtInheritDisplayAccelerator,
	/* extension             */ (XtPointer)&_XmToggleBCoreClassExtRec
    },
    /* Primitive Class part */
    {
        /* border_highlight      */ XmInheritBorderHighlight,
        /* border_unhighlight    */ XmInheritBorderUnhighlight,
        /* translations          */ XtInheritTranslations,
        /* arm_and_activate_proc */ XmInheritArmAndActivate,
        /* synthetic resources   */ syn_resources,
        /* num syn res           */ XtNumber(syn_resources),
        /* extension             */ (XtPointer)&_XmToggleBPrimClassExtRec
    },
    /* Label Class part */
    {
        /* setOverrideCallback */ XmInheritSetOverrideCallback,
        /* menuProcs           */ XmInheritMenuProc,
        /* translations        */ XtInheritTranslations,
        /* extension           */ NULL
    },
    /* ToggleButton Class part */
    {
	/* extension */ NULL
    }
};

WidgetClass xmToggleButtonWidgetClass = (WidgetClass)&xmToggleButtonClassRec;


/* 
  Some #defines to make the code below more readable
 */

#define IN_MENU(w) (XmIsRowColumn(XtParent(w)) \
                    && (RC_Type(XtParent(w)) == XmMENU_POPUP \
                          || (RC_Type(XtParent(w)) == XmMENU_PULLDOWN)))
#define IN_POPUP(w) (XmIsRowColumn(XtParent(w)) \
                    && (RC_Type(XtParent(w)) == XmMENU_POPUP)

static void
class_initialize()
{
    _XmToggleBCoreClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmTOGGLE_BUTTON_BIT);
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    Dimension string_width, string_height;

    TB_Armed(new) = False;

    TB_Set(new) = !(!TB_Set(new));
    TB_VisualSet(new) = TB_IndicatorSet(new) = TB_Set(new);

    XmStringExtent(Lab_Font(new),
                   Lab_Label(new),
                   &string_width,
                   &string_height);

    if (TB_IndOn(new))
        TB_IndicatorDim(new) = XmDEFAULT_INDICATOR_DIM;
    else
        TB_IndicatorDim(new) = 0;
 
    TB_SelectGC(new) = XtAllocateGC(new,
                                    0,0,
                                    NULL,
                                    GCForeground,~GCForeground);

    Lab_MarginLeft(new) = TB_IndicatorDim(new) + (TB_IndOn(new)
                               ? 2 * TB_Spacing(new)
                               : 0);

    _XmLabelRecomputeSize(new);

    if (IN_MENU(new))
    {
	XtOverrideTranslations(new, XtParseTranslationTable(_XmToggleB_menuTranslations));
	Lab_Highlight(new) = 0;
    }
}

static void
destroy(Widget w)
{
    XtReleaseGC(w, TB_SelectGC(w));
}

static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XmToggleButtonWidget lw = (XmToggleButtonWidget) new;
    XmToggleButtonWidget rw = (XmToggleButtonWidget) request;
    Boolean refresh_needed = True;

    if (XtWidth(rw) != XtWidth(lw)
	   || XtHeight(rw) != XtHeight(lw))
    {
	  XtWidth(lw) = XtWidth(rw);
	  XtHeight(lw) = XtHeight(rw);
	  refresh_needed = False;
    }

    TB_VisualSet(lw) = TB_IndicatorSet(lw) = TB_Set(lw);
    if (TB_Set(rw) != TB_Set(lw))
   	expose(new, NULL, (Region)NULL);

    if (TB_IndType(rw) != TB_IndType(lw))
    {
      if ((TB_IndType(lw) != XmN_OF_MANY) && (TB_IndType(lw) != XmONE_OF_MANY))
      {
         TB_IndType(lw) = TB_IndType(rw);
      }
    }

    return refresh_needed;
}

static void
Arm(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;

    TB_Armed(w) = True;
    TB_VisualSet(w) = TB_IndicatorSet(w) = !TB_Set(w);

    cbs.reason = XmCR_ARM;
    cbs.event = event;
    cbs.set = TB_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w,
		       TB_ArmCallback(w),
		       (XtPointer)&cbs);

    expose(w, NULL, (Region)NULL);
}

static void
Select(Widget w,
    XEvent *event,
    String *params,
    Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;
    XButtonEvent *ev = (XButtonEvent *)event;

    if ((ev->x >= 0 && ev->x < XtWidth(w)) &&
	(ev->y >= 0 && ev->y < XtHeight(w))) {
	if (TB_VisualSet(w) == TB_IndicatorSet(w)) {
	    TB_Set(w) = TB_VisualSet(w);
	    cbs.reason = XmCR_VALUE_CHANGED;
	    cbs.event = event;
	    cbs.set = TB_Set(w);

	    XFlush(XtDisplay(w));

	    XtCallCallbackList(w,
			       TB_ValueChangedCallback(w),
			       (XtPointer)&cbs);
	}
	else
	    TB_IndicatorSet(w) = TB_Set(w);
    }
}


static void 
Disarm(Widget w,
       XEvent *event,
       String *params,
       Cardinal *num_params)
{
    XmToggleButtonCallbackStruct cbs;

    /* expose(w, NULL, (Region)NULL); */

    TB_Set(w) = TB_IndicatorSet(w) = TB_VisualSet(w);

    cbs.reason = XmCR_DISARM;
    cbs.event = event;
    cbs.set = TB_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w,
		       TB_DisarmCallback(w),
		       (XtPointer)&cbs);

    TB_Armed(w) = False;
}

static void
ArmAndActivate(Widget w,
	       XEvent *event,
	       String *params,
	       Cardinal *num_params)
{
    Arm(w, event, params, num_params);
    Select(w, event, params, num_params);
    Disarm(w, event, params, num_params);
}

static void 
ButtonUp(Widget w, 
	 XEvent *event, 
	 String *params, 
	 Cardinal *num_params)
{
    Widget parent,shell;
    Boolean validButton, poppedUp;
    XmToggleButtonCallbackStruct cbs;

    parent = XtParent(w);

    shell = parent;
    while (!XtIsShell(shell))
	shell = XtParent(shell);

    if (event && (event->type == ButtonRelease))
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON, parent, NULL, event, &validButton);

    if (!validButton)
	return;

    if (IN_MENU(w) && !XmIsMenuShell(shell))
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_POPDOWN, w, NULL, event, &poppedUp);
    else
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON_POPDOWN, w , NULL, event, &poppedUp);

    _XmRecordEvent(event);
    
    if (poppedUp)
	return;

    TB_Armed(w) = False;
    
    TB_Set(w) = TB_VisualSet(w);
    cbs.reason = XmCR_VALUE_CHANGED;
    cbs.event = event;
    cbs.set = TB_Set(w);

    XFlush(XtDisplay(w));

    XtCallCallbackList(w, 
		       TB_ValueChangedCallback(w), 
		       (XtPointer)&cbs);


    _XmSetInDragMode(w, False);
}

static void 
ButtonDown(Widget w, 
	   XEvent *event, 
	   String *params, 
	   Cardinal *num_params)
{
    ShellWidget popupShell;
    int validButton;
    Widget child;
    
    XAllowEvents(XtDisplay(w), SyncPointer, CurrentTime);
    
    if (event && (event->type == ButtonPress))
    {
	(* xmLabelClassRec.label_class.menuProcs) (XmMENU_BUTTON, XtParent(w), NULL, event, &validButton);
	if (!validButton)
	    return;
    }

    _XmSetInDragMode(w, TRUE);

    TB_Armed(w) = True;

    popupShell = (ShellWidget)_XmGetRC_PopupPosted(XtParent(w));
    if  (popupShell)
    {
	if (popupShell->shell.popped_up)
	    (* xmLabelClassRec.label_class.menuProcs)(XmMENU_SHELL_POPDOWN, (Widget)popupShell, NULL, event, NULL);
	
	child = ((XmManagerWidget)XtParent(w))->manager.active_child;
	if (child && (XmIsCascadeButton(child) || XmIsCascadeButtonGadget(child)))
	    XmCascadeButtonHighlight (child, FALSE);
    }
    
    _XmSetInDragMode(w, FALSE);

    _XmRecordEvent(event);
}

static void 
Help(Widget w,
     XEvent *event,
     String *params,
     Cardinal *num_params)
{
}

static void
EnterWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    if (TB_Armed(w))
    {
        TB_VisualSet(w) = TB_IndicatorSet(w);
	expose(w, NULL, (Region)NULL);
    }
}

static void
LeaveWindow(Widget w,
	    XEvent *event,
	    String *params,
	    Cardinal *num_params)
{
    if (TB_Armed(w))
    {
        TB_VisualSet(w) = TB_Set(w);
	expose(w, NULL, (Region)NULL);
    }
}

static void
expose(Widget w,
       XEvent *event,
       Region region)
{
    Boolean   State = TB_VisualSet(w);
    GC myGC;

    if (XtSensitive(w))
        myGC = TB_SelectGC(w);
    else
        myGC = Lab_InsensitiveGC(w);

    if (TB_FillOnSelect(w) && State)
        XSetForeground(XtDisplay(w),
                       myGC,
                       TB_SelectColor(w));
    else
        XSetForeground(XtDisplay(w),
                       myGC,
                       XtBackground(w));

    
    if (!TB_IndOn(w)) {
	if (TB_FillOnSelect(w)) {
	    XFillRectangle(XtDisplay(w), XtWindow(w),
                           myGC,
                           Lab_Highlight(w) + Lab_Shadow(w),
                           Lab_Highlight(w) + Lab_Shadow(w),
                           XtWidth(w)
				 - 2 * (Lab_Highlight(w) + Lab_Shadow(w)),
                           XtHeight(w)
				 - 2 * (Lab_Highlight(w) + Lab_Shadow(w)));
	}
        _XmDrawShadows(XtDisplay(w), XtWindow(w),
                       Prim_TopShadowGC(w),
                       Prim_BottomShadowGC(w),
		       Lab_Highlight(w), Lab_Highlight(w),
                       XtWidth(w) - 2 * Lab_Highlight(w),
		       XtHeight(w) - 2 * Lab_Highlight(w),
                       Lab_Shadow(w),
                       State ? XmSHADOW_IN : XmSHADOW_OUT);
    }
    else if (TB_IndType(w) == XmN_OF_MANY){
        XFillRectangle(XtDisplay(w), XtWindow(w),
                       myGC,
                       TB_Spacing(w) + Lab_Highlight(w) + Lab_Shadow(w),
                       (XtHeight(w) - TB_IndicatorDim(w)) / 2,
                       TB_IndicatorDim(w),
                       TB_IndicatorDim(w));
	_XmDrawShadows(XtDisplay(w),XtWindow(w),
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       TB_Spacing(w) + Lab_Highlight(w) + Lab_Shadow(w),
		       (XtHeight(w) - TB_IndicatorDim(w)) / 2,
		       TB_IndicatorDim(w), TB_IndicatorDim(w),
		       2, State ? XmSHADOW_IN : XmSHADOW_OUT);
	_XmDrawShadows(XtDisplay(w),XtWindow(w),
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       Prim_HighlightThickness(w),
		       Prim_HighlightThickness(w),
		       XtWidth(w) - 2 * Prim_HighlightThickness(w),
		       XtHeight(w) - 2 * Prim_HighlightThickness(w),
		       Lab_Shadow(w),
		       XmSHADOW_OUT);
    }
    else 
    {
	_XmDrawDiamond(XtDisplay(w), XtWindow(w),
                       State
                           ? Prim_TopShadowGC(w)
                           : Prim_BottomShadowGC(w),
                       State
                           ? Prim_BottomShadowGC(w)
                           : Prim_TopShadowGC(w),
                       myGC,
		       TB_Spacing(w) + Lab_Highlight(w),
		       (XtHeight(w) - TB_IndicatorDim(w)) / 2,
		       TB_IndicatorDim(w), TB_IndicatorDim(w),
		       2, True);
	_XmDrawShadows(XtDisplay(w),XtWindow(w),
		       Prim_TopShadowGC(w),
		       Prim_BottomShadowGC(w),
		       Prim_HighlightThickness(w),
		       Prim_HighlightThickness(w),
		       XtWidth(w) - 2 * Prim_HighlightThickness(w),
		       XtHeight(w) - 2 * Prim_HighlightThickness(w),
		       Lab_Shadow(w),
		       XmSHADOW_OUT);
    }

#define superclass (&xmLabelClassRec)
    (*superclass->core_class.expose)(w, event, region);
#undef superclass
}

Widget
XmCreateToggleButton(Widget parent,
		     char *name,
		     Arg *arglist,
		     Cardinal argcount)
{
    return XtCreateWidget(name,
			  xmToggleButtonWidgetClass,
			  parent,
			  arglist,
			  argcount);
}

Boolean
XmToggleButtonGetState(Widget widget)
{
    return TB_Set(widget);
}

void
XmToggleButtonSetState(Widget widget, 
		       Boolean state,
		       Boolean notify)
{
    XmToggleButtonCallbackStruct cbs;

    if ((TB_Set(widget) && !state) || (!TB_Set(widget) && state)) 
    {
       TB_VisualSet(widget) = TB_Set(widget) = state ? True : False;
        if (notify) 
        {
            cbs.reason = XmCR_VALUE_CHANGED;
            cbs.event = NULL; /* FIXME -- IS THIS RIGHT ? */
            cbs.set = state;

	    XFlush(XtDisplay(widget));

            XtCallCallbackList(widget,
			       TB_ValueChangedCallback(widget),
			       (XtPointer)&cbs);
        }

        if (XtIsRealized(widget))
            expose(widget, NULL, (Region)NULL);
    }
}
