/* m_matrix.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/m_matrix.h,v 9.25 95/10/29 01:46:16 al Exp $
 * Sparse matrix package
 * Bump and spike - bordered block diagonal pattern
 */
#ifndef M_MATRIX_H
#ifndef MD_H
#include "md.h"
#endif
/*--------------------------------------------------------------------------*/
/* This kluge is because there is something wrong with templates
 * on my system (Next - gcc2.2.2).
 * The next release (after I update my compiler) may require working templates
 */
/*--------------------------------------------------------------------------*/
#ifndef BSMATRIX
/*--------------------------------------------------------------------------*/
#define T double
#define BSMATRIX BSMATRIXdouble
#include "m_matrix.h"
#undef BSMATRIX
#undef T
/*--------------------------------------------------------------------------*/
#define T COMPLEX
#define BSMATRIX BSMATRIXCOMPLEX
#include "m_matrix.h"
#undef BSMATRIX
#undef T
#define M_MATRIX_H
/*--------------------------------------------------------------------------*/
#else
/*--------------------------------------------------------------------------*/
//template <class T>
class BSMATRIX {
private:
  int	*Lownode;	// lowest node connecting to this one
  T	*space;		// ptr to actual memory space used
  T	**rowptr;	// ptrs to col 0 of every row
  T	**colptr;	// ptrs to row 0 of every col
  T	**diaptr;	// ptrs to diagonal
  int	nzcount;	// count of non-zero elements
  int	Size;		// # of rows and columns
  T	Zero;		// always 0 but not const
  T	Trash;		// depository for row and col 0, write only
public:
  BSMATRIX(int s=0){init(s);}
  ~BSMATRIX(){uninit();}
  void	reinit(int s=0){uninit();init(s);}
  void	iwant(int, int);
  void	unallocate();
  void	allocate();
private:
  void	uninit();
  void	init(int s=0);
public:
#ifndef NO_MATRIX_DEBUG
  T&	d(int r, int c){
	assert(diaptr);
  	assert(r == c);
	assert(0 <= r);
	assert(r <= Size);
	return *(diaptr[r]);
  }
  T&	u(int r, int c){
	assert(colptr);
	assert(Lownode);
	assert(1 <= Lownode[c]);
	assert(Lownode[c] <= r);
  	assert(r <= c);
	assert(c <= Size);
	return colptr[c][r];
  }
  T&	l(int r, int c){
	assert(rowptr);
	assert(Lownode);
	assert(1 <= Lownode[r]);
	assert(Lownode[r] <= c);
  	assert(c <= r);
	assert(r <= Size);
	return rowptr[r][-c];
  }
#else
  T&	d(int r, int c){return *(diaptr[r]);}
  T&	u(int r, int c){return colptr[c][r];}
  T&	l(int r, int c){return rowptr[r][-c];}
#endif
  T&	m(int r, int c){return (c>=r) ? u(r,c) : l(r,c);}
  T&	s(int r, int c);
  void	zero();
  void	dezero(T& o);
  int	size()const{return Size;}
  double density();
  double sparsity(){return 1.-density();}
  int	lownode(int i)const{return Lownode[i];}
  T&	SubtractDotProduct(int r, int c, int d);
  T&	SubtractDotProduct(int r, int c, int d, T& in);
  void	lu_decomp();
  void	fbsub(T* v);
  void	fbsub(T* x, const T* b, T* c = NULL);
};
/*--------------------------------------------------------------------------*/
#endif
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
