/* s_dc.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/s_dc.h,v 9.21 95/10/21 18:11:15 al Exp $
 * DC and OP analysis
 */
#ifndef S_DC_H
#define S_DC_H
#include "s__.h"
/*--------------------------------------------------------------------------*/
class CARD;
/*--------------------------------------------------------------------------*/
class DCOP : public SIM {
public:				/* s_dc_set.cc */
	void	finish();
protected:
	void	options(CS&);
private:
 static	void	by(CS&);
 static	void	decade(CS&);
 static	void	times(CS&);
private:			/* s_dc_swp.cc */
	void	sweep();
	void	first(int);
	int	next(int);

protected:
  double start[DCNEST];
  double stop[DCNEST];
  double step[DCNEST];
  int linswp[DCNEST];
  double *(sweepval[DCNEST]);	/* pointer to thing to sweep, dc command */
  CARD *(zap[DCNEST]);		/* to branch to zap, for re-expand */
private:
  int loop;			/* flag: do it again backwards */
  int reverse;			/* flag: sweep backwards */
  int cont;			/* flag: continue from previous run */
  int trace;			/* enum: show extended diagnostics */
};
/*--------------------------------------------------------------------------*/
class DC : public DCOP {
public:
  	void	command(CS&);
private:
	void	setup(CS&);
};
/*--------------------------------------------------------------------------*/
class OP : public DCOP {
public:
  	void	command(CS&);
private:
	void	setup(CS&);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
