
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <unistd.h>
#include <stdio.h>
#include "thrust.h"

void
writeblock(word bx, word by, byte block)
{
  word tempx, tempy;

  *(bana+bx+by*lenx)=block;
  tempx=bx;
  tempy=by;
  if(pblockx+BBILDX>lenx && tempx<BBILDX)
    tempx+=lenx;
  if(pblocky+BBILDY>leny && tempy<BBILDY)
    tempy+=leny;
  if(insideblock(tempx,tempy,pblockx,pblocky,0,0))
    putblock(bblockx-pblockx+tempx, tempy%BBILDY,
	     blocks+(block<<6));
}

#define NR_TP (6)
#define SZ_TP (3)
#define DIFF_TP (8)

void
drawteleline(int round, int x1, int y1, int x2, int y2, int j, int k)
{
  int l;
  static unsigned char telemem[2*5*4*NR_TP*SZ_TP];
  static unsigned char *tm;

  switch(round) {
  case 0:
    tm=&telemem[0];
    break;
  case 1:
    for(l=-2; l<=2; l++) {
      *(graph_mem + (x1+(j+2)*DIFF_TP+k) + (y1+l)*PSCRX) = 65;
      *(graph_mem + (x1-(j+2)*DIFF_TP-k) + (y1+l)*PSCRX) = 65;
      *(graph_mem + (x1+l) + (y1+(j+2)*DIFF_TP+k)*PSCRX) = 65;
      *(graph_mem + (x1+l) + (y1-(j+2)*DIFF_TP-k)*PSCRX) = 65;
      *(graph_mem + (x2+(j+2)*DIFF_TP+k) + (y2+l)*PSCRX) = 65;
      *(graph_mem + (x2-(j+2)*DIFF_TP-k) + (y2+l)*PSCRX) = 65;
      *(graph_mem + (x2+l) + (y2+(j+2)*DIFF_TP+k)*PSCRX) = 65;
      *(graph_mem + (x2+l) + (y2-(j+2)*DIFF_TP-k)*PSCRX) = 65;
    }
    break;
  case 2:
    for(l=-2; l<=2; l++) {
      *(tm++) = *(graph_mem + (x1+(j+2)*DIFF_TP+k) + (y1+l)*PSCRX);
      *(tm++) = *(graph_mem + (x1-(j+2)*DIFF_TP-k) + (y1+l)*PSCRX);
      *(tm++) = *(graph_mem + (x1+l) + (y1+(j+2)*DIFF_TP+k)*PSCRX);
      *(tm++) = *(graph_mem + (x1+l) + (y1-(j+2)*DIFF_TP-k)*PSCRX);
      *(tm++) = *(graph_mem + (x2+(j+2)*DIFF_TP+k) + (y2+l)*PSCRX);
      *(tm++) = *(graph_mem + (x2-(j+2)*DIFF_TP-k) + (y2+l)*PSCRX);
      *(tm++) = *(graph_mem + (x2+l) + (y2+(j+2)*DIFF_TP+k)*PSCRX);
      *(tm++) = *(graph_mem + (x2+l) + (y2-(j+2)*DIFF_TP-k)*PSCRX);
    }
    break;
  case 3:
    for(l=-2; l<=2; l++) {
      *(graph_mem + (x1+(j+2)*DIFF_TP+k) + (y1+l)*PSCRX) = *(tm++);
      *(graph_mem + (x1-(j+2)*DIFF_TP-k) + (y1+l)*PSCRX) = *(tm++);
      *(graph_mem + (x1+l) + (y1+(j+2)*DIFF_TP+k)*PSCRX) = *(tm++);
      *(graph_mem + (x1+l) + (y1-(j+2)*DIFF_TP-k)*PSCRX) = *(tm++);
      *(graph_mem + (x2+(j+2)*DIFF_TP+k) + (y2+l)*PSCRX) = *(tm++);
      *(graph_mem + (x2-(j+2)*DIFF_TP-k) + (y2+l)*PSCRX) = *(tm++);
      *(graph_mem + (x2+l) + (y2+(j+2)*DIFF_TP+k)*PSCRX) = *(tm++);
      *(graph_mem + (x2+l) + (y2-(j+2)*DIFF_TP-k)*PSCRX) = *(tm++);
    }
    break;
  }
}

void
drawteleport()
{
  int i,j,k;
  int x1,y1,x2,y2;

  x1=154+7+shipdx;
  y1= 82+7+shipdy;
  x2=154+7-((252-loadpoint)*sinus2[(alpha+256)&1023])/2016;
  y2= 82+7+((252-loadpoint)*sinus2[alpha])/2016;

  vga_waitretrace();
  for(i=0; i<NR_TP+SZ_TP-1; i++) {
    for(k=min(SZ_TP-1,i), j=max(i-(SZ_TP-1),0); j<=min(i,NR_TP-1); k--, j++)
      drawteleline(1, x1, y1, x2, y2, j, k);
    for(k=0; k<3; k++)
      vga_waitretrace();
  }

  usleep(250000UL);
  vga_waitretrace();
  putscr(bildx, bildy);

  drawteleline(0, 0, 0, 0, 0, 0, 0);
  for(i=0; i<NR_TP+SZ_TP-1; i++)
    for(k=min(SZ_TP-1,i), j=max(i-(SZ_TP-1),0); j<=min(i,NR_TP-1); k--, j++)
      drawteleline(2, x1, y1, x2, y2, j, k);
  drawteleline(0, 0, 0, 0, 0, 0, 0);
  for(i=0; i<NR_TP+SZ_TP-1; i++)
    for(k=min(SZ_TP-1,i), j=max(i-(SZ_TP-1),0); j<=min(i,NR_TP-1); k--, j++)
      drawteleline(1, x1, y1, x2, y2, j, k);
  
  usleep(250000UL);
  
  vga_waitretrace();
  drawteleline(0, 0, 0, 0, 0, 0, 0);
  for(i=0; i<NR_TP+SZ_TP-1; i++) {
    for(k=min(SZ_TP-1,i), j=max(i-(SZ_TP-1),0); j<=min(i,NR_TP-1); k--, j++)
      drawteleline(3, x1, y1, x2, y2, j, k);
    for(k=0; k<3; k++)
      vga_waitretrace();
  }
}

void
swap(pa,pb)
     int *pa,*pb;
{
  int	t;
  t=*pa; *pa=*pb; *pb=t;
}

void
drawlinev(x1,y1,x2,y2,color,storage)
     int x1,y1,x2,y2;
     byte color;
     byte *storage;
{
  int d,dx,dy;
  int Ai,Bi,xi;
  byte *ptr=bild;

  if(y1>y2) {
    swap(&x1,&x2);
    swap(&y1,&y2);
  }
  xi=(x2>x1)?1:-1;
  dx=abs(x2-x1);
  dy=(y2-y1);
  Ai=(dx-dy)<<1;
  Bi=(dx<<1);
  d=Bi-dy;

  ptr+=y1*(PBILDX<<1);
  *(storage++)=*(ptr+x1);
  *(ptr+x1)=color;
  for(y1++,ptr+=PBILDX<<1; y1<=y2; y1++,ptr+=PBILDX<<1) {
    if(y1==PBILDY)
      ptr=bild;
    if(d<0)
      d+=Bi;
    else {
      x1+=xi;
      d+=Ai;
    }
    *(storage++)=*(ptr+x1);
    *(ptr+x1)=color;
  }
}

void
undrawlinev(x1,y1,x2,y2,storage)
     int x1,y1,x2,y2;
     byte *storage;
{
  int d,dx,dy;
  int Ai,Bi,xi;
  byte *ptr=bild;

  if(y1>y2) {
    swap(&x1,&x2);
    swap(&y1,&y2);
  }
  xi=(x2>x1)?1:-1;
  dx=abs(x2-x1);
  dy=(y2-y1);
  Ai=(dx-dy)<<1;
  Bi=(dx<<1);
  d=Bi-dy;

  ptr+=y1*(PBILDX<<1);
  *(ptr+x1)=*(storage++);
  for(y1++,ptr+=PBILDX<<1; y1<=y2; y1++,ptr+=PBILDX<<1) {
    if(y1==PBILDY)
      ptr=bild;
    if(d<0)
      d+=Bi;
    else {
      x1+=xi;
      d+=Ai;
    }
    *(ptr+x1)=*(storage++);
  }
}

void
drawlineh(x1,y1,x2,y2,color,storage)
     int x1,y1,x2,y2;
     byte color;
     byte *storage;
{
  int d,dx,dy;
  int Ai,Bi,yi,i;
  byte *ptr=bild;

  if(x1>x2) {
    swap(&x1,&x2);
    swap(&y1,&y2);
  }
  if(y2>y1) {
    yi=PBILDX<<1;
    i=1;
  }
  else {
    yi=-PBILDX<<1;
    i=-1;
  }
  dx=x2-x1;
  dy=abs(y2-y1);
  Ai=(dy-dx)<<1;
  Bi=(dy<<1);
  d=Bi-dx;
  if(y1>PBILDY)
    y1-=PBILDY;
  y2=y1;
  y1=y1*PBILDX<<1;

  ptr+=y1;
  *(storage++)=*(ptr+x1);
  *(ptr+x1)=color;
  for(x1++; x1<=x2; x1++) {
    if(d<0)
      d+=Bi;
    else {
      ptr+=yi;
      y2+=i;
      if(y2==-1)
	ptr+=PBILDY*PBILDX<<1;
      if(y2==PBILDY)
	ptr=bild;
      d+=Ai;
    }
    *(storage++)=*(ptr+x1);
    *(ptr+x1)=color;
  }
}

void
undrawlineh(x1,y1,x2,y2,storage)
     int x1,y1,x2,y2;
     byte *storage;
{
  int d,dx,dy;
  int Ai,Bi,yi,i;
  byte *ptr=bild;

  if(x1>x2) {
    swap(&x1,&x2);
    swap(&y1,&y2);
  }
  if(y2>y1) {
    yi=PBILDX<<1;
    i=1;
  }
  else {
    yi=-PBILDX<<1;
    i=-1;
  }
  dx=x2-x1;
  dy=abs(y2-y1);
  Ai=(dy-dx)<<1;
  Bi=(dy<<1);
  d=Bi-dx;
  if(y1>PBILDY)
    y1-=PBILDY;
  y2=y1;
  y1=y1*PBILDX<<1;

  ptr+=y1;
  *(ptr+x1)=*(storage++);
  for(x1++; x1<=x2; x1++) {
    if(d<0)
      d+=Bi;
    else {
      ptr+=yi;
      y2+=i;
      if(y2==-1)
	ptr+=PBILDY*PBILDX<<1;
      if(y2==PBILDY)
	ptr=bild;
      d+=Ai;
    }
    *(ptr+x1)=*(storage++);
  }
}

void
drawline(x1,y1,x2,y2,color,storage)
     int x1,y1,x2,y2;
     byte color;
     byte *storage;
{
  if(y1>y2+64)
    y2+=PBILDY;
  if(y2>y1+64)
    y1+=PBILDY;
  if(abs(x1-x2)<abs(y1-y2))
    drawlinev(x1,y1,x2,y2,color,storage);
  else
    drawlineh(x1,y1,x2,y2,color,storage);
}

void
undrawline(x1,y1,x2,y2,storage)
     int x1,y1,x2,y2;
     byte *storage;
{
  if(y1>y2+64)
    y2+=PBILDY;
  if(y2>y1+64)
    y1+=PBILDY;
  if(abs(x1-x2)<abs(y1-y2))
    undrawlinev(x1,y1,x2,y2,storage);
  else
    undrawlineh(x1,y1,x2,y2,storage);
}

void
drawbullets()
{
  int l;
  bullet *bulletptr;
  word tempx,tempy;

  for(l=0, bulletptr=bullets; l<maxbullets; l++, bulletptr++)
    if((*bulletptr).life) {
      tempx=(*bulletptr).x>>3;
      tempy=(*bulletptr).y>>3;
      if(pixx+PSCRX>lenx3 && tempx<PSCRX)
	tempx+=lenx3;
      if(pixy+PSCRY>leny3 && tempy<PSCRY)
	tempy+=leny3;
      if(insidepixel(tempx, tempy, pixx, pixy, 4, 4))
	drawsquare(bildx+tempx-pixx, tempy%PBILDY,
		   bulletmap+((*bulletptr).dir<<4),
		   bulletstorage+(l<<4), 4, 4);
      else if(*(bana+(tempx>>3)%lenx+((tempy>>3)%leny)*lenx)!=32)
	(*bulletptr).life=0;
    }
}

void
undrawbullets()
{
  int l;
  bullet *bulletptr;
  word tempx,tempy;
  word crash;

  for(l=maxbullets-1, bulletptr=bullets+maxbullets-1; l>=0; l--, bulletptr--)
    if((*bulletptr).life) {
      tempx=(*bulletptr).x>>3;
      tempy=(*bulletptr).y>>3;
      if(pixx+PSCRX>lenx3 && tempx<PSCRX)
	tempx+=lenx3;
      if(pixy+PSCRY>leny3 && tempy<PSCRY)
	tempy+=leny3;
      if(insidepixel(tempx, tempy, pixx, pixy, 4, 4)) {
	crash=testcrash(bulletmap+((*bulletptr).dir<<4),
			bulletstorage+(l<<4), 16, 0);
	if(crash) {
	  if(crash>=4)
	    hit((tempx+3)%lenx3,(tempy+3)%leny3,crash,(*bulletptr).owner);
	  (*bulletptr).life=0;
	}
	undrawsquare(bildx+tempx-pixx, tempy%PBILDY,
		     bulletstorage+(l<<4), 4, 4);
      }
    }
}

void
drawfragments()
{
  int l;
  fragment *fragmentptr;
  word tempx,tempy;
  static byte fragmentmap[4]={ 12,12,12,12 };

  for(l=0, fragmentptr=fragments; l<maxfragments; l++, fragmentptr++)
    if((*fragmentptr).life) {
      tempx=(*fragmentptr).x>>3;
      tempy=(*fragmentptr).y>>3;
      if(pixx+PSCRX>lenx3 && tempx<PSCRX)
	tempx+=lenx3;
      if(pixy+PSCRY>leny3 && tempy<PSCRY)
	tempy+=leny3;
      if(insidepixel(tempx, tempy, pixx, pixy, 2, 2))
	drawsquare(bildx+tempx-pixx, tempy%PBILDY,
		   fragmentmap, fragmentstorage+(l<<2), 2, 2);
      else if(*(bana+(tempx>>3)%lenx+((tempy>>3)%leny)*lenx)!=32)
	(*fragmentptr).life=0;
    }
}

void
undrawfragments()
{
  int l;
  fragment *fragmentptr;
  word tempx,tempy;
  word crash;
  static byte fragmentmap[4]={ 12,12,12,12 };

  for(l=maxfragments-1, fragmentptr=fragments+maxfragments-1;
      l>=0;
      l--, fragmentptr--)
    if((*fragmentptr).life) {
      tempx=(*fragmentptr).x>>3;
      tempy=(*fragmentptr).y>>3;
      if(pixx+PSCRX>lenx3 && tempx<PSCRX)
	tempx+=lenx3;
      if(pixy+PSCRY>leny3 && tempy<PSCRY)
	tempy+=leny3;
      if(insidepixel(tempx, tempy, pixx, pixy, 2, 2)) {
	crash=testcrash(fragmentmap, fragmentstorage+(l<<2), 4, 0);
	if(crash) {
/*	  if(crash>=4)
	    hit((tempx+3)%lenx3,(tempy+3)%leny3,crash); */
	  (*fragmentptr).life=0;
	}
	undrawsquare(bildx+tempx-pixx, tempy%PBILDY,
		     fragmentstorage+(l<<2), 2, 2);
      }
    }
}

void
drawspacestationblip()
{
  word tempx,tempy;

  tempx=ssx;
  tempy=ssy;
  if(pblockx+BBILDX>lenx && tempx<BBILDX)
    tempx+=lenx;
  if(pblocky+BBILDY>leny && tempy<BBILDY)
    tempy+=leny;
  if(insideblock(tempx,tempy,pblockx,pblocky,0,0))
    putblock(bblockx-pblockx+tempx, tempy%BBILDY,
	     blocks+((ssblip?32:222-(scount&0xc))<<6));
}

void
drawload(flag)
     int flag;
{
  word tempx,tempy;

  tempx=loadbx;
  tempy=loadby;
  if(pblockx+BBILDX>lenx && tempx<BBILDX)
    tempx+=lenx;
  if(pblocky+BBILDY>leny && tempy<BBILDY)
    tempy+=leny;
  putblock(bblockx-pblockx+tempx, tempy%BBILDY,
	   blocks+((flag?109:32)<<6));
}

word
drawshuttle()
{
  word crash=0,tmp;
  int x1,x2=0,y1,y2=0,lx,ly;
  static byte wiremap[64]={
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13,
    13,13,13,13,13,13,13,13};

  if(loaded || loadcontact) {
    x1=bildx+161+shipdx;
    y1=(bildy+89+shipdy);
    if(loaded) {
      x2=bildx+161-((252-loadpoint)*sinus2[(alpha+256)&1023])/2016;
      y2=bildy+ 89+((252-loadpoint)*sinus2[alpha])/2016;
    }
    else {
      x2=(loadbx<<3)+3;
      if(abs(x2-x1)>PBILDX/2)
	x2+=PBILDX;
      y2=(loadby<<3)+3;
    }
    lx=abs(x1-x2)%PBILDX;
    ly=abs(y1-y2)%PBILDY;
    if(lx>64)
      lx=abs(lx-PBILDX);
    if(ly>64)
      ly=abs(ly-PBILDY);
    drawline(x1, y1%PBILDY, x2, y2%PBILDY, 13, wirestorage);
    tmp=testcrash(wiremap, wirestorage, max(lx,ly)+1, shield);
    crash=max(crash, tmp);
  }
  /* Draw the shuttle */
  drawship(bildx+154+shipdx, (bildy+82+shipdy)%PBILDY,
	   (shield?shieldship:ship)+(dir<<8), shipstorage);
  tmp=testcrash(ship+(dir<<8), shipstorage, 256, shield);
  crash=max(tmp,crash);
  if(loaded || loadcontact) {
    if(loaded)
      drawsquare(x2-3, (y2-3)%PBILDY, loadmap, loadstorage, 8, 8);
    else if(loadcontact) {
      x1=loadbx<<3;
      y1=loadby<<3;
      if(pixx+PBILDX>lenx3 && x1<PBILDX)
	x1+=lenx3;
      if(pixy+PBILDY>leny3 && y1<PBILDY)
	y1+=leny3;
      drawsquare(bildx-pixx+x1, y1%PBILDY, loadmap, loadstorage, 8, 8);
    }
    tmp=testcrash(loadmap, loadstorage, 64, shield);
    crash=max(crash, tmp);
  }
  return(crash);
}

void
undrawshuttle()
{
  int x1,x2=0,y1,y2=0;

  if(loaded || loadcontact)
    if(loaded) {
      x2=bildx+161-((252-loadpoint)*sinus2[(alpha+256)&1023])/2016;
      y2=bildy+ 89+((252-loadpoint)*sinus2[alpha])/2016;
      undrawsquare(x2-3,(y2-3)%PBILDY,loadstorage,8,8);
    }
    else if(loadcontact) {
      x1=loadbx<<3;
      y1=loadby<<3;
      if(pixx+PBILDX>lenx3 && x1<PBILDX)
	x1+=lenx3;
      if(pixy+PBILDY>leny3 && y1<PBILDY)
	y1+=leny3;
      undrawsquare(bildx-pixx+x1,y1%PBILDY,loadstorage,8,8);
    }
  undrawship(bildx+154+shipdx,(bildy+82+shipdy)%PBILDY,
	     shipstorage);
  if(loaded || loadcontact) {
    x1=bildx+161+shipdx;
    y1=(bildy+89+shipdy);
    if(loadcontact) {
      x2=(loadbx<<3)+3;
      if(abs(x2-x1)>PBILDX/2)
	x2+=PBILDX;
      y2=(loadby<<3)+3;
    }
    undrawline(x1,y1%PBILDY,x2,y2%PBILDY,wirestorage);
  }
}

void
drawfuellines()
{
  drawsquare(bildx+shipdx+151,(bildy+shipdy+98)%PBILDY,
	     fuelmap,fuelstorage,4,32);
  drawsquare(bildx+shipdx+168,(bildy+shipdy+98)%PBILDY,
	     fuelmap+128,fuelstorage+128,4,32);
}

void
undrawfuellines()
{
  undrawsquare(bildx+shipdx+151,(bildy+shipdy+98)%PBILDY,
	       fuelstorage,4,32);
  undrawsquare(bildx+shipdx+168,(bildy+shipdy+98)%PBILDY,
	       fuelstorage+128,4,32);
}
