// Copyright (c) 1997,1998 Albrecht Kleine    All rights reserved
// file version #199

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"

#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

//------ some mixed functions very often called during runtime -------------
//
// -all are called by our compiled code during runtime
//
// -some portions are rewritten to pure asm code: you can control
//  usage of this functions via setting #define USEASM in tyaconfig.h



#ifdef TRY_FAST_INVOKE

#ifndef USEASM

#define FASTINVPREPARE() if (TRUE)					\
{									\
	JavaFrame *JF;							\
 	dprintf(stderr,"fast inv calling   %s.%s %s %d %d\n",		\
		unha11(mbpcalled->fb.clazz)->name,mbpcalled->fb.name,	\
		mbpcalled->fb.signature,mbpcalled->nlocals,mbpcalled->maxstack);\
        dprintf(stderr,"         called by %s.%s   %d %d\n",		\
		unha11(ee->current_frame->current_method->fb.clazz)->name,\
		ee->current_frame->current_method->fb.name,		\
		ee->current_frame->current_method->nlocals,		\
		ee->current_frame->current_method->maxstack);		\
	JF=ee->current_frame;						\
	JF++;								\
   	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)	\
 	  StOvExcHandler();	/* compare similar in FastInvCheck()*/	\
	JF->vars=sp;							\
	JF->prev=ee->current_frame;					\
	JF->current_method=mbpcalled;					\
	JF->javastack=ee->current_frame->javastack;			\
	JF->optop=JF->ostack;						\
	ee->current_frame=JF;      					\
        return mbpcalled->CompiledCode;	/* machine code address to call */  \
}



void* FastInvCheck32(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp)
{
      // if there isn't yet compiled code, so compile such one...(try it)
      if (!mbpcalled->CompiledCode)
         if (!JITCompileMethod(mbpcalled,ee))
         {
	   if (!(mbpcalled->fb.access & ACC_NATIVE))
	     lprintf("TYA: JIT problem in %s.%s %s %d %d\n",unha11(mbpcalled->fb.clazz)->name,mbpcalled->fb.name,mbpcalled->fb.signature,mbpcalled->nlocals,mbpcalled->maxstack);
           return CodeRunner32_withDummies;

         }
      FASTINVPREPARE();
}
void* FastInvCheck64(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp)
{
      // if there isn't yet compiled code, so compile such one...(try it)
      if (!mbpcalled->CompiledCode)
         if (!JITCompileMethod(mbpcalled,ee))
         {
	   if (!(mbpcalled->fb.access & ACC_NATIVE))
	     lprintf("TYA: JIT problem in %s.%s %s %d %d\n",unha11(mbpcalled->fb.clazz)->name,mbpcalled->fb.name,mbpcalled->fb.signature,mbpcalled->nlocals,mbpcalled->maxstack);
           return CodeRunner64_withDummies;
         }
      FASTINVPREPARE();
}					 
//
// just like FastInvCheck(), but doesn't contain test for compilation
//
void* FastInvNoCheck32(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp)
{
   FASTINVPREPARE();
}
void* FastInvNoCheck64(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp)
{
   FASTINVPREPARE();
}					 
#endif
#endif

	  
// called from opcodes instanceof and checkcast
//
// h==NULL is is handled in caller's side
//
bool_t MyIsInstanceOf(ClassClass *dcb,ExecEnv *ee,HObject * h)
{
   dprintf(stderr,"MyIsInstanceOf %p %p\n",dcb,classJavaLangObject);
//   if (dcb==classJavaLangObject)
//     return TRUE;
//   if (obj_flags(h) != T_NORMAL_OBJECT)
//     return TRUE;
   if (obj_array_classblock(h)==classJavaLangObject && dcb==classJavaLangObject)
     return TRUE;     /* it seems is_instance_of doesn't handle ARRAYs */
   return is_instance_of(h,dcb,ee);
}


// wrapper, called during runtime
//	 
HObject *MyArrayAlloc(int type,int len)
{
   HObject *o=ArrayAlloc(type,len);
   if (o)
      memset(unhand(o),0,T_ELEMENT_SIZE(type)*len);
   else
     out_of_memory();
   return o;
}

#ifndef USEASM
// wrapper, called during runtime
//	 
HObject *MyObjAlloc(ClassClass *dcb)
{
   HObject *o;
   dprintf(stderr,"MyObjAlloc %p\n",dcb);
   o=ObjAlloc(dcb,0);
   if (o)
      memset(unhand(o),0,unha11(dcb)->instance_size);
   return o;
}
#endif

// Arithmethics called during runtime.
//
long long lldiv_wrapper(long long x,long long z)
{
   return z/x;
}
long long llmul_wrapper(long long x,long long z)
{
   return z*x;
}
long long llrem_wrapper(long long x,long long z)
{
   return z%x;
}

//---------------------------------------------------------------------------------

// Compile call of this function if you want to know the stack contents during runtime
//  (very helpful for debugging purposes)
// Of course you can modify this, depending what you have to expect on stack,
//  but be careful, most time you have to preserve the register on caller's side.
//  Sometimes you cannot push/pop, because you'll get some very nice side effects ;-)
//
void debughelper(void *stacA,void *stacB,void *stacC)
{
  // please NEVER use iprint,lprint,dprint... (or whatever)  A.K.
  fprintf(stderr,"debughelper says: ## %p ## %p ## %p\n",stacA,stacB,stacC);
}

//--------------------------------------------------------------------------------


void MakeStackRevInstruction(struct methodblock *mb,int nonstatic)
 {
    char aaa[256];
    char *xxx=aaa;
    int o,k,found64=0,found32=0;
    char *y=mb->fb.signature;
    if (nonstatic)
    {
     found32++;
     *xxx++=0x32;
    }
    y++;					// ignore '(' aka SIGNATURE_FUNC
    while (*y!=SIGNATURE_ENDFUNC)
	     {
		if (*y==SIGNATURE_ARRAY)
	  	{ 
 	   	 while (*y==SIGNATURE_ARRAY)	// multi dim array
	      	  y++;
	   	 if (*y==SIGNATURE_CLASS)	// array of objects
	    		while (*y!=SIGNATURE_ENDCLASS)
	      			y++;
		 found32++;  
	   	 *xxx++=0x32;	
	  	}
		else
	  	{  
	     	     if (*y==SIGNATURE_CLASS)	// object
	       	      while (*y!=SIGNATURE_ENDCLASS)
	         	y++;
		   if (*y!=SIGNATURE_LONG && *y!=SIGNATURE_DOUBLE)
		     {
	     	        *xxx++=0x32;
			found32++;
		     }
		   else
		     {
			*xxx++=0x64;		// because we have 64 bit  :) :)
			found64++;
		     }
	  	}
		y++;				// next src
     }
    k=found32+found64;				// ==strlen
    
    switch (found32+ (found64<<8))
      {
       case 256:mb->CompiledCodeFlags=256;break;
       case 0:mb->CompiledCodeFlags=257;break;
       case 1:mb->CompiledCodeFlags=1;break;
       case 2:mb->CompiledCodeFlags=2;break;
       case 3:mb->CompiledCodeFlags=3;break;
       default:
	 mb->CompiledCodeFlags=(int)sysMalloc(k+1);
	 for (o=0;o<k;o++)
	     ((char*)mb->CompiledCodeFlags)[o]=aaa[k-o-1];	//reverse string
	 ((char*)mb->CompiledCodeFlags)[k]=0;
	 //dprintf(stderr,"RI-String %s\n",(char*)mb->CompiledCodeFlags);	   
	 break;
      }
 }

#ifndef USEASM
struct methodblock *RTGetIMeth(HObject *o,ClassClass *klassX,int u)
{
   int j=0;
   struct methodtable *omt=o->methods;
   struct imethodtable *oimt=unhand( omt->classdescriptor)->imethodtable;
   while  (klassX != oimt->itable[j].classdescriptor) j++;
   return omt->methods[ oimt->itable[j].offsets[u] ];
}
#endif		       


//invocation helper
//
void* ReverseCopyViaScript(stack_item *loc,char *xx,int anz,stack_item *args)
{
   int i;
   anz--;
   for (i=0;i<=anz;i++)
     {
	if (*xx++ != 0x64)
          loc[anz-i]=args[i];
        else
	  {
	     loc[anz-i]=args[i+1];
	     loc[anz-i-1]=args[i];
	     i++;
	  }
     }
   return loc;
}

#define REVERSE_ARGS()  if (TRUE)					\
{									\
   if (!mb->CompiledCodeFlags)						\
     MakeStackRevInstruction(mb, !(mb->fb.access & ACC_STATIC));	\
   switch (mb->CompiledCodeFlags)					\
     {									\
      case 257:								\
      case 256:								\
      case 1:								\
	break;								\
      case 2:local=buffer;						\
	     local[ 1]=args[0];						\
	     local[ 0]=args[1];						\
	     args=local;						\
	break;								\
      case 3:local=buffer;						\
	     local[ 2]=args[0];						\
	     local[ 1]=args[1];						\
	     local[ 0]=args[2];						\
	     args=local;						\
	break;								\
      default:local=alloca(mb->args_size*SIS4);				\
              args=ReverseCopyViaScript((stack_item*)local,		\
		(char*)mb->CompiledCodeFlags,				\
		mb->args_size,(stack_item*)args);			\
	break;								\
     }									\
}

// ---------------------- invocation main stuff ------------------------------------
// at all 4 functions
//  -the first two are to be called from section 6A
//  -the second two are to be called from section 6B
//	(6B has to carry two DUMMY parameters for compatiblity reason with fast invocation)
// (But all are quite similar so we could consider to put them into some macros.)
//
long long CodeRunner32(ExecEnv *ee, struct methodblock *mb, int *args)
{
   int buffer[3];
   int *local;
   void *f;
   REVERSE_ARGS();
#ifdef  FAST_NATIVE102STYLE
 if (!mb->code && mb->invoker==invokeNativeMethod)
#ifdef JDK102     
    dynoLink(mb);
#else
   dynoLinkJNI(mb);
#endif
   // dprintf(stderr,"NEW CodeRunner32 !!!!!!! %s %p\n",mb->fb.name,mb->code);
   // dprintf(stderr,"%x %x\n",args[0],args[1]);
   if (!(f=mb->code) || mb->invoker!=invokeNativeMethod ) /* all CRunXXasm can't operate */
#endif
   {
    if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
    else
      f=mb->fb.clazz;
    return do_execute_java_method_vararg(ee,f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,args,NULL, TRUE);
   }
#ifdef  FAST_NATIVE102STYLE   
   else
   {
//     asm ("push %eax");
     return CRun32asm(ee,args,f);
   }
#endif
}

long long CodeRunner64(ExecEnv *ee, struct methodblock *mb, int *args)
{
   int buffer[3];
   int *local;
   void *f;
   REVERSE_ARGS();
#ifdef  FAST_NATIVE102STYLE
 if (!mb->code && mb->invoker==invokeNativeMethod)
#ifdef JDK102     
   dynoLink(mb);
#else
    dynoLinkJNI(mb);
#endif
   // dprintf(stderr,"NEW CodeRunner64 !!!!!!! %s %p\n",mb->fb.name,mb->code);
   // dprintf(stderr,"%x %x\n",args[0],args[1]);
      if (!(f=mb->code) || mb->invoker!=invokeNativeMethod)
#endif
   {
    if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
    else
      f=mb->fb.clazz;
    do_execute_java_method_vararg(ee, f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,args,NULL, TRUE);
    return *(long long *)((char*)ee->current_frame+
		  (2*(sizeof(JavaFrame)-SIS4)+
		   ee->current_frame->current_method->maxstack * SIS4));
      //  OLD:.... mbcaller->maxstack * SIS4));
   }
#ifdef  FAST_NATIVE102STYLE   
   else
   {
//     asm ("push %eax");
     return CRun64asm(ee,args,f);
   }
#endif
}

		       
long long CodeRunner32_withDummies(int d1, int d2,ExecEnv *ee, struct methodblock *mb, int *args)
{
   int buffer[3];
   int *local;
   void *f;
   REVERSE_ARGS();
#ifdef  FAST_NATIVE102STYLE
  if (!mb->code && mb->invoker==invokeNativeMethod)
#ifdef JDK102     
    dynoLink(mb);
#else
    dynoLinkJNI(mb);
#endif
   // dprintf(stderr,"NEW CodeRunner32 !!!!!!! %s %p\n",mb->fb.name,mb->code);
   // dprintf(stderr,"%x %x\n",args[0],args[1]);
      if (!(f=mb->code) || mb->invoker!=invokeNativeMethod)
#endif
   {
    if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
    else
      f=mb->fb.clazz;
    return do_execute_java_method_vararg(ee,f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,args,NULL, TRUE);
   }
#ifdef  FAST_NATIVE102STYLE   
   else
   {
      dprintf(stderr,"NEW CodeRunner32 !!!!!!! %s %p\n",mb->fb.name,mb->code);
//     asm ("push %eax");
     return CRun32asm(ee,args,f);
   }
#endif
}

long long CodeRunner64_withDummies(int d1, int d2,ExecEnv *ee, struct methodblock *mb, int *args)
{
   int buffer[3];
   int *local;
   void *f;
   REVERSE_ARGS();
#ifdef  FAST_NATIVE102STYLE
 if (!mb->code && mb->invoker==invokeNativeMethod)
#ifdef JDK102     
    dynoLink(mb);
#else
    dynoLinkJNI(mb);
#endif
   // dprintf(stderr,"NEW CodeRunner64 !!!!!!! %s %p\n",mb->fb.name,mb->code);
   // dprintf(stderr,"%x %x\n",args[0],args[1]);
      if (!(f=mb->code) || mb->invoker!=invokeNativeMethod)
#endif
   {
    if (! (mb->fb.access & ACC_STATIC))
      f=(void*)*args++;
    else
      f=mb->fb.clazz;
    do_execute_java_method_vararg(ee, f /* = object or class */,
	mb->fb.name,mb->fb.signature,mb, mb->fb.access & ACC_STATIC ,args,NULL, TRUE);
    return *(long long *)((char*)ee->current_frame+
		  (2*(sizeof(JavaFrame)-SIS4)+
		   ee->current_frame->current_method->maxstack * SIS4));
      //  OLD:.... mbcaller->maxstack * SIS4));
   }
#ifdef  FAST_NATIVE102STYLE   
   else
   {
//     asm ("push %eax");
     return CRun64asm(ee,args,f);
   }
#endif
}
