#include <qmessagebox.h>

#include "chatdlg.h"

#include <iostream.h>

ChatDlg::ChatDlg(ICQUser *u, ICQUser *o, bool isTheServer, unsigned short thePort = 0, QWidget *parent = NULL, char *name = NULL) : QWidget(parent, name)
{
   user = u;
   owner = o;
   portVal = thePort;
   isServer = isTheServer;
   boxRemote = new QGroupBox("Remote - Not connected", this);
   mleRemote = new MLEditWrap(true, boxRemote);
   mleRemote->setReadOnly(true);
   localName = new char[strlen(owner->alias()) + 1];
   remoteName = NULL;
   strcpy(localName, owner->alias());
   char localTitle[16 + strlen(localName)];
   sprintf(localTitle, "Local - %s", localName);   
   boxLocal = new QGroupBox(localTitle, this);
   mleLocal = new MLEditWrap(true, boxLocal);
   mleLocal->setEnabled(false);
   
   btnClose = new QPushButton("Close Chat", this);
   btnClose->setGeometry(200, 440, 100, 20);
   connect(btnClose, SIGNAL(clicked()), this, SLOT(chatClose()));
   connect(btnClose, SIGNAL(clicked()), this, SLOT(hide()));

   resize(500, 475);

   // now either connect to the remote host or start up a server
   if (isServer)   // set up the server
   {
      chatSockServer.startServer(thePort);
      portVal = chatSockServer.localPort();
      connect(chatSockServer.sn, SIGNAL(activated(int)), this, SLOT(chatRecvServer()));
   }
   else            // connect to the remote server
   {
      chatSock.setDestination(user->tcpSocket.remoteIP(), thePort);
      if (!chatSock.openConnection()) 
         QMessageBox::critical(this, "Licq", "Unable to connect to chat!", QMessageBox::Ok, 0);
      else
      {
         unsigned short localPort = chatSock.localPort();
         // send handshake packet: 
         /* FF 03 00 00 00 3D 62 00 00 50 A5 82 00 CF 60 AD 95 CF 60 AD 95 04 3D 62 
            00 00 */
         chatPacket.clearPacket();
         chatPacket << (unsigned long)0x03FF  // handshake code
                    << (char)0x00
                    << (unsigned long)localPort   // local port as long
                    << owner->uin()
                    << LOCALHOST // local ip
                    << LOCALHOST // remote ip
                    << (char)0x04
                    << (unsigned long)localPort // local port as long
         ;
         chatSock.sendPacket(chatPacket);
         if (DEBUG_LEVEL >= 2) cout << "Chat packet sent (TCP):\n" << chatPacket.print() << endl;
         
         // send first handshake packet:
         /* 64 00 00 00 FD FF FF FF 50 A5 82 00 08 00 38 35 36 32 30 30 30 00 62 3D 
            FF FF FF 00 00 00 00 00 00 */
         chatPacket.clearPacket();
         chatPacket << (unsigned long)0x64
                    << (unsigned long)0xFFFFFFFD
                    << owner->uin()
                    << (unsigned short)(strlen(localName) + 1) // length of string representation of uin
                    << localName             // string representation of uin
                    << ((char *)(&localPort))[1] // local port reversed as short
                    << ((char *)(&localPort))[0]
                    << (unsigned long)0x00FFFFFF // foreground (rr gg bb 00)
                    << (unsigned long)0x00000000 // background (rr gg bb 00) 
                    << (char)0x00
         ;
         chatSock.sendPacket(chatPacket);
         if (DEBUG_LEVEL >= 2) cout << "Chat packet sent (TCP):\n" << chatPacket.print() << endl;

         connect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecvHandshake()));
      }
   }
}


ChatDlg::~ChatDlg(void)
{
   delete localName;
   if (remoteName != NULL) delete remoteName;
}


void ChatDlg::chatClose()
{
   chatSock.closeConnection();
   mleLocal->setReadOnly(true);
}



void ChatDlg::chatRecv()
{
   chatPacket.clearPacket();
   if (!chatSock.receivePacket(chatPacket, false)) 
   {
      QMessageBox::critical(this, "Licq", "Receive error - lost remote end of chat.", QMessageBox::Ok, 0);
      chatClose();
      return;
   }
   
   char chatChar;
   chatPacket >> chatChar;
   
   if (chatChar == (char)0x0D)
      mleRemote->newLine();
   else if (chatChar == (char)0x08)   // backspace
      mleRemote->backspace();
   else if (chatChar >= (char)0x20)
      mleRemote->appendChar(chatChar);
   else if (chatChar == (char)0x00) // change foreground color
   {
      char colorForeRed, colorForeGreen, colorForeBlue, tempChar;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorForeRed;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorForeGreen;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorForeBlue;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> tempChar;
      
      QColor newColor((unsigned char)colorForeRed, (unsigned char)colorForeGreen, (unsigned char)colorForeBlue);
      QColorGroup newColorGroup(newColor, mleRemote->palette().normal().background(), 
                                mleRemote->palette().normal().light(), mleRemote->palette().normal().dark(), 
                                mleRemote->palette().normal().mid(), newColor, 
                                mleRemote->palette().normal().base());
      mleRemote->setPalette(QPalette(newColorGroup, mleRemote->palette().disabled(), newColorGroup));
   }
   else if (chatChar == (char)0x01)  // change background color
   {    
      char colorBackRed, colorBackGreen, colorBackBlue, tempChar;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorBackRed;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorBackGreen;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> colorBackBlue;
      chatSock.receivePacket(chatPacket, false);
      chatPacket >> tempChar;
      
      cout << (unsigned int)colorBackRed << (unsigned int)colorBackGreen << (unsigned int)colorBackBlue << endl;

      QColor newColor((unsigned char)colorBackRed, (unsigned char)colorBackGreen, (unsigned char)colorBackBlue);
      QColorGroup newColorGroup(mleRemote->palette().normal().foreground(), newColor,
                                mleRemote->palette().normal().light(), mleRemote->palette().normal().dark(),
                                mleRemote->palette().normal().mid(), mleRemote->palette().normal().text(),
                                newColor);
      mleRemote->setPalette(QPalette(newColorGroup, mleRemote->palette().disabled(), newColorGroup));
   }
   /*
   else if (charChar == (char)0x10) // change font type 
   else if (charChar == (char)0x11) // change font style
   else if (charChar == (char)0x12) // change font size
   */
}



void ChatDlg::chatRecvHandshake()
{
   chatPacket.clearPacket();
   if (!chatSock.receivePacket(chatPacket)) 
   {
      QMessageBox::critical(this, "Licq", "Receive error - lost remote end of chat.", QMessageBox::Ok, 0);
      chatClose();
      return;
   }

   if (DEBUG_LEVEL >= 2) cout << "Chat packet received (TCP):\n" << chatPacket.print() << endl;

   unsigned long chatCmd, testLong;
   chatPacket >> chatCmd >> testLong;
   switch (chatCmd) 
   {
   case 100: // 0x64 - first or second handshake packet
      if (testLong == 0xFFFFFFFD) 
      {
         // we should just have received the first handshake packet:
         /* 64 00 00 00 FD FF FF FF 50 A5 82 00 08 00 38 35 36 32 30 30 30 00 62 3D 
            FF FF FF 00 00 00 00 00 00 */
         
         // the only interesting thing to take out is the user chat name and colors
         unsigned short nameLen;
         chatPacket >> testLong  // the uin
                    >> nameLen   // length of chat name (including null)
         ;
         remoteName = new char[nameLen + 1];
         for (unsigned short i = 0; i < nameLen; i++) 
            chatPacket >> remoteName[i];
         char remoteTitle[16 + nameLen];
         sprintf(remoteTitle, "Remote - %s", remoteName); 
         boxRemote->setTitle(remoteTitle);
         
         // set up the remote colors
         unsigned short tempShort;
         char colorForeRed, colorForeGreen, colorForeBlue, 
              colorBackRed, colorBackGreen, colorBackBlue, tempChar;
         chatPacket >> tempShort // chat port reversed
                    >> colorForeRed
                    >> colorForeGreen
                    >> colorForeBlue
                    >> tempChar
                    >> colorBackRed
                    >> colorBackGreen
                    >> colorBackBlue
         ;
         QColorGroup newColorGroup(QColor((unsigned char)colorForeRed, (unsigned char)colorForeGreen, (unsigned char)colorForeBlue), 
                                   QColor((unsigned char)colorBackRed, (unsigned char)colorBackGreen, (unsigned char)colorBackBlue), 
                                   mleRemote->palette().normal().light(), mleRemote->palette().normal().dark(),
                                   mleRemote->palette().normal().mid(), QColor(colorForeRed, colorForeGreen, colorForeBlue),
                                   QColor(colorBackRed, colorBackGreen, colorBackBlue));
         mleRemote->setPalette(QPalette(newColorGroup, mleRemote->palette().disabled(), newColorGroup));
      
         // send the font packet as reply
         /* 64 00 00 00 50 A5 82 00 08 00 38 35 36 32 30 30 30 00 FF FF FF 00 00 00 
            00 00 03 00 00 00 DB 64 00 00 CF 60 AD 95 CF 60 AD 95 04 75 5A 0C 00 00 
            00 00 00 00 00 08 00 43 6F 75 72 69 65 72 00 00 00 00 */
         chatPacket.clearPacket();
         char theFont[16];
         strcpy(theFont, "courier");  // hardcode courier 12 point as the font for now
         chatPacket << (unsigned long)0x64
                    << owner->uin()
                    << (unsigned short)(strlen(localName) + 1)
                    << localName
                    << (unsigned long)0x00FFFFFF  // foreground color (rr gg bb 00)
                    << (unsigned long)0x00000000  // background color (rr gg bb 00)
                    << (unsigned long)0x03
                    << (unsigned long)chatSock.localPort()
                    << LOCALHOST
                    << LOCALHOST
                    << (char)0x04
                    << (unsigned short)0x5A75  // font face?
                    << (unsigned short)0x000C  // font size
                    << (unsigned long)0x00000000
                    << (unsigned short)0x0000
                    << (unsigned short)(strlen(theFont) + 1)
                    << theFont
                    << (unsigned short)0x0000
                    << (char)0x00
         ;
         if (!chatSock.sendPacket(chatPacket))
         {
            QMessageBox::critical(this, "Licq", "Unable to send handshake - lost remote end of chat.", QMessageBox::Ok, 0);
            chatClose();
            return;
         }
         if (DEBUG_LEVEL >= 2) cout << "Chat packet sent (TCP):\n" << chatPacket.print() << endl;
      }
      else if (testLong == user->uin())   // font packet
      {
         // take out the interesting info from the font packet (ie the name)
         unsigned short nameLen;
         chatPacket >> nameLen;   // length of chat name (including null)
         remoteName = new char[nameLen + 1];
         for (unsigned short i = 0; i < nameLen; i++) 
            chatPacket >> remoteName[i];
         char remoteTitle[16 + nameLen];
         sprintf(remoteTitle, "Remote - %s", remoteName); 
         boxRemote->setTitle(remoteTitle);
         
         // set up the remote colors
         char colorForeRed, colorForeGreen, colorForeBlue, 
              colorBackRed, colorBackGreen, colorBackBlue, tempChar;
         chatPacket >> colorForeRed
                    >> colorForeGreen
                    >> colorForeBlue
                    >> tempChar
                    >> colorBackRed
                    >> colorBackGreen
                    >> colorBackBlue
         ;
         QColorGroup newColorGroup(QColor((unsigned char)colorForeRed, (unsigned char)colorForeGreen, (unsigned char)colorForeBlue), 
                                   QColor((unsigned char)colorBackRed, (unsigned char)colorBackGreen, (unsigned char)colorBackBlue), 
                                   mleRemote->palette().normal().light(), mleRemote->palette().normal().dark(),
                                   mleRemote->palette().normal().mid(), QColor(colorForeRed, colorForeGreen, colorForeBlue),
                                   QColor(colorBackRed, colorBackGreen, colorBackBlue));
         mleRemote->setPalette(QPalette(newColorGroup, mleRemote->palette().disabled(), newColorGroup));
         
         // prepare the reply
         /* 03 00 00 00 83 72 00 00 CF 60 AD 95 CF 60 AD 95 04 54 72 0C 00 00 00 00 
            00 00 00 08 00 43 6F 75 72 69 65 72 00 00 00 */
         char theFont[16];
         strcpy(theFont, "courier");  // hardcode courier as the font for now         
         chatPacket.clearPacket();
         chatPacket << (unsigned long)0x03
                    << (unsigned long)chatSock.localPort()
                    << LOCALHOST
                    << LOCALHOST
                    << (char)0x04
                    << (unsigned short)0x5A75  // font face?
                    << (unsigned short)0x000C  // font size
                    << (unsigned long)0x00000000
                    << (unsigned short)0x0000
                    << (unsigned short)(strlen(theFont) + 1)
                    << theFont
                    << (unsigned short)0x0000
                    << (char)0x00
         ;
         if (!chatSock.sendPacket(chatPacket))
         {
            QMessageBox::critical(this, "Licq", "Unable to send handshake - lost remote end of chat.", QMessageBox::Ok, 0);
            chatClose();
            return;
         }
         if (DEBUG_LEVEL >= 2) cout << "Chat packet sent (TCP):\n" << chatPacket.print() << endl;

         // now we are done with the handshaking
         disconnect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecvHandshake()));
         connect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecv()));
         connect(mleLocal, SIGNAL(keyPressed(QKeyEvent *)), this, SLOT(chatSend(QKeyEvent *)));
         mleLocal->setEnabled(true);
      }
      else  // what the fuck is it?
      {
         QMessageBox::critical(this, "Licq", "Unknown handshake - closing chat.", QMessageBox::Ok, 0);
         chatClose();
         return;
      }
      break;
   case 3:   // font reply
      /* 03 00 00 00 83 72 00 00 CF 60 AD 95 CF 60 AD 95 04 54 72 0C 00 00 00 00 
         00 00 00 08 00 43 6F 75 72 69 65 72 00 00 00 */
      // nothing useful in this packet, but we are done with handshaking now
      disconnect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecvHandshake()));
      connect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecv()));
      connect(mleLocal, SIGNAL(keyPressed(QKeyEvent *)), this, SLOT(chatSend(QKeyEvent *)));
      mleLocal->setEnabled(true);
      break;
   default: // not part of the handshaking stuff
      QMessageBox::critical(this, "Licq", "Receive error - bad handshake.", QMessageBox::Ok, 0);
      chatClose();
      return;
   }

}

void ChatDlg::chatRecvServer()
{
   chatSockServer.receiveConnection(chatSock);
   
   // get the handshake packet
   unsigned short chatCmd;
   chatSock.receivePacket(chatPacket);
   if (DEBUG_LEVEL >= 2) cout << "Chat packet received (TCP):\n" << chatPacket.print() << endl;
   chatPacket >> chatCmd;
   if (chatCmd != 0x03FF)  // not a handshake packet
   {
      chatSock.closeConnection();
   }
   else  // was a handshake packet
   {
      connect(chatSock.sn, SIGNAL(activated(int)), this, SLOT(chatRecvHandshake()));
   }
}


void ChatDlg::chatSend(QKeyEvent *e)
{
   chatPacket.clearPacket();
   if (isprint(e->ascii())) 
      chatPacket << (char)(e->ascii());
   else if (e->key() == Key_Enter) 
      chatPacket << (char)0x0D;
   else if (e->key() == Key_Return) 
      chatPacket << (char)0x0D;   
   else if (e->key() == Key_Backspace) 
      chatPacket << (char)0x08;
   
   if (!chatSock.sendPacket(chatPacket, false))
   {
      QMessageBox::critical(this, "Licq", "Unable to send - lost remote end of chat.", QMessageBox::Ok, 0);
      chatClose();
   }      
}


unsigned short ChatDlg::port(void)  { return(portVal); }


void ChatDlg::hide()
{
   QWidget::hide();
   delete this;
}


//-----ChatDlg::resizeEvent------------------------------------------------------------------------
void ChatDlg::resizeEvent (QResizeEvent *)
{
   boxRemote->setGeometry(10, 10, width() - 20, (height() - 80) / 2);
   mleRemote->setGeometry(10, 15, boxRemote->width() - 25, boxRemote->height() - 30);
   boxLocal->setGeometry(10, boxRemote->height() + 20, width() - 20, (height() - 80) / 2);
   mleLocal->setGeometry(10, 15, boxLocal->width() - 25, boxLocal->height() - 30);
   btnClose->setGeometry((width() / 2) - 50, height() - 40, 100, 30);
   mleRemote->repaint();
}
