// Search user code base written by Alan Penner (apenner@andrew.cmu.edu)
// modified by Graham Roff

#include <string>
#include <qpainter.h>
#include <iostream.h>

#include "searchuserdlg.h"


SearchUserView::SearchUserView(QWidget *parent = NULL, char *name = NULL) : QListView(parent, name)
{
   addColumn("Alias", 110);
   addColumn("UIN", 70);
   setColumnAlignment(1, AlignRight);
   addColumn("Name", 150);
   addColumn("Email", 200);
   setAllColumnsShowFocus (true); 
}


unsigned long SearchUserView::currentUin(void)
{
   if (currentItem() == NULL) return (0);
   return (((SearchItem *)currentItem())->uin());
}


SearchItem::SearchItem(struct UserStatusline &us, QListView *parent) : QListViewItem(parent)
{
   uinVal = (unsigned long)atol(us.uin);
   setText(0, us.alias);
   setText(1, us.uin);
   setText(2, us.name);
   setText(3, us.email);
}


unsigned long SearchItem::uin(void)
{
   return (uinVal);
}





SearchUserDlg::SearchUserDlg(ICQ *s, QWidget *parent = 0, const char *name = 0) : QDialog(parent, name)
{
   server = s;

   // pre-search widgets

   lblEmail = new QLabel("Email Address:", this);
   lblEmail->setGeometry(25, 5, 80, 20);
   edtEmail = new QLineEdit(this);
   edtEmail->setGeometry(115, 5, 180, 20);

   OtherBox = new QGroupBox(this);
   OtherBox->setFrameStyle(QFrame::HLine | QFrame::Raised);
   OtherBox->setGeometry(5, 32, 450, 2);

   lblFirst = new QLabel("First Name:", this);
   lblFirst->setGeometry(25, 40, 80, 20);
   edtFirst = new QLineEdit(this);
   edtFirst->setGeometry(115, 40, 180, 20);

   lblLast = new QLabel("Last Name:", this);
   lblLast->setGeometry(25, 65, 80, 20);
   edtLast = new QLineEdit(this);
   edtLast->setGeometry(115, 65, 180, 20);
   
   lblNick = new QLabel("Alias:", this);
   lblNick->setGeometry(25, 90, 80, 20);
   edtNick = new QLineEdit(this);
   edtNick->setGeometry(115, 90, 180, 20);

   btnSearch = new QPushButton("Search", this);
   btnSearch->setGeometry(80, 120, 80, 30);
   btnCancel = new QPushButton("Cancel", this);
   btnCancel->setGeometry(180, 120, 80, 30);

   connect (btnCancel, SIGNAL(clicked()), this, SLOT(reject()));
   connect (btnSearch, SIGNAL(clicked()), this, SLOT(startSearch()));
   connect (server, SIGNAL(userFound(struct UserStatusline &, unsigned long)), 
            this, SLOT(userFound(struct UserStatusline &, unsigned long)));
   connect (server, SIGNAL(doneSearch(unsigned short, char)), 
            this, SLOT(doneSearch(unsigned short, char)));

   
   // post-search widgets

   foundView = new SearchUserView(this);
   foundView->setGeometry(10, 200, 340, 180);
 
   btnCancelSearch = new QPushButton(this);
   btnCancelSearch->setText("Cancel");
   btnCancelSearch->setGeometry(180, 400, 80, 30);
   
   btnAdd = new QPushButton(this);
   btnAdd->setText("Add User");
   btnAdd->setGeometry(80, 400, 80, 30);
   btnAdd->setEnabled(false);
   
   lblSearch = new QLabel("Searching (this can take awhile)...", this);
   lblSearch->setGeometry(10, 170, 215, 20);
   /*
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(), normal.mid(), normal.text(), QColor(192, 192, 192));
   foundView->setPalette(QPalette(newNormal, pal.disabled(), newNormal));*/
   foundView->setStyle(WindowsStyle);
   foundView->setFrameStyle(QFrame::Box | QFrame::Raised);
 
   connect (btnCancelSearch, SIGNAL(clicked()), this, SLOT(reject()));
   connect (foundView, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(addUser()));
   connect (foundView, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(accept()));
   connect (btnAdd, SIGNAL(clicked()), this, SLOT(addUser()));
   connect (btnAdd, SIGNAL(clicked()), this, SLOT(accept()));
}


void SearchUserDlg::startSearch()
{
   searchSequence = server->icqOwner.searchSequence();
   server->startSearch((char *)edtNick->text(),
                       (char *)edtFirst->text(),
                       (char *)edtLast->text(),
                       (char *)edtEmail->text(),
                       searchSequence);
   foundView->clear();
   edtNick->setEnabled(false);
   edtFirst->setEnabled(false);
   edtLast->setEnabled(false);
   edtEmail->setEnabled(false);
   btnCancel->setEnabled(false);
   btnSearch->setEnabled(false);
   btnAdd->setEnabled(false);
   lblSearch->setText("Searching (this can take awhile)...");
   resize(360, 460);
}

void SearchUserDlg::show()
{
   edtNick->setEnabled(true);
   edtFirst->setEnabled(true);
   edtLast->setEnabled(true);
   edtEmail->setEnabled(true);
   edtEmail->setText("");
   edtLast->setText("");
   edtFirst->setText("");
   edtNick->setText("");
   btnCancel->setEnabled(true);
   btnSearch->setEnabled(true);
   foundView->clear();
   resize(360, 160);
   QDialog::show();
}


void SearchUserDlg::userFound(struct UserStatusline &us, unsigned long s = 0)
{
   if (s == searchSequence)
   {  
      (void) new SearchItem(us, foundView);
      if (!btnAdd->isEnabled()) btnAdd->setEnabled(true);
   }
}


void SearchUserDlg::doneSearch(unsigned short s, char more)
{
  if (s == searchSequence)
    if (more == (char)1)
      lblSearch->setText("More users found. Narrow search.");
    else
      lblSearch->setText("Search complete.");
}


void SearchUserDlg::addUser()
{
   unsigned long uin = foundView->currentUin();
   if (uin == 0) return;
   if (!server->knownUser(uin))  // make sure not to add a user we already have
       server->addUser(uin, NULL, true );
   foundView->clear();
}  
