/*
  Copyright (C) 1997,1998  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <errno.h>
#include "common.h"
#include "version.h"
#include "pcode.h"
#include "logs.h"

#ifdef SUNOS41x
#include <memory.h>
extern int sys_nerr;
extern char *sys_errlist[];
extern int errno;
extern long strtol();
extern int fputs(), fscanf(), sscanf(), vfprintf(), fprintf();
extern int fread(), fwrite(), fclose(), rename(), gethostname();
#endif

#ifdef SUNOS5x
#include <netdb.h>
extern int gethostname();
#endif

#define MAXNUM_VERSIONS   14
#define FIRSTNBIN_VERSION  8
#define FIRSTGLOB_VERSION 10
#define FIRSTVISP_VERSION 12
#define OLDMAXNUM_ISP      8
#define MAXNUM_ISP       256
#define OLDMAXNUM_SLINES   8
#define OLDMAXLEN_SLINE   32
#define OLDMAXLEN_DEVICE  16

typedef struct {
	char descr[MAXLEN_DESCR];
	char account[8+1];
	char passwd[8+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
} xisprc_t12;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[8+1];
	char passwd[8+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
} xisprc_t13;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[8+1];
	char passwd[8+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char modemOpts;
} xisprc_t14;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[8+1];
	char passwd[8+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
} xisprc_t16;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
} xisprc_t17;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t18;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][16+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t19;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char numCBSlns;
	char CBsln[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned short operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t20;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned short operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t21;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t22;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t23;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLDMAXNUM_SLINES][OLDMAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	char modemDevice[OLDMAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t24;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	char modemDevice[MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	char modemConnect[MAXLEN_MDMSTR+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t25;

typedef union {
	xisprc_t12 opts12[OLDMAXNUM_ISP];
	xisprc_t13 opts13[OLDMAXNUM_ISP];
	xisprc_t14 opts14[OLDMAXNUM_ISP];
	xisprc_t16 opts16[OLDMAXNUM_ISP];
	xisprc_t17 opts17[OLDMAXNUM_ISP];
	xisprc_t18 opts18[OLDMAXNUM_ISP];
	xisprc_t19 opts19[OLDMAXNUM_ISP];
	xisprc_t20 opts20[OLDMAXNUM_ISP];
	xisprc_t21 opts21[OLDMAXNUM_ISP];
	xisprc_t22 opts22[OLDMAXNUM_ISP];
	xisprc_t23 opts23[OLDMAXNUM_ISP];
	xisprc_t24 opts24[OLDMAXNUM_ISP];
	xisprc_t25 opts25[MAXNUM_ISP];
} xisprc_ut;

xisprc_ut orc, nrc;

int rcsize[MAXNUM_VERSIONS] = {sizeof(xisprc_t12), sizeof(xisprc_t13),
							   sizeof(xisprc_t14), sizeof(xisprc_t14),
							   sizeof(xisprc_t16), sizeof(xisprc_t17),
							   sizeof(xisprc_t18), sizeof(xisprc_t19),
							   sizeof(xisprc_t20), sizeof(xisprc_t21),
							   sizeof(xisprc_t22), sizeof(xisprc_t23),
							   sizeof(xisprc_t24), sizeof(xisprc_t25)};

typedef struct {
	unsigned char dfltISP;
} glob_t22;

typedef struct {
	unsigned char dfltISP;
	unsigned char dfltPTT;
	unsigned char dfltZone;
	unsigned int logOpts;
} glob_t23;

typedef struct {
	unsigned char numISPs;
	unsigned char dfltISP;
	unsigned char numPTTs;
	unsigned char dfltPTT;
	unsigned char dfltZone;
	unsigned int logOpts;
	char pppdPath[MAXLEN_PATH+1];
	char runPath[MAXLEN_PATH+1];
	char chatPath[MAXLEN_PATH+1];
	char utilsPath[MAXLEN_PATH+1];
	char pipePath[MAXLEN_PATH+1];
} glob_t24;

typedef union {
	glob_t22	glob22;
	glob_t23	glob23;
	glob_t24	glob24;
} glob_ut;

glob_ut ogl, ngl;

int globsize[MAXNUM_VERSIONS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
								 sizeof(glob_t22), sizeof(glob_t23),
								 sizeof(glob_t24), sizeof(glob_t24)};

char *rcname[MAXNUM_VERSIONS] = {"1.2","1.3","1.4","1.5",
								 "1.6","1.7","1.8","1.9",
								 "2.0","2.1","2.2","2.3",
								 "2.4",Version};
#define MAXLEN_VERSION 4

char *orcfname, *nrcfname;

#define MSGLEN_ERR 128

void doErr(char *msg)
{
	char emsg[MSGLEN_ERR+1];

#ifndef SUNOS5x
	if (errno < sys_nerr)
		sprintf(emsg, "xisprccv: %s: %s\n", msg, sys_errlist[errno]);
	else
		sprintf(emsg, "xisprccv: %s: error #%d\n", msg, errno);
#else
	sprintf(emsg, "xisprccv: %s: %s\n", msg, strerror(errno));
#endif
	fputs(emsg, stderr);
	exit(1);
}

void initXisprc13(int rec)
{
	int i;
	xisprc_t12 *p12 = &(orc.opts12[rec]);
	xisprc_t13 *p13 = &(nrc.opts13[rec]);

	strcpy(p13->descr, p12->descr);
	p13->autoRedial = 0;
	strcpy(p13->account, p12->account);
	strcpy(p13->passwd, p12->passwd);
	p13->maxAttempts = p12->maxAttempts;
	p13->sleepDelay = p12->sleepDelay;
	p13->numPhones = p12->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p13->phone[i], p12->phone[i]);
	p13->numSlines = p12->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++)
		strcpy(p13->sline[i], p12->sline[i]);
}

void initXisprc14(int rec)
{
	int i;
	xisprc_t13 *p13 = &(orc.opts13[rec]);
	xisprc_t14 *p14 = &(nrc.opts14[rec]);

	strcpy(p14->descr, p13->descr);
	p14->autoRedial = p13->autoRedial;
	strcpy(p14->account, p13->account);
	strcpy(p14->passwd, p13->passwd);
	p14->maxAttempts = p13->maxAttempts;
	p14->sleepDelay = p13->sleepDelay;
	p14->numPhones = p13->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p14->phone[i], p13->phone[i]);
	p14->numSlines = p13->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++)
		strcpy(p14->sline[i], p13->sline[i]);
	strcpy(p14->modemInit, MODEM_INIT);
	p14->modemOpts = MODEM_TONEDIAL;
}

void initXisprc15(int rec)
{
	nrc.opts14[rec] = orc.opts14[rec];
}

void initXisprc16(int rec)
{
	int i;
	xisprc_t14 *p14 = &(orc.opts14[rec]);
	xisprc_t16 *p16 = &(nrc.opts16[rec]);

	strcpy(p16->descr, p14->descr);
	p16->autoRedial = p14->autoRedial;
	strcpy(p16->account, p14->account);
	strcpy(p16->passwd, p14->passwd);
	p16->maxAttempts = p14->maxAttempts;
	p16->sleepDelay = p14->sleepDelay;
	p16->numPhones = p14->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p16->phone[i], p14->phone[i]);
	p16->numSlines = p14->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++)
		strcpy(p16->sline[i], p14->sline[i]);
	strcpy(p16->modemDevice, MODEM_DEVICE);
	p16->modemSpeed = MODEM_SPEED;
	strcpy(p16->modemInit, p14->modemInit);
	p16->operOpts = p14->modemOpts | PPPD_COMPRESS;
	p16->compLevel = COMP_LEVEL;
}

void initXisprc17(int rec)
{
	int i;
	xisprc_t16 *p16 = &(orc.opts16[rec]);
	xisprc_t17 *p17 = &(nrc.opts17[rec]);
	unsigned char ep[MAXLEN_PASSWD+1] = {0},
				  pp[MAXLEN_PASSWD+1] = {0};

	strcpy(p17->descr, p16->descr);
	p17->autoRedial = p16->autoRedial;
	strcpy(p17->account, p16->account);

	if (p16->passwd[0]) {
		pencode(ep, pp);
		memcpy(ep, p16->passwd, 8);
	}
	memcpy(p17->passwd, ep, MAXLEN_PASSWD);

	p17->maxAttempts = p16->maxAttempts;
	p17->sleepDelay = p16->sleepDelay;
	p17->numPhones = p16->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p17->phone[i], p16->phone[i]);
	p17->numSlines = p16->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++)
		strcpy(p17->sline[i], p16->sline[i]);
	strcpy(p17->modemDevice, p16->modemDevice);
	p17->modemSpeed = p16->modemSpeed;
	strcpy(p17->modemInit, p16->modemInit);
	p17->operOpts = p16->operOpts |
				   (HW_FLOWCTRL|ACCEPT_LOCALIP|ACCEPT_REMOTEIP|DEFAULT_ROUTE);
	p17->compLevel = p16->compLevel;
	strcpy(p17->asyncmap, PPPD_SASYNCMAP);
	strcpy(p17->escape, PPPD_ESCAPE);
	memcpy(p17->localIP, LOCAL_IP, 4);
	memcpy(p17->remoteIP, REMOTE_IP, 4);
	memcpy(p17->netmask, NETMASK, 4);
}

void initXisprc18(int rec)
{
	int i;
	xisprc_t17 *p17 = &(orc.opts17[rec]);
	xisprc_t18 *p18 = &(nrc.opts18[rec]);

	strcpy(p18->descr, p17->descr);
	p18->autoRedial = p17->autoRedial;
	strcpy(p18->account, p17->account);
	memcpy(p18->passwd, p17->passwd, MAXLEN_PASSWD);
	p18->maxAttempts = p17->maxAttempts;
	p18->sleepDelay = p17->sleepDelay;
	p18->numPhones = p17->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p18->phone[i], p17->phone[i]);
	p18->numSlines = p17->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++)
		strcpy(p18->sline[i], p17->sline[i]);
	strcpy(p18->modemDevice, p17->modemDevice);
	p18->modemSpeed = p17->modemSpeed;
	strcpy(p18->modemInit, p17->modemInit);
	p18->operOpts = p17->operOpts;
	p18->compLevel = p17->compLevel;
	strcpy(p18->asyncmap, PPPD_SASYNCMAP);
	strcpy(p18->escape, PPPD_ESCAPE);
	memcpy(p18->localIP, LOCAL_IP, 4);
	memcpy(p18->remoteIP, REMOTE_IP, 4);
	memcpy(p18->netmask, NETMASK, 4);
	p18->mtu = MTU;
	p18->mru = MRU;
}

void initXisprc19(int rec)
{
	int i;
	xisprc_t18 *p18 = &(orc.opts18[rec]);
	xisprc_t19 *p19 = &(nrc.opts19[rec]);
	char *p1, *p2, *pq;

	strcpy(p19->descr, p18->descr);
	p19->autoRedial = p18->autoRedial;
	strcpy(p19->account, p18->account);
	memcpy(p19->passwd, p18->passwd, MAXLEN_PASSWD);
	p19->maxAttempts = p18->maxAttempts;
	p19->sleepDelay = p18->sleepDelay;
	p19->numPhones = p18->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p19->phone[i], p18->phone[i]);
	p19->numSlines = p18->numSlines;
	for (i=0; i<p18->numSlines; i++) {
		p1 = p18->sline[i];
		p2 = strchr(p1, ' ');
		if (p2 < (pq = strchr(p1+1, '\'')))
			p2 = strchr(pq, ' ');
		*p2 = 0; ++p2;
		if (*p1 == '\'')
			++p1;
		if (*(p1+strlen(p1)-1) == '\'')
			*(p1+strlen(p1)-1) = 0;
		if (*p2 == '\'')
			++p2;
		if (*(p2+strlen(p2)-1) == '\'')
			*(p2+strlen(p2)-1) = 0;
		strcpy(p19->sline[i], p1);
		strcpy(p19->sline[OLDMAXNUM_SLINES+i], p2);
	}
	strcpy(p19->modemDevice, p18->modemDevice);
	p19->modemSpeed = p18->modemSpeed;
	strcpy(p19->modemInit, p18->modemInit);
	p19->operOpts = p18->operOpts;
	p19->compLevel = p18->compLevel;
	strcpy(p19->asyncmap, p18->asyncmap);
	strcpy(p19->escape, p18->escape);
	memcpy(p19->localIP, p18->localIP, 4);
	memcpy(p19->remoteIP, p18->remoteIP, 4);
	memcpy(p19->netmask, p18->netmask, 4);
	p19->mtu = p18->mtu;
	p19->mru = p18->mru;
}

void initXisprc20(int rec)
{
	int i;
	xisprc_t19 *p19 = &(orc.opts19[rec]);
	xisprc_t20 *p20 = &(nrc.opts20[rec]);

	strcpy(p20->descr, p19->descr);
	strcpy(p20->account, p19->account);
	memcpy(p20->passwd, p19->passwd, MAXLEN_PASSWD);
	p20->maxAttempts = p19->maxAttempts;
	p20->sleepDelay = p19->sleepDelay;
	p20->numPhones = p19->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p20->phone[i], p19->phone[i]);
	p20->numSlines = p19->numSlines;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p20->sline[i], p19->sline[i]);
	strcpy(p20->modemDevice, p19->modemDevice);
	p20->modemSpeed = p19->modemSpeed;
	strcpy(p20->modemInit, p19->modemInit);
	p20->operOpts = p19->operOpts;
	if (p19->autoRedial)
		p20->operOpts |= AUTO_REDIAL;
	p20->compLevel = p19->compLevel;
	if ( (p20->operOpts & HW_FLOWCTRL) &&
		 ! strcmp(p19->asyncmap, PPPD_SASYNCMAP))
		strcpy(p20->asyncmap, PPPD_HASYNCMAP);
	else
		strcpy(p20->asyncmap, p19->asyncmap);
	strcpy(p20->escape, p19->escape);
	memcpy(p20->localIP, p19->localIP, 4);
	memcpy(p20->remoteIP, p19->remoteIP, 4);
	memcpy(p20->netmask, p19->netmask, 4);
	p20->mtu = p19->mtu;
	p20->mru = p19->mru;
}

void initXisprc21(int rec)
{
	int i;
	xisprc_t20 *p20 = &(orc.opts20[rec]);
	xisprc_t21 *p21 = &(nrc.opts21[rec]);

	strcpy(p21->descr, p20->descr);
	strcpy(p21->account, p20->account);
	memcpy(p21->passwd, p20->passwd, MAXLEN_PASSWD);
	p21->name[0] = 0;
	p21->rname[0] = 0;
	p21->maxAttempts = p20->maxAttempts;
	p21->sleepDelay = p20->sleepDelay;
	p21->connectWait = MAXSEC_CNWAIT;
	p21->numPhones = p20->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p21->phone[i], p20->phone[i]);
	p21->numSlines = p20->numSlines;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p21->sline[i], p20->sline[i]);
	p21->CBDelay = MAXSEC_CBDELAY;
	p21->numCBSlns = p20->numCBSlns;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p21->CBsln[i], p20->CBsln[i]);
	strcpy(p21->modemDevice, p20->modemDevice);
	p21->modemSpeed = p20->modemSpeed;
	strcpy(p21->modemReset, MODEM_RESET);
	strcpy(p21->modemInit, p20->modemInit);
	p21->operOpts = p20->operOpts;
	p21->compLevel = p20->compLevel;
	strcpy(p21->asyncmap, p20->asyncmap);
	strcpy(p21->escape, p20->escape);
	memcpy(p21->localIP, p20->localIP, 4);
	memcpy(p21->remoteIP, p20->remoteIP, 4);
	memcpy(p21->netmask, p20->netmask, 4);
	memcpy(p21->dns1, DNS, 4);
	memcpy(p21->dns2, DNS, 4);
	p21->mtu = p20->mtu;
	p21->mru = p20->mru;
}

void initXisprc22(int rec)
{
	int i;
	xisprc_t21 *p21 = &(orc.opts21[rec]);
	xisprc_t22 *p22 = &(nrc.opts22[rec]);

	strcpy(p22->descr, p21->descr);
	strcpy(p22->account, p21->account);
	memcpy(p22->passwd, p21->passwd, MAXLEN_PASSWD);
	strcpy(p22->name, p21->name);
	strcpy(p22->rname, p21->rname);
	p22->maxAttempts = p21->maxAttempts;
	p22->sleepDelay = p21->sleepDelay;
	p22->connectWait = p21->connectWait;
	p22->numPhones = p21->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p22->phone[i], p21->phone[i]);
	p22->numSlines = p21->numSlines;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p22->sline[i], p21->sline[i]);
	p22->CBDelay = p21->CBDelay;
	p22->numCBSlns = p21->numCBSlns;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p22->CBsln[i], p21->CBsln[i]);
	strcpy(p22->modemDevice, p21->modemDevice);
	p22->modemSpeed = p21->modemSpeed;
	strcpy(p22->modemReset, p21->modemReset);
	strcpy(p22->modemInit, p21->modemInit);
	p22->operOpts = p21->operOpts;
	p22->compLevel = p21->compLevel;
	strcpy(p22->asyncmap, p21->asyncmap);
	strcpy(p22->escape, p21->escape);
	memcpy(p22->localIP, p21->localIP, 4);
	memcpy(p22->remoteIP, p21->remoteIP, 4);
	memcpy(p22->netmask, p21->netmask, 4);
	memcpy(p22->dns1, p21->dns1, 4);
	memcpy(p22->dns2, p21->dns2, 4);
	p22->mtu = p21->mtu;
	p22->mru = p21->mru;
}

void initXisprc23(int rec)
{
	int i, todo;
	char *p, new[2] = "PU";
	xisprc_t22 *p22 = &(orc.opts22[rec]);
	xisprc_t23 *p23 = &(nrc.opts23[rec]);

	strcpy(p23->descr, p22->descr);
	strcpy(p23->account, p22->account);
	memcpy(p23->passwd, p22->passwd, MAXLEN_PASSWD);
	strcpy(p23->name, p22->name);
	strcpy(p23->rname, p22->rname);
	p23->maxAttempts = p22->maxAttempts;
	p23->sleepDelay = p22->sleepDelay;
	p23->connectWait = p22->connectWait;
	p23->numPhones = p22->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p23->phone[i], p22->phone[i]);
	p23->numSlines = p22->numSlines;
	for (i=0, todo=2; i<(2*OLDMAXNUM_SLINES); i++) {
		strcpy(p23->sline[i], p22->sline[i]);
		if (todo && (p=strstr(p23->sline[i], "%s")) != NULL) {
			*(p+1) = new[todo-1];
			--todo;
		}
	}
	p23->CBDelay = p22->CBDelay;
	p23->numCBSlns = p22->numCBSlns;
	for (i=0, todo=2; i<(2*OLDMAXNUM_SLINES); i++) {
		strcpy(p23->CBsln[i], p22->CBsln[i]);
		if (todo && (p=strstr(p23->CBsln[i], "%s")) != NULL) {
			*(p+1) = new[todo-1];
			--todo;
		}
	}
	strcpy(p23->modemDevice, p22->modemDevice);
	p23->modemSpeed = p22->modemSpeed;
	strcpy(p23->modemReset, p22->modemReset);
	strcpy(p23->modemInit, p22->modemInit);
	p23->operOpts = p22->operOpts;
	strcpy(p23->dialExtra, DIAL_EXTRA);
	p23->compLevel = p22->compLevel;
	strcpy(p23->asyncmap, p22->asyncmap);
	strcpy(p23->escape, p22->escape);
	memcpy(p23->localIP, p22->localIP, 4);
	memcpy(p23->remoteIP, p22->remoteIP, 4);
	memcpy(p23->netmask, p22->netmask, 4);
	memcpy(p23->dns1, p22->dns1, 4);
	memcpy(p23->dns2, p22->dns2, 4);
	p23->mtu = p22->mtu;
	p23->mru = p22->mru;
}

void initXisprc24(int rec)
{
	int i;
	xisprc_t23 *p23 = &(orc.opts23[rec]);
	xisprc_t24 *p24 = &(nrc.opts24[rec]);

	strcpy(p24->descr, p23->descr);
	strcpy(p24->account, p23->account);
	memcpy(p24->passwd, p23->passwd, MAXLEN_PASSWD);
	strcpy(p24->name, p23->name);
	strcpy(p24->rname, p23->rname);
	p24->maxAttempts = p23->maxAttempts;
	p24->sleepDelay = p23->sleepDelay;
	p24->connectWait = p23->connectWait;
	p24->numPhones = p23->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p24->phone[i], p23->phone[i]);
	p24->numSlines = p23->numSlines;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p24->sline[i], p23->sline[i]);
	p24->CBDelay = p23->CBDelay;
	p24->numCBSlns = p23->numCBSlns;
	for (i=0; i<(2*OLDMAXNUM_SLINES); i++)
		strcpy(p24->CBsln[i], p23->CBsln[i]);
	p24->termW = TERMW;
	p24->termH = TERMH;
	strcpy(p24->modemDevice, p23->modemDevice);
	p24->modemSpeed = p23->modemSpeed;
	strcpy(p24->modemReset, p23->modemReset);
	strcpy(p24->modemInit, p23->modemInit);
	p24->operOpts = p23->operOpts;
	strcpy(p24->dialExtra, DIAL_EXTRA);
	p24->compLevel = p23->compLevel;
	strcpy(p24->asyncmap, p23->asyncmap);
	strcpy(p24->escape, p23->escape);
	memcpy(p24->localIP, p23->localIP, 4);
	memcpy(p24->remoteIP, p23->remoteIP, 4);
	memcpy(p24->netmask, p23->netmask, 4);
	memcpy(p24->dns1, p23->dns1, 4);
	memcpy(p24->dns2, p23->dns2, 4);
	p24->mtu = p23->mtu;
	p24->mru = p23->mru;
}

void initXisprc25(int rec)
{
	int i;
	xisprc_t24 *p24 = &(orc.opts24[rec]);
	xisprc_t25 *p25 = &(nrc.opts25[rec]);

	strcpy(p25->descr, p24->descr);
	strcpy(p25->account, p24->account);
	memcpy(p25->passwd, p24->passwd, MAXLEN_PASSWD);
	strcpy(p25->name, p24->name);
	strcpy(p25->rname, p24->rname);
	p25->maxAttempts = p24->maxAttempts;
	p25->sleepDelay = p24->sleepDelay;
	p25->connectWait = p24->connectWait;
	p25->numPhones = p24->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p25->phone[i], p24->phone[i]);
	p25->numSlines = p24->numSlines;
	for (i=0; i<OLDMAXNUM_SLINES; i++) {
		strcpy(p25->sline[i], p24->sline[i]);
		strcpy(p25->sline[MAXNUM_SLINES+i], p24->sline[OLDMAXNUM_SLINES+i]);
	}
	for (; i<MAXNUM_SLINES; i++)
		p25->sline[i][0] = p25->sline[MAXNUM_SLINES+i][0] = 0;
	p25->CBDelay = p24->CBDelay;
	p25->numCBSlns = p24->numCBSlns;
	for (i=0; i<OLDMAXNUM_SLINES; i++) {
		strcpy(p25->CBsln[i], p24->CBsln[i]);
		strcpy(p25->CBsln[MAXNUM_SLINES+i], p24->CBsln[OLDMAXNUM_SLINES+i]);
	}
	for (; i<MAXNUM_SLINES; i++)
		p25->CBsln[i][0] = p25->CBsln[MAXNUM_SLINES+i][0] = 0;
	p25->termW = TERMW;
	p25->termH = TERMH;
	strcpy(p25->modemDevice, p24->modemDevice);
	p25->modemSpeed = p24->modemSpeed;
	strcpy(p25->modemReset, p24->modemReset);
	strcpy(p25->modemInit, p24->modemInit);
	strcpy(p25->modemConnect, MODEM_CONNECT);
	p25->operOpts = p24->operOpts;
	strcpy(p25->dialExtra, DIAL_EXTRA);
	p25->compLevel = p24->compLevel;
	strcpy(p25->asyncmap, p24->asyncmap);
	strcpy(p25->escape, p24->escape);
	memcpy(p25->localIP, p24->localIP, 4);
	memcpy(p25->remoteIP, p24->remoteIP, 4);
	memcpy(p25->netmask, p24->netmask, 4);
	memcpy(p25->dns1, p24->dns1, 4);
	memcpy(p25->dns2, p24->dns2, 4);
	p25->mtu = p24->mtu;
	p25->mru = p24->mru;
}

void initGlobal22(void)
{
	glob_t22 *g22 = &(ngl.glob22);

	g22->dfltISP = 1;
}

void initGlobal23(void)
{
	glob_t22 *g22 = &(ogl.glob22);
	glob_t23 *g23 = &(ngl.glob23);

	g23->dfltISP = g22->dfltISP;
	g23->dfltPTT = PTT_GR;
	g23->dfltZone = 0;
	g23->logOpts = LOG_NONE;
}

void initGlobal24(void)
{
	glob_t23 *g23 = &(ogl.glob23);
	glob_t24 *g24 = &(ngl.glob24);
	xisprc_t24 *p24;
	int i;

	g24->numISPs = 0;
	for (i=0; i<OLDMAXNUM_ISP; i++) {
		p24 = &(nrc.opts24[i]);
		if (*(p24->descr)) g24->numISPs += 1;
		else break;
	}
	g24->dfltISP = g23->dfltISP;
	g24->numPTTs = MAXNUM_PTT;
	g24->dfltPTT = g23->dfltPTT;
	g24->dfltZone = g23->dfltZone;
	g24->logOpts = g23->logOpts;
	strcpy(g24->pppdPath, PPPD_PATH);
	strcpy(g24->runPath, RUN_PATH);
	strcpy(g24->chatPath, CHAT_PATH);
	strcpy(g24->utilsPath, UTILS_PATH);
	strcpy(g24->pipePath, PIPE_PATH);
}

void initGlobal25(void)
{
	ngl.glob24 = ogl.glob24;
}

void (* initrc[MAXNUM_VERSIONS])(int) = {initXisprc13, initXisprc14,
										 initXisprc15, initXisprc16,
										 initXisprc17, initXisprc18,
										 initXisprc19, initXisprc20,
										 initXisprc21, initXisprc22,
										 initXisprc23, initXisprc24,
										 initXisprc25, NULL};

void (* initg[MAXNUM_VERSIONS])(void) = {NULL, NULL, NULL, NULL,
										 NULL, NULL, NULL, NULL,
										 NULL,         initGlobal22,
										 initGlobal23, initGlobal24,
										 initGlobal25, NULL};

char *passwd2ascii(unsigned char *pwd)
{
	static unsigned char apwd[2*MAXLEN_PASSWD+1];
	unsigned char msh, lsh, *p;
	int i;

	for (i=0, p=apwd; i<MAXLEN_PASSWD; i++, pwd++) {
		msh = (*pwd & 0xF0) >> 4;
		lsh = *pwd & 0x0F;
		*p++ = lsh + 'A';
		*p++ = msh + 'A';
	}
	*p = 0;
	return apwd;
}

char *IP2str(unsigned char *ip)
{
	static char IPstr[16];

	sprintf(IPstr, "%u.%u.%u.%u",
			ip[0],ip[1],ip[2],ip[3]);
	return IPstr;
}

char *speed2str(unsigned char speed)
{
	static char sstr[8][8] = {"1200","2400","4800","9600",
							  "19200","38400","57600","115200"};
	static int snum[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	int i;

	for (i=0; i<8; i++)
		if (speed & snum[i])
			return sstr[i];
	return NULL;
}

char *ascii2passwd(char *buf)
{
	static unsigned char pwd[MAXLEN_PASSWD+1];
	unsigned char msh, lsh, *p;
	int i = 0;

	if (*buf) {
		for (p=pwd; i<MAXLEN_PASSWD; i++) {
			lsh = (*buf++ - 'A') & 0x0F;
			msh = (*buf++ - 'A') & 0x0F;
			pwd[i] = (msh << 4) | lsh;
		}
	}
	pwd[i] = 0;
	return pwd;
}

unsigned int str2speed(char *buf)
{
	static char sstr[8][8] = {"1200","2400","4800","9600",
							  "19200","38400","57600","115200"};
	static int snum[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	int i;

	for (i=0; i<8; i++)
		if (strcmp(buf, sstr[i]) == 0)
			return snum[i];
	return 0;
}

unsigned char *str2IP(char *buf)
{
	static unsigned char ip[4];
	unsigned int iip[4];
	int i;

	i = sscanf(buf, "%3u.%3u.%3u.%3u", &iip[0],
			   &iip[1], &iip[2], &iip[3]);
	if (i < 4)
		return NULL;
	for (i=0; i<4; i++)
		ip[i] = iip[i];
	return ip;
}

void rcISP(FILE *fp, int nISP)
{
	int n;

	if (fscanf(fp, "-%3d- ", &n) < 1) {
		fprintf(stderr, "xisprccv: rcISP: error reading ISP number in %s\n",
				nrcfname);
		exit(1);
	}
	if (n != nISP) {
		fprintf(stderr, "xisprccv: rcISP: ISP sequence number wrong in %s\n",
				nrcfname);
		fprintf(stderr, "xisprccv: rcISP: expected %d, got %d\n", nISP, n);
		exit(1);
	}
}

void rcLineError(char *function, char *line)
{
	fprintf(stderr, "xisprccv: %s: error reading %s\n", function, nrcfname);
	fprintf(stderr, "xisprccv: %s: offending line: [%s]\n", function, line);
	exit(1);
}

#define MAXLEN_LINE 256
#define MAXLEN_PARAM 128

char *readParm21(FILE *fp, char *name, char type,
			   int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	int iparam, hex = 0, len;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readParm21: %s: premature EOF\n", nrcfname);
		exit(1);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		rcLineError("readParm21", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readParm21: expected [%s], got [%s]\n",
				name, line);
		exit(1);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				rcLineError("readParm21", line);
			strcpy((char *)data, sparam);
			break;

		case 'X':
			hex = 1;
		case 'B':
		case 'I':
			iparam = strtol(sparam, &endp, (hex)? 16:10);
			if ((!hex && (ulimit<iparam || iparam<llimit)) ||
				 endp == sparam || *endp )
				rcLineError("readParm21", line);
			if (type == 'B') *((unsigned char *)data) = iparam;
			else if (type == 'X') *((unsigned short *)data) = iparam;
			else if (type == 'I') *((unsigned int *)data) = iparam;
			break;

		default: break;
	}
	return(line);
}

char *readParm22(FILE *fp, char *name, char type,
			   int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	int iparam, hex = 0, len;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readParm22: %s: premature EOF\n", nrcfname);
		exit(1);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		rcLineError("readParm22", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readParm22: expected [%s], got [%s]\n",
				name, line);
		exit(1);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				rcLineError("readParm22", line);
			strcpy((char *)data, sparam);
			break;

		case 'X':
			hex = 1;
		case 'B':
		case 'I':
			iparam = strtol(sparam, &endp, (hex)? 16:10);
			if ((!hex && (ulimit<iparam || iparam<llimit)) ||
				 endp == sparam || *endp )
				rcLineError("readParm22", line);
			if (type == 'B') *((unsigned char *)data) = iparam;
			else *((unsigned int *)data) = iparam;
			break;

		default: break;
	}
	return(line);
}

void inputAllXisprc20(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t20 *p = &(up->opts20[0]);
	glob_t22 *g;

	g = &(ug->glob22);
	fgets(buf, 2*MAXLEN_PASSWD-1, rcfp);
	for (i=0; i<OLDMAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm21(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm21(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm21(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, ascii2passwd(buf), MAXLEN_PASSWD);
		readParm21(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm21(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm21(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm21(rcfp, pname, 'S', 1, MAXLEN_PHONE, p->phone[j]);
		}
		readParm21(rcfp, "NUMSLINES", 'B', 0, OLDMAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm21(rcfp, pname, 'S', 1, OLDMAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm21(rcfp, pname, 'S', 1, OLDMAXLEN_SLINE,
					  p->sline[OLDMAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "NUMCBSLINES", 'B',0, OLDMAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm21(rcfp, pname, 'S', 1, OLDMAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm21(rcfp, pname, 'S', 1, OLDMAXLEN_SLINE,
					  p->CBsln[OLDMAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "MODEMDEVICE", 'S', 1, OLDMAXLEN_DEVICE, p->modemDevice);
		line = readParm21(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm21(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm21(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm21(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm21(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm21(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm21(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm21(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm21(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		readParm21(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm21(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

static void inputAllXisprc21(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t21 *p = &(up->opts21[0]);
	glob_t22 *g;

	g = &(ug->glob22);
	fgets(buf, 2*MAXLEN_PASSWD-1, rcfp);
	for (i=0; i<OLDMAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm21(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm21(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm21(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, ascii2passwd(buf), MAXLEN_PASSWD);
		readParm21(rcfp, "NAME", 'S', 0, MAXLEN_UNR, p->name);
		readParm21(rcfp, "REMOTENAME", 'S', 0, MAXLEN_UNR, p->rname);
		readParm21(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm21(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm21(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm21(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm21(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm21(rcfp, "NUMSLINES", 'B', 0, OLDMAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm21(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm21(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->sline[OLDMAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm21(rcfp, "NUMCBSLINES", 'B',0, OLDMAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm21(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm21(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->CBsln[OLDMAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "MODEMDEVICE", 'S', 0, OLDMAXLEN_DEVICE, p->modemDevice);
		line = readParm21(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm21(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm21(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm21(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm21(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm21(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm21(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm21(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm21(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm21(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm21(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm21(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm21(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm21(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

static void inputAllXisprc22(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t22 *p = &(up->opts22[0]);
	glob_t22 *g = &(ug->glob22);

	fgets(buf, 2*MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "DEFAULT_ISP", 'B', 0, OLDMAXNUM_ISP, &(g->dfltISP));
	for (i=0; i<OLDMAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, ascii2passwd(buf), MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLDMAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->sline[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B',0, OLDMAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->CBsln[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, OLDMAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

static void inputAllXisprc23(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t23 *p = &(up->opts23[0]);
	glob_t23 *g = &(ug->glob23);

	fgets(buf, 2*MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "DEFAULTISP", 'B', 0, OLDMAXNUM_ISP, &(g->dfltISP));
	readParm22(rcfp, "QTHPTT", 'B', 0, MAXNUM_PTT, &(g->dfltPTT));
	readParm22(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES, &(g->dfltZone));
	readParm22(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	for (i=0; i<OLDMAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, ascii2passwd(buf), MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLDMAXNUM_SLINES,
				   &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->sline[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B',0, OLDMAXNUM_SLINES,
				   &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					  p->CBsln[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, OLDMAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

static void inputAllXisprc24(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t24 *p = &(up->opts24[0]);
	glob_t24 *g = &(ug->glob24);

	fgets(buf, 2*MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "NUMISPS", 'B', 0, 255, &(g->numISPs));
	readParm22(rcfp, "DEFAULTISP", 'B', 0, 255, &(g->dfltISP));
	readParm22(rcfp, "NUMPTTS", 'B', 1, 255, &(g->numPTTs));
	readParm22(rcfp, "QTHPTT", 'B', 0, (g->numPTTs)-1, &(g->dfltPTT));
	readParm22(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES-1, &(g->dfltZone));
	readParm22(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	readParm22(rcfp, "PPPDPATH", 'S', 0, MAXLEN_PATH, g->pppdPath);
	readParm22(rcfp, "RUNPATH", 'S', 0, MAXLEN_PATH, g->runPath);
	readParm22(rcfp, "CHATPATH", 'S', 0, MAXLEN_PATH, g->chatPath);
	readParm22(rcfp, "UTILSPATH", 'S', 0, MAXLEN_PATH, g->utilsPath);
	readParm22(rcfp, "PIPEPATH", 'S', 0, MAXLEN_PATH, g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		memset(p, 0, sizeof(xisprc_t));
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, ascii2passwd(buf), MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLDMAXNUM_SLINES,
				   &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					   p->sline[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B', 0, OLDMAXNUM_SLINES,
				   &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLDMAXLEN_SLINE,
					   p->CBsln[OLDMAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "TERMW", 'B', MINCHAR_TERMW, 255, &(p->termW));
		readParm22(rcfp, "TERMH", 'B', MINCHAR_TERMH, 255, &(p->termH));
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, MAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

void (* inputAllXisprc[MAXNUM_VERSIONS])(xisprc_ut*, FILE*, glob_ut*) =
	{NULL, NULL, NULL, NULL,
	 NULL, NULL, NULL, NULL,
	 inputAllXisprc20, inputAllXisprc21,
	 inputAllXisprc22, inputAllXisprc23,
	 inputAllXisprc24, NULL};

int rcVersion()
{
	struct stat st;
	FILE *rcfp;
	char buf[64];
	int ov;

	stat(nrcfname, &st);
	for (ov=0; ov<FIRSTNBIN_VERSION; ov++)
		if (st.st_size == OLDMAXNUM_ISP*rcsize[ov]) break;

	if (ov == FIRSTNBIN_VERSION) {
		rcfp = fopen(nrcfname, "r");
		if (rcfp == NULL) {
			sprintf(buf, "rcVersion: fopen(%s)", nrcfname);
			doErr(buf);
		}
		if (fscanf(rcfp, "xISP-%7[.0-9] ", buf) != 1) {
			fputs("xisprccv: rcVersion: error reading file version!\n",
				  stderr);
			exit(1);
		}
		for (ov=FIRSTNBIN_VERSION; ov<MAXNUM_VERSIONS; ov++)
			if (!strcmp(buf, rcname[ov])) break;
		if (ov == MAXNUM_VERSIONS) {
			fprintf(stderr, "xisprccv: rcVersion: %s: unknown version!\n",
					nrcfname);
			fprintf(stderr, "xisprccv: rcVersion: %s: not converted.\n",
					nrcfname);
			exit(1);
		}
		fclose(rcfp);
	}
	return ov;
}

void readXisprc(int ver)
{
	FILE *rcfp;
	int rw;
	char msg[64];

	rcfp = fopen(nrcfname, "r");
	if (rcfp == NULL) {
		sprintf(msg, "readXisprc: fopen(%s)", nrcfname);
		doErr(msg);
	}
	if (ver < FIRSTNBIN_VERSION) {
		rw = fread(&orc, rcsize[ver], OLDMAXNUM_ISP, rcfp);
		if (rw != OLDMAXNUM_ISP) {
			sprintf(msg, "readXisprc: fread(%s)", nrcfname);
			doErr(msg);
		}
	}
	else
		(*inputAllXisprc[ver])(&orc, rcfp, &ogl);
	fclose(rcfp);
}

int rcPrint(va_alist) va_dcl
{
	int bw;
	va_list ap;
	char *fmt;
	FILE *fp;

	va_start(ap);
	fp = va_arg(ap, FILE*);
	fmt = va_arg(ap, char*);
	bw = vfprintf(fp, fmt, ap);
	va_end(ap);
	if (bw <= 0)
		doErr("outputAllXisprc");
	return bw;
}

void outputAllXisprc(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, n;
	xisprc_t25 *p = &(up->opts25[0]);
	glob_t24 *g = &(ug->glob24);

	rcPrint(rcfp, "xISP-%s\n", Version);
	rcPrint(rcfp, "NUMISPS: %d\n", g->numISPs);
	rcPrint(rcfp, "DEFAULTISP: %d\n", g->dfltISP);
	rcPrint(rcfp, "NUMPTTS: %d\n", g->numPTTs);
	rcPrint(rcfp, "QTHPTT: %d\n", g->dfltPTT);
	rcPrint(rcfp, "QTHZONE: %d\n", g->dfltZone);
	rcPrint(rcfp, "LOGOPTS: %X\n", g->logOpts);
	rcPrint(rcfp, "PPPDPATH: %s\n", g->pppdPath);
	rcPrint(rcfp, "RUNPATH: %s\n", g->runPath);
	rcPrint(rcfp, "CHATPATH: %s\n", g->chatPath);
	rcPrint(rcfp, "UTILSPATH: %s\n", g->utilsPath);
	rcPrint(rcfp, "PIPEPATH: %s\n", g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		rcPrint(rcfp, "-%d-\n", i);
		rcPrint(rcfp, "DESCR: %s\n", p->descr);
		rcPrint(rcfp, "ACCOUNT: %s\n", p->account);
		if (*(p->account))
			rcPrint(rcfp, "PASSWD: %s\n", passwd2ascii(p->passwd));
		else
			rcPrint(rcfp, "PASSWD: \n");
		rcPrint(rcfp, "NAME: %s\n", p->name);
		rcPrint(rcfp, "REMOTENAME: %s\n", p->rname);
		rcPrint(rcfp, "MAXATTEMPTS: %d\n", p->maxAttempts);
		rcPrint(rcfp, "SLEEPDELAY: %d\n", p->sleepDelay);
		rcPrint(rcfp, "CONNECTWAIT: %d\n", p->connectWait);
		rcPrint(rcfp, "NUMPHONES: %d\n", p->numPhones);
		for (n=0; n<p->numPhones; n++)
			rcPrint(rcfp, " PHONE%d: %s\n", n, p->phone[n]);
		rcPrint(rcfp, "NUMSLINES: %d\n", p->numSlines);
		for (n=0; n<p->numSlines; n++) {
			rcPrint(rcfp, " SLINE%dE: %s\n", n, p->sline[n]);
			rcPrint(rcfp, " SLINE%dS: %s\n", n, p->sline[MAXNUM_SLINES+n]);
		}
		rcPrint(rcfp, "CBDELAY: %d\n", p->CBDelay);
		rcPrint(rcfp, "NUMCBSLINES: %d\n", p->numCBSlns);
		for (n=0; n<p->numCBSlns; n++) {
			rcPrint(rcfp, " CBSLINE%dE: %s\n", n, p->CBsln[n]);
			rcPrint(rcfp, " CBSLINE%dS: %s\n", n, p->CBsln[MAXNUM_SLINES+n]);
		}
		rcPrint(rcfp, "TERMW: %d\n", p->termW);
		rcPrint(rcfp, "TERMH: %d\n", p->termH);
		rcPrint(rcfp, "MODEMDEVICE: %s\n", p->modemDevice);
		rcPrint(rcfp, "MODEMSPEED: %s\n", speed2str(p->modemSpeed));
		rcPrint(rcfp, "MODEMRESET: %s\n", p->modemReset);
		rcPrint(rcfp, "MODEMINIT: %s\n", p->modemInit);
		rcPrint(rcfp, "MODEMCONNECT: %s\n", p->modemConnect);
		rcPrint(rcfp, "OPEROPTS: %X\n", p->operOpts);
		rcPrint(rcfp, "DIALEXTRA: %s\n", p->dialExtra);
		rcPrint(rcfp, "COMPLEVEL: %d\n", p->compLevel);
		rcPrint(rcfp, "ASYNCMAP: %s\n", p->asyncmap);
		rcPrint(rcfp, "ESCAPE: %s\n", p->escape);
		rcPrint(rcfp, "LOCALIP: %s\n", IP2str(p->localIP));
		rcPrint(rcfp, "REMOTEIP: %s\n", IP2str(p->remoteIP));
		rcPrint(rcfp, "NETMASK: %s\n", IP2str(p->netmask));
		rcPrint(rcfp, "DNS1: %s\n", IP2str(p->dns1));
		rcPrint(rcfp, "DNS2: %s\n", IP2str(p->dns2));
		rcPrint(rcfp, "MTU: %u\n", p->mtu);
		rcPrint(rcfp, "MRU: %u\n", p->mru);
	}
}

void writeXisprc(int ver)
{
	FILE *rcfp;
	char msg[64];

	rcfp = fopen(nrcfname, "w");
	if (rcfp == NULL) {
		sprintf(msg, "writeXisprc: fopen(%s)", nrcfname);
		doErr(msg);
	}
	outputAllXisprc(&nrc, rcfp, &ngl);
	fclose(rcfp);
}

void outofMem(void)
{
	fprintf(stderr, "xisprccv: out of memory!\n");
	exit(1);
}

void initFnames(void)
{
	struct passwd *user = getpwuid(getuid());
	int hdirlen = strlen(user->pw_dir), per_host = 0;
	char hostname[MAXHOSTNAMELEN+1];

	if (gethostname(hostname, MAXHOSTNAMELEN) == 0) {
		nrcfname =
			(char *)malloc(hdirlen+1+strlen(RCFNAME)+1+MAXHOSTNAMELEN+1);
		if (nrcfname != NULL) {
			strcpy(nrcfname, user->pw_dir); strcat(nrcfname, "/");
			strcat(nrcfname, RCFNAME); strcat(nrcfname, ".");
			strcat(nrcfname, hostname);
		}
		else outofMem();
		if (access(nrcfname, R_OK) == 0) per_host = 1;
		else free(nrcfname);
	}
	if (! per_host) {
		nrcfname = (char *)malloc(hdirlen+1+strlen(RCFNAME)+1);
		if (nrcfname != NULL) {
			strcpy(nrcfname, user->pw_dir); strcat(nrcfname, "/");
			strcat(nrcfname, RCFNAME);
		}
		else outofMem();
	}
	orcfname = (char *)malloc(strlen(nrcfname)+1+MAXLEN_VERSION);
	if (orcfname != NULL) {
		strcpy(orcfname, nrcfname);
		strcat(orcfname, "-");
	}
	else outofMem();
}

int main()
{
	int ov = 0, nv = MAXNUM_VERSIONS-1, i, j, nISPs = 0;
	char *rcsp = RCSid;

	rcsp = PatchLevel;
	umask(077);
	pcode_init();
	initFnames();

	ov = rcVersion();
	if (ov == nv) {
		fprintf(stderr, "xisprccv: %s: compatible with v%s.\n",
				nrcfname, rcname[ov]);
		fprintf(stderr, "xisprccv: %s: not converted.\n", nrcfname);
		return 0;
	}
	strcat(orcfname, rcname[ov]);

	readXisprc(ov);
	rename(nrcfname, orcfname);
	for (i=ov; i<nv; i++) {
		if (i < FIRSTVISP_VERSION)
			nISPs = OLDMAXNUM_ISP;
		else
			nISPs = ogl.glob24.numISPs;
		memset(&nrc, 0, nISPs*rcsize[i+1]);
		for (j=0; j<nISPs; j++)
			(*initrc[i])(j);
		memcpy(&orc, &nrc, nISPs*rcsize[i+1]);
		if (i >= (FIRSTGLOB_VERSION-1))
			(*initg[i])();
		memcpy(&ogl, &ngl, globsize[i+1]);
	}
	writeXisprc(nv);

	fprintf(stderr, "xisprccv: %s: converted from v%s to v%s.\n",
			nrcfname, rcname[ov], rcname[nv]);
	return 0;
}

