#ifndef AudioDialog_h
#define AudioDialog_h

#include "AudioDialogData.h"
#include "AudioConfig.h"
#include "GlobalIcon.h"

class AudioDialog : public AudioDialogData
{
    Q_OBJECT

 public:

    AudioDialog(QWidget* parent=0, const char* name=0);
    
    void setConfig(const AudioConfig&);
    const AudioConfig& getConfig() const;
    void setButtons();

 protected:

    AudioConfig config;

 protected slots:
	
    void setPrecision(int);
    void setChannels(int);
    void setFrequency(int);
    void setBitsPerSample(int p)  { setPrecision(p); }  // old name

 signals:

    void changed(const AudioConfig&);
};

#endif  // AudioDialog_h
