#ifndef AudioDriver_h
#define AudioDriver_h

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <unistd.h>

// These next includes were not required if libsidplay would not
// provide related HAVE_* definitions.
#include <sidplay/compconf.h>
#if defined(HAVE_LINUX) && defined(HAVE_LINUX_SOUNDCARD_H)
  #include <linux/soundcard.h>
#elif defined(HAVE_FREEBSD) && defined((HAVE_MACHINE_SOUNDCARD_H)
  #include <machine/soundcard.h>
#else
  #error Audio driver not supported.
#endif

#include "AudioConfig.h"

class AudioDriver
{

 public:  // --------------------------------------------------------- public

    static const char AUDIODEVICE[];

    AudioDriver();
    ~AudioDriver();
  
    // Check device availability and write permissions.
    bool isThere();

    bool open(const AudioConfig&);
    
    // Free and close opened audio device and reset any variables that
    // reflect the current state of the driver.
    void close();
    
    void play(void* buffer, unsigned long int bufferSize);

    bool reset()
    {
        if (audioHd != (-1))
            return (ioctl(audioHd,SNDCTL_DSP_RESET,0)!=(-1));
        else
            return false;
    }
    
    int getAudioHandle()
    {
        return audioHd;
    }

    const AudioConfig& getConfig() const
    {
        return config;
    }
    
    const char* getErrorString() const
    {
        return errorString;
    }
            
 private:  // ------------------------------------------------------- private

    void outOfOrder();
    
    char* errorString;
    int audioHd;
    AudioConfig config;

};

#endif  // AudioDriver_h
