#include "HVSCDialog.h"
#define Inherited HVSCDialogData

HVSCDialog::HVSCDialog(QWidget* parent,	const char* name) : Inherited(parent,name)
{
    okButton->setFocus();
    okButton->setFocusPolicy(QWidget::StrongFocus);
    setIcon(*myMainIcon);
    setCaption("HVSC Settings");
    setButtons();
    setFixedSize(width(),height());
}

void HVSCDialog::setConfig(const HVSCconfig& inConfig)
{
    config = inConfig;
    backupConfig = inConfig;
    setButtons();
}

const HVSCconfig& HVSCDialog::getConfig() const
{
    return config;
}

void HVSCDialog::setButtons()
{
    hvscPathLineEdit->setText(config.hvscRootPath.path());
    globalCommentBox->setChecked(config.showGlobalComments);
    stilEntryBox->setChecked(config.showStilEntries);
    bugListEntryBox->setChecked(config.showBugListEntries);
    showCurrentSongBtn->setChecked(config.showForCurrentSong);
    showFileBtn->setChecked(config.showForFile);
    autoResizeBtn->setChecked(config.autoResize);
    maxHeightLineEdit->setText(config.maxHeight);
}

void HVSCDialog::okButtonClicked()
{
    hide();
    config.hvscRootPath.setPath(hvscPathLineEdit->text());
    config.showGlobalComments = globalCommentBox->isChecked();
    config.showStilEntries = stilEntryBox->isChecked();
    config.showBugListEntries = bugListEntryBox->isChecked();
    config.showForCurrentSong = showCurrentSongBtn->isChecked();
    config.showForFile = showFileBtn->isChecked();
    config.autoResize = autoResizeBtn->isChecked();
    config.maxHeight = maxHeightLineEdit->text();
    backupConfig = config;
    setButtons();
    emit changed(config);
}

void HVSCDialog::cancelButtonClicked()
{
    hide();
    config = backupConfig;
    setButtons();
}

void HVSCDialog::browseButtonClicked()
{
    QFileDialog* fileDlg = new QFileDialog(this,0,true);
    fileDlg->setCaption("Select HVSC Root Directory");
    fileDlg->setIcon(*myMainIcon);
    fileDlg->setMode(QFileDialog::Directory);
    fileDlg->setDir(hvscPathLineEdit->text());
    fileDlg->show();
    if (!fileDlg->selectedFile().isNull())
        hvscPathLineEdit->setText(fileDlg->selectedFile());
}
