// dialogs.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

#include "dialogs.h"
#include "warn.xpm"
#include <qaccel.h>
#include <qapp.h>

// center window a with respect to main application window
void center_window(QWidget *a)
{
    QWidget *b = qApp->mainWidget();
    a->move(b->x() + (b->width() - a->width()) / 2,
	    b->y() + (b->height() - a->height()) / 2);
}

// ValueDialog: modal dialog to input a single string value

ValueDialog::ValueDialog(const char *caption, const char *msg,
			 const char *ed_txt)
            : QDialog(0, caption, TRUE)
{
    setCaption(caption);
    ok = new QPushButton("OK", this);
    ok->setGeometry(20, 50, 64, 24);
    connect(ok, SIGNAL(clicked()), SLOT(done_dialog()));
    ok->setDefault(TRUE);
    cancel = new QPushButton("Cancel", this);
    cancel->setGeometry(130, 50, 64, 24);
    connect(cancel, SIGNAL(clicked()), SLOT(reject()));
    label = new QLabel(msg, this);
    label->setGeometry(10, 10, 120, 30);
    lined = new QLineEdit(this);
    QFont f = font();
    f.setBold(FALSE);
    lined->setFont(f);
    lined->resize(50, lined->sizeHint().height());
    lined->move(140, label->y() + (label->height() - lined->height()) / 2);
    lined->setMaxLength(7);
    lined->setText(ed_txt);
    lined->selectAll();
    lined->setFocus();
    connect(lined, SIGNAL(returnPressed()), SLOT(done_dialog()));
    QAccel *acc = new QAccel(this);
    acc->connectItem(acc->insertItem(Key_Escape), this, SLOT(reject()));
    adjustSize();
    center_window(this);
}

void ValueDialog::done_dialog()
{
    ed_result = lined->text();
    ed_result = ed_result.stripWhiteSpace();
    accept();
}

// MessageDialog: modal dialog that just gives a message

MessageDialog::MessageDialog(QWidget *parent)
             : QDialog(parent, 0, TRUE)
{
    label = new QLabel(this);
    label->setAlignment(AlignCenter);
    icon = 0;			// no icon by default
    button = new QPushButton("OK", this);
    connect(button, SIGNAL(clicked()), SLOT(accept()));
}

void MessageDialog::setText(const char *text)
{
    label->setText(text);
}

void MessageDialog::setButtonText(const char *buttonText)
{
    button->setText(buttonText);
}

void MessageDialog::setIcon(QPixmap *pixmap)
{
    if(pixmap) {
	if(!icon) {
	    icon = new QLabel(this);
	    label->setAlignment(AlignLeft | AlignVCenter);
	}
	icon->setPixmap(*pixmap);
    }
}

void MessageDialog::adjustSize()
{
    button->adjustSize();
    // don't let the button be too narrow
    if(button->width() < button_minwidth)
	button->resize(button_minwidth, button->height());
    button->setDefault(TRUE);	// do this _after_ adjusting button size

    label->adjustSize();
    if(icon)
	icon->adjustSize();

    int label_x;
    // give generous margins in all directions
    if(icon) {
	icon->move(margin_side, margin_top);
	label_x = margin_side + icon->width() + margin_side;
    } else {
	label_x = margin_side;
    }
    label->move(label_x, margin_top);
    button->move(label_x + (label->width() - button->width()) / 2,
		 margin_top + label->height() + margin_middle);
    resize(label_x + label->width() + margin_side,
	   button->y() + button->height() + margin_bottom);
}

// static function: pop up a simple modal message box
void MessageDialog::message(const char *caption, const char *text,
			    const char *buttonText,
			    QPixmap *icon)
{
    MessageDialog *md = new MessageDialog();
    md->setIcon(icon);
    md->setCaption(caption);
    md->setText(text);
    if(buttonText)
	md->setButtonText(buttonText);
    md->adjustSize();
    center_window(md);
    md->exec();
    delete md;
}

QPixmap *MessageDialog::warn_icon = 0;

// static function: return a warning icon, for use in alert boxes
QPixmap *MessageDialog::warningIcon()
{
    if(!warn_icon)
	warn_icon = new QPixmap((const char**)warn_xpm);
    return warn_icon;
}

SliderDialog::SliderDialog(const char *caption, const char *msg,
			   int defaultval, int minval, int maxval,
			   const char *leftlbl, const char *rightlbl)
            : ValueDialog(caption, msg, "")
{
    QString s;
    s.setNum(defaultval);
    lined->setText(s);
    lined->selectAll();

    slider = new QSlider(minval, maxval, 1, defaultval, QSlider::Horizontal,
			 this);
    slider->setTickInterval(10);
    slider->setTickmarks(QSlider::Below);
    slider->setFixedHeight(slider->sizeHint().height());
    slider->setGeometry(10, 48, 200, slider->height());
    connect(slider, SIGNAL(valueChanged(int)), this, SLOT(slider_change(int)));
    // decorate slider
    QLabel *left = new QLabel(this);
    QLabel *mid = new QLabel(this);
    QLabel *right = new QLabel(this);
    left->setNum(minval);
    mid->setNum((minval + maxval) / 2);
    right->setNum(maxval);
    
    left->adjustSize();
    left->move(slider->x(), slider->y() + slider->height());
    mid->adjustSize();
    mid->move(slider->x() + (slider->width() - mid->width()) / 2, left->y());
    right->adjustSize();
    right->move(slider->x() + slider->width() - right->width(), left->y());
    QLabel *leftl = new QLabel(leftlbl, this);
    leftl->adjustSize();
    leftl->move(slider->x(), left->y()+ left->height());
    QLabel *rightl = new QLabel(rightlbl, this);
    rightl->adjustSize();
    rightl->move(slider->x() + slider->width() - rightl->width(),
		 right->y()+ right->height());

    // rearrange geometry from ValueDialog
    ok->setDefault(FALSE);
    ok->move(30, leftl->y() + leftl->height() + 15);
    cancel->move(130, ok->y());
    ok->setDefault(TRUE);	// because Motif buttons are bigger as default
    adjustSize();
    center_window(this);
}

void SliderDialog::slider_change(int val)
{
    QString s;
    s.setNum(val);
    lined->setText(s);
    lined->selectAll();
}
