// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
extern "C" {
#include <stdio.h>
}
#include "ConsoleWindow.h"
#include "Dtd.h"

//=============================================================================
// Public methods.
//-----------------------------------------------------------------------------
Dtd::Dtd()
        : _start( 0 )
{
}

Dtd::~Dtd()
{
    while ( _entities.first() ) {
	delete _entities.first();
	_entities.remove();
    }
    while ( _elements.first() ) {
	delete _elements.first();
	_elements.remove();
    }
}

bool Dtd::getEntity( QString  name,
                     QString& text )
{
    for ( SgmlEntity* e = _entities.first(); e; e = _entities.next() ) {
        if ( e->name == name ) {
            text = e->text;
            return TRUE;
        }
    }
	
    console->warning( "Dtd::getEntity() -- could not find entity '%s'", name.data() );
    return FALSE;
}

SgmlElement* Dtd::getElement( QString name )
{
    QListIterator<SgmlElement> i(_elements);
	
    for ( ; i.current(); ++i ) {
        if ( name == i.current()->name() ) {
            return i.current();
        }
    }
	
    console->warning( "Dtd::getElement() -- could not find element '%s'", name.data() );
    return 0;
}
