// Build don't link:
// Special g++ Options: -w
// prms-id: 784

//# 1 "GctSymbol.GctSymbol.CHMap.cc"
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


//#pragma implementation

//# 1 "GctSymbol.GctSymbol.CHMap.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/




//#pragma interface



//# 1 "GctSymbol.GctSymbol.Map.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/




//#pragma interface



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/Pix.h" 1



typedef void* Pix;

//# 26 "GctSymbol.GctSymbol.Map.h" 2

//# 1 "GctSymbol.defs.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/







//# 1 "../../GctSymbol.h" 1
// -*- C++ -*-



//
// GctSymbol class
//
// Expects to be included by Gct.h
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface





//# 25 "../../GctSymbol.h" 2

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/




//#pragma interface



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/stream.h" 1



// Compatibility with old library.


//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



//#pragma interface




//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/streambuf.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.




//#pragma interface


/* KLUDGES!! */
//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/stddef.h" 1


extern "C" {



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/mips/lib/gcc/decstatn/cygnus-1.96/include/stddef.h" 1






/* This avoids lossage on Sunos but only if stdtypes.h comes first.
   There's no way to win with the other order!  Sun lossage.  */

/* In case nobody has defined these types, but we aren't running under
   GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE__TYPE__, and
   __WCHAR_TYPE__ have reasonable values.  This can happen if the
   parts of GCC is compiled by an older compiler, that actually
   include gstddef.h, such as collect2.  */

/* Signed type of difference of two pointers.  */














typedef long int ptrdiff_t;






/* Unsigned type of `sizeof' something.  */














typedef unsigned int size_t;






/* Data type for wide chars.  */














typedef int wchar_t;








/* A null pointer constant.  */




/* Offset of member MEMBER in a struct of type TYPE.  */





//# 7 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/stddef.h" 2




}

//# 25 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/streambuf.h" 2
















class ostream; class streambuf;

typedef long streamoff, streampos;

struct _ios_fields { // The data members of an ios.
    streambuf *_strbuf;
    ostream* _tie;
    long _width;
    unsigned long _flags;
    char _fill;
    unsigned char _state;
    unsigned short _precision;
};


enum state_value { _good = 0, _eof = 1,  _fail = 2, _bad  = 4 };


class ios : public _ios_fields {
  public:
    enum io_state { goodbit=0, eofbit=1, failbit=2, badbit=4 };
    enum open_mode {
	in=1,
	out=2,
	ate=4,
	app=8,
	trunc=16,
	nocreate=32,
	noreplace=64 };
    enum seek_dir { beg, cur, end};
    enum { skipws=01, left=02, right=04, internal=010,
	   dec=020, oct=040, hex=0100,
	   showbase=0200, showpoint=0400, uppercase=01000, showpos=02000,
	   scientific=04000, fixed=0100000, unitbuf=020000, stdio=040000,
	   dont_close=0x80000000 //Don't close streambuf when destroying stream
	   };

    ostream* tie() { return _tie; }
    ostream* tie(ostream* val) { ostream* save=_tie; _tie=val; return save; }

    // Methods to change the format state.
    char fill() { return _fill; }
    char fill(char newf) { char oldf = _fill; _fill = newf; return oldf; }
    unsigned long flags() { return _flags; }
    unsigned long flags(unsigned long new_val) {
	unsigned long old_val = _flags; _flags = new_val; return old_val; }
    unsigned short precision() { return _precision; }
    unsigned short precision(int newp) {
	unsigned short oldp = _precision; _precision = (unsigned short)newp;
	return oldp; }
    unsigned long setf(unsigned long val) {
	unsigned long oldbits = _flags;
	_flags |= val; return oldbits; }
    unsigned long setf(unsigned long val, unsigned long mask) {
	unsigned long oldbits = _flags;
	_flags = (_flags & ~mask) | (val & mask); return oldbits; }
    unsigned long unsetf(unsigned long mask) {
	unsigned long oldbits = _flags & mask;
	_flags &= ~mask; return oldbits; }
    long width() { return _width; }
    long width(long val) { long save = _width; _width = val; return save; }

    static const unsigned long basefield;
    static const unsigned long adjustfield;
    static const unsigned long floatfield;

    streambuf* rdbuf() { return _strbuf; }
    void clear(int state = 0) { _state = state; }
    int good() { return _state == 0; }
    int eof() { return _state & ios::eofbit; }
    int fail() { return _state & (ios::badbit|ios::failbit); }
    int bad() { return _state & ios::badbit; }
    int rdstate() { return _state; }
    void set(int flag) { _state |= flag; }
    operator void*() { return fail() ? (void*)0 : (void*)this; }
    int operator!() { return fail(); }


    void unset(state_value flag) { _state &= ~flag; }
    void close();
    int is_open();
    int readable();
    int writable();


  protected:
    ios(streambuf*sb) { _strbuf=sb; _state=0; _width=0; _fill=' ';
			_flags=ios::skipws; _precision=6; }
};




typedef ios::seek_dir _seek_dir;


// Magic numbers and bits for the _flags field.
// The magic numbers use the high-order bits of _flags;
// the remaining bits are abailable for variable flags.
// Note: The magic numbers must all be negative if stdio
// emulation is desired.















struct __streambuf {
    // NOTE: If this is changed, also change __FILE in stdio/stdio.h!
    int _flags;		/* High-order word is _IO_MAGIC; rest is flags. */
    char* _gptr;	/* Current get pointer */
    char* _egptr;	/* End of get area. */
    char* _eback;	/* Start of putback+get area. */
    char* _pbase;	/* Start of put area. */
    char* _pptr;	/* Current put pointer. */
    char* _epptr;	/* End of put area. */
    char* _base;	/* Start of reserve area. */
    char* _ebuf;	/* End of reserve area. */
    struct streambuf *_chain;
};

struct streambuf : private __streambuf {
    friend class ios;
    friend class istream;
    friend class ostream;
  protected:
    static streambuf* _list_all; /* List of open streambufs. */
    streambuf*& xchain() { return _chain; }
    void _un_link();
    void _link_in();
    char* gptr() const { return _gptr; }
    char* pptr() const { return _pptr; }
    char* egptr() const { return _egptr; }
    char* epptr() const { return _epptr; }
    char* pbase() const { return _pbase; }
    char* eback() const { return _eback; }
    char* ebuf() const { return _ebuf; }
    char* base() const { return _base; }
    void xput_char(char c) { *_pptr++ = c; }
    int xflags() { return _flags; }
    int xflags(int f) { int fl = _flags; _flags = f; return fl; }
    void xsetflags(int f) { _flags |= f; }
    void gbump(int n) { _gptr += n; }
    void pbump(int n) { _pptr += n; }
    void setb(char* b, char* eb, int a=0);
    void setp(char* p, char* ep) { _pbase=_pptr=p; _epptr=ep; }
    void setg(char* eb, char* g, char *eg) { _eback=eb; _gptr=g; _egptr=eg; }
  public:
    static int flush_all();
    static void flush_all_linebuffered(); // Flush all line buffered files.
    virtual int underflow(); // Leave public for now
    virtual int overflow(int c = (-1) ); // Leave public for now
    virtual int doallocate();
    virtual streampos seekoff(streamoff, _seek_dir, int mode=ios::in|ios::out);
    virtual streampos seekpos(streampos pos, int mode = ios::in|ios::out);
    int sputbackc(char c);
    int sungetc();
    streambuf();
    virtual ~streambuf();
    int unbuffered() { return _flags & 2  ? 1 : 0; }
    int linebuffered() { return _flags & 0x4000  ? 1 : 0; }
    void unbuffered(int i)
	{ if (i) _flags |= 2 ; else _flags &= ~2 ; }
    void linebuffered(int i)
	{ if (i) _flags |= 0x4000 ; else _flags &= ~0x4000 ; }
    int allocate() {
	if (base() || unbuffered()) return 0;
	else return doallocate(); }
    virtual int sync();
    virtual int pbackfail(int c);
    virtual int ungetfail();
    virtual streambuf* setbuf(char* p, int len);
    int in_avail() { return _egptr - _gptr; }
    int out_waiting() { return _pptr - _pbase; }
    virtual int sputn(const char* s, int n);
    virtual int sgetn(char* s, int n);
    long sgetline(char* buf, size_t n, char delim, int putback_delim);
    int sbumpc() {
	if (_gptr >= _egptr && underflow() == (-1) ) return (-1) ;
	else return *(unsigned char*)_gptr++; }
    int sgetc() {
	if (_gptr >= _egptr && underflow() == (-1) ) return (-1) ;
	else return *(unsigned char*)_gptr; }
    int snextc() {
	if (++_gptr >= _egptr && underflow() == (-1) ) return (-1) ;
	else return *(unsigned char*)_gptr; }
    int sputc(int c) {
	if (_pptr >= _epptr) return overflow(c);
	return *_pptr++ = c, (unsigned char)c; }
    int vscan(char const *fmt0, char*  ap);
    int vform(char const *fmt0, char*  ap);
};

struct __file_fields {
    char _fake;
    char _shortbuf[1];
    short _fileno;
    int _blksize;
    char* _save_gptr;
    char* _save_egptr;
    long  _offset;
};

class filebuf : public streambuf {
    struct __file_fields _fb;
    void init();
  public:
    filebuf();
    filebuf(int fd);
    filebuf(int fd, char* p, int len);
    ~filebuf();
    filebuf* attach(int fd);
    filebuf* open(const char *filename, const char *mode);
    filebuf* open(const char *filename, int mode, int prot = 0664);
    virtual int underflow();
    virtual int overflow(int c = (-1) );
    int is_open() { return _fb._fileno >= 0; }
    int fd() { return is_open() ? _fb._fileno : (-1) ; }
    filebuf* close();
    virtual int doallocate();
    virtual streampos seekoff(streamoff, _seek_dir, int mode=ios::in|ios::out);
    int sputn(const char* s, int n);
    int sgetn(char* s, int n);
  protected: // See documentation in filebuf.C.
    virtual int pbackfail(int c);
    virtual int sync();
    int is_reading() { return eback() != egptr(); }
    char* cur_ptr() { return is_reading() ?  gptr() : pptr(); }
    /* System's idea of pointer */
    char* file_ptr() { return _fb._save_gptr ? _fb._save_egptr : egptr(); }
    int do_flush();
    // Low-level operations (Usually invoke system calls.)
    virtual int sys_read(char* buf, size_t size);
    virtual long  sys_seek(long , _seek_dir);
    virtual long sys_write(const void*, long);
    virtual int sys_stat(void*); // Actually, a (struct stat*)
    virtual int sys_close();
};


inline int ios::readable() { return rdbuf()->_flags & 4 ; }
inline int ios::writable() { return rdbuf()->_flags & 8 ; }
inline int ios::is_open() {return rdbuf()->_flags & 4 +8 ;}




//# 25 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 2


class istream; class ostream;
typedef istream& (*__imanip)(istream&);
typedef ostream& (*__omanip)(ostream&);

extern istream& ws(istream& ins);
extern ostream& flush(ostream& outs);
extern ostream& endl(ostream& outs);
extern ostream& ends(ostream& outs);

class ostream : public ios
{
    void do_osfx();
  public:
    ostream();
    ostream(streambuf* sb, ostream* tied=((void *)0) );
    ~ostream();

    int opfx() { if (!good()) return 0; if (_tie) _tie->flush(); return 1; }
    void osfx() { if (flags() & (ios::unitbuf|ios::stdio))
		      do_osfx(); }
    streambuf* ostreambuf() const { return _strbuf; }
    ostream& flush();
    ostream& put(char c);
    ostream& write(const char *s, int n);
    ostream& write(const unsigned char *s, int n) { return write((char*)s, n);}
    ostream& write(const void *s, int n) { return write((char*)s, n);}
    ostream& seekp(streampos);
    ostream& seekp(streamoff, _seek_dir);
    streampos tellp();
    ostream& form(const char *format ...);
    ostream& vform(const char *format, char*  args);
};

ostream& operator<<(ostream&, char c);
ostream& operator<<(ostream& os, unsigned char c) { return os << (char)c; }
//ostream& operator<<(ostream &os, signed char c) { return os << (char)c; }
extern ostream& operator<<(ostream&, const char *s);
inline ostream& operator<<(ostream& os, const unsigned char *s)
{ return os << (const char*)s; }
//inline ostream& operator<<(ostream& os, const signed char *s)
//{ return os << (const char*)s; }
ostream& operator<<(ostream&, void *p);
ostream& operator<<(ostream&, int n);
ostream& operator<<(ostream&, long n);
ostream& operator<<(ostream&, unsigned int n);
ostream& operator<<(ostream&, unsigned long n);
ostream& operator<<(ostream& os, short n) {return os << (int)n;}
ostream& operator<<(ostream& os, unsigned short n)
{return os << (unsigned int)n;}
ostream& operator<<(ostream&, float n);
ostream& operator<<(ostream&, double n);
ostream& operator<<(ostream& os, __omanip func) { return (*func)(os); }
ostream& operator<<(ostream&, streambuf*);

class istream : public ios
{
    size_t _gcount;
  public:
    istream();
    istream(streambuf* sb, ostream*tied=((void *)0) );
    ~istream();
    streambuf* istreambuf() const { return _strbuf; }
    istream& get(char& c);
    istream& get(unsigned char& c);
    istream& read(char *ptr, int n);
    istream& read(unsigned char *ptr, int n) { return read((char*)ptr, n); }
    istream& read(void *ptr, int n) { return read((char*)ptr, n); }
    int get() { return _strbuf->sbumpc(); }
    istream& getline(char* ptr, int len, char delim = '\n');
    istream& get(char* ptr, int len, char delim = '\n');
    istream& gets(char **s, char delim = '\n');
    int ipfx(int need) {
	if (!good()) { set(ios::failbit); return 0; }
	if (_tie && (need == 0 || rdbuf()->in_avail())) ;  //??? THIS LINE IS QUESTIONABLE */
	if (!need && (flags() & ios::skipws) && !ws(*this)) return 0;
	return 1;
    }
    int ipfx0() { // Optimized version of ipfx(0).
	if (!good()) { set(ios::failbit); return 0; }
	if (_tie) _tie->flush();
	if ((flags() & ios::skipws) && !ws(*this)) return 0;
	return 1;
    }
    int ipfx1() { // Optimized version of ipfx(1).
	if (!good()) { set(ios::failbit); return 0; }
	if (_tie && rdbuf()->in_avail() == 0) _tie->flush();
	return 1;
    }
    size_t gcount() { return _gcount; }
    istream& seekg(streampos);
    istream& seekg(streamoff, _seek_dir);
    streampos tellg();
    istream& putback(char ch) {
	if (good() && _strbuf->sputbackc(ch) == (-1) ) clear(ios::badbit);
	return *this;}
    istream& unget() {
	if (good() && _strbuf->sungetc() == (-1) ) clear(ios::badbit);
	return *this;}

    istream& unget(char ch) { return putback(ch); }
    int skip(int i);

};

istream& operator>>(istream&, char*);
istream& operator>>(istream& is, unsigned char* p) { return is >> (char*)p; }
//istream& operator>>(istream& is, signed char* p) { return is >> (char*)p; }
istream& operator>>(istream&, char& c);
istream& operator>>(istream&, unsigned char& c);
//istream& operator>>(istream&, signed char& c);
istream& operator>>(istream&, int&);
istream& operator>>(istream&, long&);
istream& operator>>(istream&, short&);
istream& operator>>(istream&, unsigned int&);
istream& operator>>(istream&, unsigned long&);
istream& operator>>(istream&, unsigned short&);
istream& operator>>(istream&, float&);
istream& operator>>(istream&, double&);
istream& operator>>(istream& is, __imanip func) { return (*func)(is); }

class iostream : public ios {
    size_t _gcount;
  public:
    iostream();
    operator istream&() { return *(istream*)this; }
    operator ostream&() { return *(ostream*)this; }
    ~iostream();
    // NOTE: These duplicate istream methods.
    istream& get(char& c) { return ((istream*)this)->get(c); }
    istream& get(unsigned char& c) { return ((istream*)this)->get(c); }
    istream& read(char *ptr, int n) { return ((istream*)this)->read(ptr, n); }
    istream& read(unsigned char *ptr, int n)
	{ return ((istream*)this)->read((char*)ptr, n); }
    istream& read(void *ptr, int n)
	{ return ((istream*)this)->read((char*)ptr, n); }
    int get() { return _strbuf->sbumpc(); }
    istream& getline(char* ptr, int len, char delim = '\n')
	{ return ((istream*)this)->getline(ptr, len, delim); }
    istream& get(char* ptr, int len, char delim = '\n')
	{ return ((istream*)this)->get(ptr, len, delim); }
    istream& gets(char **s, char delim = '\n')
	{ return ((istream*)this)->gets(s, delim); }
    int ipfx(int need) { return ((istream*)this)->ipfx(need); }
    int ipfx0()  { return ((istream*)this)->ipfx0(); }
    int ipfx1()  { return ((istream*)this)->ipfx1(); }
    size_t gcount() { return _gcount; }
    istream& putback(char ch) { return ((istream*)this)->putback(ch); }
    istream& unget() { return ((istream*)this)->unget(); }
    istream& seekg(streampos pos) { return ((istream*)this)->seekg(pos); }
    istream& seekg(streamoff off, _seek_dir dir)
	{ return ((istream*)this)->seekg(off, dir); }
    streampos tellg() { return ((istream*)this)->tellg(); }

    istream& unget(char ch) { return putback(ch); }


    // NOTE: These duplicate ostream methods.
    int opfx() { return ((ostream*)this)->opfx(); }
    void osfx() { ((ostream*)this)->osfx(); }
    ostream& flush() { return ((ostream*)this)->flush(); }
    ostream& put(char c) { return ((ostream*)this)->put(c); }
    ostream& write(const char *s, int n)
	{ return ((ostream*)this)->write(s, n); }
    ostream& write(const unsigned char *s, int n)
	{ return ((ostream*)this)->write((char*)s, n); }
    ostream& write(const void *s, int n)
	{ return ((ostream*)this)->write((char*)s, n); }
    ostream& form(const char *format ...);
    ostream& vform(const char *format, char*  args)
	{ return ((ostream*)this)->vform(format, args); }
    ostream& seekp(streampos pos) { return ((ostream*)this)->seekp(pos); }
    ostream& seekp(streamoff off, _seek_dir dir)
	{ return ((ostream*)this)->seekp(off, dir); }
    streampos tellp() { return ((ostream*)this)->tellp(); }
};

extern istream cin;
extern ostream cout, cerr, clog; // clog->rdbuf() == cerr->rdbuf()

inline ostream& ostream::put(char c) { _strbuf->sputc(c); return *this; }

struct Iostream_init { } ;  // Compatibility hack for AT&T libraray.


//# 7 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/stream.h" 2


extern char* form(char*, ...);

extern char* dec(long, int=0);
extern char* dec(int, int=0);
extern char* dec(unsigned long, int=0);
extern char* dec(unsigned int, int=0);

extern char* hex(long, int=0);
extern char* hex(int, int=0);
extern char* hex(unsigned long, int=0);
extern char* hex(unsigned int, int=0);

extern char* oct(long, int=0);
extern char* oct(int, int=0);
extern char* oct(unsigned long, int=0);
extern char* oct(unsigned int, int=0);

inline istream& WS(istream& str) { return ws(str); }


//# 26 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h" 2

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/Regex.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/




//#pragma interface









struct re_pattern_buffer;       // defined elsewhere
struct re_registers;

class Regex
{
private:

                     Regex(const Regex&) {}  // no X(X&)
  void               operator = (const Regex&) {} // no assignment

protected:
  re_pattern_buffer* buf;
  re_registers*      reg;

public:
                     Regex(const char* t,
                           int fast = 0,
                           int bufsize = 40,
                           const char* transtable = 0);

                    ~Regex();

  int                match(const char* s, int len, int pos = 0) const;
  int                search(const char* s, int len,
                            int& matchlen, int startpos = 0) const;
  int                match_info(int& start, int& length, int nth = 0) const;

  int                OK() const;  // representation invariant
};

// some built in regular expressions

extern const Regex RXwhite;          // = "[ \n\t\r\v\f]+"
extern const Regex RXint;            // = "-?[0-9]+"
extern const Regex RXdouble;         // = "-?\\(\\([0-9]+\\.[0-9]*\\)\\|
                                     //    \\([0-9]+\\)\\|\\(\\.[0-9]+\\)\\)
                                     //    \\([eE][---+]?[0-9]+\\)?"
extern const Regex RXalpha;          // = "[A-Za-z]+"
extern const Regex RXlowercase;      // = "[a-z]+"
extern const Regex RXuppercase;      // = "[A-Z]+"
extern const Regex RXalphanum;       // = "[0-9A-Za-z]+"
extern const Regex RXidentifier;     // = "[A-Za-z_][A-Za-z0-9_]*"



//# 27 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h" 2


struct StrRep                     // internal String representations
{
  unsigned short    len;         // string length
  unsigned short    sz;          // allocated space
  char              s[1];        // the string starts here
                                 // (at least 1 char for trailing null)
                                 // allocated & expanded via non-public fcts
};

// primitive ops on StrReps -- nearly all String fns go through these.

StrRep*     Salloc(StrRep*, const char*, int, int);
StrRep*     Scopy(StrRep*, StrRep*);
StrRep*     Sresize(StrRep*, int);
StrRep*     Scat(StrRep*, const char*, int, const char*, int);
StrRep*     Scat(StrRep*, const char*, int,const char*,int, const char*,int);
StrRep*     Sprepend(StrRep*, const char*, int);
StrRep*     Sreverse(StrRep*, StrRep*);
StrRep*     Supcase(StrRep*, StrRep*);
StrRep*     Sdowncase(StrRep*, StrRep*);
StrRep*     Scapitalize(StrRep*, StrRep*);

// These classes need to be defined in the order given

class String;
class SubString;

class SubString
{
  friend class      String;
protected:

  String&           S;        // The String I'm a substring of
  unsigned short    pos;      // starting position in S's rep
  unsigned short    len;      // length of substring

  void              assign(StrRep*, const char*, int = -1);
                    SubString(String& x, int p, int l);
                    SubString(const SubString& x);

public:

// Note there are no public constructors. SubStrings are always
// created via String operations

                   ~SubString();

  void              operator =  (const String&     y);
  void              operator =  (const SubString&  y);
  void              operator =  (const char* t);
  void              operator =  (char        c);

// return 1 if target appears anywhere in SubString; else 0

  int               contains(char        c) const;
  int               contains(const String&     y) const;
  int               contains(const SubString&  y) const;
  int               contains(const char* t) const;
  int               contains(const Regex&       r) const;

// return 1 if target matches entire SubString

  int               matches(const Regex&  r) const;

// IO

  friend ostream&   operator<<(ostream& s, const SubString& x);

// status

  unsigned int      length() const;
  int               empty() const;
  const char*       chars() const;

  int               OK() const;

};


class String
{
  friend class      SubString;

protected:
  StrRep*           rep;   // Strings are pointers to their representations

// some helper functions

  int               search(int, int, const char*, int = -1) const;
  int               search(int, int, char) const;
  int               match(int, int, int, const char*, int = -1) const;
  int               _gsub(const char*, int, const char* ,int);
  int               _gsub(const Regex&, const char*, int);
  SubString         _substr(int, int);

public:

// constructors & assignment

                    String();
                    String(const String& x);
                    String(const SubString&  x);
                    String(const char* t);
                    String(const char* t, int len);
                    String(char c);

                    ~String();

  void              operator =  (const String&     y);
  void              operator =  (const char* y);
  void              operator =  (char        c);
  void              operator =  (const SubString&  y);

// concatenation

  void              operator += (const String&     y);
  void              operator += (const SubString&  y);
  void              operator += (const char* t);
  void              operator += (char        c);

  void              prepend(const String&     y);
  void              prepend(const SubString&  y);
  void              prepend(const char* t);
  void              prepend(char        c);


// procedural versions:
// concatenate first 2 args, store result in last arg

  friend void     cat(const String&, const String&, String&);
  friend void     cat(const String&, const SubString&, String&);
  friend void     cat(const String&, const char*, String&);
  friend void     cat(const String&, char, String&);

  friend void     cat(const SubString&, const String&, String&);
  friend void     cat(const SubString&, const SubString&, String&);
  friend void     cat(const SubString&, const char*, String&);
  friend void     cat(const SubString&, char, String&);

  friend void     cat(const char*, const String&, String&);
  friend void     cat(const char*, const SubString&, String&);
  friend void     cat(const char*, const char*, String&);
  friend void     cat(const char*, char, String&);

// double concatenation, by request. (yes, there are too many versions,
// but if one is supported, then the others should be too...)
// Concatenate first 3 args, store in last arg

  friend void     cat(const String&,const String&, const String&,String&);
  friend void     cat(const String&,const String&,const SubString&,String&);
  friend void     cat(const String&,const String&, const char*, String&);
  friend void     cat(const String&,const String&, char, String&);
  friend void     cat(const String&,const SubString&,const String&,String&);
  friend void     cat(const String&,const SubString&,const SubString&,String&);
  friend void     cat(const String&,const SubString&, const char*, String&);
  friend void     cat(const String&,const SubString&, char, String&);
  friend void     cat(const String&,const char*, const String&,    String&);
  friend void     cat(const String&,const char*, const SubString&, String&);
  friend void     cat(const String&,const char*, const char*, String&);
  friend void     cat(const String&,const char*, char, String&);

  friend void     cat(const char*, const String&, const String&,String&);
  friend void     cat(const char*,const String&,const SubString&,String&);
  friend void     cat(const char*,const String&, const char*, String&);
  friend void     cat(const char*,const String&, char, String&);
  friend void     cat(const char*,const SubString&,const String&,String&);
  friend void     cat(const char*,const SubString&,const SubString&,String&);
  friend void     cat(const char*,const SubString&, const char*, String&);
  friend void     cat(const char*,const SubString&, char, String&);
  friend void     cat(const char*,const char*, const String&,    String&);
  friend void     cat(const char*,const char*, const SubString&, String&);
  friend void     cat(const char*,const char*, const char*, String&);
  friend void     cat(const char*,const char*, char, String&);


// searching & matching

// return position of target in string or -1 for failure

  int               index(char        c, int startpos = 0) const;
  int               index(const String&     y, int startpos = 0) const;
  int               index(const SubString&  y, int startpos = 0) const;
  int               index(const char* t, int startpos = 0) const;
  int               index(const Regex&      r, int startpos = 0) const;

// return 1 if target appears anyhere in String; else 0

  int               contains(char        c) const;
  int               contains(const String&     y) const;
  int               contains(const SubString&  y) const;
  int               contains(const char* t) const;
  int               contains(const Regex&      r) const;

// return 1 if target appears anywhere after position pos
// (or before, if pos is negative) in String; else 0

  int               contains(char        c, int pos) const;
  int               contains(const String&     y, int pos) const;
  int               contains(const SubString&  y, int pos) const;
  int               contains(const char* t, int pos) const;
  int               contains(const Regex&      r, int pos) const;

// return 1 if target appears at position pos in String; else 0

  int               matches(char        c, int pos = 0) const;
  int               matches(const String&     y, int pos = 0) const;
  int               matches(const SubString&  y, int pos = 0) const;
  int               matches(const char* t, int pos = 0) const;
  int               matches(const Regex&      r, int pos = 0) const;

//  return number of occurences of target in String

  int               freq(char        c) const;
  int               freq(const String&     y) const;
  int               freq(const SubString&  y) const;
  int               freq(const char* t) const;

// SubString extraction

// Note that you can't take a substring of a const String, since
// this leaves open the possiblility of indirectly modifying the
// String through the SubString

  SubString         at(int         pos, int len);
  SubString         operator () (int         pos, int len); // synonym for at

  SubString         at(const String&     x, int startpos = 0);
  SubString         at(const SubString&  x, int startpos = 0);
  SubString         at(const char* t, int startpos = 0);
  SubString         at(char        c, int startpos = 0);
  SubString         at(const Regex&      r, int startpos = 0);

  SubString         before(int          pos);
  SubString         before(const String&      x, int startpos = 0);
  SubString         before(const SubString&   x, int startpos = 0);
  SubString         before(const char*  t, int startpos = 0);
  SubString         before(char         c, int startpos = 0);
  SubString         before(const Regex&       r, int startpos = 0);

  SubString         through(int          pos);
  SubString         through(const String&      x, int startpos = 0);
  SubString         through(const SubString&   x, int startpos = 0);
  SubString         through(const char*  t, int startpos = 0);
  SubString         through(char         c, int startpos = 0);
  SubString         through(const Regex&       r, int startpos = 0);

  SubString         from(int          pos);
  SubString         from(const String&      x, int startpos = 0);
  SubString         from(const SubString&   x, int startpos = 0);
  SubString         from(const char*  t, int startpos = 0);
  SubString         from(char         c, int startpos = 0);
  SubString         from(const Regex&       r, int startpos = 0);

  SubString         after(int         pos);
  SubString         after(const String&     x, int startpos = 0);
  SubString         after(const SubString&  x, int startpos = 0);
  SubString         after(const char* t, int startpos = 0);
  SubString         after(char        c, int startpos = 0);
  SubString         after(const Regex&      r, int startpos = 0);


// deletion

// delete len chars starting at pos
  void              del(int         pos, int len);

// delete the first occurrence of target after startpos

  void              del(const String&     y, int startpos = 0);
  void              del(const SubString&  y, int startpos = 0);
  void              del(const char* t, int startpos = 0);
  void              del(char        c, int startpos = 0);
  void              del(const Regex&      r, int startpos = 0);

// global substitution: substitute all occurrences of pat with repl

  int               gsub(const String&     pat, const String&     repl);
  int               gsub(const SubString&  pat, const String&     repl);
  int               gsub(const char* pat, const String&     repl);
  int               gsub(const char* pat, const char* repl);
  int               gsub(const Regex&      pat, const String&     repl);

// friends & utilities

// split string into array res at separators; return number of elements

  friend int        split(const String& x, String res[], int maxn,
                          const String& sep);
  friend int        split(const String& x, String res[], int maxn,
                          const Regex&  sep);

  friend String     common_prefix(const String& x, const String& y,
                                  int startpos = 0);
  friend String     common_suffix(const String& x, const String& y,
                                  int startpos = -1);
  friend String     replicate(char        c, int n);
  friend String     replicate(const String&     y, int n);
  friend String     join(String src[], int n, const String& sep);

// simple builtin transformations

  friend String     reverse(const String& x);
  friend String     upcase(const String& x);
  friend String     downcase(const String& x);
  friend String     capitalize(const String& x);

// in-place versions of above

  void              reverse();
  void              upcase();
  void              downcase();
  void              capitalize();

// element extraction

  char&             operator [] (int i);
  char              elem(int i) const;
  char              firstchar() const;
  char              lastchar() const;

// conversion

                    operator const char*() const;
  const char*       chars() const;


// IO

  friend ostream&   operator<<(ostream& s, const String& x);
  friend ostream&   operator<<(ostream& s, const SubString& x);
  friend istream&   operator>>(istream& s, String& x);

  friend int        readline(istream& s, String& x,
                             char terminator = '\n',
                             int discard_terminator = 1);

// status

  unsigned int      length() const;
  int               empty() const;

// preallocate some space for String
  void              alloc(int newsize);

// report current allocation (not length!)

  int               allocation() const;


  volatile void     error(const char* msg) const;

  int               OK() const;
};

typedef String StrTmp; // for backward compatibility

// other externs

int        compare(const String&    x, const String&     y);
int        compare(const String&    x, const SubString&  y);
int        compare(const String&    x, const char* y);
int        compare(const SubString& x, const String&     y);
int        compare(const SubString& x, const SubString&  y);
int        compare(const SubString& x, const char* y);
int        fcompare(const String&   x, const String&     y); // ignore case

extern StrRep  _nilStrRep;
extern String _nilString;

// other inlines

String operator + (const String& x, const String& y);
String operator + (const String& x, const SubString& y);
String operator + (const String& x, const char* y);
String operator + (const String& x, char y);
String operator + (const SubString& x, const String& y);
String operator + (const SubString& x, const SubString& y);
String operator + (const SubString& x, const char* y);
String operator + (const SubString& x, char y);
String operator + (const char* x, const String& y);
String operator + (const char* x, const SubString& y);

int operator==(const String& x, const String& y);
int operator!=(const String& x, const String& y);
int operator> (const String& x, const String& y);
int operator>=(const String& x, const String& y);
int operator< (const String& x, const String& y);
int operator<=(const String& x, const String& y);
int operator==(const String& x, const SubString&  y);
int operator!=(const String& x, const SubString&  y);
int operator> (const String& x, const SubString&  y);
int operator>=(const String& x, const SubString&  y);
int operator< (const String& x, const SubString&  y);
int operator<=(const String& x, const SubString&  y);
int operator==(const String& x, const char* t);
int operator!=(const String& x, const char* t);
int operator> (const String& x, const char* t);
int operator>=(const String& x, const char* t);
int operator< (const String& x, const char* t);
int operator<=(const String& x, const char* t);
int operator==(const SubString& x, const String& y);
int operator!=(const SubString& x, const String& y);
int operator> (const SubString& x, const String& y);
int operator>=(const SubString& x, const String& y);
int operator< (const SubString& x, const String& y);
int operator<=(const SubString& x, const String& y);
int operator==(const SubString& x, const SubString&  y);
int operator!=(const SubString& x, const SubString&  y);
int operator> (const SubString& x, const SubString&  y);
int operator>=(const SubString& x, const SubString&  y);
int operator< (const SubString& x, const SubString&  y);
int operator<=(const SubString& x, const SubString&  y);
int operator==(const SubString& x, const char* t);
int operator!=(const SubString& x, const char* t);
int operator> (const SubString& x, const char* t);
int operator>=(const SubString& x, const char* t);
int operator< (const SubString& x, const char* t);
int operator<=(const SubString& x, const char* t);




// status reports, needed before defining other things

inline unsigned int String::length() const {  return rep->len; }
inline int         String::empty() const { return rep->len == 0; }
inline const char* String::chars() const { return &(rep->s[0]); }
inline int         String::allocation() const { return rep->sz; }
inline void        String::alloc(int newsize) { rep = Sresize(rep, newsize); }

inline unsigned int SubString::length() const { return len; }
inline int         SubString::empty() const { return len == 0; }
inline const char* SubString::chars() const { return &(S.rep->s[pos]); }


// constructors

inline String::String()
  : rep(&_nilStrRep) {}
inline String::String(const String& x)
  : rep(Scopy(0, x.rep)) {}
inline String::String(const char* t)
  : rep(Salloc(0, t, -1, -1)) {}
inline String::String(const char* t, int tlen)
  : rep(Salloc(0, t, tlen, tlen)) {}
inline String::String(const SubString& y)
  : rep(Salloc(0, y.chars(), y.length(), y.length())) {}
inline String::String(char c)
  : rep(Salloc(0, &c, 1, 1)) {}

inline String::~String() { if (rep != &_nilStrRep) delete rep; }

inline SubString::SubString(const SubString& x)
  :S(x.S), pos(x.pos), len(x.len) {}
inline SubString::SubString(String& x, int first, int l)
  :S(x), pos(first), len(l) {}

inline SubString::~SubString() {}

// assignment

inline void String::operator =  (const String& y)
{
  rep = Scopy(rep, y.rep);
}

inline void String::operator=(const char* t)
{
  rep = Salloc(rep, t, -1, -1);
}

inline void String::operator=(const SubString&  y)
{
  rep = Salloc(rep, y.chars(), y.length(), y.length());
}

inline void String::operator=(char c)
{
  rep = Salloc(rep, &c, 1, 1);
}


inline void SubString::operator = (const char* ys)
{
  assign(0, ys);
}

inline void SubString::operator = (char ch)
{
  assign(0, &ch, 1);
}

inline void SubString::operator = (const String& y)
{
  assign(y.rep, y.chars(), y.length());
}

inline void SubString::operator = (const SubString& y)
{
  assign(y.S.rep, y.chars(), y.length());
}

// Zillions of cats...

inline void cat(const String& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y, -1);
}

inline void cat(const String& x, char y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), &y, 1);
}

inline void cat(const SubString& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const SubString& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const SubString& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), y, -1);
}

inline void cat(const SubString& x, char y, String& r)
{
  r.rep = Scat(r.rep, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* x, const String& y, String& r)
{
  r.rep = Scat(r.rep, x, -1, y.chars(), y.length());
}

inline void cat(const char* x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, x, -1, y.chars(), y.length());
}

inline void cat(const char* x, const char* y, String& r)
{
  r.rep = Scat(r.rep, x, -1, y, -1);
}

inline void cat(const char* x, char y, String& r)
{
  r.rep = Scat(r.rep, x, -1, &y, 1);
}

inline void cat(const String& a, const String& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& a, const String& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& a, const String& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y, -1);
}

inline void cat(const String& a, const String& x, char y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), &y, 1);
}

inline void cat(const String& a, const SubString& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& a, const SubString& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const String& a, const SubString& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y, -1);
}

inline void cat(const String& a, const SubString& x, char y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), &y, 1);
}

inline void cat(const String& a, const char* x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x, -1, y.chars(), y.length());
}

inline void cat(const String& a, const char* x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x, -1, y.chars(), y.length());
}

inline void cat(const String& a, const char* x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x, -1, y, -1);
}

inline void cat(const String& a, const char* x, char y, String& r)
{
  r.rep = Scat(r.rep, a.chars(), a.length(), x, -1, &y, 1);
}


inline void cat(const char* a, const String& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const String& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const String& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y, -1);
}

inline void cat(const char* a, const String& x, char y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* a, const SubString& x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const SubString& x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const SubString& x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), y, -1);
}

inline void cat(const char* a, const SubString& x, char y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* a, const char* x, const String& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x, -1, y.chars(), y.length());
}

inline void cat(const char* a, const char* x, const SubString& y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x, -1, y.chars(), y.length());
}

inline void cat(const char* a, const char* x, const char* y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x, -1, y, -1);
}

inline void cat(const char* a, const char* x, char y, String& r)
{
  r.rep = Scat(r.rep, a, -1, x, -1, &y, 1);
}


// operator versions

inline void String::operator +=(const String& y)
{
  cat(*this, y, *this);
}

inline void String::operator +=(const SubString& y)
{
  cat(*this, y, *this);
}

inline void String::operator += (const char* y)
{
  cat(*this, y, *this);
}

inline void String:: operator +=(char y)
{
  cat(*this, y, *this);
}

// constructive concatenation



inline String operator + (const String& x, const String& y) return r;
{
  cat(x, y, r);
}

inline String operator + (const String& x, const SubString& y) return r;
{
  cat(x, y, r);
}

inline String operator + (const String& x, const char* y) return r;
{
  cat(x, y, r);
}

inline String operator + (const String& x, char y) return r;
{
  cat(x, y, r);
}

inline String operator + (const SubString& x, const String& y) return r;
{
  cat(x, y, r);
}

inline String operator + (const SubString& x, const SubString& y) return r;
{
  cat(x, y, r);
}

inline String operator + (const SubString& x, const char* y) return r;
{
  cat(x, y, r);
}

inline String operator + (const SubString& x, char y) return r;
{
  cat(x, y, r);
}

inline String operator + (const char* x, const String& y) return r;
{
  cat(x, y, r);
}

inline String operator + (const char* x, const SubString& y) return r;
{
  cat(x, y, r);
}

inline String reverse(const String& x) return r;
{
  r.rep = Sreverse(x.rep, r.rep);
}

inline String upcase(const String& x) return r;
{
  r.rep = Supcase(x.rep, r.rep);
}

inline String downcase(const String& x) return r;
{
  r.rep = Sdowncase(x.rep, r.rep);
}

inline String capitalize(const String& x) return r;
{
  r.rep = Scapitalize(x.rep, r.rep);
}

//# 883 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h"


// prepend

inline void String::prepend(const String& y)
{
  rep = Sprepend(rep, y.chars(), y.length());
}

inline void String::prepend(const char* y)
{
  rep = Sprepend(rep, y, -1);
}

inline void String::prepend(char y)
{
  rep = Sprepend(rep, &y, 1);
}

inline void String::prepend(const SubString& y)
{
  rep = Sprepend(rep, y.chars(), y.length());
}

// misc transformations


inline void String::reverse()
{
  rep = Sreverse(rep, rep);
}


inline void String::upcase()
{
  rep = Supcase(rep, rep);
}


inline void String::downcase()
{
  rep = Sdowncase(rep, rep);
}


inline void String::capitalize()
{
  rep = Scapitalize(rep, rep);
}

// element extraction

inline char&  String::operator [] (int i)
{
  if (((unsigned)i) >= length()) error("invalid index");
  return rep->s[i];
}

inline char  String::elem (int i) const
{
  if (((unsigned)i) >= length()) error("invalid index");
  return rep->s[i];
}

inline char  String::firstchar() const
{
  return elem(0);
}

inline char  String::lastchar() const
{
  return elem(length() - 1);
}

// searching

inline int String::index(char c, int startpos) const
{
  return search(startpos, length(), c);
}

inline int String::index(const char* t, int startpos) const
{
  return search(startpos, length(), t);
}

inline int String::index(const String& y, int startpos) const
{
  return search(startpos, length(), y.chars(), y.length());
}

inline int String::index(const SubString& y, int startpos) const
{
  return search(startpos, length(), y.chars(), y.length());
}

inline int String::index(const Regex& r, int startpos) const
{
  int unused;  return r.search(chars(), length(), unused, startpos);
}

inline int String::contains(char c) const
{
  return search(0, length(), c) >= 0;
}

inline int String::contains(const char* t) const
{
  return search(0, length(), t) >= 0;
}

inline int String::contains(const String& y) const
{
  return search(0, length(), y.chars(), y.length()) >= 0;
}

inline int String::contains(const SubString& y) const
{
  return search(0, length(), y.chars(), y.length()) >= 0;
}

inline int String::contains(char c, int p) const
{
  return match(p, length(), 0, &c, 1) >= 0;
}

inline int String::contains(const char* t, int p) const
{
  return match(p, length(), 0, t) >= 0;
}

inline int String::contains(const String& y, int p) const
{
  return match(p, length(), 0, y.chars(), y.length()) >= 0;
}

inline int String::contains(const SubString& y, int p) const
{
  return match(p, length(), 0, y.chars(), y.length()) >= 0;
}

inline int String::contains(const Regex& r) const
{
  int unused;  return r.search(chars(), length(), unused, 0) >= 0;
}

inline int String::contains(const Regex& r, int p) const
{
  return r.match(chars(), length(), p) >= 0;
}


inline int String::matches(const SubString& y, int p) const
{
  return match(p, length(), 1, y.chars(), y.length()) >= 0;
}

inline int String::matches(const String& y, int p) const
{
  return match(p, length(), 1, y.chars(), y.length()) >= 0;
}

inline int String::matches(const char* t, int p) const
{
  return match(p, length(), 1, t) >= 0;
}

inline int String::matches(char c, int p) const
{
  return match(p, length(), 1, &c, 1) >= 0;
}

inline int String::matches(const Regex& r, int p) const
{
  int l = (p < 0)? -p : length() - p;
  return r.match(chars(), length(), p) == l;
}


inline int SubString::contains(const char* t) const
{
  return S.search(pos, pos+len, t) >= 0;
}

inline int SubString::contains(const String& y) const
{
  return S.search(pos, pos+len, y.chars(), y.length()) >= 0;
}

inline int SubString::contains(const SubString&  y) const
{
  return S.search(pos, pos+len, y.chars(), y.length()) >= 0;
}

inline int SubString::contains(char c) const
{
  return S.search(pos, pos+len, 0, c) >= 0;
}

inline int SubString::contains(const Regex& r) const
{
  int unused;  return r.search(chars(), len, unused, 0) >= 0;
}

inline int SubString::matches(const Regex& r) const
{
  return r.match(chars(), len, 0) == len;
}


inline int String::gsub(const String& pat, const String& r)
{
  return _gsub(pat.chars(), pat.length(), r.chars(), r.length());
}

inline int String::gsub(const SubString&  pat, const String& r)
{
  return _gsub(pat.chars(), pat.length(), r.chars(), r.length());
}

inline int String::gsub(const Regex& pat, const String& r)
{
  return _gsub(pat, r.chars(), r.length());
}

inline int String::gsub(const char* pat, const String& r)
{
  return _gsub(pat, -1, r.chars(), r.length());
}

inline int String::gsub(const char* pat, const char* r)
{
  return _gsub(pat, -1, r, -1);
}



inline  ostream& operator<<(ostream& s, const String& x)
{
   s << x.chars(); return s;
}

// a zillion comparison operators

inline int operator==(const String& x, const String& y)
{
  return compare(x, y) == 0;
}

inline int operator!=(const String& x, const String& y)
{
  return compare(x, y) != 0;
}

inline int operator>(const String& x, const String& y)
{
  return compare(x, y) > 0;
}

inline int operator>=(const String& x, const String& y)
{
  return compare(x, y) >= 0;
}

inline int operator<(const String& x, const String& y)
{
  return compare(x, y) < 0;
}

inline int operator<=(const String& x, const String& y)
{
  return compare(x, y) <= 0;
}

inline int operator==(const String& x, const SubString&  y)
{
  return compare(x, y) == 0;
}

inline int operator!=(const String& x, const SubString&  y)
{
  return compare(x, y) != 0;
}

inline int operator>(const String& x, const SubString&  y)
{
  return compare(x, y) > 0;
}

inline int operator>=(const String& x, const SubString&  y)
{
  return compare(x, y) >= 0;
}

inline int operator<(const String& x, const SubString&  y)
{
  return compare(x, y) < 0;
}

inline int operator<=(const String& x, const SubString&  y)
{
  return compare(x, y) <= 0;
}

inline int operator==(const String& x, const char* t)
{
  return compare(x, t) == 0;
}

inline int operator!=(const String& x, const char* t)
{
  return compare(x, t) != 0;
}

inline int operator>(const String& x, const char* t)
{
  return compare(x, t) > 0;
}

inline int operator>=(const String& x, const char* t)
{
  return compare(x, t) >= 0;
}

inline int operator<(const String& x, const char* t)
{
  return compare(x, t) < 0;
}

inline int operator<=(const String& x, const char* t)
{
  return compare(x, t) <= 0;
}

inline int operator==(const SubString& x, const String& y)
{
  return compare(y, x) == 0;
}

inline int operator!=(const SubString& x, const String& y)
{
  return compare(y, x) != 0;
}

inline int operator>(const SubString& x, const String& y)
{
  return compare(y, x) < 0;
}

inline int operator>=(const SubString& x, const String& y)
{
  return compare(y, x) <= 0;
}

inline int operator<(const SubString& x, const String& y)
{
  return compare(y, x) > 0;
}

inline int operator<=(const SubString& x, const String& y)
{
  return compare(y, x) >= 0;
}

inline int operator==(const SubString& x, const SubString&  y)
{
  return compare(x, y) == 0;
}

inline int operator!=(const SubString& x, const SubString&  y)
{
  return compare(x, y) != 0;
}

inline int operator>(const SubString& x, const SubString&  y)
{
  return compare(x, y) > 0;
}

inline int operator>=(const SubString& x, const SubString&  y)
{
  return compare(x, y) >= 0;
}

inline int operator<(const SubString& x, const SubString&  y)
{
  return compare(x, y) < 0;
}

inline int operator<=(const SubString& x, const SubString&  y)
{
  return compare(x, y) <= 0;
}

inline int operator==(const SubString& x, const char* t)
{
  return compare(x, t) == 0;
}

inline int operator!=(const SubString& x, const char* t)
{
  return compare(x, t) != 0;
}

inline int operator>(const SubString& x, const char* t)
{
  return compare(x, t) > 0;
}

inline int operator>=(const SubString& x, const char* t)
{
  return compare(x, t) >= 0;
}

inline int operator<(const SubString& x, const char* t)
{
  return compare(x, t) < 0;
}

inline int operator<=(const SubString& x, const char* t)
{
  return compare(x, t) <= 0;
}


// a helper needed by at, before, etc.

inline SubString String::_substr(int first, int l)
{
  if (first >= length() )  // ??? THIS LINE IS QUESTIONABLE
    return SubString(_nilString, 0, 0) ;
  else
    return SubString(*this, first, l);
}





//# 26 "../../GctSymbol.h" 2


//# 1 "../../../../../../mips/include/Gct/Object/GctHashObject.h" 1
// -*- C++ -*-



//
// GctHashObject class (is abstract)
//
// Expects to be included by Object.h or where needed explicitly.
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "../../../../../../mips/include/Gct/Object/GctObject.h" 1
// -*- C++ -*-



//
// GctObject class (is abstract)
//
// Expects to be included by Object.h or where needed explicitly.
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h" 1
// -*- C++ -*-



//
// tostrstream class
//
// A terminated oststream - an ostsrstream that auto-terminates on str()
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/strstream.h" 1
//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.




//#pragma interface

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 23 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/strstream.h" 2


class strstreambuf : public streambuf {
    size_t *lenp; /* current (logical) length (i.e. valid data bytes) */
    size_t *sizep; /* allocated (physical) buffer size */
    char **bufp;
    size_t _len;
    size_t _size;
    char *buf;
    int _frozen;
  protected:
    virtual int overflow(int = (-1) );
  public:
    strstreambuf();
    strstreambuf(int initial);
    strstreambuf(char *ptr, int size, char *pstart = ((void *)0) );
    ~strstreambuf();
    int frozen() { return _frozen; }
    void freeze(int n=1) { _frozen = n != 0; }
    size_t pcount();
    char *str();
};

class istrstream : public istream {
  public:
    istrstream(char*);
    istrstream(char*, int);
    strstreambuf* rdbuf() { return (strstreambuf*)_strbuf; }
};

class ostrstream : public ostream {
  public:
    ostrstream();
    ostrstream(char *cp, int n, int mode=ios::out);
    size_t pcount() { return ((strstreambuf*)_strbuf)->pcount(); }
    char *str() { return ((strstreambuf*)_strbuf)->str(); }
    void freeze(int n = 1) { ((strstreambuf*)_strbuf)->freeze(n); }
    int frozen() { return ((strstreambuf*)_strbuf)->frozen(); }
    strstreambuf* rdbuf() { return (strstreambuf*)_strbuf; }
};


//# 25 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h" 2


//
// tostrstream class
//
// An isteam class that doesn't have that nasty skipws parameter that
// you have to remember to set.  This class simply provides the istream
// functionality with a set of constructors which defaults skipws to
// FALSE (instead of defaulting to TRUE as is the case with plain istream).
//
class tostrstream: public ostrstream {
public:
    tostrstream(): ostrstream()
	{ }
    // This constructor defines cp as the buffer to use for the
    // stream (instead of one of its own devising); it does NOT
    // initialize the ostrstream to contain cp (of length n).
  tostrstream(char *cp, int n, int mode=ios::out): ostrtream(cp, n, mode)	// ERROR - 
	{ }
    char *str()
	{
	    char *s = ostrstream::str();
	    s[ostrstream::pcount()] = '\0';
	    return s;
	}
};


//# 25 "../../../../../../mips/include/Gct/Object/GctObject.h" 2


//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h" 1
// -*- C++ -*-



//
// GttObject class (is abstract)
//
// Expects to be included where needed explicitly.
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h" 1
// -*- C++ -*-
//# 52 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h"

//# 25 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h" 2


//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttErrorHandler.h" 1
// -*- C++ -*-



//
// GttErrorHandler class
//
// Expects to be included by Gtt.h
//
// Wendell Baker, Berkeley CAD Group, 1992 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/bool.h" 1







//# 25 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttErrorHandler.h" 2


//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 1
// -*- C++ -*-



//
// Fake up a libstuff++
//
// This is done as a complete and utter hack; this library has no function
// at all being in the boot area; it is here solely in order to provide a
// libstuff++ against which the Makefiles can resolve link lines.
//
// The only reason that this is done is to allow the STANDARD_C++_LIBRARIES
// as provided by the Makefile templates in the boot area to be the same
// ones that are used by the tools outside this hierarchy.
//
// The tools outside this hierarchy use a different libstuff++; one that is
// written in C++.  This one is not written in C++ in order to be simpler.
//





//#pragma interface



extern "C" {
//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/stuff.h" 1



/*
 * Useful stuff
 */

/*
 */

//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/ansi.h" 1




/*
 * ANSI Compiler Support
 *
 * David Harrison
 * University of California, Berkeley
 * 1988
 *
 * ANSI compatible compilers are supposed to define the preprocessor
 * directive __STDC__.  Based on this directive, this file defines
 * certain ANSI specific macros.
 *
 * ARGS:
 *   Used in function prototypes.  Example:
 *   extern int foo
 *     ARGS((char *blah, double threshold));
 */

/*
 *
 * Modifications
 * Wendell C Baker
 * University of California, Berkeley
 */

/* Function prototypes */



























//# 15 "/sandbox/wbaker/wbaker0/source/mips/include/stuff.h" 2



/*
 * If g++, then we stub out part of this thing and let the C++ types take
 * over and do the same job; some compatibility must be given however
 */

/*
 *    Use the GNU libg++ definition
 */
//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/bool.h" 1







//# 26 "/sandbox/wbaker/wbaker0/source/mips/include/stuff.h" 2

//# 35 "/sandbox/wbaker/wbaker0/source/mips/include/stuff.h"


/*
 * Make various pieces of C code that use the old ``Boolean''
 * be compatible by faking up the definition of Boolean using
 * the new bool type.
 */


//# 58 "/sandbox/wbaker/wbaker0/source/mips/include/stuff.h"


typedef long FitAny;		/* can fit any integral type */

/*
 * typedef char *String;	- DO NOT USE THIS - it conflicts with C++
 * typedef char **Stringv;	- just use char* and char** instead.
 * 				- void* can be used for arbitrary pointers
 */




extern int nocase_strcmp (char *, char *)		;
extern int nocase_strncmp (char *, char *, int)		;

extern bool	 nocase_strequal (char *, char *)		;
extern bool	 nocase_strnequal (char *, char *, int)		;

extern bool	 lead_strequal (char *, char *)		;
extern bool	 nocase_lead_strequal (char *, char *)		;

extern int strhash (char *, int)		;
extern int nocase_strhash (char *, int)		;

extern int sign (int)		;

/*
 *    Some useful macros.
 */





























//# 33 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 2

}

//
// This is here because we wish to provide externs for the two
// functions btoa(bool, unsigned = 0) and operator<<(ostream&, bool)
// because they are not provided in bool.h.
//
//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/bool.h" 1







//# 41 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 2

extern const char *stringify(bool b);
//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 43 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 2

extern ostream& operator<<(ostream&, bool);

// Should this be kept separate?   bool isn't, but then  is
// included here only to define ostream& operator<<(ostream&, bool)
//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/unit.h" 1
// -*- C++ -*-



//
// unit enum
//
// Wendell Baker, Berkeley CAD Group, 1991 (wbaker@ic.Berkeley.EDU)
//


//
// unit enum
//
// This _looks_ silly, but it has an important theoretical basis in category
// theory.  For the pragmatic reason for its existence, see the example below.
//
enum unit {
    UNIT = 1,
};

extern const char *stringify(unit u);

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 28 "/sandbox/wbaker/wbaker0/source/mips/include/unit.h" 2

extern ostream& operator<<(ostream&, unit);

//
// A unit is used in cases where the type signature of an overloaded
// function must be differentiated in some stronger way than can be
// denoted unambiguously in the C++ syntax.  This enum is used to give
// one of the functions a different type signature, thereby allowing
// the overloading.
//
// The use of ``unit'' instead of int or bool is important because a unit
// has only one possible value; therefore it adds no more information to
// the code.   For example, say a bool was used instead, then in the testing
// phase, would have to ask: what if TRUE was given, what if FALSE was given.
// The problem is compounded if char or int is used.
//
// Example:
//
//     class ID {
//     public:
//         ID();		// construct a null ID
//         ID(unit);		// alloc a ID with a new id
//     private:
//         static unsigned high_water;
//         unsigned id;
//     };
//
// Try working this example save that ID implements all of the generic
// features of the identifier object, but the high_water is stored
// in the heir.  That is what originally motivated the creation of unit.
//


//# 48 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 2


//
// In the spirit of the standard GNU error handler functions
// as described in
//     typedef void (*one_arg_error_handler_t)(const char*);
//         a one argument error handler function pointer
//     typedef void (*two_arg_error_handler_t)(const char*, const char*);
//         a two argument error handler function pointer
//
// And now the NEW
//
// typedef void (*zero_arg_error_handler_t)();
//     a zero argument error handler function pointer
//
typedef void (*zero_arg_error_handler_t)();

//
// In the spirit of the default GNU error handler functions
// as described in
//     extern void default_one_arg_error_handler(const char *message);
//         print out message on stderr, and do the default thing (abort)
//     extern void default_two_arg_error_handler(const char *kind, const char *message);
//         print out kind and message on stderr, and do the default thing (abort)
//
// And now the NEW
//
// extern void default_zero_arg_error_handler(const char *message);
//     do the default thing (abort)
//
extern void default_zero_arg_error_handler();

// Guaranteed to exit (1)
extern void exit_zero_arg_error_handler();
extern void exit_one_arg_error_handler(const char *message);
extern void exit_two_arg_error_handler(const char *kind, const char *message);

// Guaranteed to abort()
extern void abort_zero_arg_error_handler();
extern void abort_one_arg_error_handler(const char *message);
extern void abort_two_arg_error_handler(const char *kind, const char *message);

//
// In the spirit of the standard GNU error handlers
// as described in
//     extern void  verbose_File_error_handler(const char*);
//         perror and set errno = 0
//     extern void  quiet_File_error_handler(const char*);
//         set errno = 0
//     extern void  fatal_File_error_handler(const char*);
//         perror and exit 1
//
// And now the NEW
//
// extern void preserve_File_error_handler(const char *message);
//     no perror, no assignment to errno.
//
extern void preserve_File_error_handler(const char *message);


//# 27 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttErrorHandler.h" 2

//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h" 1
// -*- C++ -*-
//# 52 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h"

//# 28 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttErrorHandler.h" 2


//
// It is expected that this will be virtually multiply inherited
// into all of the classes that need error reporting services.
//
// The typical way to have that done is by inheriting the GttObject
// as a virtual base class.
//

//
// GttErrorHandler class
//
class GttErrorHandler {
public:
    GttErrorHandler();
    GttErrorHandler(const char *program);
    virtual ~GttErrorHandler();

    //
    // Error messages
    //     - an unacceptable, but expected and recoverable condition
    //       was detected (but the test fails)
    //     - errors are for ``the expected environment was not found''
    //       rather than for ``file couldn't be opened''
    //     - these messages cannot be shut off
    //     - the error handler determines the recovery action
    //       TODO - one day exceptions will be used here
    //
    static void error(const char *message);
    static void error(tostrstream& message);

    static void error(const char *function, const char *message);
    static void error(const char *function, tostrstream& message);

    static void error(const char *class_name, const char *method, const char *message);
    static void error(const char *class_name, const char *method, tostrstream& message);

    //
    // Fatal messages
    //     - an unacceptable and unexpected error was detected
    //       the data invariants were violated, there is no recovery
    //     - these messages cannot be shut off
    //     - the error handler determines the recovery action
    //       TODO - one day exceptions will be used here
    //
    static void fatal(const char *message);
    static void fatal(tostrstream& message);

    static void fatal(const char *function, const char *message);
    static void fatal(const char *function, tostrstream& message);

    static void fatal(const char *class_name, const char *method, const char *message);
    static void fatal(const char *class_name, const char *method, tostrstream& message);
private:
    //
    // Two underscores are used here in order to prevent confusion of these
    // private variables with any of the heir's private variables.  Note that
    // access control is different than visibility in C++, so all the variable
    // names in a class hierarchy must be unique.
    //

    static bool __partial_init;
    static void __partial_initialize();
    static bool __full_init;
    static void __full_initialize(const char *program);
    static char *__program;

    static void __handle_error();
    static void __handle_fatal();
    static void __add_newline(const char *message);

    static bool __output_valid();
    static ostream *__output;
};


//# 27 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h" 2


//
// GttObject class (is abstract)
//
class GttObject: virtual public GttErrorHandler {
protected:
    GttObject();
    GttObject(const GttObject&);
    virtual ~GttObject();	// ensure descendants have virtual destructors

public:
    //
    // I/O Support
    //
    // The value typically persists only long enough for an i/o operation
    // to be performed (see the defintion of output via operator<<(... ) below)
    virtual const char *stringify();
protected:
    // This is the buffer into which the printed representation of this
    // object will be put when the time comes.  It is associated with the
    // object so it will never go away (so long as the object exists).
    // Use a pointer so that you only pay for the space when I/O is used
    tostrstream *stringbuf;
    void clear_stringbuf();

public:
    //
    // Consistency
    //
    // The global data invariant for the whole object (heirs included).
    // This OK function will call the local invariant function ok() if
    // necessary and in addition the OK functions of the heirs
    // This is expected to compute the data invariant of the object.
    // It will execute GctErrorHandler::fatal if there is wrong.
    virtual void OK() const;

protected:
    //
    // consistency
    //
    // This function computes the invariant which is local to this object.
    // It does not call any of the ancestor's OK() or ok() functions.
    // It is not a virtual function so that it can be called from within a
    // constructor with impunity.  Thus this function MUST NOT call any
    // virtual functions either; it should call them by their full name if
    // that is necessary.  The global OK() function will call this function
    // as necessary.
    //
    // This function must NOT NEVER EVER be made virtual.
    void ok() const;

protected:
    //
    // Class Name
    //
    // This must return a static (constant) string which is the name
    // of the class being declared.  By convention, not all classes
    // must have one of these, but the major root abstract class must
    // have one in order to allow the stringify() to work approximately
    // correctly.
    virtual const char *class_name() const = 0;
};

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 91 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h" 2

extern ostream& operator<<(ostream&, GttObject&);

// There may be other X& operator<<(X&, GttObject&) defined in the
// packages defining class X.  For example see the definition of
// GttUnitObject& operator<<(GttUnitObject&, GttObject&) in Unit.


//# 27 "../../../../../../mips/include/Gct/Object/GctObject.h" 2


//# 1 "../../../../../../mips/include/Gct/GctErrorHandler.h" 1
// -*- C++ -*-



//
// GctErrorHandler class
//
// Expects to be included by Gct.h
//
// Wendell Baker, Berkeley CAD Group, 1991 (wbaker@ic.Berkeley.EDU)
//





//#pragma interface



//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/bool.h" 1







//# 25 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h" 1
// This may look like C code, but it is really -*- C++ -*-
/*
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


//# 1321 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/String.h"

//# 26 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 27 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2


//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h" 1
// -*- C++ -*-
//# 107 "/sandbox/wbaker/wbaker0/source/mips/include/stuff++.h"

//# 29 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2

//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h" 1
// -*- C++ -*-
//# 52 "/sandbox/wbaker/wbaker0/source/mips/include/tostrstream.h"

//# 30 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2


//# 1 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h" 1
// -*- C++ -*-
//# 98 "/sandbox/wbaker/wbaker0/source/mips/include/Gtt/GttObject.h"

//# 32 "../../../../../../mips/include/Gct/GctErrorHandler.h" 2


//
// It is expected that this will be virtually multiply inherited
// into all of the classes that need error reporting services.
//
// The typical way to have that done is by inheriting the GctObject
// as a virtual base class.
//

//
// GctErrorHandler class
//
// GPP_1_96_BUG
// NOTE - virtual public GttObject should be MI into GctObject - but that
// causes g++ 1.96 to segfault; so we must inherit GttObject here and use SI
// GPP_1_96_BUG
class GctErrorHandler: virtual public GttObject {
public:
    GctErrorHandler();
    GctErrorHandler(const String& program);
    virtual ~GctErrorHandler();

    //
    // Debugging messages
    //     - these are turned off for production code.
    //     - these messages can be shut off
    //
    static void debug(const char *message);
    static void debug(tostrstream& message);

    static void debug(const char *function, const char *message);
    static void debug(const char *function, tostrstream& message);

    static void debug(const char *class_name, const char *method, const char *message);
    static void debug(const char *class_name, const char *method, tostrstream& message);

    static bool debug();		// current debug switch
    static void debug(bool value);	// change the debug switch

    //
    // Informational messages
    //     - these correspond to a ``verbose'' mode
    //     - these are not errors, just chatty progress reports
    //     - these messages can be shut off
    //
    static void note(const char *message);
    static void note(tostrstream& message);

    static void note(const char *function, const char *message);
    static void note(const char *function, tostrstream& message);

    static void note(const char *class_name, const char *method, const char *message);
    static void note(const char *class_name, const char *method, tostrstream& message);

    static bool note();			// current note switch
    static void note(bool value);	// change the note switch

    //
    // Warning messages
    //     - warnings are system-recoverable errors
    //     - the system has noticed something and taken some
    //       corrective action
    //     - these messages can be shut off
    //
    static void warning(const char *message);
    static void warning(tostrstream& message);

    static void warning(const char *function, const char *message);
    static void warning(const char *function, tostrstream& message);

    static void warning(const char *class_name, const char *method, const char *message);
    static void warning(const char *class_name, const char *method, tostrstream& message);

    static bool warning();		// current warning switch
    static void warning(bool value);	// change the warning switch

    //
    // Error messages
    //     - an unacceptable, but expected and recoverable
    //       condition was detected
    //     - errors are for ``the expected environment was not found''
    //       rather than for ``file couldn't be opened''
    //     - these messages cannot be shut off
    //     - the error handler determines the recovery action
    //       TODO - one day exceptions will be used here
    //
    static void error(const char *message);
    static void error(tostrstream& message);

    static void error(const char *function, const char *message);
    static void error(const char *function, tostrstream& message);

    static void error(const char *class_name, const char *method, const char *message);
    static void error(const char *class_name, const char *method, tostrstream& message);

    // can't turn off errors - no ``static void error(bool value);''
    static zero_arg_error_handler_t error();		// current error handler
    static void error(zero_arg_error_handler_t handler);// change the error handler

    static void error_is_lib_error_handler();		// change the error handler
    static void error_is_exit();			// change the error handler

    // Describes the fatal handler - WATCHOUT - implicitly uses AllocRing
    static const char *error_handler_description();

    //
    // Fatal messages
    //     - an unacceptable and unexpected error was detected
    //       the data invariants were violated, there is no recovery
    //     - these messages cannot be shut off
    //     - the error handler determines the recovery action
    //       TODO - one day exceptions will be used here
    //
    static void fatal(const char *message);
    static void fatal(tostrstream& message);

    static void fatal(const char *function, const char *message);
    static void fatal(const char *function, tostrstream& message);

    static void fatal(const char *class_name, const char *method, const char *message);
    static void fatal(const char *class_name, const char *method, tostrstream& message);

    // can't turn off fatals - no ``static void fatal(bool value);''
    static zero_arg_error_handler_t fatal();			// return the fatal handler
    static void fatal(zero_arg_error_handler_t handler);	// change the fatal handler

    static void fatal_is_exit();	// change the fatal handler
    static void fatal_is_abort();	// change the fatal handler

    // Describes the fatal handler - WATCHOUT - implicitly uses AllocRing
    static const char *fatal_handler_description();
private:
    //
    // Two underscores are used here in order to prevent confusion of these
    // private variables with any of the heir's private variables.  Note that
    // access control is different than visibility in C++, so all the variable
    // names in a class hierarchy must be unique.
    //
    static bool __debug;
    static bool __note;
    static bool __warning;
    static void (*__error_handler)();	// can't turn off errors
    static void (*__fatal_handler)();	// can't turn off fatals

    static bool __partial_init;
    static void __partial_initialize();
    static bool __full_init;
    static void __full_initialize(const char *program);
    static char *__program;

    static void __handle_error();
    static void __handle_fatal();
    static void __add_newline(const char *message);
    static void __message_switch(bool value, bool& flag, const char *description);
    static void __message_switch(bool value, bool& flag);
    static const char *__describe_handler(zero_arg_error_handler_t handler);

    static bool __output_valid();
    static ostream *__output;

    // GPP_1_96_BUG
    const char *class_name() const;
    // GPP_1_96_BUG
};


//# 29 "../../../../../../mips/include/Gct/Object/GctObject.h" 2


//
// GctObject class (is abstract)
//
class GctObject: virtual public GctErrorHandler /*, virtual public GttObject*/ {
protected:
    GctObject();
    GctObject(const GctObject&);
    virtual ~GctObject();	// ensure descendants have virtual destructors

public:
    //
    // I/O Support
    //
    // The value typically persists only long enough for an i/o operation
    // to be performed (see the defintion of output via operator<<(... ) below)
    virtual const char *stringify();
protected:
    // This is the buffer into which the printed representation of this
    // object will be put when the time comes.  It is associated with the
    // object so it will never go away (so long as the object exists).
    // Use a pointer so that you only pay for the space when I/O is used
    tostrstream *stringbuf;
    void clear_stringbuf();

public:
    //
    // Consistency (global consistency)
    //
    // The global data invariant for the whole object (heirs included).
    // This OK function will call the local invariant function ok() if
    // necessary and in addition the OK functions of the heirs
    // This is expected to compute the data invariant of the object.
    // It will execute GctErrorHandler::fatal if there is wrong.
    virtual void OK() const;

protected:
    //
    // consistency (local consistency)
    //
    // This function computes the invariant which is local to this object.
    // It does not call any of the ancestor's OK() or ok() functions.
    // It is not a virtual function so that it can be called from within a
    // constructor with impunity.  Thus this function MUST NOT call any
    // virtual functions either; it should call them by their full name if
    // that is necessary.  The global OK() function will call this function
    // as necessary.
    //
    // This function must NOT NEVER EVER be made virtual.
    void ok() const;
protected:
    //
    // Class Name
    //
    // This must return a static (constant) string which is the name
    // of the class being declared.  By convention, not all classes
    // must have one of these, but the major root abstract class must
    // have one in order to allow the stringify() to work approximately
    // correctly.
    virtual const char *class_name() const = 0;

public:
    //
    // The ``id'' of this object
    //
    // NOTE - we explicitly allow the situation where this function
    // can return the address of the object - the ``this'' pointer
    // instead of a computed id field (the __object_id field below).
    //
    // This function is protected because we don't want too much dependence
    // on this notion of object identity.  I want to be able to rip it
    // out if it becomes to cumbersome.
    unsigned objectId() const;
private:
    //
    // Symbolic ID
    //
    // NOTE - Normally this would be implemented by the `this' pointer.
    // TODO - remove this for production code
    //
    // However, in order to make the test suites run on all machines, we
    // make this into a symbolic id that is maintained with each object.
    // Thus the valid outputs are always consistent across all machines.
    unsigned __object_id;
    static unsigned __next_id;
};

//# 1 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h" 1
//    This is part of the iostream library, providing -*- C++ -*- input/output.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//# 210 "/projects/gnu-cygnus/gnu-cygnus-8/common/g++-include/iostream.h"

//# 117 "../../../../../../mips/include/Gct/Object/GctObject.h" 2

extern ostream& operator<<(ostream&, GctObject&);


//# 25 "../../../../../../mips/include/Gct/Object/GctHashObject.h" 2


//
// GctHashObject class (is abstract)
//
class GctHashObject: virtual public GctObject {
protected:
    GctHashObject();
    GctHashObject(const GctHashObject&);

public:
    //
    // hash support
    //
    virtual unsigned hash() const;
};


//# 28 "../../GctSymbol.h" 2


//
// GctSymbol
//
class GctSymbol: virtual public GctHashObject, String {
public:
    GctSymbol();		// vacuous symbol required for genclass usage
    GctSymbol(const char*);
    GctSymbol(const String&);
    GctSymbol(const GctSymbol&);

    operator const char *() const;

    bool operator==(const GctSymbol&) const;
    bool operator!=(const GctSymbol&) const;

    bool operator<=(const GctSymbol&) const;
    bool operator<(const GctSymbol&) const;
    bool operator>=(const GctSymbol&) const;
    bool operator>(const GctSymbol&) const;

    unsigned hash() const;

    // I/O Support
    const char *stringify();

    // Consistency
    void OK() const;
private:
    const char *class_name() const;
};

extern unsigned hash(GctSymbol&);	// genclass support (no const)

//
// Inline functions
//
// Note - none of the String operators save for operator const char *()
// are String member functions, instead, they are anonymous functions
// which work by overloading.
//





GctSymbol::operator const char *() const
{





    return String::operator const char *();
}

bool
GctSymbol::operator==(const GctSymbol& other) const
{





    return (bool)::operator==(*this, other);
}

bool
GctSymbol::operator!=(const GctSymbol& other) const
{





    return (bool)::operator!=(*this, other);
}

bool
GctSymbol::operator<=(const GctSymbol& other) const
{





    return (bool)::operator<=(*this, other);
}

bool
GctSymbol::operator<(const GctSymbol& other) const
{





    return (bool)::operator<(*this, other);
}

bool
GctSymbol::operator>=(const GctSymbol& other) const
{





    return (bool)::operator>=(*this, other);
}

bool
GctSymbol::operator>(const GctSymbol& other) const
{





    return (bool)::operator>(*this, other);
}


//# 25 "GctSymbol.defs.h" 2


// equality operator




// less-than-or-equal




// comparison : less-than ->  0




// hash function

extern unsigned int hash(GctSymbol&);



// initial capacity for structures requiring one







//# 27 "GctSymbol.GctSymbol.Map.h" 2


class GctSymbolGctSymbolMap
{
protected:
  int                   count;
  GctSymbol                   def;

public:
                        GctSymbolGctSymbolMap(GctSymbol& dflt);
  virtual              ~GctSymbolGctSymbolMap();

  int                   length();                // current number of items
  int                   empty();

  virtual int           contains(GctSymbol& key);      // is key mapped?

  virtual void          clear();                 // delete all items

  virtual GctSymbol&          operator [] (GctSymbol& key) = 0; // access contents by key

  virtual void          del(GctSymbol& key) = 0;       // delete entry

  virtual Pix           first() = 0;             // Pix of first item or 0
  virtual void          next(Pix& i) = 0;        // advance to next or 0
  virtual GctSymbol&          key(Pix i) = 0;          // access key at i
  virtual GctSymbol&          contents(Pix i) = 0;     // access contents at i

  virtual int           owns(Pix i);             // is i a valid Pix  ?
  virtual Pix           seek(GctSymbol& key);          // Pix of key

  GctSymbol&                  dflt();                  // access default val

  void                  error(const char* msg);
  virtual int           OK() = 0;                // rep invariant
};



inline GctSymbolGctSymbolMap::~GctSymbolGctSymbolMap() {}

inline int GctSymbolGctSymbolMap::length()
{
  return count;
}

inline int GctSymbolGctSymbolMap::empty()
{
  return count == 0;
}

inline GctSymbol& GctSymbolGctSymbolMap::dflt()
{
  return def;
}

inline GctSymbolGctSymbolMap::GctSymbolGctSymbolMap(GctSymbol& dflt) :def(dflt)
{
  count = 0;
}




//# 26 "GctSymbol.GctSymbol.CHMap.h" 2





struct GctSymbolGctSymbolCHNode
{
  GctSymbolGctSymbolCHNode*      tl;
  GctSymbol                hd;
  GctSymbol                cont;
                     GctSymbolGctSymbolCHNode();
                     GctSymbolGctSymbolCHNode(GctSymbol& h, GctSymbol& c, GctSymbolGctSymbolCHNode* t = 0);
                     ~GctSymbolGctSymbolCHNode();
};



inline GctSymbolGctSymbolCHNode::GctSymbolGctSymbolCHNode() {}

inline GctSymbolGctSymbolCHNode::GctSymbolGctSymbolCHNode(GctSymbol& h, GctSymbol& c, GctSymbolGctSymbolCHNode* t)
     : hd(h), cont(c), tl(t) {}

inline GctSymbolGctSymbolCHNode::~GctSymbolGctSymbolCHNode() {}




typedef GctSymbolGctSymbolCHNode* GctSymbolGctSymbolCHNodePtr;




class GctSymbolGctSymbolCHMap : public GctSymbolGctSymbolMap
{
protected:
  GctSymbolGctSymbolCHNode** tab;
  unsigned int   size;

public:
                GctSymbolGctSymbolCHMap(GctSymbol& dflt,unsigned int sz=100 );
                GctSymbolGctSymbolCHMap(GctSymbolGctSymbolCHMap& a);
                ~GctSymbolGctSymbolCHMap();

  GctSymbol&          operator [] (GctSymbol& key);

  void          del(GctSymbol& key);

  Pix           first();
  void          next(Pix& i);
  GctSymbol&          key(Pix i);
  GctSymbol&          contents(Pix i);

  Pix           seek(GctSymbol& key);
  int           contains(GctSymbol& key);

  void          clear();
  int           OK();
};



inline GctSymbolGctSymbolCHMap::~GctSymbolGctSymbolCHMap()
{
  clear();
  delete tab;
}

inline int GctSymbolGctSymbolCHMap::contains(GctSymbol& key)
{
  return seek(key) != 0;
}

inline GctSymbol& GctSymbolGctSymbolCHMap::key(Pix p)
{
  if (p == 0) error("null Pix");
  return ((GctSymbolGctSymbolCHNode*)p)->hd;
}

inline GctSymbol& GctSymbolGctSymbolCHMap::contents(Pix p)
{
  if (p == 0) error("null Pix");
  return ((GctSymbolGctSymbolCHNode*)p)->cont;
}




//# 22 "GctSymbol.GctSymbol.CHMap.cc" 2


// The nodes are linked together serially via a version
// of a trick used in some vtables: odd pointers are
// actually links to the next table entry.
// Not terrible, but not wonderful either

static inline int goodCHptr(GctSymbolGctSymbolCHNode* t)
{
  return ((((unsigned)t) & 1) == 0);
}

static inline GctSymbolGctSymbolCHNode* index_to_CHptr(int i)
{
  return (GctSymbolGctSymbolCHNode*)((i << 1) + 1);
}

static inline int CHptr_to_index(GctSymbolGctSymbolCHNode* t)
{
  return ( ((unsigned) t) >> 1);
}

GctSymbolGctSymbolCHMap::GctSymbolGctSymbolCHMap(GctSymbol& dflt, unsigned int sz)
     :GctSymbolGctSymbolMap(dflt)
{
  tab = (GctSymbolGctSymbolCHNode**)(new GctSymbolGctSymbolCHNodePtr[size = sz]);
  for (unsigned int i = 0; i < size; ++i) tab[i] = index_to_CHptr(i+1);
  count = 0;
}

GctSymbolGctSymbolCHMap::GctSymbolGctSymbolCHMap(GctSymbolGctSymbolCHMap& a) :GctSymbolGctSymbolMap(a.def)
{
  tab = (GctSymbolGctSymbolCHNode**)(new GctSymbolGctSymbolCHNodePtr[size = a.size]);
  for (unsigned int i = 0; i < size; ++i) tab[i] = index_to_CHptr(i+1);
  count = 0;
  for (Pix p = a.first(); p; a.next(p)) (*this)[a.key(p)] = a.contents(p); // gets bogus error - type `GctSymbol' is derived from private `String'
}
