/* 
   XRButtonCell.m

   NSButtonCell for GNUstep GUI X/RAW Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   A completely rewritten version of the original source by Scott Christley.
   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February 1997
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <stdlib.h>

#include <AppKit/NSColor.h>
#include <AppKit/NSGraphics.h>

#include <gnustep/xraw/XRCell.h>
#include <gnustep/xraw/XRButtonCell.h>
#include <gnustep/xraw/XRView.h>
#include <gnustep/xraw/XRWindow.h>
#include <gnustep/xraw/XRImage.h>
#include <gnustep/xraw/XRFont.h>

extern void NSDrawButton(NSRect aRect, NSRect clipRect);


@implementation XRButtonCell

//
// Class methods
//
+ (void)initialize
{
	if (self == [XRButtonCell class])
		[self setVersion:1];								// Initial version
}

//
// Instance methods
//
- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
float backgroundGray = NSLightGray;
														// do nothing if cell's
	if (!cellFrame.origin.x && !cellFrame.origin.y && 	// frame rect is zero
			!cellFrame.size.width && !cellFrame.size.height)
		return;

//fprintf(stderr,"XRButtonCell drawWithFrame \n");

	control_view = controlView;						// Save last view drawn to

	if (cell_state) 						// determine the background color
		{
		if ((showAltStateMask & NSChangeGrayCellMask) || 
				(showAltStateMask & NSChangeBackgroundCellMask)) 
			backgroundGray = NSWhite;
  		}

	if (cell_highlighted) 
		{
		if ((highlightsByMask & NSChangeGrayCellMask) || 
				(highlightsByMask & NSChangeBackgroundCellMask)) 
			backgroundGray = NSWhite;
  		}										 
  										 		// set cell's background color
	[[NSColor colorWithCalibratedWhite:backgroundGray alpha:1.0] set];
	NSRectFill(cellFrame);

	if (cell_bordered) 							// draw the border if needed
		{
		if (cell_highlighted && (highlightsByMask & NSPushInCellMask)) 
			{
			NSDrawGrayBezel (cellFrame, cellFrame);		
			cellFrame.origin.x += 2;
			cellFrame.origin.y += 1;
			cellFrame.size.width -= 3;
			cellFrame.size.height -= 3;
			}
		else 
			{
			NSDrawButton (cellFrame, cellFrame);
			cellFrame.origin.x += 1;
			cellFrame.origin.y += 2;
			cellFrame.size.width -= 3;
			cellFrame.size.height -= 3;
			}
		}
//  PSrectclip (cellFrame.origin.x, cellFrame.origin.y,
//	      cellFrame.size.width, cellFrame.size.height);
//  PStranslate (cellFrame.origin.x, cellFrame.origin.y);
//  cellFrame.origin = NSZeroPoint;

	[self drawInteriorWithFrame:cellFrame inView:controlView];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView*)controlView
{
BOOL showAlternate = NO;
unsigned int mask;
NSImage* imageToDisplay;
NSString* titleToDisplay;
NSSize imageSize = {0, 0};
NSRect rect;
float titleGray = NSBlack;
float backgroundGray = NSLightGray;

	if (cell_state) 									// determine the effect
		{												// of cell's state on 
		if (showAltStateMask & NSChangeGrayCellMask) 	// it's appearance
			{
			backgroundGray = NSWhite;
			titleGray = NSLightGray;
    		}
   		else
		 	{
			if (showAltStateMask & NSChangeBackgroundCellMask) 
				backgroundGray = NSWhite;
			}
  		}

	if (cell_highlighted) 								// determine the effect
		{												// of cell's highlight
		mask = highlightsByMask;						// on it's appearance
		if ((highlightsByMask & NSChangeGrayCellMask) && 
					(backgroundGray == NSLightGray)) 
			titleGray = NSLightGray;
  		}
	else
		mask = showAltStateMask;

						// Determine the image and the title that will be 
						// displayed. If the NSContentsCellMask is set the 
						// image and title are swapped only if state is 1 or 
						// if highlighting is set (when a button is pushed it's 
						// content is changed to the face of reversed state).
	if (mask & NSContentsCellMask) 
		showAlternate = cell_state;			

	if (showAlternate || cell_highlighted) 
		{
		imageToDisplay = altImage;
		titleToDisplay = altContents;
		if (!titleToDisplay)
			titleToDisplay = contents;
  		}
	else 
		{
		imageToDisplay = cell_image;
		titleToDisplay = contents;
  		}

	if (imageToDisplay)
		imageSize = [imageToDisplay size];
	rect = NSMakeRect (cellFrame.origin.x, cellFrame.origin.y,
		     			imageSize.width, imageSize.height);

	switch (image_position) 
		{												
		case NSNoImage:										// draw title only
			[self _displayTitle:titleToDisplay 
						inFrame:cellFrame 
						titleGray:titleGray];
			break;
	
		case NSImageOnly:									// draw image only
			[self _displayImage:imageToDisplay inFrame:cellFrame];
			break;
														// draw image to the
		case NSImageLeft:					 			// the left of title
			rect.origin = cellFrame.origin;
			rect.size.width = imageSize.width + 2 * xDist;
			rect.size.height = cellFrame.size.height;
			[self _displayImage:imageToDisplay inFrame:rect];
	
			rect.origin.x += rect.size.width;					// draw title
			rect.size.width = cellFrame.size.width - rect.size.width;
			[self _displayTitle:titleToDisplay 
						inFrame:rect 
						titleGray:titleGray];
			break;
														// draw image to the
		case NSImageRight:					 			// right of the title
			rect.origin.x += cellFrame.size.width - 
							 	(2 * xDist + imageSize.width);
			rect.origin.y += cellFrame.size.height - 
							 	(2 * yDist + imageSize.height);
			[self _displayImage:imageToDisplay inFrame:rect];
																// draw title
			rect.size.width = rect.origin.x - cellFrame.origin.x;
			rect.origin.x = cellFrame.origin.x;
			rect.size.height = cellFrame.size.height;
			rect.origin.y = cellFrame.origin.y;
			[self _displayTitle:titleToDisplay 
						inFrame:rect 
						titleGray:titleGray];
			break;
															// draw image above
		case NSImageBelow:									// below the title
			cellFrame.size.height /= 2;
			[self _displayImage:imageToDisplay inFrame:cellFrame];
			cellFrame.origin.y += cellFrame.size.height;
			[self _displayTitle:titleToDisplay
						inFrame:cellFrame
						titleGray:titleGray];
			break;
															// draw image above
		case NSImageAbove:						 			// title
			cellFrame.size.height /= 2;
			[self _displayTitle:titleToDisplay
						inFrame:cellFrame
						titleGray:titleGray];
			cellFrame.origin.y += cellFrame.size.height;
			[self _displayImage:imageToDisplay inFrame:cellFrame];
			break;
															// draw title over
		case NSImageOverlaps:					 			// the image
			[self _displayImage:imageToDisplay inFrame:cellFrame];
			[self _displayTitle:titleToDisplay
						inFrame:cellFrame
						titleGray:titleGray];
			break;
		}
}

@end
