/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	kattach.c,v $
 * Revision 6.1  96/11/23  19:42:20  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:11:18  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/13  12:38:22  gdburns
 * Remove client ports for TCP kernel.
 * 
 * Revision 5.2  94/08/22  13:36:06  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  09:35:54  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:36:03  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:21:05  gdburns
 * Ohio Release
 * 
 *	Function:	- attaches calling process to the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <signal.h>
			  
#include <kio.h>
#include <kreq.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */
extern int		errno;

/*
 * external functions
 */
extern int		_cio_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* follow signals */

int
kattach(priority)

int			priority;

{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */
	sigset_t	newset;		/* new signal set */
	sigset_t	oldset;		/* old signal set */

	req.kq_req = KQATTACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = getpid();
	req.kq_priority = priority;
/*
 * Send the request to the kernel and receive a reply.
 */
	sigemptyset(&newset);
	sigaddset(&newset, SIGUSR1);
	sigprocmask(SIG_BLOCK, &newset, &oldset);

	if (_cio_kreq(&req, &reply)) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		return(LAMERROR);
	}

	if (reply.kr_reply) {
		sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);
		errno = reply.kr_reply;
		return(LAMERROR);
	}

	_kio.ki_index = reply.kr_index;
	_kio.ki_rtf |= RTF_KERNEL;	
	_kio.ki_pid = getpid();	
	_kio.ki_priority = priority;
	sigprocmask(SIG_SETMASK, &oldset, (sigset_t *) 0);

	if (reply.kr_signal) {
		_kio.ki_signal |= reply.kr_signal;
		_ksig_follow();
	}

	return(0);
}
