/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	kdetach.c,v $
 * Revision 6.1  96/11/23  19:42:23  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:11:19  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  94/09/09  14:21:01  raja
 * Change _cio_kreqfront() error condition.
 * 
 * Revision 5.2  94/08/22  13:36:07  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  09:36:03  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:36:07  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:21:06  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.2  94/02/15  17:38:12  raja
 * Upgrade to use POSIX signal blocking.
 * 
 * Revision 2.2.1.1  93/10/15  13:16:09  raja
 * Use pid to check if attached to kernel.
 * 
 * Revision 2.2  93/07/21  22:02:47  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- detaches calling process from the kernel
 *	Accepts:	- process scheduling priority
 *	Returns:	- 0 or ERROR
 */
			  
#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* Kernel I/O block */

/*
 * external functions
 */
extern int		_cio_kreqfront();	/* make kernel request */

int
kdetach(pid)

int			pid;

{
	struct kreq	req;			/* kernel request */

	if (_kio.ki_pid != getpid()) {
		errno = ENOTATTACHED;	
		return(ERROR);
	}

	req.kq_req = KQDETACH;
	req.kq_index = _kio.ki_index;
	req.kq_pid = (pid == 0) ? getpid() : pid;

	if (_cio_kreqfront(&req) < 0) {
		return(ERROR);
	}

	if ((pid == 0) || (pid == getpid())) {
		_kio.ki_rtf &= ~RTF_KERNEL;	
		_kio.ki_pid = -1;	
		_kio.ki_index = -1;
	}

	return(0);
}
