/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	mrw.c,v $
 * Revision 6.1  96/11/23  19:58:10  nevin
 * Ohio Release
 * 
 * Revision 6.0.1.1  96/04/18  13:22:35  nevin
 * iov_base may be of type void*
 * 
 * Revision 6.0  96/02/29  13:48:10  gdburns
 * Ohio Release
 * 
 *	Function:	- atomic reads and writes
 *			- continues through partial transfers and interrupts
 */

#include <errno.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

#include <portable.h>
#include <terror.h>
#include <typical.h>

/*
 *	mread
 *
 *	Function:	- atomic read()
 *	Returns:	- #bytes read or ERROR
 */
int4
mread(fd, buf, nbytes)

int			fd;
char			*buf;
int4			nbytes;

{
	int		nread;		/* # of bytes read */
	int		r;

	nread = 0;

	do {
		r = read(fd, buf, nbytes);

		if (r < 0) {

			if (errno != EINTR) {
				return(ERROR);
			}
		} else if ((r == 0) && (nbytes > 0)) {	/* eof */
			errno = EEOF;
			return((int4) nread);
		} else {
			nread += r;
			buf += r;
			nbytes -= r;
		}
	} while (nbytes > 0);

	return((int4) nread);
}

/*
 *	mreadv
 *
 *	Function:	- atomic readv()
 *	Returns:	- #bytes read or ERROR
 */
int4
mreadv(fd, iov, iovcnt)

int			fd;
struct iovec		*iov;
int			iovcnt;

{
	int		nread;		/* # of bytes read */
	int		r;
	int		savelen;	/* save full length */
	char		*savebase;	/* save original base ptr */

	nread = 0;

	if (iovcnt > 0) {
		savelen = iov->iov_len;
		savebase = iov->iov_base;
	}

	do {
		r = readv(fd, iov, iovcnt);

		if (r < 0) {

			if (errno != EINTR) {
				iov->iov_len = savelen;
				iov->iov_base = savebase;
				return(LAMERROR);
			}
		} else if (r == 0) {	/* eof */
			iov->iov_len = savelen;
			iov->iov_base = savebase;

			while ((iovcnt > 0) && (iov->iov_len == 0)) {
				iov++;
				iovcnt--;
			}

			if (iovcnt > 0) {
				errno = EEOF;
			}

			return((int4) nread);
		} else {
			nread += r;

			while (r > 0) {

				if (r >= iov->iov_len) {
					r -= iov->iov_len;
					iov->iov_len = savelen;
					iov->iov_base = savebase;
					iov++;
					iovcnt--;

					if (iovcnt > 0) {
						savelen = iov->iov_len;
						savebase = iov->iov_base;
					}
				} else {
					iov->iov_len -= r;
					iov->iov_base =
						(char *) iov->iov_base + r;
					r = 0;
				}
			}

			while ((iovcnt > 0) && (iov->iov_len == 0)) {
				iov++;
				iovcnt--;
				savelen = iov->iov_len;
				savebase = iov->iov_base;
			}
		}
	} while (iovcnt > 0);

	return((int4) nread);
}

/*
 *	mwrite
 *
 *	Function:	- atomic write()
 *	Returns:	- #bytes written or ERROR
 */
int4
mwrite(fd, buf, nbytes)

int			fd;
char			*buf;
int			nbytes;

{
	int		nwritten;	/* # of bytes written */
	int		r;

	nwritten = 0;

	do {
		r = write(fd, buf, nbytes);

		if (r < 0) {

			if (errno != EINTR) {
				return(ERROR);
			}
		} else if ((r == 0) && (nbytes > 0)) {	/* eof */
			errno = EEOF;
			return((int4) nwritten);
		} else {
			nwritten += r;
			buf += r;
			nbytes -= r;
		}
	} while (nbytes > 0);

	return((int4) nwritten);
}

/*
 *	mwritev
 *
 *	Function:	- atomic writev()
 *	Returns:	- #bytes written or ERROR
 */
int4
mwritev(fd, iov, iovcnt)

int			fd;
struct iovec		*iov;
int			iovcnt;

{
	int		nwritten;	/* # of bytes written */
	int		r;
	int		savelen;	/* save full length */
	char		*savebase;	/* save original base ptr */

	nwritten = 0;

	if (iovcnt > 0) {
		savelen = iov->iov_len;
		savebase = iov->iov_base;
	}

	do {
		r = writev(fd, iov, iovcnt);

		if (r < 0) {

			if (errno != EINTR) {
				iov->iov_len = savelen;
				iov->iov_base = savebase;
				return(LAMERROR);
			}
		} else if (r == 0) {	/* eof */
			iov->iov_len = savelen;
			iov->iov_base = savebase;

			while ((iovcnt > 0) && (iov->iov_len == 0)) {
				iov++;
				iovcnt--;
			}

			if (iovcnt > 0) {
				errno = EEOF;
			}

			return((int4) nwritten);
		} else {
			nwritten += r;

			while (r > 0) {

				if (r >= iov->iov_len) {
					r -= iov->iov_len;
					iov->iov_len = savelen;
					iov->iov_base = savebase;
					iov++;
					iovcnt--;

					if (iovcnt > 0) {
						savelen = iov->iov_len;
						savebase = iov->iov_base;
					}
				} else {
					iov->iov_len -= r;
					iov->iov_base =
						(char *) iov->iov_base + r;
					r = 0;
				}
			}

			while ((iovcnt > 0) && (iov->iov_len == 0)) {
				iov++;
				iovcnt--;
				savelen = iov->iov_len;
				savebase = iov->iov_base;
			}
		}
	} while (iovcnt > 0);

	return((int4) nwritten);
}
