/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: rpisys.h,v 6.1.1.2 97/03/24 12:02:44 nevin Exp Locker: nevin $
 *
 *	Function:	- RPI dependent structures
 */

#ifndef _RPISYS_H
#define _RPISYS_H

#include <sys/types.h>

#include <app_mgmt.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpi.lamd.h>

/*
 * client-to-client envelope
 */
struct c2c_envl {
	int4		ce_len;			/* message length */
	int4		ce_tag;			/* message tag (16 bits) */
	int4		ce_flags;		/* flags */
#define C2CLONG		0x01			/* long protocol */
#define C2CACK		0x02			/* ACK message */
#define C2C2ND		0x04			/* 2nd message chunk */
#define C2CSSEND	0x08			/* synchronous send */
	int4		ce_rank;		/* peer rank */
	int4		ce_cid;			/* message context ID */
	int4		ce_seq;			/* sequence number */
};

/*
 * client-to-client specific request data
 */
struct c2c_req {
	int		cq_state;		/* state of request */
#define	C2CDONE		1			/* all data transfer done */
#define C2CWRITE	2			/* writing to socket */
#define C2CREAD		3			/* reading from socket */
#define C2CSENDSELF	4			/* sending to self */
	int4		cq_peer;		/* matched peer */
	struct c2c_envl cq_env;			/* envelope (synch + state) */	
	struct c2c_envl cq_outenv;		/* byte-ordered outgoing env. */
	int		cq_nenvout;		/* # env. bytes left to write */
	int		cq_nmsgout;		/* # msg. bytes left to write */
	char		*cq_envbuf;		/* envelope buffer pointer*/
	char		*cq_msgbuf;		/* message buffer pointer */
	int		(*cq_adv)();		/* advance function */
};


/*
 * Include client-to-client header file according to the selected interface.
 */
#if defined(RPI_SHM)

#if defined(SHM_SYSV)
#include <shm.sysv.h>
#elif defined(SHM_SGI)
#include <shm.sgi.h>
#elif defined(SHM_HPUX)
#include <shm.hpux.h>
#elif defined(SHM_SOL)
#include <shm.sol.h>
#else
Error: shared memory type undefined.
#endif

#elif defined(RPI_TCP)

#include <rpi.tcp.h>

#else

Error: RPI type undefined.

#endif

/*
 * RPI specific part of process structure.  Currently there is no LAM
 * daemon specific part.  
 */
union rpi_proc {
	struct c2c_proc	c2c;			/* client-to-client data */
};

struct _proc {
	struct _gps	p_gps;			/* process GPS */
	int		p_ger_nsnd;		/* #msgs sent there */
	int		p_mode;			/* mode flags */
#define LAM_PFLAG	0x001			/* used for marking */
#define LAM_PDEAD	0x002			/* node died */
#define LAM_PRPIINIT	0x004			/* RPI initialized */
#define LAM_PCLIENT	0x008			/* in client world */
	int		p_refcount;		/* reference count */
	union rpi_proc	p_rpi;			/* RPI specific stuff */
};

union rpi_req {
	struct lamd_req	lamd;			/* LAM daemon mode req. data */
	struct c2c_req	c2c;			/* client-to-client req. data */
};

struct _req {
	int		rq_type;
#define LAM_RQISEND	0
#define LAM_RQIBSEND	1
#define LAM_RQISSEND	2
#define LAM_RQIRSEND	3
#define LAM_RQIRECV	4
#define LAM_RQIPROBE	5
#define LAM_RQIFAKE	6
	int		rq_state;
#define LAM_RQSINIT	0			/* request initialized */
#define LAM_RQSSTART	1			/* active, nothing done yet */
#define LAM_RQSACTIVE	4			/* active, undone request */
#define LAM_RQSDONE	3			/* request done */
	int		rq_marks;		/* persistent flags */
#define LAM_RQFPERSIST	0x0001			/* persistent request */
#define LAM_RQFDYNBUF	0x0004			/* dynamic buffer */
#define LAM_RQFDYNREQ	0x0008			/* dynamic request */
#define LAM_RQFSOURCE	0x0200			/* source request */
#define LAM_RQFDEST	0x0400			/* destination request */
#define LAM_RQFBLKTYPE	0x0800			/* blocking request type */
	int		rq_flags;		/* active req flags */
#define LAM_RQFCANCEL	0x0002			/* cancelled request */
#define LAM_RQFBLOCK	0x0010			/* blocking request */
#define LAM_RQFTRUNC	0x0040			/* truncated message */
#define LAM_RQFORPHAN	0x0100			/* destroy when done */
#define LAM_RQFCHAR	0x0100000		/* == DRAWMSG */
#define LAM_RQFINT	0x0200000		/* == DINT4MSG */
#define LAM_RQFFLOAT	0x0400000		/* == DFLT4MSG */
#define LAM_RQFDOUBLE	0x0800000		/* == DFLT8MSG */
#define LAM_RQFSHORT	0x01000000		/* == DINT2MSG */
	char		*rq_packbuf;		/* pack buffer */
	int		rq_packsize;		/* pack buffer size */
	int		rq_count;		/* MPI request parameter */
	void		*rq_buf;		/* MPI request parameter */
	MPI_Datatype	rq_dtype;		/* MPI request parameter */
	int		rq_rank;		/* MPI request parameter */
	int		rq_tag;			/* MPI request parameter */
	MPI_Comm	rq_comm;		/* MPI request parameter */
	int		rq_cid;			/* context ID to use */
	int		rq_func;		/* MPI func. which made req. */
	int		rq_seq;			/* seq# of associated msg */
	MPI_Status	rq_status;		/* status info storage */
	struct _bsndhdr	*rq_bsend;		/* ptr bsend header */
	struct _proc	*rq_proc;		/* ptr peer process */
	struct _req	*rq_next;		/* ptr next request */
	union rpi_req	rq_rpi;			/* RPI specific stuff */
};

/*
 * context ID hash table entry
 */
struct cbuf_cid {
	int4		cb_cid;			/* context ID */
	MPI_Comm	cb_comm;		/* communicator */
	LIST		*cb_envs;		/* envelope list */
};

/*
 * message/envelope entry
 */
struct cbuf_msg {
	struct c2c_proc *cm_proc;		/* source process */
	struct c2c_envl	cm_env;			/* envelope */
	char		*cm_buf;		/* short message data */
	MPI_Request	cm_req;			/* send req if sender == self */
};

/*
 * internal macros
 */
#define commdead_m(r)	\
	(((r)->rq_comm->c_flags & (LAM_CLDEAD | LAM_CRDEAD))	\
	? _c2c_comm_dead(r) : 0)

/*
 * data conversion for client-to-client envelopes
 */
#if WORDS_BIGENDIAN

#define tcp_set_out_envelope_m(r) \
	{ \
		(r).cq_nenvout = sizeof(struct c2c_envl); \
		(r).cq_envbuf = (char *) &((r).cq_env); \
	}

#else	/* not WORDS_BIGENDIAN */

#define tcp_set_out_envelope_m(r) \
	if (lam_homog) { \
		(r).cq_nenvout = sizeof(struct c2c_envl); \
		(r).cq_envbuf = (char *) &((r).cq_env); \
	} \
	else { \
		(r).cq_nenvout = sizeof(struct c2c_envl); \
		(r).cq_outenv = (r).cq_env; \
		mltoti4((int4 *) &((r).cq_outenv), \
				sizeof(struct c2c_envl) / sizeof(int4)); \
		(r).cq_envbuf = (char *) &((r).cq_outenv); \
	}

#endif	/* not WORDS_BIGENDIAN */

/*
 * prototypes of LAM MPI library client-to-client internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

extern int	_c2c_comm_dead __ARGS((MPI_Request));
extern int	_c2c_envl_cmp __ARGS((struct c2c_envl *, struct c2c_envl *));
extern void	_c2c_fill_mpi_status __ARGS((MPI_Request, int, int, int));
extern void	_c2c_fill_wildcards __ARGS((MPI_Request, struct c2c_envl *));

extern int	_cbuf_init __ARGS((void));
extern void	_cbuf_delete __ARGS((struct cbuf_msg *));
extern void	_cbuf_end __ARGS((void));
extern void	*_cbuf_append __ARGS((struct cbuf_msg *));
extern struct cbuf_msg
		*_cbuf_find __ARGS((struct c2c_envl *));

extern int	_tcp_advmultiple __ARGS((void));
extern int	_tcp_adv1 __ARGS((void));
extern int	_tcp_proc_read_env __ARGS((struct c2c_proc *));
extern int	_tcp_req_write_long __ARGS((struct c2c_proc *, MPI_Request));
extern int	_tcp_req_write_short __ARGS((struct c2c_proc *, MPI_Request));
extern int	_tcp_req_write_synch __ARGS((struct c2c_proc *, MPI_Request));
extern int	_tcp_req_read __ARGS((struct c2c_proc *, MPI_Request));
extern int	_tcp_req_probe __ARGS((struct c2c_proc *, MPI_Request));
extern int	_tcp_buffered_adv __ARGS((MPI_Request, struct cbuf_msg *));

extern int	_shm_advance __ARGS((void));
extern int	_shm_proc_read_env __ARGS((struct c2c_proc *));
extern int	_shm_req_send_long __ARGS((struct c2c_proc *, MPI_Request));
extern int	_shm_req_send_short __ARGS((struct c2c_proc *, MPI_Request));
extern int	_shm_req_send_synch __ARGS((struct c2c_proc *, MPI_Request));
extern int	_shmtcp_req_probe __ARGS((struct c2c_proc *, MPI_Request));
extern int	_shmtcp_req_read __ARGS((struct c2c_proc *, MPI_Request));
extern int	_shm_buffered_adv __ARGS((MPI_Request, struct cbuf_msg *));


#ifdef __cplusplus
}
#endif

#endif	/* _RPISYS_H */
