/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: address.c,v 6.1 96/11/23 22:50:40 nevin Rel $
 *
 *	Function:	- return address of location
 *	Accepts:	- location
 *			- ptr to address (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Address(loc, paddr)

void			*loc;
MPI_Aint		*paddr;

{
	lam_initerr();
	lam_setfunc(BLKMPIADDRESS);

	if (paddr == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIADDRESS, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*paddr = ((MPI_Aint) loc) - ((MPI_Aint) MPI_BOTTOM);

	lam_resetfunc(BLKMPIADDRESS);
	return(MPI_SUCCESS);
}
