/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: attrput.c,v 6.1 96/11/23 22:50:52 nevin Rel $
 *
 *	Function:	- put value in attribute
 *			- assign attribute to communicator
 *	Accepts:	- communicator
 *			- attribute key
 *			- attribute value
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern struct _attrkey	*lam_getattr();
extern struct _attr	*lam_getkey();

int
MPI_Attr_put(comm, key, value)

MPI_Comm		comm;
int			key;
void			*value;

{
	struct _attrkey	*p;
	struct _attr	*pk;
	int		errcode;

	lam_initerr();
	lam_setfunc(BLKMPIATTRPUT);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIATTRPUT, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	p = lam_getattr(key);
	if (p == 0 || (p->ak_flags & LAM_PREDEF)) {
		return(lam_errfunc(comm,
			BLKMPIATTRPUT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * If the key is not attached to the communicator, attach and fill it.
 */
	pk = (struct _attr *) lam_getkey(comm, key);
	if (pk == 0) {
		if (lam_putkey(comm, key)) {
			return(lam_errfunc(comm, BLKMPIATTRPUT,
				lam_mkerr(MPI_ERR_OTHER, errno)));
		}

		pk = (struct _attr *) lam_getkey(comm, key);
	}
/*
 * Old attribute, delete previous value and fill new one.
 */
	else if (p->ak_del) {
		if (p->ak_f77comm < 0) {
			errcode = (*(p->ak_del))(&comm, &key,
					pk->a_value, p->ak_extra);
		} else {
			(*(p->ak_del))(&(p->ak_f77comm), &key,
				(int *) &pk->a_value, (int *) &p->ak_extra,
				&errcode);
		}

		if (errcode != MPI_SUCCESS) {
			return(lam_errfunc(comm,
				BLKMPIATTRPUT, lam_mkerr(errcode, 0)));
		}
	}

	pk->a_value = value;

	lam_resetfunc(BLKMPIATTRPUT);
	return(MPI_SUCCESS);
}
