/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: bsend.c,v 6.1 96/11/23 22:50:57 nevin Rel $
 *
 *	Function:	- buffered send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_msg();
extern int		lam_errfunc();
extern int		lam_isend();
extern int		lam_tr_incff();

int
MPI_Bsend(buf, count, dtype, dest, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;

{
	int		err;			/* error code */
	MPI_Request	req;			/* request */
	int		fl_trace;		/* do tracing? */
	double		startt;			/* start time */
	double		finisht;		/* finish time */

	lam_initerr();
/*
 * Handle special case of peer MPI_PROC_NULL.
 */
        if (dest == MPI_PROC_NULL) return(MPI_SUCCESS);

	lam_setfunc(BLKMPIBSEND);

	if ((fl_trace = LAM_TRACE_TOP())) startt = MPI_Wtime();
/*
 * Request will be orphaned, no need to bother with it here.
 */
	req = MPI_REQUEST_NULL;
	err = lam_isend(buf, count, dtype,
			dest, tag, comm, &req, LAM_RQIBSEND);

	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPIBSEND, err));
/*
 * Generate a run time trace.
 */
	if (fl_trace) {
		finisht = MPI_Wtime();

		lam_tr_msg(TRTOUTPUT, startt, LAM_S2US(finisht - startt), 0,
				dest, tag, comm, dtype, count, 0, 0, 
				req->rq_seq, LAM_RQIBSEND);
	}
	
	lam_resetfunc(BLKMPIBSEND);
	return(MPI_SUCCESS);
}
