/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartrank.c,v 6.1 96/11/23 22:51:15 nevin Rel $
 *
 *	Function:	- translate coordinates to rank
 *	Accepts:	- communicator
 *			- coordinates array
 *			- ptr rank (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_rank(comm, coords, prank)

MPI_Comm		comm;
int			*coords;
int			*prank;

{
	int		rank;
	int		dim;
	int		ord;
	int		factor;
	int		i;
	int		*d;
	int		*c;

	lam_initerr();
	lam_setfunc(BLKMPICARTRANK);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTRANK, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTRANK, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_CART(comm)) {
		return(lam_errfunc(comm, BLKMPICARTRANK,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((coords == 0) || (prank == 0)) {
		return(lam_errfunc(comm,
			BLKMPICARTRANK, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Loop over coordinates computing the rank.
 */
	factor = 1;
	rank = 0;
	i = comm->c_topo_ndims - 1;
	d = comm->c_topo_dims + i;
	c = coords + i;

	for (; i >= 0; --i, --c, --d) {
		dim = (*d > 0) ? *d : -(*d);
		ord = *c;
		if ((ord < 0) || (ord >= dim)) {
			if (*d > 0) {
				return(lam_errfunc(comm, BLKMPICARTRANK,
					lam_mkerr(MPI_ERR_ARG, 0)));
			}

			ord %= dim;
			if (ord < 0) {
				ord += dim;
			}
		}

		rank += factor * ord;
		factor *= dim;
	}

	*prank = rank;

	lam_resetfunc(BLKMPICARTRANK);
	return(MPI_SUCCESS);
}
