/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: crsize.c,v 6.1 96/11/23 22:51:31 nevin Rel $
 *
 *	Function:	- return the size of the remote group
 *	Accepts:	- inter-communicator
 *			- ptr to size (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_remote_size(comm, psize)

MPI_Comm		comm;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMRSIZE);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTRA(comm)) {
		return(lam_errfunc(comm,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (psize == 0) {
		return(lam_errfunc(comm,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*psize = comm->c_rgroup->g_nprocs;

	lam_resetfunc(BLKMPICOMMRSIZE);
	return(MPI_SUCCESS);
}
