/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errget.c,v 6.1 96/11/23 22:51:45 nevin Rel $
 *
 *	Function:	- get error handler of communicator
 *	Accepts:	- communicator
 *			- ptr to error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Errhandler_get(comm, errhdl)

MPI_Comm		comm;
MPI_Errhandler		*errhdl;

{
	lam_initerr();
	lam_setfunc(BLKMPIERRGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (errhdl == 0) {
		return(lam_errfunc(comm,
			BLKMPIERRGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Get the communicator's error handler.
 */
	*errhdl = comm->c_errhdl;

	lam_resetfunc(BLKMPIERRGET);
	return(MPI_SUCCESS);
}
