/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: testsome_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Testsome F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_testsome_(c, rqs, oc, idx, st, ierr)

int			*c, *rqs, *oc, *idx, *st, *ierr;

{
	MPI_Request	*reqs;
	MPI_Status	*stats;
	int		i;

	reqs = (MPI_Request *) malloc((unsigned) (*c) *	sizeof(MPI_Request));
	if (reqs == 0) {
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}

	stats =	(MPI_Status *) malloc((unsigned) (*c) *	sizeof(MPI_Status));
	if (stats == 0)	{
		free((char *) reqs);
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}

	for (i = 0; i <	*c; ++i) reqs[i] = GETHDL(rqs[i]);

	*ierr =	MPI_Testsome(*c, reqs, oc, idx,	stats);
	if ((*ierr == MPI_SUCCESS) && (*oc > 0)) {
		for (i = 0; i <	*c; ++i) {
			if (reqs[i] == MPI_REQUEST_NULL) {
				lam_F_typefree(rqs[i]);
				rqs[i] = -1;
			}
		}

		for (i = 0; i <	*oc; ++i) {
			idx[i] += 1;
			lam_C2F_stat(stats + i,	st);
			st[6] =	-1;
			st += 7;
		}
	}

	free((char *) reqs);
	free((char *) stats);
}
