/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: thindex_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Type_hindexed F77	wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_type_hindexed_(c, b, d, ot,	nt, ierr)

int			*c, *b,	*d, *ot, *nt, *ierr;

{
	MPI_Datatype	dtype;
	MPI_Aint	*dp;
	int		i;

	dp = (MPI_Aint *) malloc((unsigned) (*c) * sizeof(MPI_Aint));
	if (dp == 0) {
		*ierr =	lam_mkerr(MPI_ERR_OTHER, errno);
		return;
	}

	for (i = 0; i <	*c; ++i) dp[i] = (MPI_Aint) d[i];

	*ierr =	MPI_Type_hindexed(*c, b, dp, GETHDL(*ot), &dtype);
	lam_F_maketype(nt, ierr, (void *) dtype);

	free((char *) dp);
}
