/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/JRV
 *
 *	$Id: gather.c,v 6.1 96/11/23 22:51:51 nevin Rel $
 *
 *	Function:	- gather buffers at root in process rank order
 *	Accepts:	- send buffer
 *			- send count
 *			- send datatype
 *			- recv buffer
 *			- recv count
 *			- recv datatype
 *			- root
 *			- communicator
 *	Returns:	- MPI_SUCCESS or an MPI error code
 */

#include <app_mgmt.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

int
MPI_Gather(sbuf, scount, sdtype, rbuf, rcount, rdtype, root, comm)

void			*sbuf;
int			scount;
MPI_Datatype		sdtype;
void			*rbuf;
int			rcount;
MPI_Datatype		rdtype;
int			root;
MPI_Comm		comm;

{
	int		i;			/* favourite index */
	int		rank;			/* my rank */
	int		size;			/* group size */
	int		err;			/* error code */
	char		*ptmp;			/* temporary buffer */
	MPI_Aint	incr;			/* increment size */
	MPI_Aint	extent;			/* datatype extent */
	MPI_Status	stat;			/* receive status */
	struct _gps	*p;			/* favourite pointer */

	lam_initerr();
	lam_setfunc(BLKMPIGATHER);
/*
 * Check for invalid arguments.
 */
	if ((comm == MPI_COMM_NULL) || LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm, BLKMPIGATHER,
					lam_mkerr(MPI_ERR_COMM, 0)));
	}

	MPI_Comm_rank(comm, &rank);
	MPI_Comm_size(comm, &size);

	if ((root >= size) || (root < 0)) {
		return(lam_errfunc(comm, BLKMPIGATHER,
					lam_mkerr(MPI_ERR_ROOT, 0)));
	}

	if ((sdtype == MPI_DATATYPE_NULL)
			|| (rank == root && rdtype == MPI_DATATYPE_NULL)) {
		return(lam_errfunc(comm, BLKMPIGATHER,
					lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if ((scount < 0) || (rank == root && rcount < 0)) {
		return(lam_errfunc(comm, BLKMPIGATHER,
					lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	LAM_TRACE(lam_tr_cffstart(BLKMPIGATHER));
/*
 * Remember required parameters.
 */
	p = &(comm->c_group->g_procs[root]->p_gps);

	lam_setparam(BLKMPIGATHER, root | (p->gps_grank << 16),
				(p->gps_node << 16) | p->gps_idx);
/*
 * Switch to collective communicator.
 */
	lam_mkcoll(comm);
/*
 * Everyone but root sends data and returns.
 */
	if (rank != root) {

		err = MPI_Send(sbuf, scount, sdtype, root, BLKMPIGATHER, comm);
		lam_mkpt(comm);

		if (err != MPI_SUCCESS) {
			return(lam_errfunc(comm, BLKMPIGATHER, err));
		}

		LAM_TRACE(lam_tr_cffend(BLKMPIGATHER,
						root, comm, sdtype, scount));

		lam_resetfunc(BLKMPIGATHER);
		return(MPI_SUCCESS);
	}
/*
 * I am the root, loop receiving the data.
 */
	MPI_Type_extent(rdtype, &extent);
	incr = extent * rcount;

	for (i = 0, ptmp = (char *) rbuf; i < size; ++i, ptmp += incr) {
/*
 * simple optimization
 */
		if (i == rank) {
			err = lam_dtsndrcv(sbuf, scount, sdtype, ptmp,
					rcount, rdtype, BLKMPIGATHER, comm);
		} else {
			err = MPI_Recv(ptmp, rcount, rdtype, i,
						BLKMPIGATHER, comm, &stat);
		}

		if (err != MPI_SUCCESS) {
			lam_mkpt(comm);
			return(lam_errfunc(comm, BLKMPIGATHER, err));
		}
	}

	lam_mkpt(comm);

	LAM_TRACE(lam_tr_cffend(BLKMPIGATHER, root, comm, sdtype, scount));

	lam_resetfunc(BLKMPIGATHER);
	return(MPI_SUCCESS);
}
