/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: graphget.c,v 6.1 96/11/23 22:52:12 nevin Rel $
 *
 *	Function:	- get nodes/edges in graph topology
 *	Accepts:	- communicator
 *			- size of nodes array
 *			- size of edges array
 *			- nodes array
 *			- edges array
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Graph_get(comm, maxnodes, maxedges, nodes, edges)

MPI_Comm		comm;
int			maxnodes;
int			maxedges;
int			*nodes;
int			*edges;

{
	int		i;
	int		*p;

	lam_initerr();
	lam_setfunc(BLKMPIGRAPHGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGRAPHGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_GRAPH(comm)) {
		return(lam_errfunc(comm, BLKMPIGRAPHGET,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((maxnodes < 0) || (maxedges < 0) || (nodes == 0) || (edges == 0)) {
		return(lam_errfunc(comm,
			BLKMPIGRAPHGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Fill the nodes and edges arrays.
 */
	p = comm->c_topo_index;
	for (i = 0; (i < comm->c_topo_nprocs) && (i < maxnodes); ++i, ++p) {
		*nodes++ = *p;
	}

	p = comm->c_topo_edges;
	for (i = 0; (i < comm->c_topo_nedges) && (i < maxedges); ++i, ++p) {
		*edges++ = *p;
	}

	lam_resetfunc(BLKMPIGRAPHGET);
	return(MPI_SUCCESS);
}
