/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: infogetnth.c,v 6.1 96/11/22 13:34:58 nevin Rel $
 *
 *	Function:	- get n'th key in info object
 *	Accepts:	- info
 *			- n
 *			- key (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_get_nthkey(info, n, key)

MPI_Info		info;
int			n;
char			*key;

{
	struct _info	*p;			/* key/value pair */
	
        lam_initerr();
	lam_setfunc(BLKMPIINFONTH);

	if (info == 0 || n >= al_count((LIST *) info)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFONTH,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	for (p = al_top((LIST *) info); n > 0; n--) {
		p = al_next((LIST *) info, p);
	}

	strcpy(key, p->info_key);
	
        lam_resetfunc(BLKMPIINFONTH);
	return(MPI_SUCCESS);
}
