/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lamports.c,v 6.1 96/11/22 13:35:02 nevin Rel $
 *
 *	Function:	- port management functions
 */

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpisys.h>
#include <terror.h>
#include <typical.h>

#define LAM_PORTMAX	16
#define LAM_PORTLOW	(BLKHIGH + 1)

/*
 * private variables
 */
static int		ports[LAM_PORTMAX];	/* port table */

/*
 *	lam_port_open
 * 
 *	Function:	- open a LAM MPI port
 *	Returns:	- port number or LAMERROR
 */
int
lam_port_open()

{
	int		i;
/*
 * Search for free port.
 */
	for (i = 0; i < LAM_PORTMAX; i++) {
		if (ports[i] == 0) {
			ports[i] = 1;
			return(LAM_PORTLOW + i);
		}
	}

	return(LAMERROR);
}

/*
 *	lam_port_is_open
 * 
 *	Function:	- checks if port is open
 *	Returns:	- 1 if open, 0 if not open, or LAMERROR if illegal port
 */
int
lam_port_is_open(port)

int			port;

{
	port -= LAM_PORTLOW;
	if (!((0 <= port) && (port < LAM_PORTMAX))) {
		errno = EINVAL;
		return(LAMERROR);
	}

	return(ports[port]);
}

/*
 *	lam_port_close
 * 
 *	Function:	- closes a port
 *	Returns:	- 0 else LAMERROR
 */
int
lam_port_close(port)

int			port;

{
	port -= LAM_PORTLOW;
	if (!((0 <= port) && (port < LAM_PORTMAX))) {
		errno = EINVAL;
		return(LAMERROR);
	}
	
	ports[port] = 0; 
	return(0);
}
