/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: testcancel.c,v 6.1 96/11/23 22:54:31 nevin Rel $
 *
 *	Function:	- test if cancellation succeeded
 *	Accepts:	- ptr status structure
 *			- ptr flag (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Test_cancelled(pstat, pflag)

MPI_Status		*pstat;
int			*pflag;

{
	lam_setfunc(BLKMPITESTCANCEL);

	if ((pstat == 0) || (pflag == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITESTCANCEL, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pflag = (pstat->MPI_SOURCE == MPI_CANCEL_SOURCE) ? 1 : 0;

	lam_resetfunc(BLKMPITESTCANCEL);
	return(MPI_SUCCESS);
}
