/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tlb.c,v 6.1 96/11/23 22:54:42 nevin Rel $
 *
 *	Function:	- return lower bound of datatype
 *	Accepts:	- datatype
 *			- lower bound (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Type_lb(dtype, lb)

MPI_Datatype		dtype;
MPI_Aint		*lb;

{
	lam_initerr();
	lam_setfunc(BLKMPITLB);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITLB, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (lb == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITLB, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*lb = dtype->dt_lower;
	}

	lam_resetfunc(BLKMPITLB);
	return(MPI_SUCCESS);
}
