/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: waitall.c,v 6.1 96/11/23 22:54:54 nevin Rel $
 *
 *	Function:	- wait for all requests to finish
 *	Accepts:	- # of requests
 *			- array of requests
 *			- array of status structures (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * external functions
 */
extern void		lam_emptystat();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_wrapend();
extern int		lam_tr_wrapstart();
extern int		lam_errfunc();
extern int		lam_mkerr();


int
MPI_Waitall(count, reqs, stats)

int			count;
MPI_Request		*reqs;
MPI_Status		*stats;

{
	int		i;			/* favourite index */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	int		first;			/* first request ready */
	MPI_Status	firststat;		/* status of first request */
	MPI_Status	*p;			/* favourite pointer */

	lam_setfunc(BLKMPIWAITALL);

	if (count < 0) {
	    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITALL,
		    lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && ((reqs == 0) || (stats == 0))) {
	    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITALL,
		    lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
	    lam_tr_wrapstart(BLKMPIWAITALL);
	}
/*
 * Initialize all status members.
 */
	for (i = 0, p = stats; i < count; ++i, ++p) {
	    lam_emptystat(p);
	}
/*
 * Loop waiting for all requests.
 */
	for (i = 0; i < count; ++i) {
	    err = MPI_Waitany(count, reqs, &first, &firststat);

	    if (err != MPI_SUCCESS) {

		if (first == MPI_UNDEFINED) {
		    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITALL, err));
		}

		else {
		    stats[first].MPI_ERROR = err;

		    if (fl_trace) {
			lam_tr_wrapend(BLKMPIWAITALL);
		    }
	
		    lam_resetfunc(BLKMPIWAITALL);
		    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIWAITALL,
			    lam_mkerr(MPI_ERR_IN_STATUS, 0)));
		}
	    }

	    if (first == MPI_UNDEFINED) {

		if (fl_trace) {
		    lam_tr_wrapend(BLKMPIWAITALL);
		}

		lam_resetfunc(BLKMPIWAITALL);
		return(MPI_SUCCESS);
	    }

	    stats[first] = firststat;
	    stats[first].MPI_ERROR = MPI_SUCCESS;
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
	    lam_tr_wrapend(BLKMPIWAITALL);
	}
	
	lam_resetfunc(BLKMPIWAITALL);
	return(MPI_SUCCESS);
}
