/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rpwait.c,v 6.1 96/11/24 00:26:15 nevin Rel $
 * 
 *	Function:	- waits for kenya process to die
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *
 *	Accepts:	- ptr to node ID
 *			- ptr to process ID
 *			- ptr to child process status
 *
 *	Returns:	- 0 or ERROR with errno set accordingly
 */

#include <unistd.h>

#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>

int
rpwait(nodeid, pid, status)

int4			*nodeid;
int			*pid;
int			*status;

{
	struct nmsg	nhead;		/* network message descriptor */
	struct preply	reply;		/* kenyad reply */

	nhead.nh_event = (-getpid()) & 0xBFFFFFFF;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(struct preply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		return(ERROR);
	}

	*nodeid = ttol(reply.pr_nodeid);
	*pid = (int) ttol(reply.pr_pid);
	*status = (int) ttol(reply.pr_reply);

	return(0);
}
