DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.

# Some of the stubs takes a long time to compile with optimisation.
# Set CXXDEBUGFLAGS to null to compile the stubs without optimisation.
CXXDEBUGFLAGS =

OBJS = NamingSK.o \
       array1SK.o \
       attrEchoSK.o \
       attrObjRefSK.o \
       boolSK.o \
       bug1SK.o \
       bug2SK.o \
       bugReportSK.o \
       childSK.o \
       const1SK.o \
       echoSK.o \
       derivedEchoSK.o \
       enumsSK.o \
       fooSK.o \
       inheritance_1SK.o \
       inheritance_2SK.o \
       intf1SK.o \
       intf2SK.o \
       intf3SK.o \
       intf4SK.o \
       managerSK.o \
       mrBookSK.o \
       multiEchoSK.o \
       passrefSK.o \
       refpSK.o \
       rendermanSK.o \
       seqEchoSK.o \
       seqtestSK.o \
       shutdownSK.o \
       struct1SK.o \
       struct2SK.o \
       tstexceptSK.o \
       ttcpSK.o \
       typedef1SK.o \
       typedef2SK.o \
       typedef3SK.o \
       union1SK.o \
       union2SK.o \
       varTestSK.o \
       varTest2SK.o \
       virtualbugSK.o \
       scopetestSK.o \
       bug971222SK.o \
       intf_fwd1SK.o \
       enum1SK.o \
       struct1aSK.o \
       struct1bSK.o \
       struct1cSK.o \
       structNestSK.o \
       except1aSK.o \
       except1bSK.o \
       except1cSK.o \
       union1aSK.o \
       union1bSK.o \
       union1cSK.o \
       union1b1SK.o \
       union1c1SK.o \
       typedef1aSK.o \
       typedef1bSK.o \
       typedef1cSK.o \
       array1aSK.o \
       array1bSK.o \
       array1cSK.o \
       $(ANY_OBJS) \
       $(TYPECODE_OBJS) \
       $(SEQOBJS) \
       bug980810SK.o


SEQOBJS = seq2SK.o \
       seq3SK.o \
       seq4SK.o \
       seq5SK.o \
       seq6SK.o \
       seq7SK.o \
       seq8SK.o \
       seq9SK.o \
       seq10SK.o \
       seq1SK.o \
       array2aSK.o \
       sequence1aSK.o \
       sequence1bSK.o \
       sequence1cSK.o \
       seqAlias1SK.o \
       seqArray1SK.o \
       seqArray2SK.o \
       seqArray3SK.o \
       recTestSK.o \
       recTest2SK.o \
       recUnionSK.o \
       recUnion2SK.o

ANY_OBJS = anyTestSK.o \
	anySeq2SK.o \
	testAnyUnion1SK.o \
	testAnyUnion2SK.o \
	any_sequenceSK.o \
	any_arraySK.o \
	any_structSK.o \
	any_exceptSK.o \
	any_unionSK.o \
	testAnyObjEnumSK.o \
	anyStructTestSK.o \
	anyUnionTestSK.o

TYPECODE_OBJS = typecodeSK.o \
	tcSequenceSK.o \
	tcArraySK.o \
	tcStructSK.o \
	tcExceptSK.o \
	tcUnionSK.o \
	typecodeTestSK.o

ifdef EgcsMajorVersion
ifeq ($(EgcsMajorVersion),1)
ifeq ($(EgcsMinorVersion),0)
# There is a bug in egcs-1.0 and it fails to compile idl stubs with
# sequences. Exclude sequence tests.
SEQOBJS =
endif
endif
endif



OMNIORB2_IDL += -I.

all:: stubs $(OBJS)

stubs:: $(patsubst %.o,%.cc,$(OBJS)) 

ifdef Win32Platform
OMNIORB2_IDL = $(EXPORT_TREE)/$(BINDIR)/omniidl2.exe -a  -DTEST_MSVC -s SK.cc $(patsubst %,-I%,$(VPATH))
else
OMNIORB2_IDL = $(EXPORT_TREE)/$(BINDIR)/omniidl2 -a -s SK.cc $(patsubst %,-I%,$(VPATH))
ifeq ($(notdir $(CXX)),g++)
ifndef EgcsMajorVersion
OMNIORB2_IDL += -DTEST_GCC272
else
OMNIORB2_IDL += -DTEST_EGCS -DEGCS_MAJOR=$(EgcsMajorVersion) \
                -DEGCS_MINOR=$(EgcsMinorVersion)
endif
else
ifdef OSF1
ifeq ($(notdir $(CXX)),cxx)
ifndef DecCxxMajorVersion
DecCxxMajorVersion = 5
endif
OMNIORB2_IDL += -DTEST_DECCXX -DCXX_MAJOR=$(DecCxxMajorVersion)
endif
endif
endif
endif

ERASK.cc : ERA.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

NamingSK.cc : Naming.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

array1SK.cc : array1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

attrEchoSK.cc : attrEcho.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

attrObjRefSK.cc : attrObjRef.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

bug1SK.cc : bug1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

bug2SK.cc : bug2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


bugReportSK.cc : bugReport.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


childSK.cc : child.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


const1SK.cc : const1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


derivedEchoSK.cc : derivedEcho.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


echoSK.cc : echo.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


enumsSK.cc : enums.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


fooSK.cc : foo.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


inheritance_1SK.cc : inheritance_1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


inheritance_2SK.cc : inheritance_2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


intf1SK.cc : intf1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


intf2SK.cc : intf2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


intf3SK.cc : intf3.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


intf4SK.cc : intf4.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


managerSK.cc : manager.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


mrBookSK.cc : mrBook.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


multiEchoSK.cc : multiEcho.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

passrefSK.cc : passref.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


refpSK.cc : refp.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


rendermanSK.cc : renderman.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)


scopetestSK.cc : scopetest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq1SK.cc : seq1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq2SK.cc : seq2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq3SK.cc : seq3.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq4SK.cc : seq4.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq5SK.cc : seq5.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq6SK.cc : seq6.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq7SK.cc : seq7.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq8SK.cc : seq8.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq9SK.cc : seq9.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seq10SK.cc : seq10.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqEchoSK.cc : seqEcho.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqtestSK.cc : seqtest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

shutdownSK.cc : shutdown.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

struct1SK.cc : struct1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

struct2SK.cc : struct2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tstexceptSK.cc : tstexcept.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

ttcpSK.cc : ttcp.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef1SK.cc : typedef1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef2SK.cc : typedef2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef3SK.cc : typedef3.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1SK.cc : union1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union2SK.cc : union2.idl
	$(RM) union2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

varTestSK.cc : varTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

varTest2SK.cc : varTest2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

virtualbugSK.cc : virtualbug.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

mosquerySK.cc : mosquery.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

mosbrowseSK.cc : mosbrowse.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

bug971222SK.cc : bug971222.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

intf_fwd1SK.cc : intf_fwd1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

enum1SK.cc : enum1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

struct1aSK.cc : struct1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

struct1bSK.cc : struct1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

struct1cSK.cc : struct1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

structNestSK.cc : structNest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

except1aSK.cc : except1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

except1bSK.cc : except1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

except1cSK.cc : except1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1aSK.cc : union1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1bSK.cc : union1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1cSK.cc : union1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1b1SK.cc : union1b1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

union1c1SK.cc : union1c1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef1aSK.cc : typedef1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef1bSK.cc : typedef1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typedef1cSK.cc : typedef1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

array1aSK.cc : array1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

array1bSK.cc : array1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

array1cSK.cc : array1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

array2aSK.cc : array2a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

sequence1aSK.cc : sequence1a.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

sequence1bSK.cc : sequence1b.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

sequence1cSK.cc : sequence1c.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqAlias1SK.cc : seqAlias1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqArray1SK.cc : seqArray1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqArray2SK.cc : seqArray2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

seqArray3SK.cc : seqArray3.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

recTestSK.cc : recTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

recTest2SK.cc : recTest2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

recUnionSK.cc : recUnion.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

recUnion2SK.cc : recUnion2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

anyTestSK.cc : anyTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

anySeq2SK.cc : anySeq2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

testAnyUnion1SK.cc : testAnyUnion1.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

testAnyUnion2SK.cc : testAnyUnion2.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

any_sequenceSK.cc : any_sequence.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

any_arraySK.cc : any_array.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

any_structSK.cc : any_struct.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

any_exceptSK.cc : any_except.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

any_unionSK.cc : any_union.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

testAnyObjEnumSK.cc : testAnyObjEnum.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

anyStructTestSK.cc : anyStructTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

anyUnionTestSK.cc : anyUnionTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typecodeSK.cc : typecode.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tcSequenceSK.cc : tcSequence.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tcArraySK.cc : tcArray.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tcStructSK.cc : tcStruct.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tcExceptSK.cc : tcExcept.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

tcUnionSK.cc : tcUnion.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

typecodeTestSK.cc : typecodeTest.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

boolSK.cc : bool.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

bug980810SK.cc : bug980810.idl
	-@$(CP) $^ .
	$(OMNIORB2_IDL) $(notdir $^)

veryclean::
	$(RM) *SK.cc *.hh *.h *.idl
