/*
 * PCPIO.C - I/O hooks suitable for use with PDBLib and parallel communications
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "ppc.h"

#define REPLY(msg, val)                                                      \
   {printf("%s:%ld\n", msg, (long) val);                                     \
    fflush(stdout);                                                          \
    if (_PC_debug)                                                           \
       {fprintf(_PC_diag, "%s:%ld\n", msg, (long) val);                      \
        fflush(_PC_diag);};}

struct s_REMOTE_FILE
   {PROCESS *pp;
    int type;
    int fid;
    long file_size;
    char *buffer;
    long sb_addr;
    long size;
    long cf_addr;};

typedef struct s_REMOTE_FILE REMOTE_FILE;

#define MESSAGES(x)         PC_procs.m[(x)].msg
#define MESSAGE_TYPES(x)    PC_procs.m[(x)].type
#define MESSAGE_LENGTHS(x)  PC_procs.m[(x)].ni
#define N_MESSAGES(x)       PC_procs.m[(x)].n
#define MAX_MESSAGES(x)     PC_procs.m[(x)].nx

struct s_NODE_LIST
   {int n;
    int nx;
    PROCESS **p;
    PC_message *m;
    PC_poll_desc *fd;};

typedef struct s_NODE_LIST NODE_LIST;

static NODE_LIST
 PC_procs = {0, 0, NULL, NULL};

extern long
 SC_DECLARE(_PC_transfer_bytes, (int cfd, long nbe, FILE *fp)),
 SC_DECLARE(_PC_get_cmd_resp, (PROCESS *pp, char *msg));

static int
 SC_DECLARE(PC_register_proc, (PROCESS *pp, int i)),
 SC_DECLARE(_PC_setup_children, (char **argv, char *mode)),
 SC_DECLARE(_PC_get_message, (int i)),
 SC_DECLARE(_PC_get_msg, (int i)),
 SC_DECLARE(_PC_put_msg, 
            (PROCESS *pi, char *type, int ni, int indx));

/*--------------------------------------------------------------------------*/

/*                           SERVER SIDE ROUTINES                           */

/*--------------------------------------------------------------------------*/

/* PC_PROCESS_ACCESS - carry out file access commands on the named host
 *                   - this is the server end
 *                   - the command codes are:
 *                   -   PC_FOPEN
 *                   -   PC_FCLOSE
 *                   -   PC_FFLUSH
 *                   -   PC_FTELL
 *                   -   PC_FSEEK
 *                   -   PC_FREAD
 *                   -   PC_FWRITE
 *                   -   PC_FPUTS
 *                   -   PC_FGETS
 *                   -   PC_FGETC
 *                   -   PC_FUNGETC
 *                   -   PC_FEXIT
 *                   -   PC_NUM_NODES
 */

int PC_process_access(argv, mode)
   char **argv, *mode;
   {int i, n, rev, msgs, *nim;

#ifdef HAVE_PROCESS_CONTROL

    _PC_setup_children(argv, mode);
            
    while (TRUE)
       {PC_err[0] = '\0';
	n = PC_poll(PC_procs.fd, PC_procs.n, -1);
	if (n > 0)
	   {do {msgs = FALSE;
		for (i = 0; i < PC_procs.n; i++)
		    {rev = PC_procs.fd[i].revents;
		     if ((rev & POLLIN) || (rev & POLLPRI))
		        {msgs |= _PC_get_message(i);};};

/* for anybody who may be doing a blocking read and there is a message
 * available let it through before another poll
 */
		for (i = 0; i < PC_procs.n; i++)
		    {nim = MESSAGE_LENGTHS(i);
		     if (nim != NULL)
		        _PC_get_msg(i);};}

	    while (msgs);};};
    return(TRUE);}

#else

    return(FALSE);}

#endif

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_GET_MESSAGE - handle input from the specified child */

static int _PC_get_message(i)
   int i;
   {int ni, code, indx;
    char s[MAXLINE], *type, *t;
    PROCESS *pi;

    pi = PC_procs.p[i];
    if (pi == NULL)
       return(FALSE);

    s[0] = '\0';
    if (PC_gets(s, MAXLINE, pi) == NULL)
       return(FALSE);

    if (_PC_debug && isprint(s[0]))
       {fprintf(_PC_diag, "Message from node #%d: %s", i, s);
	fflush(_PC_diag);};

    code = s[0];
    if ((code <= PC_MIN_CMMNDS) || (code >= PC_MAX_CMMNDS))
       {PRINT(stdout, s);
	return(TRUE);};

    SC_strtok(s, ",", t);
    switch (code)
       {case PC_FSETVBUF :
             break;

        case PC_FCLOSE :
             break;

        case PC_FFLUSH :
             break;

        case PC_FTELL :
             break;

        case PC_FSEEK :
             break;

        case PC_FREAD :
	     type = SC_strtok(NULL, ",\n", t);
	     ni   = SC_stoi(SC_strtok(NULL, ",\n", t));

/*	     blk  = SC_stoi(SC_strtok(NULL, ",\n", t)); */
	     SC_strtok(NULL, ",\n", t);

	     _PC_get_msg(i);

	     break;

        case PC_FWRITE :
             type = SC_strtok(NULL, ",\n", t);
	     ni   = SC_stoi(SC_strtok(NULL, ",\n", t));
	     indx = SC_stoi(SC_strtok(NULL, ",\n", t));

             _PC_put_msg(pi, type, ni, indx);

	     break;

        case PC_FPUTS :
             break;

        case PC_FGETS :
             break;

        case PC_FGETC :
             break;

        case PC_FUNGETC :
             break;

        case PC_FEXIT :
             exit(0);

        default :
             break;};

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_PUT_MSG - get the message from the specified node */

static int _PC_put_msg(pi, type, ni, indx)
   PROCESS *pi;
   char *type;
   int ni, indx;
   {int nbi, nbt, nir, bpi;
    char *bf;

    bpi = PN_sizeof(type, pi->vif->host_chart);
    nbi = ni*bpi;
    bf  = FMAKE_N(char, nbi, "_PC_PUT_MSG:bf");
    if (_PC_debug)
       {fprintf(_PC_diag, "   Write Get(%d,%s,%d)", ni, type, pi->acpu);
	fflush(_PC_diag);};

    nbt = PC_buffer_data_out(pi, bf, nbi, TRUE);
    nir = nbt/bpi;

    PC_push_message(PC_procs.m + indx, indx, ni, type, bf);

    if (_PC_debug)
       {fprintf(_PC_diag, " Recv(%d,%s,%d)\n", nir, type, indx);
	fflush(_PC_diag);};

    PC_printf(pi, "%d,%s,%d\n", nir, type, indx);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_GET_MSG - send the first message on the queue for the specified
 *             - node
 */

static int _PC_get_msg(i)
   int i;
   {int nbo, nbe, bpi;
    int ni, *nis, data;
    char *type, **msg, **typ, *pbf;
    PROCESS *pi;

    msg = MESSAGES(i);
    typ = MESSAGE_TYPES(i);
    nis = MESSAGE_LENGTHS(i);
    pi  = PC_procs.p[i];
    if ((msg != NULL) && (typ != NULL) && (nis != NULL))
       {pbf  = msg[0];
        type = typ[0];
        ni   = nis[0];
        data = pi->data;
        if (pbf != NULL)
	   {if (_PC_debug)
	       {fprintf(_PC_diag, "   Read");
		fflush(_PC_diag);};

	    PC_printf(pi, "%d,%s\n", ni, type);

	    if (_PC_debug)
	       {fprintf(_PC_diag, " Put(%d,%s)", ni, type);
		fflush(_PC_diag);};

	    bpi = PN_sizeof(type, pi->vif->host_chart);
	    nbo = ni*bpi;
	    while (nbo > 0)
 	       {PC_buffer_data_in(pi);
		nbe = write(data, pbf, nbo);
                if (nbe < 0)
                   continue;
		else if (_PC_debug)
		   {fprintf(_PC_diag, ".%d", nbe);
		    fflush(_PC_diag);};

		pbf += nbe;
		nbo -= nbe;};

	    if (_PC_debug)
	       {fprintf(_PC_diag, " Sent(%d,%s,%d)\n",
			(ni - nbo/bpi), type, i);
		fflush(_PC_diag);};

            PC_pop_message(i);

	    return(TRUE);};};

    PC_printf(pi, "0,none\n");

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PC_SETUP_CHILDREN - spawn the specified set of children */

static int _PC_setup_children(argv, mode)
   char **argv, *mode;
   {int i, n, port, argc, which, cbk, off;
    long parentp;
    char **args, s[MAXLINE], host[MAXLINE];
    PROCESS *pp;

#ifdef HAVE_PROCESS_CONTROL

    gethostname(host, MAXLINE);
    port = PC_init_server(GET_PORT, FALSE);
    if (port == -1)
       return(FALSE);

    which     = 0;
    off       = 1;
    parentp   = FALSE;
    _PC_debug = FALSE;
    for (i = 1; argv[i] != NULL; i++)
        {if (argv[i][0] == '-')
	    {switch (argv[i][1])
	        {case 'a' :
	              which = SC_stoi(argv[++i]);
		      break;
	         case 'l' :
		      _PC_debug = TRUE;
		      break;
		 case 'n' :
	              n = SC_stoi(argv[++i]);
		      break;
		 case 'r' :
		      if (SC_numstrp(argv[i+1]))
			 parentp = SC_stoi(argv[++i]);
		      break;};}
	 else
	    off = i;};

    argv += off;

    if (_PC_debug)
       {sprintf(s, "PC_srvr_log.%d", (int) getpid());
	_PC_diag = fopen(s, "w");
        fprintf(_PC_diag, "\n   ------ Begin Setup ------\n\n");
        fprintf(_PC_diag, "Requesting %d nodes (%d)\n", n, which);
        fprintf(_PC_diag, "Exec: %s %s\n\n", argv[0], argv[1]);
	fflush(_PC_diag);};

    if (parentp)

/* the process on the other end of stdin, and stdout is either the
 * master application or the first of an SPMD application
 * remember it as node specified by "which"
 */
       {pp = PC_mk_process(argv, mode, PC_CHILD);
	if (_PC_debug)
	   {fprintf(_PC_diag, "Open node #%d (%p)\n", which, pp);
	    fflush(_PC_diag);};
	pp->in   = 0;
	pp->out  = 1;
	pp->acpu = which;

	if (pp != NULL)

/* this goes to PC_open_group */
	   {PC_printf(pp, "%s,%d,%d,%d\n", host, port, n, _PC_debug);

/* this goes to PC_open_member */
	    PC_printf(pp, "%d,%d,%d\n", which, n, _PC_debug);
	    PC_block(pp);
	    PC_gets(s, MAXLINE, pp);
	    if (_PC_debug)
	       {fprintf(_PC_diag, "Latch up with parent: %s", s);
		fflush(_PC_diag);};

	    if (_PC_debug)
	       {fprintf(_PC_diag, "Get data socket for node #%d\n",
			which);
		fflush(_PC_diag);};
	    pp->data = PC_init_server(GET_CONNECTION, FALSE);
	    if (_PC_debug)
	       {fprintf(_PC_diag, "Data socket for node #%d: %d\n",
			which, pp->data);
		fflush(_PC_diag);};

	    cbk = PC_register_proc(pp, which);
	    if (_PC_debug)
	       {fprintf(_PC_diag, "I/O interrupt: %d\n\n", cbk);
		fflush(_PC_diag);};};}

/* the process on the other end of stdin and stdout is a terminal */
    else
       which = -1;

/* setup a special new arglist for the new children */
    for (argc = 0; argv[argc] != NULL; argc++);
    args = FMAKE_N(char *, argc + 1,
           "_PC_SETUP_CHILDREN:args");
    for (argc = 0; argv[argc] != NULL; argc++)
        args[argc] = argv[argc];

/* add an additional argument at the end of the old list */
    sprintf(s, "HOST:%s,%d", host, port);
    args[argc] = SC_strsavef(s, "char*:_PC_SETUP_CHILDREN:s");
    args[argc+1] = NULL;

/* open the requested additional nodes */
    for (i = 0; i < n; i++)
        {if (i == which)
            continue;
         pp = PC_open(args, NULL, mode);
	 if (_PC_debug)
	    {fprintf(_PC_diag, "Open node #%d (%p)\n", i, pp);
	     fflush(_PC_diag);};
	 if (pp != NULL)
	    {PC_printf(pp, "%d,%d,%d\n", i, n, _PC_debug);
	     pp->acpu = i;

	     PC_block(pp);
	     PC_gets(s, MAXLINE, pp);
	     if (_PC_debug)
	        {fprintf(_PC_diag, "Latch up with child: %s", s);
	         fprintf(_PC_diag, "Get data socket for node #%d\n", i);
		 fflush(_PC_diag);};
	     pp->data = PC_init_server(GET_CONNECTION, FALSE);
	     if (_PC_debug)
	        {fprintf(_PC_diag, "Data socket for node #%d: %d\n",
			 i, pp->data);
		 fflush(_PC_diag);};

	     cbk = PC_register_proc(pp, i);
	     if (_PC_debug)
	        {fprintf(_PC_diag, "I/O interrupt: %d\n\n", cbk);
		 fflush(_PC_diag);};};};

    SFREE(args[argc]);
    SFREE(args);

    if (_PC_debug)
       {fprintf(_PC_diag, "   ------ End of Setup ------\n\n");
	fflush(_PC_diag);};

#endif

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_REGISTER_PROC - register a child process */

static int PC_register_proc(pp, i)
   PROCESS *pp;
   int i;
   {int n, nx;
    PC_poll_desc pd;

    n  = PC_procs.n;
    nx = PC_procs.nx;
    if (PC_procs.p == NULL)
       {nx = i + 8;
	PC_procs.p  = FMAKE_N(PROCESS *, nx,
                      "PC_REGISTER_PROC:procsp");
	PC_procs.m  = FMAKE_N(PC_message, nx,
                      "PC_REGISTER_PROC:procsm");
	PC_procs.fd = FMAKE_N(PC_poll_desc, nx,
                      "PC_REGISTER_PROC:procsfd");};

    if (i >= nx)
       {nx = i + 8;
	REMAKE_N(PC_procs.p, PROCESS *, nx);
	REMAKE_N(PC_procs.m, PC_message, nx);
	REMAKE_N(PC_procs.fd, PC_poll_desc, nx);};

    pd.fd     = pp->in;
    pd.events = POLLIN | POLLPRI;

    PC_procs.p[i]  = pp;
    PC_procs.fd[i] = pd;

    PC_procs.n  = max(n, i) + 1;
    PC_procs.nx = nx;

    PC_unblock(pp);

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_PUSH_MESSAGE - register a message for a node */

int PC_push_message(msg, i, ni, type, bf)
   PC_message *msg;
   int i, ni;
   char *type, *bf;
   {int n, nx;

    if (msg == NULL)
       return(FALSE);

    n   = msg->n;
    nx  = msg->nx;
    if (msg->msg == NULL)
       {nx = i + 8;
	msg->ni   = FMAKE_N(int, nx, "PC_PUSH_MESSAGE:ni");
	msg->type = FMAKE_N(char *, nx, "PC_PUSH_MESSAGE:type");
	msg->msg  = FMAKE_N(char *, nx, "PC_PUSH_MESSAGE:msg");};

    if (i >= nx)
       {nx = i + 8;
	REMAKE_N(msg->ni,   int, nx);
	REMAKE_N(msg->type, char *, nx);
	REMAKE_N(msg->msg,  char *, nx);};

    msg->ni[n]   = ni;
    msg->type[n] = SC_strsavef(type, "char*:PC_PUSH_MESSAGE:type");
    msg->msg[n]  = bf;

    msg->n  = n + 1;
    msg->nx = nx;

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PC_POP_MESSAGE - pop a message off the queue */

void PC_pop_message(i)
   int i;
   {int j, n;
    int *nis;
    char **msg, **typ;
    
    msg = MESSAGES(i);
    typ = MESSAGE_TYPES(i);
    nis = MESSAGE_LENGTHS(i);

    n = N_MESSAGES(i)--;
    SFREE(msg[0]);
    SFREE(typ[0]);
    for (j = 0; j < n; j++)
        {msg[j] = msg[j+1];
	 typ[j] = typ[j+1];
	 nis[j] = nis[j+1];};

    msg[n] = NULL;
    typ[n] = NULL;
    nis[n] = 0;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

