/*
 * PPC.H - header for Portable Process Control system
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#ifndef PCK_PPC

#include "cpyright.h"

#define PCK_PPC

/* Think C compiler defines THINK_C; CodeWarrior defines __MWERKS__ */
#ifdef THINK_C
# include "pdb.h"
#else
# ifdef __MWERKS__
#  include "pdb.h"
# else
#  include <pdb.h>
# endif
#endif

#ifdef AIX
# include <sys/select.h>
# ifdef HAVE_SOCKETS_P
#  define BSD_TERMINAL
#  include <sys/ioctl.h>
#  undef _IO
# else
#  define SYSV_TERMINAL
# endif
# define TERMINAL_HANDLING_DEFINED
# define BAD_FLUSH_SEMANTICS
#endif

#ifdef HPUX
# define LATCH_AFTER_RECONNECT
#endif

#ifdef SOLARIS
# include <sys/ttold.h>
# define SYSV_TERMINAL
# define TERMINAL_HANDLING_DEFINED
# define BAD_FLUSH_SEMANTICS
# define NO_LATCH_PTYS
#endif

#ifdef SGI
# define SYSV_CONTROL_OPT_B
# define TERMINAL_CONTROL_DEFINED
#endif

#ifdef HAVE_GNU_LIBC_5
# include <bsd/sgtty.h>
# include <linux/time.h>
# define TANDEM    0
# define ALLDELAY  0
#endif

#ifdef UNICOS
# define BAD_FLUSH_SEMANTICS
# define NO_LATCH_PTYS
#endif

#ifdef ULTRIX
# define NO_LATCH_PTYS
#endif

#ifdef OPENNT     
#undef SYSV
#endif

#ifdef HAVE_STREAMS_P
# include <stropts.h>
# include <poll.h>
# define PC_SIGIO SIGPOLL
#endif

#ifdef HAVE_SELECT_P
# ifndef PARAGON
#  define KERNEL
# endif
# include <sys/time.h>
# undef KERNEL
# define PC_SIGIO SIGIO
#endif

#ifdef BSD
# include <sys/ioctl.h>

/* X11 includes <sys/resource.h> - sigh */
# ifndef _XLIB_H_
#  include <sys/resource.h>
# endif
# include <sys/wait.h>
#endif

#ifdef SYSV
# ifdef HAVE_GNU_LIBC_6
#  include <termio.h>
# else
#  include <sys/termio.h>
# endif

/* OSF defines BSD in termio.h unfortunately for us */
# undef BSD

#endif

#ifdef UNIX
# include <fcntl.h>
# include <signal.h>
# include <errno.h>
#endif

#ifdef HAVE_SOCKETS_P
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
#endif

#define IN  0
#define OUT 1

#define RUNNING      0
#define STOPPED      1
#define CHANGED      2
#define EXITED       4
#define COREDUMPED   8
#define SIGNALED    16

#define PC_CHILD     100
#define PC_PARENT    101
#define PC_LOCAL     102
#define PC_REMOTE    103
#define PC_PARALLEL  104

#define USE_PTYS     50
#define USE_SOCKETS  51
#define USE_PIPES    52

#define PC_NDELAY    FNDELAY
#define PC_APPEND    FAPPEND
#define PC_SYNC      FSYNC
#define PC_LINE      1000

#define SIZE_MASK  0x3FFF
#define SIZE_BUF   0x4000

#ifndef SIGCHLD
# define SIGCHLD SIGCLD
#endif

#ifndef PC_SIGIO
# define PC_SIGIO -1
#endif

/*--------------------------------------------------------------------------*/

/*                          CLIENT/SERVER SUPPORT                           */

/*--------------------------------------------------------------------------*/

#define GET_PORT        1
#define GET_CONNECTION  2

/*--------------------------------------------------------------------------*/

/*                           MESSAGE PASSING SUPPORT                        */

/*--------------------------------------------------------------------------*/

#ifdef PARALLEL_HOST        
# define PC_open_node _PC_open_node
#else
# define PC_open_node _PC_open_proc
#endif

#define PC_GROUP_LEADER -999

#define PC_MATCH_TYPE  -1001
#define PC_MATCH_TAG   -1002
#define PC_MATCH_NODE  -1003
#define PC_MATCH_PID   -1004
#define PC_BLOCK_STATE -1005
#define PC_BUFFER_SIZE -1006

#define PC_READ_MSG     1
#define PC_WRITE_MSG    2

#define PC_TYPE_MATCH   0x40000000
#define PC_CLASS_MATCH  0x20000000
#define PC_TYPE_MASK    0x1FFF0000
#define PC_TAG_MASK     0x0000FFFF

/*--------------------------------------------------------------------------*/

/*                     INTERRUPT DRIVEN I/O HANDLING                        */

/*--------------------------------------------------------------------------*/

#ifdef FASYNC
# define PC_ASYNC     FASYNC
#else
# define PC_ASYNC     -1
#endif

#ifndef HAVE_STREAMS_P
# ifndef POLLIN
#  define POLLIN    001
# endif
# ifndef POLLPRI
#  define POLLPRI   002
# endif
# ifndef POLLERR
#  define POLLERR   020
# endif
# ifndef POLLNVAL
#  define POLLNVAL  040
# endif
# ifdef FASYNC
#  define HAVE_INTERRUPTS_P
# endif
#else
# define HAVE_INTERRUPTS_P
# define PC_poll poll
#endif

/*--------------------------------------------------------------------------*/

/*                                PTY HANDLING                              */

/*--------------------------------------------------------------------------*/

#ifdef SGI
# define PC_MASTER_PTY_NAME      "ptc"
# define PC_MASTER_PTY_LETTERS   NULL
# define PC_MASTER_PTY_DIGITS    "1234"
# define PC_SLAVE_PTY_NAME       "ttyp"
# define PC_SLAVE_PTY_LETTERS    "dfmq"
# define PC_SLAVE_PTY_DIGITS     "0123456789"
#endif

#ifdef UNICOS
# define PC_MASTER_PTY_NAME      "tty"
# define PC_MASTER_PTY_LETTERS   "p"
# define PC_MASTER_PTY_DIGITS    "0123456789"
# define PC_SLAVE_PTY_NAME       "tty"
# define PC_SLAVE_PTY_LETTERS    "p"
# define PC_SLAVE_PTY_DIGITS     "0123456789"
#endif

#ifndef PC_MASTER_PTY_NAME
# define PC_MASTER_PTY_NAME      "pty"
# define PC_MASTER_PTY_LETTERS   "pqrstuvwxyz"
# define PC_MASTER_PTY_DIGITS    "0123456789abcdef"
# define PC_SLAVE_PTY_NAME       "tty"
# define PC_SLAVE_PTY_LETTERS    "pqrstuvwxyz"
# define PC_SLAVE_PTY_DIGITS     "0123456789abcdef"
#endif

/*--------------------------------------------------------------------------*/

/*                            TERMINAL HANDLING                             */

/*--------------------------------------------------------------------------*/

#ifndef TERMINAL_HANDLING_DEFINED
# ifdef SYSV
#  define SYSV_TERMINAL
# endif
# ifdef BSD
#  define BSD_TERMINAL
# endif
#endif

#ifndef TERMINAL_CONTROL_DEFINED
# define SYSV_CONTROL_OPT_A
#endif

#ifdef SYSV_CONTROL_OPT_B
# undef TIOCGETP
# define TIOCGETP TCGETA
# undef TIOCSETP
# define TIOCSETP TCSETA
# undef TIOCSETN
# define TIOCSETN TIOCSETP
#endif

#ifdef SYSV_CONTROL_OPT_A
# ifndef TIOCGETP
#  define TIOCGETP TCGETA
# endif
# ifndef TIOCSETP
#  define TIOCSETP TCSETA
# endif
# ifndef TIOCSETN
#  define TIOCSETN TIOCSETP
# endif
#endif

#ifdef SYSV_TERMINAL
# define TERMINAL struct termio
#endif

#ifdef BSD_TERMINAL
# define TERMINAL struct sgttyb
#endif

#ifndef TERMINAL
# define TERMINAL int
#endif

/*--------------------------------------------------------------------------*/

/*                               WAIT HANDLING                              */

/*--------------------------------------------------------------------------*/

#ifndef WAIT_HANDLING_DEFINED
# ifdef SYSV
#  define SYSV_WAIT
# endif
# ifdef BSD
#  define BSD_WAIT
# endif
#endif

#ifdef SYSV_WAIT
# ifndef WAITTYPE
#  define WAITTYPE int
# endif
# ifndef WIFSTOPPED
#  define WIFSTOPPED(w)  ((w&0377) == 0177)
# endif
# ifndef WIFSIGNALED
#  define WIFSIGNALED(w) ((w&0377) != 0177 && (w&~0377) == 0)
# endif
# ifndef WIFEXITED
#  define WIFEXITED(w)   ((w&0377) == 0)
# endif
# ifndef WRETCODE
#  define WRETCODE(w)     (w >> 8)
# endif
# ifndef WSTOPSIG
#  define WSTOPSIG(w)     (w >> 8)
# endif
# ifndef WCOREDUMP
#  define WCOREDUMP(w)   ((w&0200) != 0)
# endif
# ifndef WTERMSIG
#  define WTERMSIG(w)     (w & 0377)
# endif
# ifndef WAITING
#  define WAITING(x) wait(&x)
# endif
#endif

#ifdef BSD_WAIT
# ifndef WAITTYPE
#  define WAITTYPE union wait
# endif
# ifdef HAVE_GNU_LIBC_5
#  ifndef WRETCODE
#   define WRETCODE(x)  ((x).w_retcode)
#  endif
# else
#  ifndef WIFSTOPPED
#   define WIFSTOPPED(x)  (((x).w_status & 0377) == 0177)
#  endif
#  ifndef WIFSIGNALED
#   define WIFSIGNALED(x) (((x).w_status & 0377) != 0177 && ((x).w_status & ~0377) == 0)
#  endif
#  ifndef WIFEXITED
#   define WIFEXITED(x)   (((x).w_status & 0377) == 0)
#  endif
#  ifndef WRETCODE
#   define WRETCODE(x)  ((x).w_T.w_Retcode)
#  endif
#  ifndef WCOREDUMP
#   define WCOREDUMP(x) ((x).w_T.w_Coredump)
#  endif
#  ifndef WTERMSIG
#   define WTERMSIG(x)  ((x).w_T.w_Termsig)
#  endif
#  ifndef WSTOPSIG
#   define WSTOPSIG(x)  ((x).w_S.w_Stopsig)
#  endif
# endif
# ifndef WAITING
#  define WAITING(x) wait3(&x, WNOHANG | WUNTRACED, 0)
# endif
#endif

/*--------------------------------------------------------------------------*/

/*                    REMOTE FILE/PROCESS I/O HANDLING                      */

/*--------------------------------------------------------------------------*/

#define PC_MIN_CMMNDS   'a'
#define PC_FOPEN        'b'
#define PC_FSETVBUF     'c'
#define PC_FCLOSE       'd'
#define PC_FFLUSH       'e'
#define PC_FTELL        'f'
#define PC_FSEEK        'g'
#define PC_FREAD        'h'
#define PC_FWRITE       'i'
#define PC_FPUTS        'j'
#define PC_FGETS        'k'
#define PC_FGETC        'l'
#define PC_FUNGETC      'm'
#define PC_FEXIT        'n'
#define PC_NUM_NODES    'o'
#define PC_MAX_CMMNDS   'p'

/*--------------------------------------------------------------------------*/

/*                             PROCEDURAL MACROS                            */

/*--------------------------------------------------------------------------*/

#define PC_BINARY_MODEP(x)  (strchr(&((x)[1]), 'b') != NULL)
#define PC_OTHER_HOSTP(x)   (strchr((x), ':') != NULL)
#define PC_OTHER_CPUP(x)    (strchr((x), '@') != NULL)

#define PC_ERR_TRAP(val)                                                     \
  {PC_err[0] = '\0';                                                         \
   if (setjmp(_PC_err_state))                                                \
      return(val);}

#define PC_flush(pp)                                                         \
   ((((pp) != NULL) && ((pp)->flush != NULL)) ?                              \
   (pp)->flush(pp) :                                                         \
   0)

#define PC_close(pp)                                                         \
   {PROCESS *x;                                                              \
    x = pp;                                                                  \
    if ((x != NULL) && (x->close != NULL))                                   \
       x->close(x);}

#define PC_status(pp) ((pp)->statusp(pp))

#define PC_read(ptr, type, nitems, pp)                                       \
   ((((pp) != NULL) && ((pp)->read != NULL)) ?                               \
    (pp)->read(ptr, type, nitems, pp) : -1)

#define PC_write(ptr, type, nitems, pp)                                      \
   ((((pp) != NULL) && ((pp)->write != NULL)) ?                              \
    (pp)->write(ptr, type, nitems, pp) : -1)

/*--------------------------------------------------------------------------*/

/*                             TYPEDEFS AND STRUCTS                         */

/*--------------------------------------------------------------------------*/

typedef struct s_PC_pending_msg PC_pending_msg;
typedef struct s_PROCESS PROCESS;
typedef struct s_PC_message PC_message;
typedef struct s_TERMINAL_STATE TERMINAL_STATE;

struct s_PC_pending_msg
   {char *bf;
    char *type;
    size_t nitems;
    byte *vr;
    int req;
    int oper;
    PC_pending_msg *nxt;};

struct s_PROCESS
   {int type;            /* process type (PC_LOCAL, PC_REMOTE, PC_PARALLEL) */
    int id;
    int in;
    int data;                           /* socket for separate data channel */
    int out;
    int blocking;
    int rcpu;                                       /* requested CPU number */
    int acpu;                                        /* assigned CPU number */
    int status;
    int reason;
    int line_mode;
    int line_sep;
    int data_type;                             /* data type (BINARY, ASCII) */
    int medium;                         /* USE_PTYS, USE_SOCKETS, USE_PIPES */
    char *spty;
    unsigned char *in_ring;
    unsigned int ib_in;
    unsigned int ob_in;
    char *data_buffer;
    unsigned long nb_data;
    unsigned long nx_data;
    PDBfile *vif;

    int n_pending;
    PC_pending_msg *pending;

    int SC_DECLARE((*release), (PROCESS *pp));
    int SC_DECLARE((*exec), (PROCESS *cp, char **argv, char **env,
			  char *mode));
    int SC_DECLARE((*statusp), (PROCESS *pp));
    int SC_DECLARE((*close), (PROCESS *pp));
    int SC_DECLARE((*flush), (PROCESS *pp));
    int SC_DECLARE((*read),  (byte *ptr, char *type, size_t nitems,
			   PROCESS *pp));
    int SC_DECLARE((*write), (byte *ptr, char *type, size_t nitems,
			   PROCESS *pp));
    int SC_DECLARE((*printf), (PROCESS *pp, char *buffer));
    int SC_DECLARE((*gets), (char *bf, int len, PROCESS *pp));
    int SC_DECLARE((*in_ready), (PROCESS *pp));
    int SC_DECLARE((*setup), (PROCESS *pp, int child));};

struct s_PC_message
   {int n;
    int nx;
    int *ni;
    char **type;
    char **msg;};

struct s_TERMINAL_STATE
   {int fd;
    int full_info;
    TERMINAL term;

#ifdef BSD
    struct tchars tch;
    struct ltchars ltc;
    int localmode;
    int discipline;
    struct winsize window_size;
#endif

   };    


/* put a STREAMS like interface together to smooth over the
 * differences between various multiplex I/O functionalities
 */

#ifndef HAVE_STREAMS_P

# ifndef SOLARIS

struct pollfd
   {int fd;
    short events;
    short revents;};

# endif

#endif

typedef struct pollfd PC_poll_desc;

#ifdef __cplusplus
extern "C" {
#endif

#ifdef OPENNT
#define SYSV
#endif

/*--------------------------------------------------------------------------*/

/*                            VARIABLE DECLARATIONS                         */

/*--------------------------------------------------------------------------*/

extern jmp_buf
 _PC_err_state;

extern TERMINAL_STATE
 *PC_original_terminal_state;

extern PROCESS
 *PC_terminal;

extern char
 PC_err[];

extern int
 _PC_current_flushed_process,
 _PC_debug,
 _PC_n_processes,
 PC_io_interrupts_on;

extern FILE
 *_PC_diag;

extern PROCESS
 **_PC_processes;

/*--------------------------------------------------------------------------*/

/*                            FUNCTION DECLARATIONS                         */

/*--------------------------------------------------------------------------*/

#ifdef SGI

extern char
 SC_DECLARE(*_getpty, 
            (int *pfd, int mode, mode_t perm, int flag));

#endif

extern PROCESS
 SC_DECLARE(*PC_mk_process, (char **argv, char *mode, int type));


/* PCBIN.C declarations */

extern long
 SC_DECLARE(_PC_pr_tell, (FILE *fp));

extern int
 SC_DECLARE(PC_recv_formats, (PROCESS *pp)),
 SC_DECLARE(PC_send_formats, (byte)),
 SC_DECLARE(_PC_pr_flush, (FILE *fp)),
 SC_DECLARE(_PC_pr_seek, (FILE *stream, long offset, int whence)),
 SC_DECLARE(_PC_bin_read, 
            (byte *ptr, char *type, size_t nitems, PROCESS *pp)),
 SC_DECLARE(_PC_bin_write,
         (byte *ptr, char *type, size_t nitems, PROCESS *pp));

extern size_t
 SC_DECLARE(_PC_pr_read_a,
         (byte *ptr, size_t size, size_t nitems, PROCESS *pp)),
 SC_DECLARE(_PC_pr_read_b,
         (byte *ptr, size_t size, size_t nitems, PROCESS *pp)),
 SC_DECLARE(_PC_pr_write,
         (byte *ptr, size_t size, size_t nitems, PROCESS *pp));


/* PCFIO.C declarations */

extern int
 SC_DECLARE(PC_file_access, (int log)),
 SC_DECLARE(PC_rsetvbuf, 
            (FILE *stream, char *bf, int type, size_t size)),
 SC_DECLARE(PC_rclose, (FILE *stream)),
 SC_DECLARE(PC_rflush, (FILE *stream)),
 SC_DECLARE(PC_rseek, (FILE *stream, long addr, int offset)),
 SC_DECLARE(PC_rputs, (char *s, FILE *stream)),
 SC_DECLARE(PC_rgetc, (FILE *stream)),
 SC_DECLARE(PC_rungetc, (int c, FILE *stream)),
 SC_DECLARE(PC_exit_all, (byte));

extern size_t
 SC_DECLARE(PC_rread, 
            (char *s, size_t nbi, size_t ni, FILE *stream)),
 SC_DECLARE(PC_rwrite, 
            (char *s, size_t nbi, size_t ni, FILE *stream));

extern long
 SC_DECLARE(PC_rtell, (FILE *stream));

extern FILE
 *SC_DECLARE(PC_ropen, (char *name, char *mode));

extern char
 *SC_DECLARE(PC_rgets, (char *s, int nc, FILE *stream));


/* PCPIO.C declarations */

extern int
 SC_DECLARE(PC_process_access, (char **argv, char *mode)),
 SC_DECLARE(PC_push_message,
	 (PC_message *msg, int i, int ni, char *type, char *bf));

extern void
 SC_DECLARE(PC_pop_message, (int i));


/* PPC.C declarations */

extern PROCESS
 SC_DECLARE(*PC_open, (char **argv, char **envp, char *mode));

extern void
 SC_DECLARE(_PC_manage_process, (PROCESS *pp)),
 SC_DECLARE(_PC_delete_process, (PROCESS *pp)),
 SC_DECLARE(_PC_rl_process, (PROCESS *pp)),
 SC_DECLARE(PC_signal_handler, (int signo));

extern int
 SC_DECLARE(_PC_buffer_in, (char *bf, int n, PROCESS *pp)),
 SC_DECLARE(_PC_buffer_out, 
            (char *bf, PROCESS *pp, int nb, int binf)),
 SC_DECLARE(PC_buffer_data_in, (PROCESS *pp)),
 SC_DECLARE(PC_buffer_data_out, (PROCESS *pp, char *bf,
			      int nbi, int block_state)),
 SC_DECLARE(PC_printf, (PROCESS *pp, char *fmt, ...));

extern char
 SC_DECLARE(*PC_gets, (char *bf, int len, PROCESS *pp));


/* PPCAUX.C declarations */

extern char
 SC_DECLARE(**PC_string_to_args, (char *s, char *delim));

extern void
 SC_DECLARE(PC_error, (char *fmt, ...)),
 SC_DECLARE(PC_rl_io_callback, (int fd)),
 SC_DECLARE(_PC_rl_io_callback_lists, (byte)),
 SC_DECLARE(PC_catch_io_interrupts, (int flag)),
 SC_DECLARE(PC_alarm, (int to, PFByte fnc));

extern int
 SC_DECLARE(PC_set_attr, (PROCESS *pp, int attr, int val)),
 SC_DECLARE(PC_set_fd_attr, (int fd, int i, int state)),
 SC_DECLARE(PC_set_io_attr, (int fd, int attr, int state)),
 SC_DECLARE(PC_echo_on_file, (FILE *fp)),
 SC_DECLARE(PC_echo_on_fd, (int fd)),
 SC_DECLARE(PC_echo_off_file, (FILE *fp)),
 SC_DECLARE(PC_echo_off_fd, (int fd)),
 SC_DECLARE(PC_unblock, (PROCESS *pp)),
 SC_DECLARE(PC_unblock_file, (FILE *fp)),
 SC_DECLARE(PC_unblock_fd, (int fd)),
 SC_DECLARE(PC_block, (PROCESS *pp)),
 SC_DECLARE(PC_block_file, (FILE *fp)),
 SC_DECLARE(PC_block_fd, (int fd)),
 SC_DECLARE(PC_io_callback_file, (FILE *fp, PFVoid fnc)),
 SC_DECLARE(PC_io_callback_fd, (int fd, PFVoid fnc)),
 SC_DECLARE(PC_poll_descriptors, (int to)),
 SC_DECLARE(PC_init_server, (int step, int closep)),
 SC_DECLARE(PC_init_client, (char *host, int port)),
 SC_DECLARE(PC_io_connect, (int flag));

#ifndef HAVE_STREAMS_P

extern int
 SC_DECLARE(PC_poll, 
            (PC_poll_desc *fds, long nfds, int timeout));

#endif


/* PCPARC.C declarations */

extern int
 SC_DECLARE(PC_get_number_processors, (void)),
 SC_DECLARE(PC_get_processor_number, (void)),
 SC_DECLARE(PC_open_group, (char **argv, int *pn));

extern long
 SC_DECLARE(PC_wait, (PROCESS *pp)),
 SC_DECLARE(PC_in, 
            (byte *bf, char *type, size_t ni, PROCESS *pp, int *filt)),
 SC_DECLARE(PC_out, 
            (byte *bf, char *type, size_t ni, PROCESS *pp, int *filt));

extern void
 SC_DECLARE(PC_close_member, (PROCESS *pp)),
 SC_DECLARE(PC_sync_execution, (void));

extern PROCESS
 *SC_DECLARE(PC_open_member, (char **argv, int *pnn));


/* PCTMOD.C declarations */

extern int
 SC_DECLARE(PC_set_term_state, (TERMINAL_STATE *t, int trmfd)),
 SC_DECLARE(PC_set_raw_state, (int fd, int trap)),
 SC_DECLARE(PC_set_cooked_state, (int fd, int trap));

extern TERMINAL_STATE
 SC_DECLARE(*PC_get_term_state, (int fd));

extern void
 SC_DECLARE(PC_print_term_state, (FILE *fp, int fd));

#ifdef __cplusplus
}
#endif

#endif

