/*
 * SHPRNT.C - C and Scheme Primitive Output Routines
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

object
 *SS_histdev,
 *SS_outdev;

char
 SS_prompt[] = "Scheme-> ",
 SS_ans_prompt[] = "(): ";

static char
 *_sp_bf;

int
 Disp_flag = FALSE;

PFVoid
 SS_pr_ch_out;

static void
 SC_DECLARE(_SS_xprintf, (object *str, object *argl));

static int
 SC_DECLARE(_SS_push_chars, (FILE *fp, char *fmt, ...));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_PRINT - takes an object, produces a printable representation, and
 *           - prints it
 */

object *_SS_print(obj, begin, end, strm)
   object *obj;
   char *begin, *end;
   object *strm;
   {FILE *str;

    str = SS_OUTSTREAM(strm);
    PRINT(str, "%s", begin);

    SS_OBJECT_PRINT(obj, strm);

    PRINT(str, "%s", end);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

/* DPRINT - an easy to use debug time object printer */

void dprint(obj)
   object *obj;
   {_SS_print(obj, "", "\n", SS_outdev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_WRITE - invoke at Scheme level the C level print function */

object *SS_write(obj)
   object *obj;
   {Register object *str;

    str = SS_cdr(obj);
    obj = SS_car(obj);
    if (SS_nullobjp(str))
       _SS_print(obj, "", "", SS_outdev);
    else if (SS_consp(str))
       {str = SS_car(str);
        if (SS_outportp(str))
           _SS_print(obj, "", "", str);}
    else
       SS_error("LAST ARGUMENT NOT OUTPUT-PORT - WRITE", str);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SPRINTF - a C type sprintf for SCHEME */

object *SS_sprintf(argl)
   object *argl;
   {PFfprintf pr;

    pr = putln;
    putln = (PFfprintf) _SS_push_chars;

    _SS_xprintf(SS_outdev, argl);

    putln = pr;

    return(SS_mk_string(_sp_bf));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_FPRINTF - a C type fprintf for SCHEME */

object *SS_fprintf(argl)
   object *argl;
   {object *str;

    str  = SS_car(argl);
    argl = SS_cdr(argl);
    if (SS_nullobjp(str))
       str = SS_outdev;

    _SS_xprintf(str, argl);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_XPRINTF - interpret C style format specifcation and get values
 *             - from arg list to fulfill them
 *             - return a string with the result
 */

static void _SS_xprintf(str, argl)
   object *str;
   object *argl;
   {Register object *obj, *format;
    char forms[MAXLINE], *fmt, *le, *lb, local[MAXLINE], *pt;
    int c;
    FILE *stream;

    if (!SS_outportp(str))
       SS_error("BAD PORT - _SS_XPRINTF", str);
    stream = SS_OUTSTREAM(str);

    format = SS_car(argl);
    if (!SS_stringp(format))
       SS_error("BAD FORMAT - _SS_XPRINTF", format);
    strcpy(forms, SS_STRING_TEXT(format));
    fmt = forms;

    _sp_bf = NULL;
    while (TRUE)
       {for (pt = local; (((c = *fmt++) != '%') && (c != '\0')); pt++)
            {if (c == '\\')
                {switch (c = *fmt++)
                    {case 't' : *pt = '\t';
                                break;
                     case 'r' : *pt = '\r';
                                break;
                     case 'n' : *pt = '\n';
                                break;
                     default  : *pt = c;
                                break;};}
             else
                *pt = c;};
        *pt = '\0';
        PRINT(stream, local);

        if (c == '\0')
           break;

/* copy from the % to the type specifier to get the format descriptor for
 * this item
 */
        le = strpbrk(fmt, "sdouxXfeEgGc%");
        local[0] = '%';
        for (lb = &local[1]; le != fmt; *lb++ = *fmt++);
        fmt++;
        *lb++ = *le;
        *lb = '\0';

/* get the object now */
        if (*le != '%')
           {if (SS_nullobjp(argl))
               return;
            argl = SS_cdr(argl);
            if (SS_nullobjp(argl))
               return;
            obj = SS_car(argl);};

/* jump on the type spec to pull the correct arg type off the stack */
        switch (*le)
           {case 's' :
                 Disp_flag = TRUE;
                 _SS_print(obj, "", "", str);
                 Disp_flag = FALSE;
                 break;

            case 'c' :
                 if (SS_integerp(obj))
                    PRINT(stream, local, SS_INTEGER_VALUE(obj));
                 else
                    {Disp_flag = TRUE;
                     _SS_print(obj, "", "", str);
                     Disp_flag = FALSE;};
                 break;

            case 'i' :
            case 'X' :
            case 'x' :
            case 'o' :
            case 'd' :
            case 'u' :
                 if (!SS_integerp(obj))
                    SS_error("NON-INTEGER FOR INTEGER FIELD - _SS_XPRINTF",
                             obj);
                 PRINT(stream, local, SS_INTEGER_VALUE(obj));
                 break;

            case 'f' : 
            case 'e' :
            case 'E' : 
            case 'g' : 
            case 'G' :
                 if (!SS_floatp(obj))
                    SS_error("NON-FLOAT FOR REAL FIELD - _SS_XPRINTF",
                             obj);
                 PRINT(stream, local, SS_FLOAT_VALUE(obj));
                 break;
            case '%' :
                 PRINT(stream, "%%");
                 break;};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_PUSH_CHARS - do an sprintf on the tailing arg and push
 *                - them onto the first arg resizing if neceassary
 */

#ifdef PCC

static int _SS_push_chars(fp, fmt, va_alist)
   FILE *fp;
   char *fmt;
   va_dcl

#endif

#ifdef ANSI

static int _SS_push_chars(FILE *fp, char *fmt, ...)

#endif

   {char bf[MAX_LEX_BUFFER];
    int ns, nb;

    if (fp != NULL)
       {SC_VA_START(fmt);
	SC_VSPRINTF(bf, fmt);
	SC_VA_END;

	if (_sp_bf == NULL)
 	   _sp_bf = FMAKE_N(char, MAXLINE, "_SS_PUSH_CHARS:_sp_bf");

	ns = strlen(_sp_bf);
	nb = strlen(bf);
	if ((ns + nb + 2) >= SC_arrlen(_sp_bf))
	   REMAKE_N(_sp_bf, char, ns+nb+MAXLINE);

	strcat(_sp_bf, bf);};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_DISPLAY - the human readable print function in Scheme */

object *SS_display(obj)
   object *obj;
   {Disp_flag = TRUE;
    SS_write(obj);
    Disp_flag = FALSE;
    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PRINT_TOGGLE - toggle printing of values in Scheme */

object *SS_print_toggle()
   {SS_print_flag = !SS_print_flag;
    if (SS_print_flag)
        return(SS_t);
    else
        return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_STATS_TOGGLE - toggle printing of statistics in Scheme */

object *SS_stats_toggle()
   {SS_stat_flag = !SS_stat_flag;
    if (SS_stat_flag)
        return(SS_t);
    else
        return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_TRANS_ON - turn on a transcript of the Scheme session */

object *SS_trans_on(obj)
   object *obj;
   {FILE *str;
    Register char *s;

    if (!SS_nullobjp(SS_histdev))
       SS_error("TRANSCRIPT ALREADY ACTIVE - TRANSCRIPT-ON", obj);

    if (SS_stringp(obj))
       s = SS_STRING_TEXT(obj);
    else if (SS_variablep(obj))
       s = SS_VARIABLE_NAME(obj);
    else
       SS_error("BAD STRING TO TRANSCRIPT-ON", obj);

    str = io_open(s, "a");
    if (str == NULL)
       SS_error("CAN'T OPEN FILE - TRANSCRIPT-ON", obj);

    SS_histdev = SS_mk_outport(str);
    SS_hist_flag = ALL;

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_TRANS_OFF - turn off the transcript of the Scheme session */

object *SS_trans_off()
   {if (SS_nullobjp(SS_histdev))
       return(SS_f);

    io_close(SS_OUTSTREAM(SS_histdev));

    SS_OBJECT_FREE(SS_histdev);
    SS_histdev   = SS_null;
    SS_hist_flag = FALSE;

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_OPN_OUT - open-output-file in Scheme */

object *SS_opn_out(obj)
   object *obj;
   {FILE *str;
    Register char *s;

    if (SS_stringp(obj))
       s = SS_STRING_TEXT(obj);
    else if (SS_variablep(obj))
       s = SS_VARIABLE_NAME(obj);
    else
       SS_error("BAD STRING TO OPEN-OUTPUT-FILE", obj);

    str = io_open(s, "w");
    if (str == NULL)
       SS_error("CAN'T OPEN FILE - OPEN-OUTPUT-FILE", obj);

    return(SS_mk_outport(str));}

/*--------------------------------------------------------------------------*/

#ifdef LARGE

/*--------------------------------------------------------------------------*/

/* SS_CALL_OF - call-with-output-file in Scheme */

object *SS_call_of(argl)
   object *argl;
   {FILE *str;
    char *s;
    object *obj, *old_outdev, *ret;

    obj = SS_car(argl);

    if (SS_stringp(obj))
       s = SS_STRING_TEXT(obj);
    else if (SS_variablep(obj))
       s = SS_VARIABLE_NAME(obj);
    else
       SS_error("BAD STRING TO OPEN-OUTPUT-FILE", obj);

    str = io_open(s, BINARY_MODE_W);
    if (str == NULL)
       SS_error("CAN'T OPEN FILE - OPEN-OUTPUT-FILE", obj);

    old_outdev = SS_outdev;
    SS_outdev  = SS_mk_outport(str);
    ret        = SS_exp_eval(SS_cdr(argl));
    SS_cls_out(SS_outdev);
    SS_outdev = old_outdev;

    return(ret);}

/*--------------------------------------------------------------------------*/

#endif

/*--------------------------------------------------------------------------*/

/* SS_CLS_OUT - close-output-file in Scheme */

object *SS_cls_out(obj)
   object *obj;
   {if (!SS_outportp(obj))
       SS_error("BAD OUTPUT-PORT TO CLOSE-OUTPUT-FILE", obj);

    io_close(SS_OUTSTREAM(obj));

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_OPORTP - output-port? at Scheme level */

object *SS_oportp(obj)
   object *obj;
   {return(SS_outportp(obj) ? SS_t : SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_WR_PROC - print a procedure */

void SS_wr_proc(obj, strm)
   object *obj, *strm;
   {FILE *str;
    char *s;

    str = SS_OUTSTREAM(strm);

    s = SS_PROCEDURE_NAME(obj);
    if (s != NULL)
       {switch (SS_PROCEDURE_TYPE(obj))
           {case SS_ESC_PROC : PRINT(str, "%s(cont=%d, stack=%d)",
                                     s,
                                     SS_ESCAPE_CONTINUATION(obj),
                                     SS_ESCAPE_STACK(obj));
                               break;
            default          : PRINT(str, "%s", s);
                               break;};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_BANNER - print the banner */

object *SS_banner(obj)
   object *obj;
   {char *s;
    static int override = 1;

    SS_args(obj,
	    SC_STRING_I, &s,
	    SC_INTEGER_I, &override,
	    0);

    if (override)
       {PRINT(stdout, "\n\t%s - %s\n", s, VERSION);
	override = 0;};

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_DESCRIBE - print out the documentation on the function */

object *SS_describe(obj)
   object *obj;
   {Register object *strm;

    strm = SS_cdr(obj);
    obj = SS_car(obj);
    if (SS_nullobjp(strm))
       strm = SS_outdev;
    else if (SS_consp(strm))
       {strm = SS_car(strm);
        if (!SS_outportp(strm))
           SS_error("LAST ARGUMENT NOT OUTPUT-PORT - DESCRIBE", strm);}
    else
       SS_error("LAST ARGUMENT NOT OUTPUT-PORT - DESCRIBE", strm);

    if (!SS_prim_des(strm, obj))
       SS_error("DESCRIPTIONS ONLY AVAIBLE FOR PROCEDURES", obj);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PRIM_DES - primitive part of describe facility */

int SS_prim_des(strm, obj)
   object *strm, *obj;
   {char *s;
    Register object *desc;
    FILE *str;

    str = SS_OUTSTREAM(strm);

    if (!SS_procedurep(obj))
       {if (SS_variablep(obj))
           {desc = SS_lk_var_val(obj, SS_Env);
            if (!SS_procedurep(desc))
               {PRINT(str, "     Variable: %s\n", SS_VARIABLE_NAME(obj));
                _SS_print(desc, "     Value: ", "\n", strm);
                return(TRUE);}
            else
               obj = desc;}
        else
           return(FALSE);};

    switch (SS_PROCEDURE_TYPE(obj))
       {case SS_PROC     :
             desc = SS_cdr(SS_COMPOUND_PROCEDURE_FUNCTION(obj));
             if (SS_stringp(SS_cadr(desc)))
                PRINT(str, "     %s", SS_STRING_TEXT(SS_cadr(desc)));
             else
                {desc = SS_mk_cons(obj, desc);
                 SS_MARK(desc);
                 PRINT(str, "     Compound procedure:\n");
                 SS_wr_lst(desc, strm);
                 SS_GC(desc);};
             break;

        case SS_MACRO    :
             desc = SS_cdr(SS_COMPOUND_PROCEDURE_FUNCTION(obj));
             if (SS_stringp(SS_cadr(desc)))
                PRINT(str, "     %s", SS_STRING_TEXT(SS_cadr(desc)));
             else
                {desc = SS_mk_cons(obj, desc);
                 SS_MARK(desc);
                 PRINT(str, "     Compound macro:\n");
                 SS_wr_lst(desc, strm);
                 SS_GC(desc);};
             break;

        case SS_PR_PROC  : 
        case SS_EE_MACRO :
        case SS_UR_MACRO :
        case SS_UE_MACRO :
             s = SS_PROCEDURE_DOC(obj);
             if (s != NULL)
                PRINT(str, "     %s", s);};

    PRINT(str, "\n");

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_APROPOS - search the hash table for information about the given
 *          - string
 */

object *SS_apropos(obj)
   object *obj;
   {Register object *strm;
    Register char *token;
    FILE *str;

/*    SC_banner("APROPOS"); */

    strm = SS_cdr(obj);
    obj = SS_car(obj);
    if (SS_nullobjp(strm))
       strm = SS_outdev;
    else if (SS_consp(strm))
       {strm = SS_car(strm);
        if (!SS_outportp(strm))
           SS_error("LAST ARGUMENT NOT OUTPUT-PORT - APROPOS", strm);}
    else
       SS_error("LAST ARGUMENT NOT OUTPUT-PORT - APROPOS", strm);

    str = SS_OUTSTREAM(strm);
    if (SS_stringp(obj))
       token = SS_STRING_TEXT(obj);
    else if (SS_variablep(obj))
       token = SS_VARIABLE_NAME(obj);
    else if (SS_procedurep(obj))
       token = SS_PROCEDURE_NAME(obj);
    else
       SS_error("BAD OBJECT - APROPOS", obj);

    PRINT(str, "\nApropos search string: %s\n\n", token);
    if (!SS_prim_apr(str, token, SS_symtab))
       PRINT(str, "No documentation on %s\n\n", token);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PRIM_APR - finds all commands which contain the substring s in their 
 *             - name or description
 */

int SS_prim_apr(str, s, tab)
   FILE *str;
   char *s;
   HASHTAB *tab;
   {hashel *np, **tb;
    object *op, *obj;
    Register int i, sz, flag, nlp, nmore;
    Register char c;
    char bf[10];
        
/* if the hash table has undocumented objects then leave */
    if (!tab->docp)
       return(FALSE);

    flag  = 0;
    nmore = 0;
    nlp   = SS_lines_page;
    if (nlp == 0)
       nlp = INT_MAX;
    sz = tab->size;
    tb = tab->table;
    for (i = 0; i < sz; i++)
        for (np = tb[i]; np != NULL; np = np->next)
            {if (nmore > nlp)
	        {PRINT(str, "More ... (n to stop)");
		 GETLN(bf, 10, stdin);
		 if (bf[0] == 'n')
		    return(flag);
		 nmore = 0;};
	     obj = (object *) np->def;
             if (SS_variablep(obj))
                {op = SS_VARIABLE_VALUE(obj);
                 if (SS_procedurep(op))
                    {c = SS_PROCEDURE_TYPE(op);
                     if ((c == SS_PR_PROC)  || (c == SS_UR_MACRO) ||
                         (c == SS_UE_MACRO) || (c == SS_EE_MACRO))
                        if ((SC_strstri(SS_PROCEDURE_DOC(op), s) != NULL) ||
                            (SC_strstri(SS_PROCEDURE_NAME(op), s) != NULL))
                           {PRINT(str, "%s :\n%s\n\n",
                                  SS_PROCEDURE_NAME(op), SS_PROCEDURE_DOC(op));
			    nmore = nmore + 3;
                            flag = 1;};}
                 else if (SC_strstri(np->name, s) != NULL)
                    {PRINT(str, "%s : Variable\n\n", s);
		     nmore = nmore + 2;
                     flag = 1;};};};

    return(flag);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_WR_LST - print a list */

void SS_wr_lst(obj, strm)
   object *obj;
   object *strm;
   {FILE *str;
    Register object *cd;

    str = SS_OUTSTREAM(strm);
    PRINT(str, "(");

    while (TRUE)
       {_SS_print(SS_car(obj), "", "", strm);

        if (SS_nullobjp(cd = SS_cdr(obj)))
           {PRINT(str, ")");
            break;}
        else if (SS_consp(cd))
           {obj = cd;
            PRINT(str, " ");}
        else
           {_SS_print(cd, " . ", ")", strm);
            break;};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_WR_ATM - print an atom or string */

void SS_wr_atm(obj, strm)
   object *obj, *strm;
   {FILE *str;

    str = SS_OUTSTREAM(strm);
    switch (SS_OBJECT_TYPE(obj))
       {case SC_INTEGER_I  : PRINT(str, "%ld", SS_INTEGER_VALUE(obj));
                             break;
        case SC_FLOAT_I    : PRINT(str, "%g", SS_FLOAT_VALUE(obj));
                             break;
#ifdef LARGE
        case CHAR_OBJ      : PRINT(str, "%c", SS_CHARACTER_VALUE(obj));
                             break;
#endif
        case SC_STRING_I   : if (Disp_flag)
                                PRINT(str, "%s", SS_STRING_TEXT(obj));
                             else
                                PRINT(str, "\"%s\"", SS_STRING_TEXT(obj));
                             break;
        case VARIABLE      : PRINT(str, "%s", SS_VARIABLE_NAME(obj));
                             break;
        case NULL_OBJ      : PRINT(str, "()");
                             break;
        case EOF_OBJ       :
        case BOOLEAN       : PRINT(str, "%s", SS_BOOLEAN_NAME(obj));
                             break;
        default            : PRINT(str, "UNKOWN OR NON-ATOMIC OBJECT TYPE");
                             break;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_NEWLINE - Scheme newline function */

object *SS_newline(strm)
   object *strm;
   {FILE *fp;
   
    if (SS_nullobjp(strm))
       {fp = SS_OUTSTREAM(SS_outdev);
        if (fp == stdout)
           PRINT(fp,  "\n");
        else
           PRINT(fp,  "\r\n");}
    else if (SS_consp(strm))
       {strm = SS_car(strm);
        if (SS_outportp(strm))
           {fp = SS_OUTSTREAM(strm);
            if (fp == stdout)
               PRINT(fp,  "\n");
            else
               PRINT(fp,  "\r\n");};}
    else
       SS_error("BAD OUTPUT PORT - NEWLINE", strm);

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_CURR_OP - current-output-port in Scheme */

object *SS_curr_op()
    {return(SS_outdev);}

/*--------------------------------------------------------------------------*/

#ifdef LARGE

/*--------------------------------------------------------------------------*/

/* SS_WR_CHR - write-char for Scheme */

object *SS_wr_chr(argl)
   object *argl;
   {Register object *str;

    str = SS_cdr(argl);
    if (!SS_charobjp(argl = SS_car(argl)))
       SS_error("BAD CHARACTER - WRITE-CHAR", argl);

    if (SS_nullobjp(str))
       _SS_print(argl, "", "", SS_outdev);
    else if (SS_outportp(str = SS_car(str)))
       _SS_print(argl, "", "", str);
    else
       SS_error("LAST ARGUMENT NOT OUTPUT-PORT - WRITE-CHAR", str);

    return(SS_f);}

/*--------------------------------------------------------------------------*/

#endif

/*--------------------------------------------------------------------------*/
