/*-----------------------------------------------------------------*-C-*---
 * File:    handc/cfg/gc/irc/makeheap.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.14
 * File mod date:    1997.11.29 23:10:46
 * System build:     v0.7.2, 97.12.21
 *
 * Purpose:          IRC heap initializer
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "irc.h"

#ifndef atracef
FILE *atracef = NULL;
#endif

static void out_of_memory( struct IRC_Heap *h, UINT_32 size )
{
  fprintf( stderr, 
	  "FATAL ERROR: allocation failed trying to grow heap by 0x%08x\n",
	  size );
  fprintf( stderr, 
	  "  (had already grabbed 0x%08x + 0x%08x bytes from system)\n",
	  h->allocedInChunks,
	  h->curAllocsInBig );
  abort();
}

void irc_std_alloc_chunk( struct IRC_Heap *h )
{
  h->moreSpacePtr = malloc( ALLOCATION_CHUNK_SIZE );
  if (!h->moreSpacePtr)
    out_of_memory( h, ALLOCATION_CHUNK_SIZE );
  h->allocedInChunks += ALLOCATION_CHUNK_SIZE;
  h->spaceLeft = ALLOCATION_CHUNK_SIZE;
}

IRC_Header *irc_std_alloc_big( struct IRC_Heap *h, UINT_32 size )
{
  IRC_Header *p;

  p = (IRC_Header *)malloc( size + sizeof(IRC_Header) );
  if (!p)
    out_of_memory( h, size );
  h->curAllocsInBig += size + sizeof(IRC_Header);
  return p;
}

static void initSizeClass( struct IRC_Gen *gen, 
			    IRC_SizeClass *sc, 
			    int isLargeObjectQ,
			    unsigned limitBytes );

IRC_Heap *IRC_newHeap( void )
{
  return irc_init_heap( MALLOC(IRC_Heap) );
}

IRC_Heap *irc_init_heap( IRC_Heap *h )
{
UINT_8 *wbt;
unsigned gen, l, r;

/*
if (!atracef)
  atracef = stdout;
   atracef = fopen( "atrace0.log", "w" );  
*/

    h->clientInfo = NULL;
    h->moreSpacePtr = NULL;
    h->spaceLeft = 0;
    h->allocedInChunks = 0;
    h->curAllocsInBig = 0;
    
    for (gen=0; gen<NUM_GENERATIONS; gen++)
    {
	irc_init_gen( h, 
		  gen,
		  &h->theGenerations[gen],
		  gen ? NULL : h->sizeClassesIndex );
    }
    
    /* initialize the write-barrier table */
    wbt = h->writeBarrierTable;

    h->alloc_chunk_meth = irc_std_alloc_chunk;
    h->alloc_big_meth = irc_std_alloc_big;
    
    /* initially, all generations have 0=white, 1=black */
    
    for (l=0; l<14; l++)         /* l represents lvalue gen/color bits */
	for (r=0; r<16; r++)     /* r represents rvalue gen/color bits */
	{
	char c = WB_NONE;
	
	    if ((l/2) > (r/2))
	    {
		/* ie, young ptr in old obj */
		c = WB_GENERATION;
	    }
	    else if (((l/2) == (r/2)) && ((l & 1) && !(r & 1)))
	    {
		/* ie, white ptr in blk obj */
		c = WB_COLOR;
	    }
	    *wbt++ = c;
	}
    for (l=14; l<16; l++)
      for (r=0; r<16; r++)
	{
#if 0
	  *wbt++ = WB_GLOBAL;		/* no write is valid for gen 7 */
#endif
	  *wbt++ = WB_NONE;   /* ignore writes into pstore */
	}
    return h;
}

static void initPtrList( struct IRC_PtrList *ptrlist )
{
    ptrlist->first = NULL;
    ptrlist->last = NULL;
}

void irc_init_gen( IRC_Heap *owner, 
		   unsigned genNum,
		   struct IRC_Gen *gen,
		   IRC_SizeClass **logicalSCs )
{
IRC_SizeClass *(temp[NUM_LOGICAL_SIZE_CLASSES]);
IRC_SizeClass **lsc, *psc;
int i;
UINT_32 lim;

    gen->heap = owner;
    gen->genNum = genNum;
    gen->whiteColorCode = 0;
    gen->blackColorCode = 1;
    gen->state = GSTATE_IDLE;
    
    initPtrList( &gen->regrayObjects );
    initPtrList( &gen->markedObjects );
    initPtrList( &gen->extraHeapPointers );
    
    lsc = logicalSCs ? logicalSCs : temp;
	
    psc = gen->theSizeClasses;    /* physical size classes */

    /* fine size class [0] is aliased to size class [1] */
    *lsc++ = psc;

    lim = 0;
    for (i=0; i<NUM_FINE_SIZE_CLASSES-1; i++)
    {
	*lsc++ = psc;
	lim += FINE_SIZE_CLASS_RESOLUTION;
	initSizeClass( gen, psc, 0, lim );
	psc++;
    }
    for (i=0; i<NUM_COARSE_SIZE_CLASSES; i++)
    {
	*lsc++ = psc;
	lim += COARSE_SIZE_CLASS_RESOLUTION;
	initSizeClass( gen, psc, 0, lim );
	psc++;
    }
    *lsc++ = psc;
    initSizeClass( gen, psc, 1, 0xFFFFFFFF - sizeof(IRC_Header) );

    /* initialize the traversal work table */
    
    /* initially, only need to do work on encountering
       a white object in our own generation
    */
    for (i=0; i<16; i++)
	gen->traversalWork[i] = 0;
    gen->traversalWork[genNum*2] = 1;
}

static void initSizeClass( struct IRC_Gen *gen, 
		    IRC_SizeClass *sc, 
		    int isLargeObjectQ,
		    unsigned limitBytes )
{
IRC_Header *m;
unsigned num;

    sc->gen = gen;
    sc->heap = gen->heap;
    sc->itemSize = limitBytes + sizeof(IRC_Header);

    if (sc->itemSize > 256)
    {
	num = 2048 / sc->itemSize;
	if (num == 0)
	    num = 1;
    }
    else
	num = 8;

    sc->chunkSize = sc->itemSize * num;
    sc->isLargeObject = isLargeObjectQ;
    
    m = &sc->marker;
    sc->white = sc->black = sc->gray = sc->free = m;

    m->next = m->prev = m;
    /* set the sizeClass of the marker to be NULL
       so we can easily recognize it (and cause a SEGV
       in case we accidently try to use the marker as a
       real object!)
    */
    m->sizeClass = NULL;
    m->flagBits = 0xF;
    sc->initFlagBits = 0;
}
