#include "header.h"

implementActionCallback(TestMenu)

TestMenu::TestMenu(Glyph* screen_) {
       my_glyph = screen_;
}

PolyGlyph* TestMenu::compose(WidgetKit &kit) {
      const LayoutKit& layout = *LayoutKit::instance();
      Menu *m = CreateMenu(kit);
      return layout.vbox(m, kit.inset_frame(
             layout.margin(my_glyph, 10.0) )
                        );
}

Menu* TestMenu::CreateMenu(WidgetKit &kit) {
       Menu *file = kit.pulldown();
         MenuItem *m11 = kit.menu_item(
                  kit.fancy_label("Copyright"));
         m11->action(new ActionCallback(TestMenu)
                      (this,&TestMenu::copyright)); 
         file->append_item(m11);

         MenuItem *m12 = kit.menu_item(
                  kit.fancy_label("Quit"));
         m12->action(new ActionCallback(TestMenu)
                           (this,&TestMenu::quit)); 
         file->append_item(m12);

       Menu *options = kit.pulldown();
         MenuItem *m21 = kit.menu_item(
                  kit.fancy_label("Preferences"));
         m21->action(new ActionCallback(TestMenu)
                    (this,&TestMenu::preferences));
         options->append_item(m21);

      Menu *mb = kit.menubar();
        MenuItem *m1 = kit.menubar_item(
                 kit.fancy_label("File"));
        MenuItem *m2 = kit.menubar_item(
                 kit.fancy_label("Options"));
        m1->menu(file);
        m2->menu(options);
        mb->append_item(m1);
        mb->append_item(m2);
     return mb;
}

void TestMenu::copyright() {
     cerr<<"TestMenu::copyright called\n";
}

void TestMenu::preferences() {
     cerr<<"TestMenu::preferences called\n";
}

void TestMenu::quit() {
     Session::instance()->quit();
}
