//  UColor.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __ucolor_h__
#define __ucolor_h__

#include <X11/Xlib.h>
#include "UBinArray.h"

class UDisplayCache
{
public:
				UDisplayCache (Display* display);
				~UDisplayCache();
	Display*		display;
	int			screen;
	Colormap		colormap;
	Visual*			visual;
	int			cellCount;
	UBinArray		cache;
};

class UColor
{
public:
				UColor (void);
				UColor (Display *display);
				UColor (const UColor& color);
	UColor& operator=	(const char *color);
	UColor& operator=	(const UColor& color);
	void			assign (unsigned short r, unsigned short g,
					unsigned short b);

	void			lighter (int damp=2);
	void			darker (int damp=1);

				~UColor ();
	inline unsigned long	getPixel() const { return pixel; }
	inline Display*		getDisplay () { return display; }
private:
	XColor*			allocateColor (UDisplayCache *dcache,
					XColor* color, unsigned long rgb);
	unsigned long		pixel;
	unsigned long		rgb;
	Display*		display;
};


#endif /* __ucolor_h__ */
