//  UTextArea.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UTextArea.h"


UTextArea::UTextArea (UFrame* parent_) : UFrame (parent_)
{
	// This is the top guy.
	textFrame = new UTextFrame (this, 1);
	textFrame->place (2, 2, 22, 22);

	scrollh = new UScroll (this, UScroll::HORIZONTAL);
	scrollh->place (2, -22, 22, 2);

	scrollv = new UScroll (this, UScroll::VERTICAL);
	scrollv->place (-22, 2, 2, 22);
}


UTextArea::~UTextArea ()
{
	// autodelete from frame
}


int
UTextArea::isA (UComponent::UType type_)
{
	if (type_ == UComponent::TEXT_AREA) return 1;
	return UComponent::isA (type_);
}

void
UTextArea::eventUp (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::SCROLL_RANGE_VERTICAL:
		if (event->client==textFrame)
		{  
			scrollv->scroll (event->value, event->step,
				event->page, event->max);
			textFrame->uVScroll (scrollv->getValue());
		}
		break;
	case UEvent::SCROLL_RANGE_HORIZONTAL:
		if (event->client==textFrame)
		{
			scrollh->scroll (event->value, event->step,
				event->page, event->max);
			textFrame->uHScroll (scrollh->getValue());
		}
		break;
	case UEvent::CARDINAL:
		if (event->client==scrollv)
		{
			textFrame->uVScroll (event->cardinal);
		}
		if (event->client==scrollh)
		{
			textFrame->uHScroll (event->cardinal);
		}
		break;
	default:
		parent->eventUp (event);
	}
	return;
}
