//  UFreeType.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef __ufree_type__
#define __ufree_type__

#include "UCommon.h"

#ifdef FREETYPE
#include <freetype.h>
#endif

#ifndef FREETYPE
typedef int TT_Face;
typedef int TT_Face_Properties;
typedef int TT_CharMap;
#endif

class UFreeTypeFace
{
public:
				UFreeTypeFace (void);
				~UFreeTypeFace();
	void			setFont (const char* pathName);
	enum	UFlags		{EMPTY, UNINITED, INITED};
	UFlags			flags;
	inline const char*	getName() const { return fontFileName; }
	TT_Face*		getFace();
	TT_Face_Properties*	getProperty();
	int 			getCharIndex (const UCS2 ucs2);
private:
	void			openFace();
	char*			fontFileName;
	TT_Face			face;
	TT_Face_Properties	properties;
	TT_CharMap		charMap;
};

class UFreeType
{
public:
	enum UStatus { OK, ERROR };
	enum UWeight {MEDIUM=0, BOLD, WEIGHT_COUNT};
	enum USlant  {ROMAN=0, ITALIC, SLANT_COUNT};
				UFreeType (const char* nameIn);
	UStatus 		setFontFile (const char* file, 
					UWeight weight, USlant slant);
				~UFreeType ();
	inline const char*	getName () const { return myName; }
	const char*		getFileName (UWeight weight, USlant slant) const;
	inline UFreeTypeFace*	getFreeTypeFace (UWeight  weight, USlant slant)
				{ return (&freeTypeFace[weight][slant]); }
	UWeight			freeTypeWeight (int weightIn);
	USlant			freeTypeSlant (int slantIn);
	
private:
	UFreeTypeFace		freeTypeFace[WEIGHT_COUNT][SLANT_COUNT];
	char*			myName; // This is not the fontPath
	static int		initialized;
};


UFreeType::UStatus UAddFreeType (const char* name);
UFreeType* UGetFreeType (const char *name);
UFreeType* UGetFreeTypePrint (const char *name);
UFreeType::UStatus UDeleteFreeType (const char *name);

#endif /* __ufree_type__ */
