/*
 * rd_cazm - analog waveform file reader for the transient-simulation
 * format written by the CAzM simulator. 
 *
 * Steve Tell, August 11, 1998.
 *
 * $Log: rd_cazm.c,v $
 * Revision 1.2  1998/09/17 18:24:14  tell
 * add backpointer from DataSet to DataFile
 *
 * Revision 1.1  1998/08/31 20:58:41  tell
 * Initial revision
 *
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include "reader.h"

/*
 * Read a whole file into memory.
 *   Returns pointer to DataFile on success,
 *   NULL on failure
 * TODO: figure out a way to return more information on failure.
 */
DataFile *
cz_read_file(char *name, FILE *fp)
{
	DataFile *df;
	char *line;
	char *signam;
	int lineno = 0;
	int linesize = 1024;
	int dvsize = 128;
	int nrows;
	double val;
	int i;

	line = g_new(char, linesize);
	
	while(1) {
		if((fread_line(fp, &line, &linesize) == EOF) || lineno > 10) {
			g_free(line);
			return NULL;
		}
		lineno++;
		/* "section header" TODO: handle the rest of them */
		if(strncmp(line, "TRANSIENT", 8) == 0)
			break;
	}

	/* line after header contains signal names
	 * first one is assumed to be the independent variable.
	 */
	if(fread_line(fp, &line, &linesize) == EOF) {
		g_free(line);
		return NULL;
	}

	df = g_new0(DataFile, 1);
	df->filename = g_strdup(name);

	signam = strtok(line, " \t\n");
	if(!signam)
		goto bailout;
	df->iv = g_new0(IVar, 1);
	an_init_dataset((DataSet *)df->iv, df, signam, TIME);

	df->dv = g_new0(DVar*, dvsize);
	df->ndv = 0;
	while((signam = strtok(NULL, " \t\n")) != NULL) {
		DVar *dv;
		if(df->ndv >= dvsize) {
			dvsize *= 2;
			df->dv = g_realloc(df->dv, dvsize * sizeof(DVar*));
		}
		dv = g_new0(DVar, 1);
		dv->iv = df->iv;
		df->dv[df->ndv++] = dv;

		an_init_dataset((DataSet *)&dv->d, df, signam, VOLTAGE);
	}

	nrows = 0;
	while(fscanf(fp, "%lg", &val) != EOF) {
		if(ds_blockno(nrows) >= df->iv->d.bpused) {
			an_expand_dset((DataSet *)df->iv);
			for(i = 0; i < df->ndv; i++)
				an_expand_dset((DataSet *)df->dv[i]);
		}

		an_set_point((DataSet *)&df->iv->d, nrows, val);
		df->iv->d.nvalues++;
		for(i = 0; i < df->ndv; i++) {
			val = 0;
			fscanf(fp, "%lg", &val);
			an_set_point((DataSet *)&df->dv[i]->d, nrows, val);
			df->dv[i]->d.nvalues++;
		}
		nrows++;
	}

	g_free(line);
	return df;

 bailout:  /* TODO: free everything else that might have been allocated */
	if(line)
		g_free(line);
	if(df) {
		g_free(df->filename);
		g_free(df);
	}
	return NULL;
}

