/*
 * Copyright 1996, 1997, 1998 by Daniel B. Suthers, Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com

 * You may freely copy, use, and distribute this software
 * subject to the following restrictions:
 *
 *  1)	You may not charge money for it.
 *  2)	You may not remove or alter this copyright notice.
 *  3)	You may not claim you wrote it.
 *  4)	If you make improvements (or other changes), you are requested
 *	to send them to me, so there's a focal point for distributing
 *	improved versions.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include "x10.h"
#include <string.h>

extern int tty;
extern int sptty;
extern int verbose;
extern unsigned char cm11map[];


/*
 * This function erases the EEPROM in the CM11.  It does so 
 * by overwriting the EEPROM with no macros and no events
 * In essence, the following byte string should be sent
 * FB 00 00 00 02 ff ff ff ff ff ff ff ff ff ff ff ff ff ff
 * FB = load macros
 *    00 00 = address to load at
 *          00 02 = address 2 = start of macro initiators
 *                ff ff  end of macro initiators
 *                      ff ff ff ff ff ff ff ff ff ff ff ff   filler
 *
 * It's important to note that the eeprom macro data is NOT zeroed.  This
 * leaves a possibility that a new timer/macro will put a partial record
 * at the address of the old one.
 */
c_erase(argc, argv)
int argc;
char *argv[];
{
    register n, x;
    unsigned int hcode, dim, bits, unit;
    int statusflag;
    int fctn;
    int timeout;
    unsigned sum;
    unsigned char buf[22];
    char *unitnums;
    char RCSID[]= "@@(#) $Id: erase.c,v 1.3 1998/04/28 04:06:53 dbs Exp $\n";


    timeout=10;
    statusflag = 0;

    /* There's better ways to stuff this information into an array,
     * but I'm feeling too tired to do it. */
    buf[0] = 0xfb; /* I want to write data */
    buf[1] = 0x0;  /* starting address to write (hi-lo) in this case Zero */
    buf[2] = 0x0;
                   /* data to store in eeprom starts here */
    buf[3] = 0x0;  /* Start of the macro init table (hi-lo) = 2 */
    buf[4] = 0x2;
    		   /* start of timer initiator table */
    buf[5] = 0xff; /* flag to indicate end of timer init table */
    buf[6] = 0xff; /* start of bogus macro initiator table */
    buf[7] = 0xff; /* filler.  Content of data packets must be 16 bytes */
    buf[8] = 0xff;
    buf[9] = 0xff;
    buf[10] = 0xff;
    buf[11] = 0xff;
    buf[12] = 0xff;
    buf[13] = 0xff;
    buf[14] = 0xff;
    buf[15] = 0xff;
    buf[16] = 0xff;
    buf[17] = 0xff;
    buf[18] = 0xff;
    buf[19] = 0x0; /* Experiment.  Please ignore */
    buf[20] = 0xff;
    buf[21] = 0;

    if( verbose )
    {
	fprintf(stderr, "Sending erase string\n" ); 
    }
    (void) xwrite(tty, (char *) buf, 19);

    /* get a check sum in reply */
    /* The check sum does not include the 'fb'
     * It starts at the 4th byte (buf[3])
     */
    sum=chksum(buf+3,16) ;
    if( verbose )
	fprintf( stderr, "Expected checksum = %0x\n", sum);
    n = exread(sptty, buf, 1, timeout);
    if( verbose )
	fprintf(stderr, "Cm11 reports a checksum of %0x\n", buf[0]);
    if( sum == buf[0]) 
    {
	(void) xwrite(tty, "\00" , 1);	/* WRMI (we really mean it) */
    }
    else
    {
	fprintf(stderr, "Failure sending address header\n");
	return(-1);
    }

    buf[0] = 0;
    n = exread(sptty, buf, 1, timeout);
    if( n == 1 )
        if(buf[0] != 0x55 )
        {
            fprintf(stderr, "Ack after execution = %0x, It should be 0x55)\n",
                    buf[0]);
            n = 0;
        }
    if(n != 1)
    {
        fprintf(stderr,
                "Interface not ready after excuting function (buf= %0x)\n",
                buf[0]);
        fprintf(stderr, "N = %0x)\n", n);
        return(-1);
    }


    if(statusflag == 1)
    {
	for( n = 0; n < 2; n++)
	    check4poll(1,1);
    }
    else
	check4poll(0,0);
    if( verbose )
	fprintf(stderr, "All ok with Erase.\n");
    return(0);
}
