"""Maintains graphical censor window."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Tkinter import *
import string

from Tk_List import *

import empDb

## def gridClear(win):
##     win['height'] = win.winfo_reqheight()
##     win['width'] = win.winfo_reqwidth()
##     win.grid_propagate(0)
## def packClear(win):
##     def after_f(win=win):
##	h, w = win.winfo_reqheight(), win.winfo_reqwidth()
##	win.pack_propagate(0)
##	win['height'], win['width'] = h, w
##     win.after_idle(after_f)

###########################################################################
#############################  Censor window  #############################
def enterLabel(label):
    label['relief'] = GROOVE
def leaveLabel(label):
    label['relief'] = SUNKEN
def bindLabel(label):
    label.bind('<Enter>',
	       (lambda e, label=label:
		enterLabel(label)))
    label.bind('<Leave>',
	       (lambda e, label=label:
		leaveLabel(label)))

class LabPair(Frame):
    """Create a label/value pair for HDL with description LABEL."""
    def __init__(self, master, deflist, name, **kw):
	# label, command, hide, default
	self.name = name
	self.default = kw.get('default')
	self.hide = kw.get('hide')
	label = kw.get('label', name)
	self.label = Label(master, name='label',
			   text=label, width=7, anchor=NE)
	self.label.pack(side=TOP, expand=1, fill=BOTH)
	self.value = Label(master, name='value',
			   relief=SUNKEN, anchor=NE)
	self.value.pack(side=TOP, expand=1, fill=BOTH)
	try:
	    self.value.bind('<Button-1>',
			    (lambda e, c=kw['command'], n=name:
			     c(n)))
	    bindLabel(self.value)
	except KeyError: pass
	self.value.bind('<Control-1>', (lambda e, self=self:
					viewer.cen.EditField(self.name)))
	deflist[name] = self.update

    def update(self, val):
	if val == self.default:
	    val = ""
	if val == self.hide:
	    self.label.pack_forget()
	    self.value.pack_forget()
	elif self.value['text'] == str(self.hide):
	    self.label.pack(expand=1, fill=BOTH)
	    self.value.pack(expand=1, fill=BOTH)
	self.value['text'] = val

class LabPairIdx:
    """Same as LabPair, but take two values and create an x/y index."""
    def __init__(self, master, deflist, name, **kw):
	# takes label, command, hide as possible parameters:
	label = kw.get('label', name)
	self.coord = ["", ""]
	label = Label(master, name='label',
		      text=label, width=7, anchor=NE)
	self.value = Label(master, name='value',
			   width=4, relief=SUNKEN, anchor=NE)
	label.pack(side=TOP, expand=1, fill=BOTH)
	self.value.pack(side=TOP, expand=1, fill=BOTH)
	if kw.get('command') != None:
	    self.value.bind('<Button-1>',
			    (lambda e, c=kw['command'], n=name:
			     c(n)))
	    bindLabel(self.value)
	self.value.bind('<3>', self.goSect)
	deflist[name+"x"] = (lambda val, self=self:
			     self.update(0, val))
	deflist[name+"y"] = (lambda val, self=self:
			     self.update(1, val))

    def update(self, pos, val):
	self.coord[pos] = val
	self.value['text'] = "%s,%s" % (self.coord[0], self.coord[1])

    def goSect(self, event):
	try:
	    x = string.atoi(self.coord[0])
	    y = string.atoi(self.coord[1])
	    viewer.cen.SetSect((x, x, y, y))
	except ValueError:
	    pass

class ComdQuad:
    """Create 4 fields for a commodity."""
    def __init__(self, master, deflist, comd,
		 vhdl=None, dhdl=None, chdl=None, ahdl=None):

	def update(win, val):
	    """Update a commodity attribute label."""
	    if val == '0' or val == '.':
		val = ""
	    win['text'] = val

	frame = Frame(master, name=comd, class_='Commodity')
	frame.pack(side=TOP)
	label = Label(frame, name='label', text=comd, width=7, anchor=NE)
	label.pack(side=LEFT)
	f = comd[0]
	for i in ((comd, 5, vhdl, 'value'),
		  (f+"_dist", 5, dhdl, 'dist'),
		  (f+"_cut", 5, chdl, 'cutoff'),
		  (f+"_del", 2, ahdl, 'deliver')):
	    tmp = Label(frame, name=i[3], width=i[1], relief=SUNKEN, anchor=NE)
	    tmp.pack(side=LEFT)
	    if i[2]:
		tmp.bind('<Button-1>', i[2])
		bindLabel(tmp)
	    deflist[i[0]] = (lambda val, u=update, t=tmp:
			     u(t, val))

def DoWinList(rframe, hookList, lablist):
    row = col = 0
    for i in lablist:
	for j in i:
	    if j:
		# HACK++
		if j[1] == '*':
		    name = 'enemy'
		elif j[0] is LabPairIdx: name=j[1]+'sect'
		else: name=j[1]
		tmp = Frame(rframe, name=name, class_='Resources')
##		tmp = Frame(rframe, class_='Resources')
		tmp.grid(column=col, row=row)
		if type(j[-1]) == type({}):
		    apply(j[0], (tmp, hookList)+j[1:-1], j[-1])
		else:
		    apply(j[0], (tmp, hookList)+j[1:])
##		packClear(tmp)
	    col = col + 1
	if not i:
	    # make sure empty rows still take space.
	    rframe.grid_rowconfigure(row, minsize='1c')
	row = row + 1
	col = 0

class cenWin:
    """Censor Window"""

    class SectorCensus:
	"""Subwindow in the censor window that displays sector resources."""
	def __init__(self, master):
	    self.key = ('0','0')
	    self.db = 'SECTOR'
	    self.name = 'sector'

	    # Sector resources
	    rframe = Frame(master, name='resources', class_='SubCensor')
	    self.Rlist = {}

	    # x y des sdes eff mob * off min gold fert ocontent uran work
	    # avail terr civ mil uw food shell gun pet iron dust bar oil
	    # lcm hcm rad u_del f_del s_del g_del p_del i_del d_del b_del
	    # o_del l_del h_del r_del u_cut f_cut s_cut g_cut p_cut i_cut
	    # d_cut b_cut o_cut l_cut h_cut r_cut dist_x dist_y c_dist
	    # m_dist u_dist f_dist s_dist g_dist p_dist i_dist d_dist
	    # b_dist o_dist l_dist h_dist r_dist road rail defense fallout
	    # coast c_del m_del c_cut m_cut
	    DoWinList(rframe, self.Rlist, (
		((LabPairIdx, "", {'label':"sect"}),
		 (LabPair, "owner", {'default':empDb.CN_OWNED,
				     'hide':""}), (),
		 (LabPair, "sdes", {'label':"newd", 'command':self.SetDes,
				    'default':"_", 'hide':""}),
		 (LabPair, "des", {'command':self.SetDes})),

		((LabPair, "eff"), (LabPair, "mob"),
		 (LabPair, "avail"), (LabPair, "work"),
		 (LabPair, "off", {'label':"stop", 'default':'0',
				   'hide':""})),

		((LabPair, "terr", {'command':self.SetTerr}),
		 (LabPair, "coast"),
		 (LabPair, "fallout", {'default':'0', 'hide':""}),
		 (), (LabPair, "*", {'label':"enemy", 'default':'.',
				     'hide':""})),

		((LabPair, "min"), (LabPair, "gold"), (LabPair, "fert"),
		 (LabPair, "ocontent", {'label':"oil"}), (LabPair, "uran")),

		((LabPair, "road",
		  {'command':
		   (lambda comd, self=self:
		    viewer.queryCommand(
			"Improve road of sector %s,%s to ?" % self.key,
			"eval %s,%s improve road [sect] [%%s-road]" % self.key,
			"esync", "esync"))}),
		 (LabPair, "rail",
		  {'command':
		   (lambda comd, self=self:
		    viewer.queryCommand(
			"Improve rail of sector %s,%s to ?" % self.key,
			"eval %s,%s improve rail [sect] [%%s-road]" % self.key,
			"esync", "esync"))}), 
		 (LabPair, "defense",
		  {'command':
		   (lambda comd, self=self:
		    viewer.queryCommand(
			"Improve defense of sector %s,%s to ?" % self.key,
			"eval %s,%s improve def [sect] [%%s-road]" % self.key,
			"esync", "esync"))}),
		 (), (LabPairIdx, "dist_", {'label':"dist",
					    'command':self.SetDist})),
		(),
		))

	    rframe.pack(side=TOP)

	    cframe = Frame(master, name='commodities', borderwidth=4)
	    cframe.pack(side=TOP, anchor=NE)
	    lcframe = Frame(cframe, name='label')
	    lcframe.pack()
	    Label(lcframe, name='type', text='Type',
		  width=7, anchor=W).pack(side=LEFT)
	    Label(lcframe, name='qty', text='Qty',
		  width=5, anchor=W).pack(side=LEFT)
	    Label(lcframe, name='thr', text='Thr',
		  width=5, anchor=W).pack(side=LEFT)
	    Label(lcframe, name='del', text='Del',
		  width=7, anchor=W).pack(side=LEFT)
	    for i in ("civ", "mil", "uw", "food", "shell", "gun",
		      "pet", "iron", "dust", "bar", "oil", "lcm",
		      "hcm", "rad"):
		ComdQuad(cframe, self.Rlist, i,
			 (lambda e, h=self.SetCurrent, i=i:
			  h(i)),
			 (lambda e, h=self.SetThresh, i=i:
			  h(i)),
			 (lambda e, h=self.SetDel, i=i:
			  h(i)))

	def SetSect(self, range):
##	    self.key = (range[0], range[2])
	    self.key = (str(range[0]), str(range[2]))
	    viewer.map.markSectors([(range[0], range[2])])
	    viewer.map.see((range[0], range[2]))
	    self.redraw(1)

	def EditField(self, name):
	    if viewer.stsList:
		viewer.Root.bell()
		return
	    def f(val, db=self.db, key=self.key, name=name):
		if not val:
		    return
		db = empDb.megaDB[db]
		t = {}
		for i in range(len(key)):
		    t[db.primary_keytype[i]] = key[i]
		t[name] = val
		db.update(t)
		viewer.updateDB(0)
	    viewer.bufferStatus(
		"Manually edit %s value at %s,%s to ?" % ((name,) + self.key),
		f)

	def SetDist(self, name):
	    viewer.queryCommand(
		"New dist sector for %s,%s ?" % self.key,
		"dist %s,%s %%s" % self.key,
		"esync")

	def SetDes(self, name):
	    viewer.queryCommand(
		"New designation for %s,%s ?" % self.key,
		"des %s,%s %%s" % self.key,
		"esync")

	def SetTerr(self, name):
	    viewer.queryCommand(
		"New territory value for %s,%s ?" % self.key,
		"territory %s,%s %%s" % self.key,
		"esync")

	def SetCurrent(self, comd):
	    viewer.queryCommand(
		"Resupply %s commodity at %s,%s to?" % ((comd,) + self.key),
		"eval val=%%s %s,%s move %s [val>%s and dist+' '+`val-%s`+' '+sect or sect+' '+`%s-val`+' '+dist]" % (
		    self.key + (comd, comd, comd, comd)),
		"esync", "esync")

	def SetThresh(self, comd):
	    viewer.queryCommand(
		"New %s threshold for %s,%s ?" % ((comd,) + self.key),
		"thresh %s %s,%s %%s" % ((comd,) + self.key),
		"esync")

	def SetDel(self, comd):
	    viewer.queryCommand(
		"New %s cutoff for %s,%s ?" % ((comd,) + self.key),
		"deli %s %s,%s +%%s" % ((comd,) + self.key),
		"esync")

	def redraw(self, total):
	    DB = empDb.megaDB.get(self.db, {})
	    DBs = DB.get(self.key, {})
	    for i, j in self.Rlist.items():
		j(DBs.get(i, ""))

    class UnitCensus:
	"""Generic class that Land/Ship/Plane classes descend from."""
	def doStartup(self, master):
	    self.key = 0

	    self.sect = ()

	    sframe = Frame(master, name=self.name, class_='SubCensor')
	    sframe.pack(side=BOTTOM, fill=BOTH, expand=1)
	    scrollY = Scrollbar(sframe, name='scrollY')
	    scrollY.pack(side=RIGHT, fill=Y)
	    self.List = MyListbox(sframe, name='list',
				  height=4, command=self.SetId,
				  yscrollcommand=scrollY.set)
	    self.List.pack(side=LEFT, fill=BOTH, expand=1)
	    scrollY['command'] = self.List.yview

	    rframe = Frame(master, name='resources')
	    rframe.pack(side=TOP)

	    self.Rlist = {}

	    DoWinList(rframe, self.Rlist, self.winList)

	def redrawWin(self, total=0):
	    DB = empDb.megaDB.get(self.db, {})
	    DBs = DB.get(self.key, {})
	    for i, j in self.Rlist.items():
		j(DBs.get(i, ""))

	def SetId(self, info):
	    if info: self.key = (info[0],)
	    else: self.key = ()
	    self.redrawWin(1)

	def SetSect(self, range):
	    self.sect = range
	    self.redraw()

	def EditField(self, name):
	    if viewer.stsList:
		viewer.Root.bell()
		return
	    def f(val, db=self.db, key=self.key, name=name):
		if not val:
		    return
		db = empDb.megaDb[db]
		t = {}
		for i in len(self.key):
		    t[db.primary_keytype[i]] = self.key[i]
		t[name] = val
		db.update(t)
	    viewer.bufferStatus(
		"Manually edit %s value of %s to ?" % (name, self.key[0]),
		f)

	def redraw(self, total=0):
	    self.redrawWin(total)
	    sts = self.List.getStatus()
	    DB = empDb.megaDB.get(self.db, {})
	    self.List.delete()
	    list = []
	    for i, j in DB.items():
		if self.sect:
		    x, y = string.atoi(j['x']), string.atoi(j['y'])
		    if (x < self.sect[0] or x > self.sect[1]
			or y < self.sect[2] or y > self.sect[3]):
			continue
##		if j.get('owner') != empDb.CN_OWNED:
##		    continue
		if j.get('owner') == empDb.CN_UNOWNED:
		    continue
		addi = ""
		if j.get('owner') != empDb.CN_OWNED:
		    addi = " owner:%s" % (j.get('owner'),)
		list.append(
		    ("%3s @ %-10s type: %s %15s" %
		     (j['id'], ("(%s,%s)" % (j['x'], j['y'])),j['type'], addi),
		     j['id']))
	    list.sort()
	    for i in list:
		self.List.insert(END, i)
	    apply(self.List.setStatus, sts)

	def GoLand(self, name):
	    k = empDb.megaDB.get(self.db, {}).get(self.key, {}).get('land')
	    if k == None or k == '-1':
		return
	    viewer.cen.blist['Land'].handle.key = ( k, )
	    viewer.cen.newWin(viewer.cen.blist['Land'])

	def GoShip(self, range):
	    k = empDb.megaDB.get(self.db, {}).get(self.key, {}).get('ship')
	    if k == None or k == '-1':
		return
	    viewer.cen.blist['Ship'].handle.key = ( k, )
	    viewer.cen.newWin(viewer.cen.blist['Ship'])

    class ShipCensus(UnitCensus):
	"""Subwindow within the censor window that displays ships."""
	def __init__(self, master):
	    self.db = 'SHIPS'
	    self.name = 'ship'

##	    cc = {'default':"0", 'command':self.LoadComd}
	    cc = {'command':self.LoadComd}

	    # id type x y flt eff civ mil uw food pln he xl land mob fuel tech
	    # shell gun petrol iron dust bar oil lcm hcm rad
	    # def spd vis rng fir origx origy name
	    self.winList = (
		((LabPair, "id"), (LabPair, "type"),
		 (LabPair, "owner", {'default':empDb.CN_OWNED,
				     'hide':""}),
		 (LabPairIdx, "", {'label':"sect", 'command':self.GoSect}),
		 (LabPair, "flt", {'label':"fleet", 'command':self.SetFleet})),

		((LabPair, "eff"), (LabPair, "mob"), (LabPair, "fuel"),
		 (LabPair, "tech")),

		((LabPair, "def"), (LabPair, "spd", {'label':"speed"}),
		 (LabPair, "vis"), (LabPair, "rng", {'label':"range"}),
		 (LabPair, "fir")),

		((LabPair, "pln", {'label':"planes"}), (LabPair, "land"),
		 (LabPair, "he"), (LabPair, "xl")),

		((LabPairIdx, "orig"),
		 (LabPair, "name", {'command':self.SetName})),

		(),
		# List of commodities
		((LabPair, "civ", cc), (LabPair, "mil", cc),
		 (LabPair, "uw", cc), (LabPair, "food", cc),
		 (LabPair, "shell", cc)),
		((LabPair, "gun", cc), (LabPair, "petrol", cc),
		 (LabPair, "iron", cc), (LabPair, "dust", cc),
		 (LabPair, "bar", cc)),
		((LabPair, "oil", cc), (LabPair, "lcm", cc),
		 (LabPair, "hcm", cc), (LabPair, "rad", cc)),
		)
	    self.doStartup(master)

	def GoSect(self, name):
	    viewer.queryCommand(
		"Navigate ship %s to ?" % self.key,
		"navi %s %%s" % self.key,
		"ssync")

	def SetFleet(self, name):
	    viewer.queryCommand(
		"Add ship %s to fleet ?" % self.key,
		"fleet %%s %s" % self.key,
		"ssync")

	def SetName(self, name):
	    viewer.queryCommand(
		"New name for ship %s ?" % self.key,
		"name %s %%s" % self.key,
		"ssync")

	def LoadComd(self, comd):
	    viewer.queryCommand(
		"Set %s cargo on ship %s to ?" % (comd, self.key[0]),
		"load %s %s -%%s" % (comd, self.key[0]),
		"essync")

    class LandCensus(UnitCensus):
	"""Subwindow within the censor window that displays land units."""
	def __init__(self, master):
	    self.db = 'LAND UNITS'
	    self.name = 'land'

##	    cc = {'default':"0", 'command':self.LoadComd}
	    cc = {'command':self.LoadComd}

	    # id type x y army eff mil fort mob food fuel tech retr react xl
	    # nland land ship shell gun petrol iron dust bar oil lcm hcm rad
	    # att def vul spd vis spy radius frg acc dam amm aaf
	    self.winList = (
		((LabPair, "id"), (LabPair, "type"),
		 (LabPair, "owner", {'default':empDb.CN_OWNED,
				     'hide':""}),
		 (LabPairIdx, "", {'label':"sect", 'command':self.GoSect}),
		 (LabPair, "army", {'command':self.SetArmy})),

		((LabPair, "eff"), (LabPair, "mob"), (LabPair, "fuel"),
		 (LabPair, "tech")),

		((LabPair, "fort"), (LabPair, "retr"),
		 (LabPair, "react", {'command':self.SetRange}),
		 (LabPair, "att"), (LabPair, "def")),

		((LabPair, "vul"), (LabPair, "spd"),
		 (LabPair, "vis"), (LabPair, "spy"),
		 (LabPair, "radius")),

		((LabPair, "frg"), (LabPair, "acc"),
		 (LabPair, "dam"),
		 (LabPair, "amm"), (LabPair, "aaf")),

		((LabPair, "xl"), (LabPair, "nland"), (),
		 (LabPair, "land", {'default':'-1', 'command':self.GoLand}),
		 (LabPair, "ship", {'default':'-1', 'command':self.GoShip})),

		(),
		# List of commodities
		((LabPair, "civ", cc), (LabPair, "mil", cc),
		 (LabPair, "uw", cc), (LabPair, "food", cc),
		 (LabPair, "shell", cc)),
		((LabPair, "gun", cc), (LabPair, "petrol", cc),
		 (LabPair, "iron", cc), (LabPair, "dust", cc),
		 (LabPair, "bar", cc)),
		((LabPair, "oil", cc), (LabPair, "lcm", cc),
		 (LabPair, "hcm", cc), (LabPair, "rad", cc)),
		)
	    self.doStartup(master)

	def GoSect(self, name):
	    viewer.queryCommand(
		"March land unit %s to ?" % self.key,
		"march %s %%s" % self.key,
		"lsync")

	def SetArmy(self, name):
	    viewer.queryCommand(
		"Add land unit %s to army ?" % self.key,
		"army %%s %s" % self.key,
		"lsync")

	def SetRange(self, name):
	    viewer.queryCommand(
		"Set reaction range of land unit %s to ?" % self.key,
		"lrange %s %%s" % self.key,
		"lsync")

	def LoadComd(self, comd):
	    viewer.queryCommand(
		"Set %s cargo on land unit %s to ?" % (comd, self.key[0]),
		"lload %s %s -%%s" % (comd, self.key[0]),
		"elsync")

    class PlaneCensus(UnitCensus):
	"""Subwindow within the censor window that displays planes."""
	def __init__(self, master):
	    self.db = 'PLANES'
	    self.name = 'plane'

	    # id type x y wing eff mob tech att def acc react range load
	    # fuel hard ship land laun orb nuke grd
	    self.winList = (
		((LabPair, "id"), (LabPair, "type"),
		 (LabPair, "owner", {'default':empDb.CN_OWNED,
				     'hide':""}),
		 (LabPairIdx, "", {'label':"sect", 'command':self.GoSect}),
		 (LabPair, "wing", {'command':self.SetWing})),

		((LabPair, "eff"), (LabPair, "mob"), (LabPair, "fuel"),
		 (LabPair, "tech")),

		((LabPair, "hard"),
		 (LabPair, "react", {'command':self.SetRange}),
		 (LabPair, "att"), (LabPair, "def")),

		((LabPair, "acc"), (LabPair, "range"),
		 (LabPair, "load"), (LabPair, "laun"),
		 (LabPair, "orb")),

		((LabPair, "nuke"), (LabPair, "grd"), (),
		 (LabPair, "land", {'default':'-1', 'command':self.GoLand}),
		 (LabPair, "ship", {'default':'-1', 'command':self.GoShip})),
		)
	    self.doStartup(master)

	def GoSect(self, name):
	    viewer.queryCommand(
		"Transport plane %s to ?" % self.key,
		"transp %s %%s" % self.key,
		"psync")

	def SetWing(self, name):
	    viewer.queryCommand(
		"Add plane %s to wing ?" % self.key,
		"wing %%s %s" % self.key,
		"psync")

	def SetRange(self, name):
	    viewer.queryCommand(
		"Set reaction range of plane %s to ?" % self.key,
		"range %s %%s" % self.key,
		"psync")

    ####################
    # Main censor window
    def __init__(self, master):
	self.master = master
	self.blist = {}

	buttons = Frame(master, name='buttons')
	buttons.pack(side=TOP, fill=X)
	for i in (#('Nuke', self.SectorCensus, 'NUKES'),
		  ('Plane', self.PlaneCensus, 'PLANES'),
		  ('Land', self.LandCensus, 'LAND UNITS'),
		  ('Ship', self.ShipCensus, 'SHIPS'),
		  ('Sector', self.SectorCensus, 'SECTOR')):
	    frm = Frame(master, name='f'+i[0], class_='Buttons',
			relief=RAISED, borderwidth=2)
	    frm.handle = i[1](frm)
	    frm.db = i[2]
	    frm.button = Button(buttons, name='b'+i[0], text=i[0], relief=FLAT,
				command=(lambda self=self, cls=frm:
					 self.newWin(cls)))
	    frm.button.pack(side=RIGHT, fill=Y, expand=1)
	    self.blist[i[0]] = frm
	self.subWindow = frm
	frm.button['relief'] = RAISED
	frm.pack(fill=Y, expand=1)
##	self.SetSect((0,0,0,0))

	# Register automatic updating
	viewer.updateList.append(self)

    def newWin(self, ofType):
	self.subWindow.button['relief'] = FLAT
	self.subWindow.pack_forget()
	self.subWindow = ofType
	self.subWindow.button['relief'] = RAISED
	self.subWindow.pack(fill=Y, expand=1)
	self.subWindow.handle.sect = ()
	self.redraw(1)

    def redraw(self, total):
	self.subWindow.handle.redraw(total)

    def SetSect(self, range):
	self.subWindow.handle.SetSect(range)

    def EditField(self, field):
	self.subWindow.handle.EditField(field)
