/****************************************************************************
 * NCSA HDF                                                                 *
 * National Comptational Science Alliance                                   *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 *                                                                          *
 * For conditions of distribution and use, see the accompanying             *
 * hdf/COPYING file.                                                        *
 *                                                                          *
 ****************************************************************************/


package  ncsa.hdf.awt.palette;

import java.awt.image.ColorModel;
import java.awt.image.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.lang.Math;
import ncsa.hdf.awt.image.*;

public class PaletteCanvas extends Canvas 
{

	PalettePanel    parent;

	// Default palette image (256 by 64)
	Image	pImage = null;

	// current palette image color model
 	ColorModel   cModel = null;

	// default width and height of palette image
	int	pWidth = 256;
	int  	pHeight= 64;

	// palette image data
	byte[] pImageData = new byte[pWidth*pHeight];

	// specify the RGB values
	byte[] reds   = null;
	byte[] greens = null;
	byte[] blues  = null;
	
	// the new RGB values	 ( after processing )
	byte[] newReds   = null;
	byte[] newGreens = null;
	byte[] newBlues  = null;

	static final int PALETTESTACKSIZE	= 20;

	// platte values stack
	Stack 	paletteStack = new Stack();

	// the factor that the orignal palette has been expanded or shrink
	int    fiddleFactor = 0;

	// indicator of the palette taken by the fiddle operation
	boolean		fiddleFlag = false;
	
  	/** variables for duble-buffer  */
  	Image 		offScreenImage = null;
  	Graphics 	offGraphics;
 
	/** translated variable for scroll panel */
  	int tx=0,  ty=0;       // offset translate

	// current runtime version
	String jversion = System.getProperty("java.version");

	// palette shifted direction constants 
	static final int LEFT  = 0;
	static final int RIGHT = 0;

	// keep track of the mouse points
	int  xpos, ypos;

    // Default class constructor 
    public PaletteCanvas() {

	// set data
	setImageData();

	// default
	setInvertedRainbowPalette();

	// set image
	pImage = getPaletteImage();

	// resize 
	this.setSize(pWidth, pHeight);
       enableEvents(AWTEvent.MOUSE_EVENT_MASK);
       enableEvents(AWTEvent.MOUSE_MOTION_EVENT_MASK);
     }
 
     // Default class constructor 
     public PaletteCanvas(PalettePanel parent) {
 
       this();
       this.parent = parent;
     }


    // Construct the palette image data
    public void setImageData() {

	// set data
	for (int i=0; i<pHeight; i++)  
      	    for (int j=0; j<pWidth; j++ )  
		pImageData[i*pWidth+j]    = (byte)j;
	  	 
    }

    // Construct the palette image data
    public void setImageData(byte[] data) {

	pImageData    = data;
		  	 
    }

    // set the rainbow palette
    public void setRainbowPalette() {

	// new default rgb
	pushPaletteValue();
	
	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] rainbowValues = {  

   // rgb,rgb, ......
 (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x7c, (byte)0x00, (byte)0xff, (byte)0x78, (byte)0x00, (byte)0xfe, (byte)0x73, (byte)0x00, (byte)0xff,
 (byte)0x6f, (byte)0x00, (byte)0xfe, (byte)0x6a, (byte)0x00, (byte)0xff, (byte)0x66, (byte)0x00, (byte)0xfe, (byte)0x61, (byte)0x00, (byte)0xff,
 (byte)0x5d, (byte)0x00, (byte)0xfe, (byte)0x58, (byte)0x00, (byte)0xff, (byte)0x54, (byte)0x00, (byte)0xfe, (byte)0x4f, (byte)0x00, (byte)0xff,
 (byte)0x4b, (byte)0x00, (byte)0xfe, (byte)0x46, (byte)0x00, (byte)0xff, (byte)0x42, (byte)0x00, (byte)0xfe, (byte)0x3d, (byte)0x00, (byte)0xff,
 (byte)0x39, (byte)0x00, (byte)0xfe, (byte)0x34, (byte)0x00, (byte)0xff, (byte)0x30, (byte)0x00, (byte)0xfe, (byte)0x2b, (byte)0x00, (byte)0xff,
 (byte)0x27, (byte)0x00, (byte)0xfe, (byte)0x22, (byte)0x00, (byte)0xff, (byte)0x1e, (byte)0x00, (byte)0xfe, (byte)0x19, (byte)0x00, (byte)0xff,
 (byte)0x15, (byte)0x00, (byte)0xfe, (byte)0x10, (byte)0x00, (byte)0xff, (byte)0x0c, (byte)0x00, (byte)0xfe, (byte)0x07, (byte)0x00, (byte)0xff,
 (byte)0x03, (byte)0x00, (byte)0xfe, (byte)0x00, (byte)0x02, (byte)0xff, (byte)0x00, (byte)0x06, (byte)0xfe, (byte)0x00, (byte)0x0b, (byte)0xff,
 (byte)0x00, (byte)0x0f, (byte)0xfe, (byte)0x00, (byte)0x14, (byte)0xff, (byte)0x00, (byte)0x18, (byte)0xfe, (byte)0x00, (byte)0x1d, (byte)0xff,
 (byte)0x00, (byte)0x21, (byte)0xfe, (byte)0x00, (byte)0x26, (byte)0xff, (byte)0x00, (byte)0x2a, (byte)0xfe, (byte)0x00, (byte)0x2f, (byte)0xff,
 (byte)0x00, (byte)0x33, (byte)0xfe, (byte)0x00, (byte)0x38, (byte)0xff, (byte)0x00, (byte)0x3c, (byte)0xfe, (byte)0x00, (byte)0x41, (byte)0xff,
 (byte)0x00, (byte)0x45, (byte)0xfe, (byte)0x00, (byte)0x4a, (byte)0xff, (byte)0x00, (byte)0x4e, (byte)0xfe, (byte)0x00, (byte)0x53, (byte)0xff,
 (byte)0x00, (byte)0x57, (byte)0xfe, (byte)0x00, (byte)0x5c, (byte)0xff, (byte)0x00, (byte)0x60, (byte)0xfe, (byte)0x00, (byte)0x65, (byte)0xff,
 (byte)0x00, (byte)0x69, (byte)0xfe, (byte)0x00, (byte)0x6e, (byte)0xff, (byte)0x00, (byte)0x72, (byte)0xfe, (byte)0x00, (byte)0x77, (byte)0xff,
 (byte)0x00, (byte)0x7a, (byte)0xfe, (byte)0x00, (byte)0x80, (byte)0xff, (byte)0x00, (byte)0x83, (byte)0xfe, (byte)0x00, (byte)0x89, (byte)0xff,
 (byte)0x00, (byte)0x8c, (byte)0xfe, (byte)0x00, (byte)0x92, (byte)0xff, (byte)0x00, (byte)0x95, (byte)0xfe, (byte)0x00, (byte)0x9b, (byte)0xff,
 (byte)0x00, (byte)0x9e, (byte)0xfe, (byte)0x00, (byte)0xa4, (byte)0xff, (byte)0x00, (byte)0xa7, (byte)0xfe, (byte)0x00, (byte)0xad, (byte)0xff,
 (byte)0x00, (byte)0xb0, (byte)0xfe, (byte)0x00, (byte)0xb6, (byte)0xff, (byte)0x00, (byte)0xb9, (byte)0xfe, (byte)0x00, (byte)0xbf, (byte)0xff,
 (byte)0x00, (byte)0xc2, (byte)0xfe, (byte)0x00, (byte)0xc8, (byte)0xff, (byte)0x00, (byte)0xcb, (byte)0xfe, (byte)0x00, (byte)0xd1, (byte)0xff,
 (byte)0x00, (byte)0xd4, (byte)0xfe, (byte)0x00, (byte)0xda, (byte)0xff, (byte)0x00, (byte)0xdd, (byte)0xfe, (byte)0x00, (byte)0xe3, (byte)0xff,
 (byte)0x00, (byte)0xe6, (byte)0xfe, (byte)0x00, (byte)0xec, (byte)0xff, (byte)0x00, (byte)0xf0, (byte)0xfe, (byte)0x00, (byte)0xf5, (byte)0xff,
 (byte)0x00, (byte)0xf9, (byte)0xfe, (byte)0x00, (byte)0xfe, (byte)0xff, (byte)0x00, (byte)0xfe, (byte)0xfa, (byte)0x00, (byte)0xff, (byte)0xf7,
 (byte)0x00, (byte)0xfe, (byte)0xf1, (byte)0x00, (byte)0xff, (byte)0xee, (byte)0x00, (byte)0xfe, (byte)0xe8, (byte)0x00, (byte)0xff, (byte)0xe5,
 (byte)0x00, (byte)0xfe, (byte)0xdf, (byte)0x00, (byte)0xff, (byte)0xdc, (byte)0x00, (byte)0xfe, (byte)0xd6, (byte)0x00, (byte)0xff, (byte)0xd3,
 (byte)0x00, (byte)0xfe, (byte)0xcd, (byte)0x00, (byte)0xff, (byte)0xca, (byte)0x00, (byte)0xfe, (byte)0xc4, (byte)0x00, (byte)0xff, (byte)0xc1,
 (byte)0x00, (byte)0xfe, (byte)0xbb, (byte)0x00, (byte)0xff, (byte)0xb8, (byte)0x00, (byte)0xfe, (byte)0xb2, (byte)0x00, (byte)0xff, (byte)0xaf,
 (byte)0x00, (byte)0xfe, (byte)0xa9, (byte)0x00, (byte)0xff, (byte)0xa6, (byte)0x00, (byte)0xfe, (byte)0xa0, (byte)0x00, (byte)0xff, (byte)0x9d,
 (byte)0x00, (byte)0xfe, (byte)0x97, (byte)0x00, (byte)0xff, (byte)0x94, (byte)0x00, (byte)0xfe, (byte)0x8e, (byte)0x00, (byte)0xff, (byte)0x8b,
 (byte)0x00, (byte)0xfe, (byte)0x85, (byte)0x00, (byte)0xff, (byte)0x82, (byte)0x00, (byte)0xfe, (byte)0x7d, (byte)0x00, (byte)0xff, (byte)0x79,
 (byte)0x00, (byte)0xfe, (byte)0x74, (byte)0x00, (byte)0xff, (byte)0x70, (byte)0x00, (byte)0xfe, (byte)0x6b, (byte)0x00, (byte)0xff, (byte)0x67,
 (byte)0x00, (byte)0xfe, (byte)0x62, (byte)0x00, (byte)0xff, (byte)0x5e, (byte)0x00, (byte)0xfe, (byte)0x59, (byte)0x00, (byte)0xff, (byte)0x55,
 (byte)0x00, (byte)0xfe, (byte)0x50, (byte)0x00, (byte)0xff, (byte)0x4c, (byte)0x00, (byte)0xfe, (byte)0x47, (byte)0x00, (byte)0xff, (byte)0x43,
 (byte)0x00, (byte)0xfe, (byte)0x3e, (byte)0x00, (byte)0xff, (byte)0x3a, (byte)0x00, (byte)0xfe, (byte)0x35, (byte)0x00, (byte)0xff, (byte)0x31,
 (byte)0x00, (byte)0xfe, (byte)0x2c, (byte)0x00, (byte)0xff, (byte)0x28, (byte)0x00, (byte)0xfe, (byte)0x23, (byte)0x00, (byte)0xff, (byte)0x1f,
 (byte)0x00, (byte)0xfe, (byte)0x1a, (byte)0x00, (byte)0xff, (byte)0x16, (byte)0x00, (byte)0xfe, (byte)0x11, (byte)0x00, (byte)0xff, (byte)0x0d,
 (byte)0x00, (byte)0xfe, (byte)0x08, (byte)0x00, (byte)0xff, (byte)0x04, (byte)0x01, (byte)0xfe, (byte)0x00, (byte)0x05, (byte)0xff, (byte)0x00,
 (byte)0x0a, (byte)0xfe, (byte)0x00, (byte)0x0e, (byte)0xff, (byte)0x00, (byte)0x13, (byte)0xfe, (byte)0x00, (byte)0x17, (byte)0xff, (byte)0x00,
 (byte)0x1c, (byte)0xfe, (byte)0x00, (byte)0x20, (byte)0xff, (byte)0x00, (byte)0x25, (byte)0xfe, (byte)0x00, (byte)0x29, (byte)0xff, (byte)0x00,
 (byte)0x2e, (byte)0xfe, (byte)0x00, (byte)0x32, (byte)0xff, (byte)0x00, (byte)0x37, (byte)0xfe, (byte)0x00, (byte)0x3b, (byte)0xff, (byte)0x00,
 (byte)0x40, (byte)0xfe, (byte)0x00, (byte)0x44, (byte)0xff, (byte)0x00, (byte)0x49, (byte)0xfe, (byte)0x00, (byte)0x4d, (byte)0xff, (byte)0x00,
 (byte)0x52, (byte)0xfe, (byte)0x00, (byte)0x56, (byte)0xff, (byte)0x00, (byte)0x5b, (byte)0xfe, (byte)0x00, (byte)0x5f, (byte)0xff, (byte)0x00,
 (byte)0x64, (byte)0xfe, (byte)0x00, (byte)0x68, (byte)0xff, (byte)0x00, (byte)0x6d, (byte)0xfe, (byte)0x00, (byte)0x71, (byte)0xff, (byte)0x00,
 (byte)0x76, (byte)0xfe, (byte)0x00, (byte)0x7b, (byte)0xff, (byte)0x00, (byte)0x7e, (byte)0xfe, (byte)0x00, (byte)0x84, (byte)0xff, (byte)0x00,
 (byte)0x87, (byte)0xfe, (byte)0x00, (byte)0x8d, (byte)0xff, (byte)0x00, (byte)0x90, (byte)0xfe, (byte)0x00, (byte)0x96, (byte)0xff, (byte)0x00,
 (byte)0x99, (byte)0xfe, (byte)0x00, (byte)0x9f, (byte)0xff, (byte)0x00, (byte)0xa2, (byte)0xfe, (byte)0x00, (byte)0xa8, (byte)0xff, (byte)0x00,
 (byte)0xab, (byte)0xfe, (byte)0x00, (byte)0xb1, (byte)0xff, (byte)0x00, (byte)0xb4, (byte)0xfe, (byte)0x00, (byte)0xba, (byte)0xff, (byte)0x00,
 (byte)0xbd, (byte)0xfe, (byte)0x00, (byte)0xc3, (byte)0xff, (byte)0x00, (byte)0xc6, (byte)0xfe, (byte)0x00, (byte)0xcc, (byte)0xff, (byte)0x00,
 (byte)0xcf, (byte)0xfe, (byte)0x00, (byte)0xd5, (byte)0xff, (byte)0x00, (byte)0xd8, (byte)0xfe, (byte)0x00, (byte)0xde, (byte)0xff, (byte)0x00,
 (byte)0xe1, (byte)0xfe, (byte)0x00, (byte)0xe7, (byte)0xff, (byte)0x00, (byte)0xea, (byte)0xfe, (byte)0x00, (byte)0xf0, (byte)0xff, (byte)0x00,
 (byte)0xf3, (byte)0xfe, (byte)0x00, (byte)0xf9, (byte)0xff, (byte)0x00, (byte)0xfc, (byte)0xfe, (byte)0x00, (byte)0xff, (byte)0xfc, (byte)0x00,
 (byte)0xfe, (byte)0xf7, (byte)0x00, (byte)0xff, (byte)0xf3, (byte)0x00, (byte)0xfe, (byte)0xee, (byte)0x00, (byte)0xff, (byte)0xea, (byte)0x00,
 (byte)0xfe, (byte)0xe5, (byte)0x00, (byte)0xff, (byte)0xe1, (byte)0x00, (byte)0xfe, (byte)0xdc, (byte)0x00, (byte)0xff, (byte)0xd8, (byte)0x00,
 (byte)0xfe, (byte)0xd3, (byte)0x00, (byte)0xff, (byte)0xcf, (byte)0x00, (byte)0xfe, (byte)0xca, (byte)0x00, (byte)0xff, (byte)0xc6, (byte)0x00,
 (byte)0xfe, (byte)0xc1, (byte)0x00, (byte)0xff, (byte)0xbd, (byte)0x00, (byte)0xfe, (byte)0xb8, (byte)0x00, (byte)0xff, (byte)0xb4, (byte)0x00,
 (byte)0xfe, (byte)0xaf, (byte)0x00, (byte)0xff, (byte)0xab, (byte)0x00, (byte)0xfe, (byte)0xa6, (byte)0x00, (byte)0xff, (byte)0xa2, (byte)0x00,
 (byte)0xfe, (byte)0x9d, (byte)0x00, (byte)0xff, (byte)0x99, (byte)0x00, (byte)0xfe, (byte)0x94, (byte)0x00, (byte)0xff, (byte)0x90, (byte)0x00,
 (byte)0xfe, (byte)0x8b, (byte)0x00, (byte)0xff, (byte)0x87, (byte)0x00, (byte)0xfe, (byte)0x83, (byte)0x00, (byte)0xff, (byte)0x7e, (byte)0x00,
 (byte)0xfe, (byte)0x7a, (byte)0x00, (byte)0xff, (byte)0x75, (byte)0x00, (byte)0xfe, (byte)0x71, (byte)0x00, (byte)0xff, (byte)0x6c, (byte)0x00,
 (byte)0xfe, (byte)0x68, (byte)0x00, (byte)0xff, (byte)0x63, (byte)0x00, (byte)0xfe, (byte)0x5f, (byte)0x00, (byte)0xff, (byte)0x5a, (byte)0x00,
 (byte)0xfe, (byte)0x56, (byte)0x00, (byte)0xff, (byte)0x51, (byte)0x00, (byte)0xfe, (byte)0x4d, (byte)0x00, (byte)0xff, (byte)0x48, (byte)0x00,
 (byte)0xfe, (byte)0x44, (byte)0x00, (byte)0xff, (byte)0x3f, (byte)0x00, (byte)0xfe, (byte)0x3b, (byte)0x00, (byte)0xff, (byte)0x36, (byte)0x00,
 (byte)0xfe, (byte)0x32, (byte)0x00, (byte)0xff, (byte)0x2d, (byte)0x00, (byte)0xfe, (byte)0x29, (byte)0x00, (byte)0xff, (byte)0x24, (byte)0x00,
 (byte)0xfe, (byte)0x20, (byte)0x00, (byte)0xff, (byte)0x1b, (byte)0x00, (byte)0xfe, (byte)0x17, (byte)0x00, (byte)0xff, (byte)0x12, (byte)0x00,
 (byte)0xfe, (byte)0x0e, (byte)0x00, (byte)0xff, (byte)0x09, (byte)0x00, (byte)0xff, (byte)0x05, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff };

	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)rainbowValues[i*3];

	    // for  greens
	    greens[i] = (byte)rainbowValues[i*3+1];

	    // for blues
	    blues[i]  = (byte)rainbowValues[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());


  }

    // set tnew palette by specified RGB values
    public void setPalette(byte[] rgb) {

	// new default rgb
	pushPaletteValue();
	
	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)rgb[i*3];

	    // for  greens
	    greens[i] = (byte)rgb[i*3+1];

	    // for blues
	    blues[i]  = (byte)rgb[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());

  }

    // set the banded rainbow palette
    public void setBandedRainbowPalette() {

	// new default rgb
	pushPaletteValue();
	
	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] rainbowValues = {  // RGB

   (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x2e, (byte)0x06, (byte)0x46, (byte)0x34, (byte)0x07, (byte)0x50, (byte)0x3d, (byte)0x09, (byte)0x61,
   (byte)0x48, (byte)0x0b, (byte)0x76, (byte)0x54, (byte)0x0d, (byte)0x8d, (byte)0x5f, (byte)0x0f, (byte)0xa4, (byte)0x68, (byte)0x11, (byte)0xb9,
   (byte)0x6e, (byte)0x13, (byte)0xc9, (byte)0x70, (byte)0x14, (byte)0xd4, (byte)0x6f, (byte)0x14, (byte)0xd7, (byte)0x69, (byte)0x14, (byte)0xd3,
   (byte)0x61, (byte)0x13, (byte)0xc9, (byte)0x56, (byte)0x11, (byte)0xb8, (byte)0x49, (byte)0x0f, (byte)0xa4, (byte)0x3d, (byte)0x0d, (byte)0x8d,
   (byte)0x31, (byte)0x0b, (byte)0x75, (byte)0x26, (byte)0x09, (byte)0x61, (byte)0x1f, (byte)0x07, (byte)0x50, (byte)0x19, (byte)0x06, (byte)0x46,
   (byte)0x17, (byte)0x06, (byte)0x42, (byte)0x17, (byte)0x06, (byte)0x46, (byte)0x19, (byte)0x07, (byte)0x50, (byte)0x1d, (byte)0x09, (byte)0x61,
   (byte)0x21, (byte)0x0b, (byte)0x76, (byte)0x25, (byte)0x0d, (byte)0x8d, (byte)0x29, (byte)0x0f, (byte)0xa4, (byte)0x2b, (byte)0x11, (byte)0xb9,
   (byte)0x2c, (byte)0x13, (byte)0xc9, (byte)0x2a, (byte)0x14, (byte)0xd4, (byte)0x28, (byte)0x14, (byte)0xd7, (byte)0x23, (byte)0x14, (byte)0xd3,
   (byte)0x1e, (byte)0x13, (byte)0xc9, (byte)0x19, (byte)0x11, (byte)0xb8, (byte)0x13, (byte)0x0f, (byte)0xa4, (byte)0x0e, (byte)0x0d, (byte)0x8d,
   (byte)0x0b, (byte)0x0c, (byte)0x76, (byte)0x09, (byte)0x0b, (byte)0x61, (byte)0x07, (byte)0x0a, (byte)0x50, (byte)0x06, (byte)0x0a, (byte)0x46,
   (byte)0x06, (byte)0x0b, (byte)0x42, (byte)0x06, (byte)0x0c, (byte)0x46, (byte)0x07, (byte)0x10, (byte)0x50, (byte)0x09, (byte)0x15, (byte)0x61,
   (byte)0x0b, (byte)0x1b, (byte)0x75, (byte)0x0d, (byte)0x23, (byte)0x8d, (byte)0x0f, (byte)0x2b, (byte)0xa4, (byte)0x11, (byte)0x34, (byte)0xb8,
   (byte)0x13, (byte)0x3c, (byte)0xc9, (byte)0x14, (byte)0x43, (byte)0xd3, (byte)0x14, (byte)0x47, (byte)0xd7, (byte)0x14, (byte)0x4a, (byte)0xd4,
   (byte)0x13, (byte)0x49, (byte)0xc9, (byte)0x11, (byte)0x46, (byte)0xb9, (byte)0x0f, (byte)0x41, (byte)0xa4, (byte)0x0d, (byte)0x3a, (byte)0x8d,
   (byte)0x0b, (byte)0x33, (byte)0x76, (byte)0x09, (byte)0x2b, (byte)0x61, (byte)0x07, (byte)0x25, (byte)0x50, (byte)0x06, (byte)0x21, (byte)0x46,
   (byte)0x06, (byte)0x21, (byte)0x42, (byte)0x06, (byte)0x24, (byte)0x46, (byte)0x07, (byte)0x2a, (byte)0x50, (byte)0x09, (byte)0x35, (byte)0x61,
   (byte)0x0b, (byte)0x42, (byte)0x75, (byte)0x0d, (byte)0x51, (byte)0x8d, (byte)0x0f, (byte)0x61, (byte)0xa4, (byte)0x11, (byte)0x71, (byte)0xb8,
   (byte)0x13, (byte)0x7e, (byte)0xc9, (byte)0x14, (byte)0x88, (byte)0xd3, (byte)0x14, (byte)0x8e, (byte)0xd7, (byte)0x14, (byte)0x90, (byte)0xd4,
   (byte)0x13, (byte)0x8c, (byte)0xc9, (byte)0x11, (byte)0x83, (byte)0xb9, (byte)0x0f, (byte)0x77, (byte)0xa4, (byte)0x0d, (byte)0x69, (byte)0x8d,
   (byte)0x0b, (byte)0x59, (byte)0x76, (byte)0x09, (byte)0x4b, (byte)0x61, (byte)0x07, (byte)0x40, (byte)0x50, (byte)0x06, (byte)0x39, (byte)0x46,
   (byte)0x06, (byte)0x37, (byte)0x42, (byte)0x06, (byte)0x3b, (byte)0x46, (byte)0x07, (byte)0x45, (byte)0x50, (byte)0x09, (byte)0x55, (byte)0x61,
   (byte)0x0b, (byte)0x69, (byte)0x75, (byte)0x0d, (byte)0x80, (byte)0x8d, (byte)0x0f, (byte)0x98, (byte)0xa4, (byte)0x11, (byte)0xae, (byte)0xb8,
   (byte)0x13, (byte)0xc1, (byte)0xc9, (byte)0x14, (byte)0xce, (byte)0xd3, (byte)0x14, (byte)0xd6, (byte)0xd7, (byte)0x14, (byte)0xd4, (byte)0xd2,
   (byte)0x13, (byte)0xc9, (byte)0xc4, (byte)0x11, (byte)0xb9, (byte)0xb1, (byte)0x0f, (byte)0xa4, (byte)0x9a, (byte)0x0d, (byte)0x8d, (byte)0x82,
   (byte)0x0b, (byte)0x76, (byte)0x6b, (byte)0x09, (byte)0x61, (byte)0x56, (byte)0x07, (byte)0x50, (byte)0x46, (byte)0x06, (byte)0x46, (byte)0x3c,
   (byte)0x06, (byte)0x42, (byte)0x38, (byte)0x06, (byte)0x46, (byte)0x39, (byte)0x07, (byte)0x50, (byte)0x41, (byte)0x09, (byte)0x61, (byte)0x4c,
   (byte)0x0b, (byte)0x75, (byte)0x5b, (byte)0x0d, (byte)0x8d, (byte)0x6b, (byte)0x0f, (byte)0xa4, (byte)0x79, (byte)0x11, (byte)0xb8, (byte)0x86,
   (byte)0x13, (byte)0xc9, (byte)0x8e, (byte)0x14, (byte)0xd3, (byte)0x93, (byte)0x14, (byte)0xd7, (byte)0x92, (byte)0x14, (byte)0xd4, (byte)0x8c,
   (byte)0x13, (byte)0xc9, (byte)0x81, (byte)0x11, (byte)0xb9, (byte)0x74, (byte)0x0f, (byte)0xa4, (byte)0x64, (byte)0x0d, (byte)0x8d, (byte)0x53,
   (byte)0x0b, (byte)0x76, (byte)0x44, (byte)0x09, (byte)0x61, (byte)0x36, (byte)0x07, (byte)0x50, (byte)0x2c, (byte)0x06, (byte)0x46, (byte)0x25,
   (byte)0x06, (byte)0x42, (byte)0x22, (byte)0x06, (byte)0x46, (byte)0x22, (byte)0x07, (byte)0x50, (byte)0x26, (byte)0x09, (byte)0x61, (byte)0x2c,
   (byte)0x0b, (byte)0x75, (byte)0x34, (byte)0x0d, (byte)0x8d, (byte)0x3c, (byte)0x0f, (byte)0xa4, (byte)0x43, (byte)0x11, (byte)0xb8, (byte)0x49,
   (byte)0x13, (byte)0xc9, (byte)0x4c, (byte)0x14, (byte)0xd3, (byte)0x4d, (byte)0x14, (byte)0xd7, (byte)0x4a, (byte)0x14, (byte)0xd4, (byte)0x46,
   (byte)0x13, (byte)0xc9, (byte)0x3f, (byte)0x11, (byte)0xb9, (byte)0x37, (byte)0x0f, (byte)0xa4, (byte)0x2e, (byte)0x0d, (byte)0x8d, (byte)0x25,
   (byte)0x0b, (byte)0x76, (byte)0x1d, (byte)0x09, (byte)0x61, (byte)0x16, (byte)0x07, (byte)0x50, (byte)0x11, (byte)0x06, (byte)0x46, (byte)0x0d,
   (byte)0x06, (byte)0x42, (byte)0x0c, (byte)0x06, (byte)0x46, (byte)0x0b, (byte)0x07, (byte)0x50, (byte)0x0c, (byte)0x09, (byte)0x61, (byte)0x0c,
   (byte)0x0b, (byte)0x75, (byte)0x0d, (byte)0x0d, (byte)0x8d, (byte)0x0e, (byte)0x11, (byte)0xa4, (byte)0x0f, (byte)0x16, (byte)0xb8, (byte)0x11,
   (byte)0x1b, (byte)0xc9, (byte)0x13, (byte)0x20, (byte)0xd3, (byte)0x14, (byte)0x24, (byte)0xd7, (byte)0x14, (byte)0x27, (byte)0xd4, (byte)0x14,
   (byte)0x29, (byte)0xc9, (byte)0x13, (byte)0x28, (byte)0xb9, (byte)0x11, (byte)0x27, (byte)0xa4, (byte)0x0f, (byte)0x23, (byte)0x8d, (byte)0x0d,
   (byte)0x1f, (byte)0x76, (byte)0x0b, (byte)0x1b, (byte)0x61, (byte)0x09, (byte)0x18, (byte)0x50, (byte)0x07, (byte)0x16, (byte)0x46, (byte)0x06,
   (byte)0x16, (byte)0x42, (byte)0x06, (byte)0x18, (byte)0x46, (byte)0x06, (byte)0x1d, (byte)0x50, (byte)0x07, (byte)0x25, (byte)0x61, (byte)0x09,
   (byte)0x2f, (byte)0x75, (byte)0x0b, (byte)0x3b, (byte)0x8d, (byte)0x0d, (byte)0x47, (byte)0xa4, (byte)0x0f, (byte)0x53, (byte)0xb8, (byte)0x11,
   (byte)0x5e, (byte)0xc9, (byte)0x13, (byte)0x66, (byte)0xd3, (byte)0x14, (byte)0x6c, (byte)0xd7, (byte)0x14, (byte)0x6d, (byte)0xd4, (byte)0x14,
   (byte)0x6b, (byte)0xc9, (byte)0x13, (byte)0x65, (byte)0xb9, (byte)0x11, (byte)0x5d, (byte)0xa4, (byte)0x0f, (byte)0x52, (byte)0x8d, (byte)0x0d,
   (byte)0x46, (byte)0x76, (byte)0x0b, (byte)0x3c, (byte)0x61, (byte)0x09, (byte)0x33, (byte)0x50, (byte)0x07, (byte)0x2d, (byte)0x46, (byte)0x06,
   (byte)0x2c, (byte)0x42, (byte)0x06, (byte)0x2f, (byte)0x46, (byte)0x06, (byte)0x38, (byte)0x50, (byte)0x07, (byte)0x45, (byte)0x61, (byte)0x09,
   (byte)0x56, (byte)0x75, (byte)0x0b, (byte)0x69, (byte)0x8d, (byte)0x0d, (byte)0x7d, (byte)0xa4, (byte)0x0f, (byte)0x90, (byte)0xb8, (byte)0x11,
   (byte)0xa0, (byte)0xc9, (byte)0x13, (byte)0xac, (byte)0xd3, (byte)0x14, (byte)0xb3, (byte)0xd7, (byte)0x14, (byte)0xb3, (byte)0xd4, (byte)0x14,
   (byte)0xae, (byte)0xc9, (byte)0x13, (byte)0xa3, (byte)0xb9, (byte)0x11, (byte)0x93, (byte)0xa4, (byte)0x0f, (byte)0x80, (byte)0x8d, (byte)0x0d,
   (byte)0x6d, (byte)0x76, (byte)0x0b, (byte)0x5c, (byte)0x61, (byte)0x09, (byte)0x4d, (byte)0x50, (byte)0x07, (byte)0x44, (byte)0x46, (byte)0x06,
   (byte)0x42, (byte)0x42, (byte)0x06, (byte)0x46, (byte)0x45, (byte)0x06, (byte)0x50, (byte)0x4e, (byte)0x07, (byte)0x61, (byte)0x5c, (byte)0x09,
   (byte)0x75, (byte)0x6e, (byte)0x0b, (byte)0x8d, (byte)0x81, (byte)0x0d, (byte)0xa4, (byte)0x94, (byte)0x0f, (byte)0xb8, (byte)0xa4, (byte)0x11,
   (byte)0xc9, (byte)0xaf, (byte)0x13, (byte)0xd3, (byte)0xb5, (byte)0x14, (byte)0xd7, (byte)0xb4, (byte)0x14, (byte)0xd4, (byte)0xae, (byte)0x14,
   (byte)0xc9, (byte)0xa2, (byte)0x13, (byte)0xb9, (byte)0x92, (byte)0x11, (byte)0xa4, (byte)0x7f, (byte)0x0f, (byte)0x8d, (byte)0x6a, (byte)0x0d,
   (byte)0x76, (byte)0x57, (byte)0x0b, (byte)0x61, (byte)0x46, (byte)0x09, (byte)0x50, (byte)0x39, (byte)0x07, (byte)0x46, (byte)0x30, (byte)0x06,
   (byte)0x42, (byte)0x2c, (byte)0x06, (byte)0x46, (byte)0x2e, (byte)0x06, (byte)0x50, (byte)0x33, (byte)0x07, (byte)0x61, (byte)0x3c, (byte)0x09,
   (byte)0x75, (byte)0x47, (byte)0x0b, (byte)0x8d, (byte)0x53, (byte)0x0d, (byte)0xa4, (byte)0x5e, (byte)0x0f, (byte)0xb8, (byte)0x67, (byte)0x11,
   (byte)0xc9, (byte)0x6d, (byte)0x13, (byte)0xd3, (byte)0x6f, (byte)0x14, (byte)0xd7, (byte)0x6d, (byte)0x14, (byte)0xd4, (byte)0x68, (byte)0x14,
   (byte)0xc9, (byte)0x5f, (byte)0x13, (byte)0xb9, (byte)0x55, (byte)0x11, (byte)0xa4, (byte)0x48, (byte)0x0f, (byte)0x8d, (byte)0x3c, (byte)0x0d,
   (byte)0x76, (byte)0x30, (byte)0x0b, (byte)0x61, (byte)0x26, (byte)0x09, (byte)0x50, (byte)0x1e, (byte)0x07, (byte)0x46, (byte)0x19, (byte)0x06,
   (byte)0x42, (byte)0x16, (byte)0x06, (byte)0x46, (byte)0x16, (byte)0x06, (byte)0x50, (byte)0x19, (byte)0x07, (byte)0x61, (byte)0x1c, (byte)0x09,
   (byte)0x75, (byte)0x20, (byte)0x0b, (byte)0x8d, (byte)0x24, (byte)0x0d, (byte)0xa4, (byte)0x28, (byte)0x0f, (byte)0xb8, (byte)0x2a, (byte)0x11,
   (byte)0xc9, (byte)0x2a, (byte)0x13, (byte)0xd3, (byte)0x29, (byte)0x14, (byte)0xd7, (byte)0x26, (byte)0x14, (byte)0xd4, (byte)0x22, (byte)0x14,
   (byte)0xc9, (byte)0x1d, (byte)0x13, (byte)0xb9, (byte)0x17, (byte)0x11, (byte)0xa4, (byte)0x12, (byte)0x0f, (byte)0xff, (byte)0xff, (byte)0xff };

  
	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)rainbowValues[i*3];

	    // for  greens
	    greens[i] = (byte)rainbowValues[i*3+1];

	    // for blues
	    blues[i]  = (byte)rainbowValues[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());

	// new default rgb
	// pushPaletteValue();
  }

    // set the inverted  rainbow palette
    public void setInvertedRainbowPalette() {

	// new default rgb
	pushPaletteValue();

	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] rainbowValues = {  // RGB

   (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0x05, (byte)0x00, (byte)0xfe, (byte)0x08, (byte)0x00, (byte)0xff, (byte)0x0e, (byte)0x00,
   (byte)0xfe, (byte)0x11, (byte)0x00, (byte)0xff, (byte)0x17, (byte)0x00, (byte)0xfe, (byte)0x1a, (byte)0x00, (byte)0xff, (byte)0x20, (byte)0x00,
   (byte)0xfe, (byte)0x23, (byte)0x00, (byte)0xff, (byte)0x29, (byte)0x00, (byte)0xfe, (byte)0x2c, (byte)0x00, (byte)0xff, (byte)0x32, (byte)0x00,
   (byte)0xfe, (byte)0x35, (byte)0x00, (byte)0xff, (byte)0x3b, (byte)0x00, (byte)0xfe, (byte)0x3e, (byte)0x00, (byte)0xff, (byte)0x44, (byte)0x00,
   (byte)0xfe, (byte)0x47, (byte)0x00, (byte)0xff, (byte)0x4d, (byte)0x00, (byte)0xfe, (byte)0x50, (byte)0x00, (byte)0xff, (byte)0x56, (byte)0x00,
   (byte)0xfe, (byte)0x59, (byte)0x00, (byte)0xff, (byte)0x5f, (byte)0x00, (byte)0xfe, (byte)0x62, (byte)0x00, (byte)0xff, (byte)0x68, (byte)0x00,
   (byte)0xfe, (byte)0x6b, (byte)0x00, (byte)0xff, (byte)0x71, (byte)0x00, (byte)0xfe, (byte)0x74, (byte)0x00, (byte)0xff, (byte)0x7a, (byte)0x00,
   (byte)0xfe, (byte)0x7d, (byte)0x00, (byte)0xff, (byte)0x83, (byte)0x00, (byte)0xfe, (byte)0x86, (byte)0x00, (byte)0xff, (byte)0x8b, (byte)0x00,
   (byte)0xfe, (byte)0x8f, (byte)0x00, (byte)0xff, (byte)0x94, (byte)0x00, (byte)0xfe, (byte)0x98, (byte)0x00, (byte)0xff, (byte)0x9d, (byte)0x00,
   (byte)0xfe, (byte)0xa1, (byte)0x00, (byte)0xff, (byte)0xa6, (byte)0x00, (byte)0xfe, (byte)0xaa, (byte)0x00, (byte)0xff, (byte)0xaf, (byte)0x00,
   (byte)0xfe, (byte)0xb3, (byte)0x00, (byte)0xff, (byte)0xb8, (byte)0x00, (byte)0xfe, (byte)0xbc, (byte)0x00, (byte)0xff, (byte)0xc1, (byte)0x00,
   (byte)0xfe, (byte)0xc5, (byte)0x00, (byte)0xff, (byte)0xca, (byte)0x00, (byte)0xfe, (byte)0xce, (byte)0x00, (byte)0xff, (byte)0xd3, (byte)0x00,
   (byte)0xfe, (byte)0xd7, (byte)0x00, (byte)0xff, (byte)0xdc, (byte)0x00, (byte)0xfe, (byte)0xe0, (byte)0x00, (byte)0xff, (byte)0xe5, (byte)0x00,
   (byte)0xfe, (byte)0xe9, (byte)0x00, (byte)0xff, (byte)0xee, (byte)0x00, (byte)0xfe, (byte)0xf2, (byte)0x00, (byte)0xff, (byte)0xf7, (byte)0x00,
   (byte)0xfe, (byte)0xfb, (byte)0x00, (byte)0xfd, (byte)0xff, (byte)0x00, (byte)0xf8, (byte)0xfe, (byte)0x00, (byte)0xf3, (byte)0xff, (byte)0x00,
   (byte)0xef, (byte)0xfe, (byte)0x00, (byte)0xea, (byte)0xff, (byte)0x00, (byte)0xe6, (byte)0xfe, (byte)0x00, (byte)0xe1, (byte)0xff, (byte)0x00,
   (byte)0xdd, (byte)0xfe, (byte)0x00, (byte)0xd8, (byte)0xff, (byte)0x00, (byte)0xd4, (byte)0xfe, (byte)0x00, (byte)0xcf, (byte)0xff, (byte)0x00,
   (byte)0xcb, (byte)0xfe, (byte)0x00, (byte)0xc6, (byte)0xff, (byte)0x00, (byte)0xc2, (byte)0xfe, (byte)0x00, (byte)0xbd, (byte)0xff, (byte)0x00,
   (byte)0xb9, (byte)0xfe, (byte)0x00, (byte)0xb4, (byte)0xff, (byte)0x00, (byte)0xb0, (byte)0xfe, (byte)0x00, (byte)0xab, (byte)0xff, (byte)0x00,
  (byte)0xa7, (byte)0xfe, (byte)0x00, (byte)0xa2, (byte)0xff, (byte)0x00, (byte)0x9e, (byte)0xfe, (byte)0x00, (byte)0x99, (byte)0xff, (byte)0x00,
   (byte)0x95, (byte)0xfe, (byte)0x00, (byte)0x90, (byte)0xff, (byte)0x00, (byte)0x8c, (byte)0xfe, (byte)0x00, (byte)0x87, (byte)0xff, (byte)0x00,
   (byte)0x83, (byte)0xfe, (byte)0x00, (byte)0x7e, (byte)0xff, (byte)0x00, (byte)0x7a, (byte)0xfe, (byte)0x00, (byte)0x76, (byte)0xff, (byte)0x00,
   (byte)0x70, (byte)0xfe, (byte)0x00, (byte)0x6d, (byte)0xff, (byte)0x00, (byte)0x67, (byte)0xfe, (byte)0x00, (byte)0x64, (byte)0xff, (byte)0x00,
   (byte)0x5e, (byte)0xfe, (byte)0x00, (byte)0x5b, (byte)0xff, (byte)0x00, (byte)0x55, (byte)0xfe, (byte)0x00, (byte)0x52, (byte)0xff, (byte)0x00,
   (byte)0x4c, (byte)0xfe, (byte)0x00, (byte)0x49, (byte)0xff, (byte)0x00, (byte)0x43, (byte)0xfe, (byte)0x00, (byte)0x40, (byte)0xff, (byte)0x00,
   (byte)0x3a, (byte)0xfe, (byte)0x00, (byte)0x37, (byte)0xff, (byte)0x00, (byte)0x31, (byte)0xfe, (byte)0x00, (byte)0x2e, (byte)0xff, (byte)0x00,
   (byte)0x28, (byte)0xfe, (byte)0x00, (byte)0x25, (byte)0xff, (byte)0x00, (byte)0x1f, (byte)0xfe, (byte)0x00, (byte)0x1c, (byte)0xff, (byte)0x00,
   (byte)0x16, (byte)0xfe, (byte)0x00, (byte)0x13, (byte)0xff, (byte)0x00, (byte)0x0d, (byte)0xfe, (byte)0x00, (byte)0x0a, (byte)0xff, (byte)0x00,
   (byte)0x04, (byte)0xfe, (byte)0x00, (byte)0x01, (byte)0xff, (byte)0x00, (byte)0x00, (byte)0xfe, (byte)0x03, (byte)0x00, (byte)0xff, (byte)0x08,
   (byte)0x00, (byte)0xfe, (byte)0x0c, (byte)0x00, (byte)0xff, (byte)0x11, (byte)0x00, (byte)0xfe, (byte)0x15, (byte)0x00, (byte)0xff, (byte)0x1a,
   (byte)0x00, (byte)0xfe, (byte)0x1e, (byte)0x00, (byte)0xff, (byte)0x23, (byte)0x00, (byte)0xfe, (byte)0x27, (byte)0x00, (byte)0xff, (byte)0x2c,
   (byte)0x00, (byte)0xfe, (byte)0x30, (byte)0x00, (byte)0xff, (byte)0x35, (byte)0x00, (byte)0xfe, (byte)0x39, (byte)0x00, (byte)0xff, (byte)0x3e,
   (byte)0x00, (byte)0xfe, (byte)0x42, (byte)0x00, (byte)0xff, (byte)0x47, (byte)0x00, (byte)0xfe, (byte)0x4b, (byte)0x00, (byte)0xff, (byte)0x50,
   (byte)0x00, (byte)0xfe, (byte)0x54, (byte)0x00, (byte)0xff, (byte)0x59, (byte)0x00, (byte)0xfe, (byte)0x5d, (byte)0x00, (byte)0xff, (byte)0x62,
   (byte)0x00, (byte)0xfe, (byte)0x66, (byte)0x00, (byte)0xff, (byte)0x6b, (byte)0x00, (byte)0xfe, (byte)0x6f, (byte)0x00, (byte)0xff, (byte)0x74,
   (byte)0x00, (byte)0xfe, (byte)0x78, (byte)0x00, (byte)0xff, (byte)0x7d, (byte)0x00, (byte)0xfe, (byte)0x81, (byte)0x00, (byte)0xff, (byte)0x85,
   (byte)0x00, (byte)0xfe, (byte)0x8a, (byte)0x00, (byte)0xff, (byte)0x8e, (byte)0x00, (byte)0xfe, (byte)0x93, (byte)0x00, (byte)0xff, (byte)0x97,
   (byte)0x00, (byte)0xfe, (byte)0x9c, (byte)0x00, (byte)0xff, (byte)0xa0, (byte)0x00, (byte)0xfe, (byte)0xa5, (byte)0x00, (byte)0xff, (byte)0xa9,
   (byte)0x00, (byte)0xfe, (byte)0xae, (byte)0x00, (byte)0xff, (byte)0xb2, (byte)0x00, (byte)0xfe, (byte)0xb7, (byte)0x00, (byte)0xff, (byte)0xbb,
   (byte)0x00, (byte)0xfe, (byte)0xc0, (byte)0x00, (byte)0xff, (byte)0xc4, (byte)0x00, (byte)0xfe, (byte)0xc9, (byte)0x00, (byte)0xff, (byte)0xcd,
   (byte)0x00, (byte)0xfe, (byte)0xd2, (byte)0x00, (byte)0xff, (byte)0xd6, (byte)0x00, (byte)0xfe, (byte)0xdb, (byte)0x00, (byte)0xff, (byte)0xdf,
   (byte)0x00, (byte)0xfe, (byte)0xe4, (byte)0x00, (byte)0xff, (byte)0xe8, (byte)0x00, (byte)0xfe, (byte)0xed, (byte)0x00, (byte)0xff, (byte)0xf1,
   (byte)0x00, (byte)0xfe, (byte)0xf6, (byte)0x00, (byte)0xff, (byte)0xfa, (byte)0x00, (byte)0xfd, (byte)0xfe, (byte)0x00, (byte)0xf9, (byte)0xff,
   (byte)0x00, (byte)0xf4, (byte)0xfe, (byte)0x00, (byte)0xf0, (byte)0xff, (byte)0x00, (byte)0xeb, (byte)0xfe, (byte)0x00, (byte)0xe6, (byte)0xff,
   (byte)0x00, (byte)0xe2, (byte)0xfe, (byte)0x00, (byte)0xdd, (byte)0xff, (byte)0x00, (byte)0xd9, (byte)0xfe, (byte)0x00, (byte)0xd4, (byte)0xff,
   (byte)0x00, (byte)0xd0, (byte)0xfe, (byte)0x00, (byte)0xcb, (byte)0xff, (byte)0x00, (byte)0xc7, (byte)0xfe, (byte)0x00, (byte)0xc2, (byte)0xff,
   (byte)0x00, (byte)0xbe, (byte)0xfe, (byte)0x00, (byte)0xb9, (byte)0xff, (byte)0x00, (byte)0xb5, (byte)0xfe, (byte)0x00, (byte)0xb0, (byte)0xff,
   (byte)0x00, (byte)0xac, (byte)0xfe, (byte)0x00, (byte)0xa7, (byte)0xff, (byte)0x00, (byte)0xa3, (byte)0xfe, (byte)0x00, (byte)0x9e, (byte)0xff,
   (byte)0x00, (byte)0x9a, (byte)0xfe, (byte)0x00, (byte)0x95, (byte)0xff, (byte)0x00, (byte)0x91, (byte)0xfe, (byte)0x00, (byte)0x8c, (byte)0xff,
   (byte)0x00, (byte)0x88, (byte)0xfe, (byte)0x00, (byte)0x83, (byte)0xff, (byte)0x00, (byte)0x7f, (byte)0xfe, (byte)0x00, (byte)0x7a, (byte)0xff,
   (byte)0x00, (byte)0x76, (byte)0xfe, (byte)0x00, (byte)0x72, (byte)0xff, (byte)0x00, (byte)0x6d, (byte)0xfe, (byte)0x00, (byte)0x69, (byte)0xff,
   (byte)0x00, (byte)0x64, (byte)0xfe, (byte)0x00, (byte)0x60, (byte)0xff, (byte)0x00, (byte)0x5b, (byte)0xfe, (byte)0x00, (byte)0x57, (byte)0xff,
   (byte)0x00, (byte)0x52, (byte)0xfe, (byte)0x00, (byte)0x4e, (byte)0xff, (byte)0x00, (byte)0x49, (byte)0xfe, (byte)0x00, (byte)0x45, (byte)0xff,
   (byte)0x00, (byte)0x40, (byte)0xfe, (byte)0x00, (byte)0x3c, (byte)0xff, (byte)0x00, (byte)0x37, (byte)0xfe, (byte)0x00, (byte)0x33, (byte)0xff,
   (byte)0x00, (byte)0x2e, (byte)0xfe, (byte)0x00, (byte)0x2a, (byte)0xff, (byte)0x00, (byte)0x25, (byte)0xfe, (byte)0x00, (byte)0x21, (byte)0xff,
   (byte)0x00, (byte)0x1c, (byte)0xfe, (byte)0x00, (byte)0x18, (byte)0xff, (byte)0x00, (byte)0x13, (byte)0xfe, (byte)0x00, (byte)0x0f, (byte)0xff,
   (byte)0x00, (byte)0x0a, (byte)0xfe, (byte)0x00, (byte)0x06, (byte)0xff, (byte)0x00, (byte)0x01, (byte)0xfe, (byte)0x03, (byte)0x00, (byte)0xff,
   (byte)0x06, (byte)0x00, (byte)0xfe, (byte)0x0c, (byte)0x00, (byte)0xff, (byte)0x0f, (byte)0x00, (byte)0xfe, (byte)0x15, (byte)0x00, (byte)0xff,
   (byte)0x18, (byte)0x00, (byte)0xfe, (byte)0x1e, (byte)0x00, (byte)0xff, (byte)0x21, (byte)0x00, (byte)0xfe, (byte)0x27, (byte)0x00, (byte)0xff,
   (byte)0x2a, (byte)0x00, (byte)0xfe, (byte)0x30, (byte)0x00, (byte)0xff, (byte)0x33, (byte)0x00, (byte)0xfe, (byte)0x39, (byte)0x00, (byte)0xff,
   (byte)0x3c, (byte)0x00, (byte)0xfe, (byte)0x42, (byte)0x00, (byte)0xff, (byte)0x45, (byte)0x00, (byte)0xfe, (byte)0x4b, (byte)0x00, (byte)0xff,
   (byte)0x4e, (byte)0x00, (byte)0xfe, (byte)0x54, (byte)0x00, (byte)0xff, (byte)0x57, (byte)0x00, (byte)0xfe, (byte)0x5d, (byte)0x00, (byte)0xff,
   (byte)0x60, (byte)0x00, (byte)0xfe, (byte)0x66, (byte)0x00, (byte)0xff, (byte)0x69, (byte)0x00, (byte)0xfe, (byte)0x6f, (byte)0x00, (byte)0xff,
   (byte)0x72, (byte)0x00, (byte)0xfe, (byte)0x78, (byte)0x00, (byte)0xff, (byte)0x7c, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0xff };

   
	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)rainbowValues[i*3];

	    // for  greens
	    greens[i] = (byte)rainbowValues[i*3+1];

	    // for blues
	    blues[i]  = (byte)rainbowValues[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());

  }

    // set the striped  rainbow palette
    public void setStripedRainbowPalette() {

	// new default rgb
	pushPaletteValue();

	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] rainbowValues = {  // RGB

   (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xbb, (byte)0x00, (byte)0xba, (byte)0xbd, (byte)0x00, (byte)0xbc, (byte)0xbf, (byte)0x00, (byte)0xbf,
   (byte)0xbc, (byte)0x00, (byte)0xc0, (byte)0xba, (byte)0x00, (byte)0xc0, (byte)0xb8, (byte)0x00, (byte)0xc1, (byte)0xb6, (byte)0x00, (byte)0xc2,
   (byte)0xb3, (byte)0x00, (byte)0xc3, (byte)0xb1, (byte)0x00, (byte)0xc3, (byte)0x8c, (byte)0x00, (byte)0x9d, (byte)0x8a, (byte)0x00, (byte)0x9d,
   (byte)0xaa, (byte)0x00, (byte)0xc6, (byte)0xa8, (byte)0x00, (byte)0xc6, (byte)0xa5, (byte)0x00, (byte)0xc7, (byte)0xa3, (byte)0x00, (byte)0xc8,
   (byte)0xa1, (byte)0x00, (byte)0xc9, (byte)0x9e, (byte)0x00, (byte)0xca, (byte)0x9c, (byte)0x00, (byte)0xca, (byte)0x9a, (byte)0x00, (byte)0xcb,
   (byte)0x79, (byte)0x00, (byte)0xa3, (byte)0x77, (byte)0x00, (byte)0xa4, (byte)0x93, (byte)0x00, (byte)0xcd, (byte)0x91, (byte)0x00, (byte)0xce,
   (byte)0x8e, (byte)0x00, (byte)0xcf, (byte)0x8c, (byte)0x00, (byte)0xd0, (byte)0x8a, (byte)0x00, (byte)0xd0, (byte)0x87, (byte)0x00, (byte)0xd1,
   (byte)0x85, (byte)0x00, (byte)0xd2, (byte)0x83, (byte)0x00, (byte)0xd3, (byte)0x67, (byte)0x00, (byte)0xa9, (byte)0x65, (byte)0x00, (byte)0xaa,
   (byte)0x7c, (byte)0x00, (byte)0xd5, (byte)0x7a, (byte)0x00, (byte)0xd6, (byte)0x77, (byte)0x00, (byte)0xd7, (byte)0x75, (byte)0x00, (byte)0xd7,
   (byte)0x73, (byte)0x00, (byte)0xd8, (byte)0x70, (byte)0x00, (byte)0xd9, (byte)0x6e, (byte)0x00, (byte)0xda, (byte)0x6c, (byte)0x00, (byte)0xda,
   (byte)0x54, (byte)0x00, (byte)0xaf, (byte)0x52, (byte)0x00, (byte)0xb0, (byte)0x65, (byte)0x00, (byte)0xdd, (byte)0x63, (byte)0x00, (byte)0xdd,
   (byte)0x60, (byte)0x00, (byte)0xde, (byte)0x5e, (byte)0x00, (byte)0xdf, (byte)0x5c, (byte)0x00, (byte)0xe0, (byte)0x59, (byte)0x00, (byte)0xe1,
   (byte)0x57, (byte)0x00, (byte)0xe1, (byte)0x55, (byte)0x00, (byte)0xe2, (byte)0x42, (byte)0x00, (byte)0xb5, (byte)0x40, (byte)0x00, (byte)0xb6,
   (byte)0x4e, (byte)0x00, (byte)0xe4, (byte)0x4c, (byte)0x00, (byte)0xe5, (byte)0x49, (byte)0x00, (byte)0xe6, (byte)0x47, (byte)0x00, (byte)0xe7,
   (byte)0x45, (byte)0x00, (byte)0xe7, (byte)0x42, (byte)0x00, (byte)0xe8, (byte)0x40, (byte)0x00, (byte)0xe9, (byte)0x3e, (byte)0x00, (byte)0xea,
   (byte)0x2f, (byte)0x00, (byte)0xbc, (byte)0x2e, (byte)0x00, (byte)0xbc, (byte)0x37, (byte)0x00, (byte)0xec, (byte)0x34, (byte)0x00, (byte)0xed,
   (byte)0x32, (byte)0x00, (byte)0xee, (byte)0x30, (byte)0x00, (byte)0xee, (byte)0x2e, (byte)0x00, (byte)0xef, (byte)0x2b, (byte)0x00, (byte)0xf0,
   (byte)0x29, (byte)0x00, (byte)0xf1, (byte)0x27, (byte)0x00, (byte)0xf1, (byte)0x1d, (byte)0x00, (byte)0xc2, (byte)0x1b, (byte)0x00, (byte)0xc2,
   (byte)0x20, (byte)0x00, (byte)0xf4, (byte)0x1d, (byte)0x00, (byte)0xf5, (byte)0x1b, (byte)0x00, (byte)0xf5, (byte)0x19, (byte)0x00, (byte)0xf6,
   (byte)0x17, (byte)0x00, (byte)0xf7, (byte)0x14, (byte)0x00, (byte)0xf8, (byte)0x12, (byte)0x00, (byte)0xf8, (byte)0x10, (byte)0x00, (byte)0xf9,
   (byte)0x0b, (byte)0x00, (byte)0xc8, (byte)0x09, (byte)0x00, (byte)0xc8, (byte)0x09, (byte)0x00, (byte)0xfb, (byte)0x06, (byte)0x00, (byte)0xfc,
   (byte)0x04, (byte)0x00, (byte)0xfd, (byte)0x02, (byte)0x00, (byte)0xfe, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0x00, (byte)0x06, (byte)0xff,
   (byte)0x00, (byte)0x0c, (byte)0xff, (byte)0x00, (byte)0x12, (byte)0xff, (byte)0x00, (byte)0x13, (byte)0xcc, (byte)0x00, (byte)0x18, (byte)0xcc,
   (byte)0x00, (byte)0x24, (byte)0xff, (byte)0x00, (byte)0x2a, (byte)0xff, (byte)0x00, (byte)0x30, (byte)0xff, (byte)0x00, (byte)0x36, (byte)0xff,
   (byte)0x00, (byte)0x3c, (byte)0xff, (byte)0x00, (byte)0x42, (byte)0xff, (byte)0x00, (byte)0x48, (byte)0xff, (byte)0x00, (byte)0x4e, (byte)0xff,
   (byte)0x00, (byte)0x44, (byte)0xcc, (byte)0x00, (byte)0x48, (byte)0xcc, (byte)0x00, (byte)0x61, (byte)0xff, (byte)0x00, (byte)0x67, (byte)0xff,
   (byte)0x00, (byte)0x6d, (byte)0xff, (byte)0x00, (byte)0x73, (byte)0xff, (byte)0x00, (byte)0x79, (byte)0xff, (byte)0x00, (byte)0x7f, (byte)0xff,
   (byte)0x00, (byte)0x85, (byte)0xff, (byte)0x00, (byte)0x8b, (byte)0xff, (byte)0x00, (byte)0x74, (byte)0xcc, (byte)0x00, (byte)0x79, (byte)0xcc,
   (byte)0x00, (byte)0x9d, (byte)0xff, (byte)0x00, (byte)0xa3, (byte)0xff, (byte)0x00, (byte)0xaa, (byte)0xff, (byte)0x00, (byte)0xb0, (byte)0xff,
   (byte)0x00, (byte)0xb6, (byte)0xff, (byte)0x00, (byte)0xbc, (byte)0xff, (byte)0x00, (byte)0xc2, (byte)0xff, (byte)0x00, (byte)0xc8, (byte)0xff,
   (byte)0x00, (byte)0xa5, (byte)0xcc, (byte)0x00, (byte)0xaa, (byte)0xcc, (byte)0x00, (byte)0xda, (byte)0xff, (byte)0x00, (byte)0xe0, (byte)0xff,
   (byte)0x00, (byte)0xe6, (byte)0xff, (byte)0x00, (byte)0xec, (byte)0xff, (byte)0x00, (byte)0xf2, (byte)0xff, (byte)0x00, (byte)0xf8, (byte)0xff,
   (byte)0x00, (byte)0xff, (byte)0xff, (byte)0x00, (byte)0xff, (byte)0xf8, (byte)0x00, (byte)0xcc, (byte)0xc2, (byte)0x00, (byte)0xcc, (byte)0xbd,
   (byte)0x00, (byte)0xff, (byte)0xe6, (byte)0x00, (byte)0xff, (byte)0xe0, (byte)0x00, (byte)0xff, (byte)0xda, (byte)0x00, (byte)0xff, (byte)0xd4,
   (byte)0x00, (byte)0xff, (byte)0xce, (byte)0x00, (byte)0xff, (byte)0xc8, (byte)0x00, (byte)0xff, (byte)0xc2, (byte)0x00, (byte)0xff, (byte)0xbc,
   (byte)0x00, (byte)0xcc, (byte)0x91, (byte)0x00, (byte)0xcc, (byte)0x8c, (byte)0x00, (byte)0xff, (byte)0xa9, (byte)0x00, (byte)0xff, (byte)0xa3,
   (byte)0x00, (byte)0xff, (byte)0x9d, (byte)0x00, (byte)0xff, (byte)0x97, (byte)0x00, (byte)0xff, (byte)0x91, (byte)0x00, (byte)0xff, (byte)0x8b,
   (byte)0x00, (byte)0xff, (byte)0x85, (byte)0x00, (byte)0xff, (byte)0x7f, (byte)0x00, (byte)0xcc, (byte)0x61, (byte)0x00, (byte)0xcc, (byte)0x5c,
   (byte)0x00, (byte)0xff, (byte)0x6d, (byte)0x00, (byte)0xff, (byte)0x67, (byte)0x00, (byte)0xff, (byte)0x61, (byte)0x00, (byte)0xff, (byte)0x5b,
   (byte)0x00, (byte)0xff, (byte)0x54, (byte)0x00, (byte)0xff, (byte)0x4e, (byte)0x00, (byte)0xff, (byte)0x48, (byte)0x00, (byte)0xff, (byte)0x42,
   (byte)0x00, (byte)0xcc, (byte)0x30, (byte)0x00, (byte)0xcc, (byte)0x2b, (byte)0x00, (byte)0xff, (byte)0x30, (byte)0x00, (byte)0xff, (byte)0x2a,
   (byte)0x00, (byte)0xff, (byte)0x24, (byte)0x00, (byte)0xff, (byte)0x1e, (byte)0x00, (byte)0xff, (byte)0x18, (byte)0x00, (byte)0xff, (byte)0x12,
   (byte)0x00, (byte)0xff, (byte)0x0c, (byte)0x00, (byte)0xff, (byte)0x06, (byte)0x00, (byte)0xcc, (byte)0x00, (byte)0x04, (byte)0xcc, (byte)0x00,
   (byte)0x0c, (byte)0xff, (byte)0x00, (byte)0x12, (byte)0xff, (byte)0x00, (byte)0x18, (byte)0xff, (byte)0x00, (byte)0x1e, (byte)0xff, (byte)0x00,
   (byte)0x24, (byte)0xff, (byte)0x00, (byte)0x2a, (byte)0xff, (byte)0x00, (byte)0x30, (byte)0xff, (byte)0x00, (byte)0x36, (byte)0xff, (byte)0x00,
   (byte)0x30, (byte)0xcc, (byte)0x00, (byte)0x35, (byte)0xcc, (byte)0x00, (byte)0x48, (byte)0xff, (byte)0x00, (byte)0x4e, (byte)0xff, (byte)0x00,
   (byte)0x55, (byte)0xff, (byte)0x00, (byte)0x5b, (byte)0xff, (byte)0x00, (byte)0x61, (byte)0xff, (byte)0x00, (byte)0x67, (byte)0xff, (byte)0x00,
   (byte)0x6d, (byte)0xff, (byte)0x00, (byte)0x73, (byte)0xff, (byte)0x00, (byte)0x61, (byte)0xcc, (byte)0x00, (byte)0x66, (byte)0xcc, (byte)0x00,
   (byte)0x85, (byte)0xff, (byte)0x00, (byte)0x8b, (byte)0xff, (byte)0x00, (byte)0x91, (byte)0xff, (byte)0x00, (byte)0x97, (byte)0xff, (byte)0x00,
   (byte)0x9d, (byte)0xff, (byte)0x00, (byte)0xa3, (byte)0xff, (byte)0x00, (byte)0xaa, (byte)0xff, (byte)0x00, (byte)0xb0, (byte)0xff, (byte)0x00,
   (byte)0x91, (byte)0xcc, (byte)0x00, (byte)0x96, (byte)0xcc, (byte)0x00, (byte)0xc2, (byte)0xff, (byte)0x00, (byte)0xc8, (byte)0xff, (byte)0x00,
   (byte)0xce, (byte)0xff, (byte)0x00, (byte)0xd4, (byte)0xff, (byte)0x00, (byte)0xda, (byte)0xff, (byte)0x00, (byte)0xe0, (byte)0xff, (byte)0x00,
   (byte)0xe6, (byte)0xff, (byte)0x00, (byte)0xec, (byte)0xff, (byte)0x00, (byte)0xc2, (byte)0xcc, (byte)0x00, (byte)0xc7, (byte)0xcc, (byte)0x00,
   (byte)0xff, (byte)0xff, (byte)0x00, (byte)0xff, (byte)0xf8, (byte)0x02, (byte)0xff, (byte)0xf2, (byte)0x05, (byte)0xff, (byte)0xeb, (byte)0x07,
   (byte)0xff, (byte)0xe5, (byte)0x0a, (byte)0xff, (byte)0xdf, (byte)0x0c, (byte)0xff, (byte)0xd8, (byte)0x0f, (byte)0xff, (byte)0xd2, (byte)0x11,
   (byte)0xcc, (byte)0xa3, (byte)0x10, (byte)0xcc, (byte)0x9e, (byte)0x12, (byte)0xff, (byte)0xbf, (byte)0x19, (byte)0xff, (byte)0xb8, (byte)0x1c,
   (byte)0xff, (byte)0xb2, (byte)0x1e, (byte)0xff, (byte)0xac, (byte)0x21, (byte)0xff, (byte)0xa5, (byte)0x23, (byte)0xff, (byte)0x9f, (byte)0x26,
   (byte)0xff, (byte)0x99, (byte)0x28, (byte)0xff, (byte)0x92, (byte)0x2b, (byte)0xcc, (byte)0x70, (byte)0x24, (byte)0xcc, (byte)0x6b, (byte)0x26,
   (byte)0xff, (byte)0x7f, (byte)0x33, (byte)0xff, (byte)0x79, (byte)0x30, (byte)0xff, (byte)0x73, (byte)0x2e, (byte)0xff, (byte)0x6e, (byte)0x2c,
   (byte)0xff, (byte)0x68, (byte)0x29, (byte)0xff, (byte)0x62, (byte)0x27, (byte)0xff, (byte)0x5c, (byte)0x25, (byte)0xff, (byte)0x56, (byte)0x22,
   (byte)0xcc, (byte)0x40, (byte)0x19, (byte)0xcc, (byte)0x3c, (byte)0x18, (byte)0xff, (byte)0x45, (byte)0x1b, (byte)0xff, (byte)0x3f, (byte)0x19,
   (byte)0xff, (byte)0x39, (byte)0x17, (byte)0xff, (byte)0x34, (byte)0x14, (byte)0xff, (byte)0x2e, (byte)0x12, (byte)0xff, (byte)0x28, (byte)0x10,
   (byte)0xff, (byte)0x22, (byte)0x0d, (byte)0xff, (byte)0x1c, (byte)0x0b, (byte)0xcc, (byte)0x12, (byte)0x07, (byte)0xcc, (byte)0x0d, (byte)0x05,
   (byte)0xff, (byte)0x0b, (byte)0x04, (byte)0xff, (byte)0x05, (byte)0x02, (byte)0xff, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff };

   
   
	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)rainbowValues[i*3];

	    // for  greens
	    greens[i] = (byte)rainbowValues[i*3+1];

	    // for blues
	    blues[i]  = (byte)rainbowValues[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());

	// new default rgb
	// pushPaletteValue();
  }

    // set the gray scale palette
    public void setGrayScalePalette() {

	// new default rgb
	pushPaletteValue();

	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)i;

	    // for  greens
	    greens[i] = (byte)i;

	    // for blues
	    blues[i]  = (byte)i;
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());	
	// new default rgb
	// pushPaletteValue();
  }

    // set the banded gray scale palette
    public void setBandedGrayScalePalette() {

	// new default rgb
	pushPaletteValue();

	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] values = {   // RGB,RGB, ....

   (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x33, (byte)0x33, (byte)0x33, (byte)0x29, (byte)0x29, (byte)0x29, (byte)0x1c, (byte)0x1c, (byte)0x1c,
   (byte)0x0e, (byte)0x0e, (byte)0x0e, (byte)0x05, (byte)0x05, (byte)0x05, (byte)0x02, (byte)0x02, (byte)0x02, (byte)0x07, (byte)0x07, (byte)0x07,
   (byte)0x12, (byte)0x12, (byte)0x12, (byte)0x21, (byte)0x21, (byte)0x21, (byte)0x31, (byte)0x31, (byte)0x31, (byte)0x3c, (byte)0x3c, (byte)0x3c,
   (byte)0x41, (byte)0x41, (byte)0x41, (byte)0x3e, (byte)0x3e, (byte)0x3e, (byte)0x34, (byte)0x34, (byte)0x34, (byte)0x27, (byte)0x27, (byte)0x27,
   (byte)0x19, (byte)0x19, (byte)0x19, (byte)0x10, (byte)0x10, (byte)0x10, (byte)0x0d, (byte)0x0d, (byte)0x0d, (byte)0x12, (byte)0x12, (byte)0x12,
   (byte)0x1d, (byte)0x1d, (byte)0x1d, (byte)0x2c, (byte)0x2c, (byte)0x2c, (byte)0x3c, (byte)0x3c, (byte)0x3c, (byte)0x47, (byte)0x47, (byte)0x47,
   (byte)0x4c, (byte)0x4c, (byte)0x4c, (byte)0x49, (byte)0x49, (byte)0x49, (byte)0x3f, (byte)0x3f, (byte)0x3f, (byte)0x32, (byte)0x32, (byte)0x32,
   (byte)0x24, (byte)0x24, (byte)0x24, (byte)0x1b, (byte)0x1b, (byte)0x1b, (byte)0x18, (byte)0x18, (byte)0x18, (byte)0x1c, (byte)0x1c, (byte)0x1c,
   (byte)0x28, (byte)0x28, (byte)0x28, (byte)0x37, (byte)0x37, (byte)0x37, (byte)0x47, (byte)0x47, (byte)0x47, (byte)0x52, (byte)0x52, (byte)0x52,
   (byte)0x57, (byte)0x57, (byte)0x57, (byte)0x54, (byte)0x54, (byte)0x54, (byte)0x4b, (byte)0x4b, (byte)0x4b, (byte)0x3d, (byte)0x3d, (byte)0x3d,
   (byte)0x2f, (byte)0x2f, (byte)0x2f, (byte)0x26, (byte)0x26, (byte)0x26, (byte)0x23, (byte)0x23, (byte)0x23, (byte)0x27, (byte)0x27, (byte)0x27,
   (byte)0x33, (byte)0x33, (byte)0x33, (byte)0x42, (byte)0x42, (byte)0x42, (byte)0x52, (byte)0x52, (byte)0x52, (byte)0x5d, (byte)0x5d, (byte)0x5d,
   (byte)0x62, (byte)0x62, (byte)0x62, (byte)0x5f, (byte)0x5f, (byte)0x5f, (byte)0x55, (byte)0x55, (byte)0x55, (byte)0x48, (byte)0x48, (byte)0x48,
   (byte)0x3a, (byte)0x3a, (byte)0x3a, (byte)0x31, (byte)0x31, (byte)0x31, (byte)0x2e, (byte)0x2e, (byte)0x2e, (byte)0x32, (byte)0x32, (byte)0x32,
   (byte)0x3e, (byte)0x3e, (byte)0x3e, (byte)0x4d, (byte)0x4d, (byte)0x4d, (byte)0x5d, (byte)0x5d, (byte)0x5d, (byte)0x68, (byte)0x68, (byte)0x68,
   (byte)0x6d, (byte)0x6d, (byte)0x6d, (byte)0x6a, (byte)0x6a, (byte)0x6a, (byte)0x60, (byte)0x60, (byte)0x60, (byte)0x53, (byte)0x53, (byte)0x53,
   (byte)0x45, (byte)0x45, (byte)0x45, (byte)0x3c, (byte)0x3c, (byte)0x3c, (byte)0x39, (byte)0x39, (byte)0x39, (byte)0x3d, (byte)0x3d, (byte)0x3d,
   (byte)0x49, (byte)0x49, (byte)0x49, (byte)0x58, (byte)0x58, (byte)0x58, (byte)0x68, (byte)0x68, (byte)0x68, (byte)0x73, (byte)0x73, (byte)0x73,
   (byte)0x78, (byte)0x78, (byte)0x78, (byte)0x75, (byte)0x75, (byte)0x75, (byte)0x6b, (byte)0x6b, (byte)0x6b, (byte)0x5e, (byte)0x5e, (byte)0x5e,
   (byte)0x50, (byte)0x50, (byte)0x50, (byte)0x47, (byte)0x47, (byte)0x47, (byte)0x44, (byte)0x44, (byte)0x44, (byte)0x48, (byte)0x48, (byte)0x48,
   (byte)0x54, (byte)0x54, (byte)0x54, (byte)0x63, (byte)0x63, (byte)0x63, (byte)0x73, (byte)0x73, (byte)0x73, (byte)0x7e, (byte)0x7e, (byte)0x7e,
   (byte)0x83, (byte)0x83, (byte)0x83, (byte)0x80, (byte)0x80, (byte)0x80, (byte)0x76, (byte)0x76, (byte)0x76, (byte)0x69, (byte)0x69, (byte)0x69,
   (byte)0x5b, (byte)0x5b, (byte)0x5b, (byte)0x52, (byte)0x52, (byte)0x52, (byte)0x4f, (byte)0x4f, (byte)0x4f, (byte)0x53, (byte)0x53, (byte)0x53,
   (byte)0x5f, (byte)0x5f, (byte)0x5f, (byte)0x6e, (byte)0x6e, (byte)0x6e, (byte)0x7e, (byte)0x7e, (byte)0x7e, (byte)0x89, (byte)0x89, (byte)0x89,
   (byte)0x8e, (byte)0x8e, (byte)0x8e, (byte)0x8b, (byte)0x8b, (byte)0x8b, (byte)0x81, (byte)0x81, (byte)0x81, (byte)0x74, (byte)0x74, (byte)0x74,
   (byte)0x66, (byte)0x66, (byte)0x66, (byte)0x5d, (byte)0x5d, (byte)0x5d, (byte)0x5a, (byte)0x5a, (byte)0x5a, (byte)0x5e, (byte)0x5e, (byte)0x5e,
   (byte)0x6a, (byte)0x6a, (byte)0x6a, (byte)0x79, (byte)0x79, (byte)0x79, (byte)0x89, (byte)0x89, (byte)0x89, (byte)0x94, (byte)0x94, (byte)0x94,
   (byte)0x99, (byte)0x99, (byte)0x99, (byte)0x96, (byte)0x96, (byte)0x96, (byte)0x8c, (byte)0x8c, (byte)0x8c, (byte)0x7f, (byte)0x7f, (byte)0x7f, 
   (byte)0x71, (byte)0x71, (byte)0x71, (byte)0x68, (byte)0x68, (byte)0x68, (byte)0x64, (byte)0x64, (byte)0x64, (byte)0x69, (byte)0x69, (byte)0x69,
   (byte)0x75, (byte)0x75, (byte)0x75, (byte)0x84, (byte)0x84, (byte)0x84, (byte)0x93, (byte)0x93, (byte)0x93, (byte)0x9f, (byte)0x9f, (byte)0x9f,
   (byte)0xa4, (byte)0xa4, (byte)0xa4, (byte)0xa1, (byte)0xa1, (byte)0xa1, (byte)0x97, (byte)0x97, (byte)0x97, (byte)0x8a, (byte)0x8a, (byte)0x8a,
   (byte)0x7c, (byte)0x7c, (byte)0x7c, (byte)0x72, (byte)0x72, (byte)0x72, (byte)0x6f, (byte)0x6f, (byte)0x6f, (byte)0x74, (byte)0x74, (byte)0x74,
   (byte)0x80, (byte)0x80, (byte)0x80, (byte)0x8f, (byte)0x8f, (byte)0x8f, (byte)0x9e, (byte)0x9e, (byte)0x9e, (byte)0xaa, (byte)0xaa, (byte)0xaa,
   (byte)0xaf, (byte)0xaf, (byte)0xaf, (byte)0xac, (byte)0xac, (byte)0xac, (byte)0xa2, (byte)0xa2, (byte)0xa2, (byte)0x95, (byte)0x95, (byte)0x95,
   (byte)0x87, (byte)0x87, (byte)0x87, (byte)0x7d, (byte)0x7d, (byte)0x7d, (byte)0x7a, (byte)0x7a, (byte)0x7a, (byte)0x7f, (byte)0x7f, (byte)0x7f,
   (byte)0x8b, (byte)0x8b, (byte)0x8b, (byte)0x9a, (byte)0x9a, (byte)0x9a, (byte)0xa9, (byte)0xa9, (byte)0xa9, (byte)0xb5, (byte)0xb5, (byte)0xb5,
   (byte)0xba, (byte)0xba, (byte)0xba, (byte)0xb7, (byte)0xb7, (byte)0xb7, (byte)0xad, (byte)0xad, (byte)0xad, (byte)0xa0, (byte)0xa0, (byte)0xa0,
   (byte)0x92, (byte)0x92, (byte)0x92, (byte)0x88, (byte)0x88, (byte)0x88, (byte)0x85, (byte)0x85, (byte)0x85, (byte)0x8a, (byte)0x8a, (byte)0x8a,
   (byte)0x96, (byte)0x96, (byte)0x96, (byte)0xa5, (byte)0xa5, (byte)0xa5, (byte)0xb4, (byte)0xb4, (byte)0xb4, (byte)0xc0, (byte)0xc0, (byte)0xc0,
   (byte)0xc5, (byte)0xc5, (byte)0xc5, (byte)0xc2, (byte)0xc2, (byte)0xc2, (byte)0xb8, (byte)0xb8, (byte)0xb8, (byte)0xab, (byte)0xab, (byte)0xab,
   (byte)0x9d, (byte)0x9d, (byte)0x9d, (byte)0x93, (byte)0x93, (byte)0x93, (byte)0x90, (byte)0x90, (byte)0x90, (byte)0x95, (byte)0x95, (byte)0x95,
   (byte)0xa1, (byte)0xa1, (byte)0xa1, (byte)0xb0, (byte)0xb0, (byte)0xb0, (byte)0xbf, (byte)0xbf, (byte)0xbf, (byte)0xcb, (byte)0xcb, (byte)0xcb,
   (byte)0xd0, (byte)0xd0, (byte)0xd0, (byte)0xcd, (byte)0xcd, (byte)0xcd, (byte)0xc3, (byte)0xc3, (byte)0xc3, (byte)0xb6, (byte)0xb6, (byte)0xb6,
   (byte)0xa8, (byte)0xa8, (byte)0xa8, (byte)0x9e, (byte)0x9e, (byte)0x9e, (byte)0x9b, (byte)0x9b, (byte)0x9b, (byte)0xa0, (byte)0xa0, (byte)0xa0,
   (byte)0xac, (byte)0xac, (byte)0xac, (byte)0xbb, (byte)0xbb, (byte)0xbb, (byte)0xca, (byte)0xca, (byte)0xca, (byte)0xd6, (byte)0xd6, (byte)0xd6,
   (byte)0xdb, (byte)0xdb, (byte)0xdb, (byte)0xd8, (byte)0xd8, (byte)0xd8, (byte)0xce, (byte)0xce, (byte)0xce, (byte)0xc0, (byte)0xc0, (byte)0xc0,
   (byte)0xb3, (byte)0xb3, (byte)0xb3, (byte)0xa9, (byte)0xa9, (byte)0xa9, (byte)0xa6, (byte)0xa6, (byte)0xa6, (byte)0xab, (byte)0xab, (byte)0xab,
   (byte)0xb6, (byte)0xb6, (byte)0xb6, (byte)0xc6, (byte)0xc6, (byte)0xc6, (byte)0xd5, (byte)0xd5, (byte)0xd5, (byte)0xe1, (byte)0xe1, (byte)0xe1,
   (byte)0xe6, (byte)0xe6, (byte)0xe6, (byte)0xe3, (byte)0xe3, (byte)0xe3, (byte)0xd9, (byte)0xd9, (byte)0xd9, (byte)0xcb, (byte)0xcb, (byte)0xcb,
   (byte)0xbe, (byte)0xbe, (byte)0xbe, (byte)0xb4, (byte)0xb4, (byte)0xb4, (byte)0xb1, (byte)0xb1, (byte)0xb1, (byte)0xb6, (byte)0xb6, (byte)0xb6,
   (byte)0xc1, (byte)0xc1, (byte)0xc1, (byte)0xd1, (byte)0xd1, (byte)0xd1, (byte)0xe0, (byte)0xe0, (byte)0xe0, (byte)0xec, (byte)0xec, (byte)0xec,
   (byte)0xf1, (byte)0xf1, (byte)0xf1, (byte)0xee, (byte)0xee, (byte)0xee, (byte)0xe4, (byte)0xe4, (byte)0xe4, (byte)0xd6, (byte)0xd6, (byte)0xd6,
   (byte)0xc9, (byte)0xc9, (byte)0xc9, (byte)0xbf, (byte)0xbf, (byte)0xbf, (byte)0xbc, (byte)0xbc, (byte)0xbc, (byte)0xc1, (byte)0xc1, (byte)0xc1,
   (byte)0xcc, (byte)0xcc, (byte)0xcc, (byte)0xdc, (byte)0xdc, (byte)0xdc, (byte)0xeb, (byte)0xeb, (byte)0xeb, (byte)0xf7, (byte)0xf7, (byte)0xf7,
   (byte)0xfc, (byte)0xfc, (byte)0xfc, (byte)0xf9, (byte)0xf9, (byte)0xf9, (byte)0xef, (byte)0xef, (byte)0xef, (byte)0xe1, (byte)0xe1, (byte)0xe1,
   (byte)0xd4, (byte)0xd4, (byte)0xd4, (byte)0xca, (byte)0xca, (byte)0xca, (byte)0xc7, (byte)0xc7, (byte)0xc7, (byte)0xcc, (byte)0xcc, (byte)0xcc,
   (byte)0xd7, (byte)0xd7, (byte)0xd7, (byte)0xe7, (byte)0xe7, (byte)0xe7, (byte)0xf6, (byte)0xf6, (byte)0xf6, (byte)0xfd, (byte)0xfd, (byte)0xfd,
   (byte)0xf8, (byte)0xf8, (byte)0xf8, (byte)0xfb, (byte)0xfb, (byte)0xfb, (byte)0xfa, (byte)0xfa, (byte)0xfa, (byte)0xec, (byte)0xec, (byte)0xec,
   (byte)0xdf, (byte)0xdf, (byte)0xdf, (byte)0xd5, (byte)0xd5, (byte)0xd5, (byte)0xd2, (byte)0xd2, (byte)0xd2, (byte)0xd7, (byte)0xd7, (byte)0xd7,
   (byte)0xe2, (byte)0xe2, (byte)0xe2, (byte)0xf2, (byte)0xf2, (byte)0xf2, (byte)0xfe, (byte)0xfe, (byte)0xfe, (byte)0xf2, (byte)0xf2, (byte)0xf2,
   (byte)0xed, (byte)0xed, (byte)0xed, (byte)0xf0, (byte)0xf0, (byte)0xf0, (byte)0xfa, (byte)0xfa, (byte)0xfa, (byte)0xf7, (byte)0xf7, (byte)0xf7,
   (byte)0xea, (byte)0xea, (byte)0xea, (byte)0xe0, (byte)0xe0, (byte)0xe0, (byte)0xdd, (byte)0xdd, (byte)0xdd, (byte)0xe2, (byte)0xe2, (byte)0xe2,
   (byte)0xed, (byte)0xed, (byte)0xed, (byte)0xfd, (byte)0xfd, (byte)0xfd, (byte)0xf3, (byte)0xf3, (byte)0xf3, (byte)0xe7, (byte)0xe7, (byte)0xe7,
   (byte)0xe3, (byte)0xe3, (byte)0xe3, (byte)0xe5, (byte)0xe5, (byte)0xe5, (byte)0xef, (byte)0xef, (byte)0xef, (byte)0xff, (byte)0xff, (byte)0xff };

	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)values[i*3];

	    // for  greens
	    greens[i] = (byte)values[i*3+1];

	    // for blues
	    blues[i]  = (byte)values[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());	

	// new default rgb
	// pushPaletteValue();
  }

    // set the inverted gray scale palette
    public void setInvertedGrayScalePalette() {

	// new default rgb
	pushPaletteValue();
	
	// specify how big it is.
	if (reds == null)
	   reds = new byte[256];
	if (greens == null)
	   greens = new byte[256];
	if (blues == null)
	   blues = new byte[256];

	byte[] values = {   // RGB,RGB, ....

   (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff, (byte)0xfe, (byte)0xfe, (byte)0xfe, (byte)0xfd, (byte)0xfd, (byte)0xfd,
   (byte)0xfc, (byte)0xfc, (byte)0xfc, (byte)0xfb, (byte)0xfb, (byte)0xfb, (byte)0xfa, (byte)0xfa, (byte)0xfa, (byte)0xf9, (byte)0xf9, (byte)0xf9,
   (byte)0xf8, (byte)0xf8, (byte)0xf8, (byte)0xf7, (byte)0xf7, (byte)0xf7, (byte)0xf6, (byte)0xf6, (byte)0xf6, (byte)0xf5, (byte)0xf5, (byte)0xf5,
   (byte)0xf4, (byte)0xf4, (byte)0xf4, (byte)0xf3, (byte)0xf3, (byte)0xf3, (byte)0xf2, (byte)0xf2, (byte)0xf2, (byte)0xf1, (byte)0xf1, (byte)0xf1,
   (byte)0xf0, (byte)0xf0, (byte)0xf0, (byte)0xef, (byte)0xef, (byte)0xef, (byte)0xee, (byte)0xee, (byte)0xee, (byte)0xed, (byte)0xed, (byte)0xed,
   (byte)0xec, (byte)0xec, (byte)0xec, (byte)0xeb, (byte)0xeb, (byte)0xeb, (byte)0xea, (byte)0xea, (byte)0xea, (byte)0xe9, (byte)0xe9, (byte)0xe9,
   (byte)0xe8, (byte)0xe8, (byte)0xe8, (byte)0xe7, (byte)0xe7, (byte)0xe7, (byte)0xe6, (byte)0xe6, (byte)0xe6, (byte)0xe5, (byte)0xe5, (byte)0xe5,
   (byte)0xe4, (byte)0xe4, (byte)0xe4, (byte)0xe3, (byte)0xe3, (byte)0xe3, (byte)0xe2, (byte)0xe2, (byte)0xe2, (byte)0xe1, (byte)0xe1, (byte)0xe1,
   (byte)0xe0, (byte)0xe0, (byte)0xe0, (byte)0xdf, (byte)0xdf, (byte)0xdf, (byte)0xde, (byte)0xde, (byte)0xde, (byte)0xdd, (byte)0xdd, (byte)0xdd,
   (byte)0xdc, (byte)0xdc, (byte)0xdc, (byte)0xdb, (byte)0xdb, (byte)0xdb, (byte)0xda, (byte)0xda, (byte)0xda, (byte)0xd9, (byte)0xd9, (byte)0xd9,
   (byte)0xd8, (byte)0xd8, (byte)0xd8, (byte)0xd7, (byte)0xd7, (byte)0xd7, (byte)0xd6, (byte)0xd6, (byte)0xd6, (byte)0xd5, (byte)0xd5, (byte)0xd5,
   (byte)0xd4, (byte)0xd4, (byte)0xd4, (byte)0xd3, (byte)0xd3, (byte)0xd3, (byte)0xd2, (byte)0xd2, (byte)0xd2, (byte)0xd1, (byte)0xd1, (byte)0xd1,
   (byte)0xd0, (byte)0xd0, (byte)0xd0, (byte)0xcf, (byte)0xcf, (byte)0xcf, (byte)0xce, (byte)0xce, (byte)0xce, (byte)0xcd, (byte)0xcd, (byte)0xcd,
   (byte)0xcc, (byte)0xcc, (byte)0xcc, (byte)0xcb, (byte)0xcb, (byte)0xcb, (byte)0xca, (byte)0xca, (byte)0xca, (byte)0xc9, (byte)0xc9, (byte)0xc9,
   (byte)0xc8, (byte)0xc8, (byte)0xc8, (byte)0xc7, (byte)0xc7, (byte)0xc7, (byte)0xc6, (byte)0xc6, (byte)0xc6, (byte)0xc5, (byte)0xc5, (byte)0xc5,
   (byte)0xc4, (byte)0xc4, (byte)0xc4, (byte)0xc3, (byte)0xc3, (byte)0xc3, (byte)0xc2, (byte)0xc2, (byte)0xc2, (byte)0xc1, (byte)0xc1, (byte)0xc1,
   (byte)0xc0, (byte)0xc0, (byte)0xc0, (byte)0xbf, (byte)0xbf, (byte)0xbf, (byte)0xbe, (byte)0xbe, (byte)0xbe, (byte)0xbd, (byte)0xbd, (byte)0xbd,
   (byte)0xbc, (byte)0xbc, (byte)0xbc, (byte)0xbb, (byte)0xbb, (byte)0xbb, (byte)0xba, (byte)0xba, (byte)0xba, (byte)0xb9, (byte)0xb9, (byte)0xb9,
   (byte)0xb8, (byte)0xb8, (byte)0xb8, (byte)0xb7, (byte)0xb7, (byte)0xb7, (byte)0xb6, (byte)0xb6, (byte)0xb6, (byte)0xb5, (byte)0xb5, (byte)0xb5,
   (byte)0xb4, (byte)0xb4, (byte)0xb4, (byte)0xb3, (byte)0xb3, (byte)0xb3, (byte)0xb2, (byte)0xb2, (byte)0xb2, (byte)0xb1, (byte)0xb1, (byte)0xb1,
   (byte)0xb0, (byte)0xb0, (byte)0xb0, (byte)0xaf, (byte)0xaf, (byte)0xaf, (byte)0xae, (byte)0xae, (byte)0xae, (byte)0xad, (byte)0xad, (byte)0xad,
   (byte)0xab, (byte)0xab, (byte)0xab, (byte)0xaa, (byte)0xaa, (byte)0xaa, (byte)0xa9, (byte)0xa9, (byte)0xa9, (byte)0xa8, (byte)0xa8, (byte)0xa8,
   (byte)0xa7, (byte)0xa7, (byte)0xa7, (byte)0xa6, (byte)0xa6, (byte)0xa6, (byte)0xa5, (byte)0xa5, (byte)0xa5, (byte)0xa4, (byte)0xa4, (byte)0xa4,
   (byte)0xa3, (byte)0xa3, (byte)0xa3, (byte)0xa2, (byte)0xa2, (byte)0xa2, (byte)0xa1, (byte)0xa1, (byte)0xa1, (byte)0xa0, (byte)0xa0, (byte)0xa0,
   (byte)0x9f, (byte)0x9f, (byte)0x9f, (byte)0x9e, (byte)0x9e, (byte)0x9e, (byte)0x9d, (byte)0x9d, (byte)0x9d, (byte)0x9c, (byte)0x9c, (byte)0x9c,
   (byte)0x9b, (byte)0x9b, (byte)0x9b, (byte)0x9a, (byte)0x9a, (byte)0x9a, (byte)0x99, (byte)0x99, (byte)0x99, (byte)0x98, (byte)0x98, (byte)0x98,
   (byte)0x97, (byte)0x97, (byte)0x97, (byte)0x96, (byte)0x96, (byte)0x96, (byte)0x95, (byte)0x95, (byte)0x95, (byte)0x94, (byte)0x94, (byte)0x94,
   (byte)0x93, (byte)0x93, (byte)0x93, (byte)0x92, (byte)0x92, (byte)0x92, (byte)0x91, (byte)0x91, (byte)0x91, (byte)0x90, (byte)0x90, (byte)0x90,
   (byte)0x8f, (byte)0x8f, (byte)0x8f, (byte)0x8e, (byte)0x8e, (byte)0x8e, (byte)0x8d, (byte)0x8d, (byte)0x8d, (byte)0x8c, (byte)0x8c, (byte)0x8c,
   (byte)0x8b, (byte)0x8b, (byte)0x8b, (byte)0x8a, (byte)0x8a, (byte)0x8a, (byte)0x89, (byte)0x89, (byte)0x89, (byte)0x88, (byte)0x88, (byte)0x88,
   (byte)0x87, (byte)0x87, (byte)0x87, (byte)0x86, (byte)0x86, (byte)0x86, (byte)0x85, (byte)0x85, (byte)0x85, (byte)0x84, (byte)0x84, (byte)0x84,
   (byte)0x83, (byte)0x83, (byte)0x83, (byte)0x82, (byte)0x82, (byte)0x82, (byte)0x81, (byte)0x81, (byte)0x81, (byte)0x80, (byte)0x80, (byte)0x80,
   (byte)0x7f, (byte)0x7f, (byte)0x7f, (byte)0x7e, (byte)0x7e, (byte)0x7e, (byte)0x7d, (byte)0x7d, (byte)0x7d, (byte)0x7c, (byte)0x7c, (byte)0x7c,
   (byte)0x7b, (byte)0x7b, (byte)0x7b, (byte)0x7a, (byte)0x7a, (byte)0x7a, (byte)0x79, (byte)0x79, (byte)0x79, (byte)0x78, (byte)0x78, (byte)0x78,
   (byte)0x77, (byte)0x77, (byte)0x77, (byte)0x76, (byte)0x76, (byte)0x76, (byte)0x75, (byte)0x75, (byte)0x75, (byte)0x74, (byte)0x74, (byte)0x74,
   (byte)0x73, (byte)0x73, (byte)0x73, (byte)0x72, (byte)0x72, (byte)0x72, (byte)0x71, (byte)0x71, (byte)0x71, (byte)0x70, (byte)0x70, (byte)0x70,
   (byte)0x6f, (byte)0x6f, (byte)0x6f, (byte)0x6e, (byte)0x6e, (byte)0x6e, (byte)0x6d, (byte)0x6d, (byte)0x6d, (byte)0x6c, (byte)0x6c, (byte)0x6c,
   (byte)0x6b, (byte)0x6b, (byte)0x6b, (byte)0x6a, (byte)0x6a, (byte)0x6a, (byte)0x69, (byte)0x69, (byte)0x69, (byte)0x68, (byte)0x68, (byte)0x68,
   (byte)0x67, (byte)0x67, (byte)0x67, (byte)0x66, (byte)0x66, (byte)0x66, (byte)0x65, (byte)0x65, (byte)0x65, (byte)0x64, (byte)0x64, (byte)0x64,
   (byte)0x63, (byte)0x63, (byte)0x63, (byte)0x62, (byte)0x62, (byte)0x62, (byte)0x61, (byte)0x61, (byte)0x61, (byte)0x60, (byte)0x60, (byte)0x60,
   (byte)0x5f, (byte)0x5f, (byte)0x5f, (byte)0x5e, (byte)0x5e, (byte)0x5e, (byte)0x5d, (byte)0x5d, (byte)0x5d, (byte)0x5c, (byte)0x5c, (byte)0x5c,
   (byte)0x5b, (byte)0x5b, (byte)0x5b, (byte)0x5a, (byte)0x5a, (byte)0x5a, (byte)0x59, (byte)0x59, (byte)0x59, (byte)0x58, (byte)0x58, (byte)0x58,
   (byte)0x57, (byte)0x57, (byte)0x57, (byte)0x55, (byte)0x55, (byte)0x55, (byte)0x54, (byte)0x54, (byte)0x54, (byte)0x53, (byte)0x53, (byte)0x53,
   (byte)0x52, (byte)0x52, (byte)0x52, (byte)0x51, (byte)0x51, (byte)0x51, (byte)0x50, (byte)0x50, (byte)0x50, (byte)0x4f, (byte)0x4f, (byte)0x4f,
   (byte)0x4e, (byte)0x4e, (byte)0x4e, (byte)0x4d, (byte)0x4d, (byte)0x4d, (byte)0x4c, (byte)0x4c, (byte)0x4c, (byte)0x4b, (byte)0x4b, (byte)0x4b,
   (byte)0x4a, (byte)0x4a, (byte)0x4a, (byte)0x49, (byte)0x49, (byte)0x49, (byte)0x48, (byte)0x48, (byte)0x48, (byte)0x47, (byte)0x47, (byte)0x47,
   (byte)0x46, (byte)0x46, (byte)0x46, (byte)0x45, (byte)0x45, (byte)0x45, (byte)0x44, (byte)0x44, (byte)0x44, (byte)0x43, (byte)0x43, (byte)0x43,
   (byte)0x42, (byte)0x42, (byte)0x42, (byte)0x41, (byte)0x41, (byte)0x41, (byte)0x40, (byte)0x40, (byte)0x40, (byte)0x3f, (byte)0x3f, (byte)0x3f,
   (byte)0x3e, (byte)0x3e, (byte)0x3e, (byte)0x3d, (byte)0x3d, (byte)0x3d, (byte)0x3c, (byte)0x3c, (byte)0x3c, (byte)0x3b, (byte)0x3b, (byte)0x3b,
   (byte)0x3a, (byte)0x3a, (byte)0x3a, (byte)0x39, (byte)0x39, (byte)0x39, (byte)0x38, (byte)0x38, (byte)0x38, (byte)0x37, (byte)0x37, (byte)0x37,
   (byte)0x36, (byte)0x36, (byte)0x36, (byte)0x35, (byte)0x35, (byte)0x35, (byte)0x34, (byte)0x34, (byte)0x34, (byte)0x33, (byte)0x33, (byte)0x33,
   (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x31, (byte)0x31, (byte)0x31, (byte)0x30, (byte)0x30, (byte)0x30, (byte)0x2f, (byte)0x2f, (byte)0x2f,
   (byte)0x2e, (byte)0x2e, (byte)0x2e, (byte)0x2d, (byte)0x2d, (byte)0x2d, (byte)0x2c, (byte)0x2c, (byte)0x2c, (byte)0x2b, (byte)0x2b, (byte)0x2b,
   (byte)0x2a, (byte)0x2a, (byte)0x2a, (byte)0x29, (byte)0x29, (byte)0x29, (byte)0x28, (byte)0x28, (byte)0x28, (byte)0x27, (byte)0x27, (byte)0x27,
   (byte)0x26, (byte)0x26, (byte)0x26, (byte)0x25, (byte)0x25, (byte)0x25, (byte)0x24, (byte)0x24, (byte)0x24, (byte)0x23, (byte)0x23, (byte)0x23,
   (byte)0x22, (byte)0x22, (byte)0x22, (byte)0x21, (byte)0x21, (byte)0x21, (byte)0x20, (byte)0x20, (byte)0x20, (byte)0x1f, (byte)0x1f, (byte)0x1f,
   (byte)0x1e, (byte)0x1e, (byte)0x1e, (byte)0x1d, (byte)0x1d, (byte)0x1d, (byte)0x1c, (byte)0x1c, (byte)0x1c, (byte)0x1b, (byte)0x1b, (byte)0x1b,
   (byte)0x1a, (byte)0x1a, (byte)0x1a, (byte)0x19, (byte)0x19, (byte)0x19, (byte)0x18, (byte)0x18, (byte)0x18, (byte)0x17, (byte)0x17, (byte)0x17,
   (byte)0x16, (byte)0x16, (byte)0x16, (byte)0x15, (byte)0x15, (byte)0x15, (byte)0x14, (byte)0x14, (byte)0x14, (byte)0x13, (byte)0x13, (byte)0x13,
   (byte)0x12, (byte)0x12, (byte)0x12, (byte)0x11, (byte)0x11, (byte)0x11, (byte)0x10, (byte)0x10, (byte)0x10, (byte)0x0f, (byte)0x0f, (byte)0x0f,
   (byte)0x0e, (byte)0x0e, (byte)0x0e, (byte)0x0d, (byte)0x0d, (byte)0x0d, (byte)0x0c, (byte)0x0c, (byte)0x0c, (byte)0x0b, (byte)0x0b, (byte)0x0b,
   (byte)0x0a, (byte)0x0a, (byte)0x0a, (byte)0x09, (byte)0x09, (byte)0x09, (byte)0x08, (byte)0x08, (byte)0x08, (byte)0x07, (byte)0x07, (byte)0x07,
   (byte)0x06, (byte)0x06, (byte)0x06, (byte)0x05, (byte)0x05, (byte)0x05, (byte)0x04, (byte)0x04, (byte)0x04, (byte)0x03, (byte)0x03, (byte)0x03,
   (byte)0x02, (byte)0x02, (byte)0x02, (byte)0x01, (byte)0x01, (byte)0x01, (byte)0x00, (byte)0x00, (byte)0x00, (byte)0xff, (byte)0xff, (byte)0xff };

   
	// set reds, greens and blues
	for (int i=0; i<256; i++) {

	    // for reds
	    reds[i]   = (byte)values[i*3];

	    // for  greens
	    greens[i] = (byte)values[i*3+1];

	    // for blues
	    blues[i]  = (byte)values[i*3+2];
	}

	// repaint the image associated with current palette
	setImage(getPaletteImage());	
	
	
  }

    // repaint image 
    public void setImage(Image img) {

	// set palette image
	this.pImage = img;

	// repaint it
	repaint();
	
    }

    // create palette image
    public Image getPaletteImage()  {
 
	// color model
	ColorModel   cm = currentColorModel();
	
	// Image producer
	MemoryImageSource src = new MemoryImageSource(pWidth,   // width of image
						      pHeight,  // height of the image
						      cm,       // color model
						      pImageData, // byte stream
						      0,        // offset
						      pWidth ); // scan number
	// create image
	Image img = null;
   	img       = Toolkit.getDefaultToolkit().createImage(src);
 
	return (Image)img; 
    }

    // create palette image
    public Image getPaletteImage(byte[] r, byte[] g, byte[] b)  {
 
	// color model
	ColorModel   cm = currentColorModel(r,g,b);
	
	// Image producer
	MemoryImageSource src = new MemoryImageSource(pWidth,   // width of image
						      pHeight,  // height of the image
						      cm,       // color model
						      pImageData, // byte stream
						      0,        // offset
						      pWidth ); // scan number
	// create image
	Image img = null;
   	img       = Toolkit.getDefaultToolkit().createImage(src);
 			  	 
	return (Image)img; 
    }

   /** Get a new color table. */    
  public ColorModel currentColorModel() {

    if (fiddleFlag) { // use newRed ...
	// fiddling
    	if ((newReds!=null) && (newGreens!=null)&&(newBlues!=null)) {	   
	   ImageColorModel cm = new ImageColorModel(newReds,newGreens,newBlues);
	   return (cm.getColorModel());
	}
	else {
	   // default color model
	   return ((ColorModel)getColorModel()); 
	} 

     }
     else {
	// normal
    	if ((reds!=null) && (greens!=null)&&(blues!=null)) {
	   // return new IndexColorModel(8, 256, reds,greens,blues);
	   ImageColorModel cm = new ImageColorModel(reds,greens,blues);
	   return (cm.getColorModel());
	}
	else {
	   // default color model
	   return ((ColorModel)getColorModel()); 
	} 
    } // if (fiddleFlag) { // use newRed ...

  }
    

   /** Get a new color table. */    
  public byte[] currentPaletteValue() {

	byte newPalette[] = null;

	// normal
    	if ((reds!=null) && (greens!=null)&&(blues!=null)) {
	
	    newPalette  = new byte[768];
	    for (int i = 0; i<256; i++) {
		newPalette[3*i]   = (byte)reds[i];
		newPalette[3*i+1] = (byte)greens[i];
		newPalette[3*i+2] = (byte)blues[i];
	    }
	}
	
	return newPalette;
  
  }
    

   /** Get a new color table. */    
  public ColorModel currentColorModel(byte[] r, byte[] g, byte[] b) {
	
    	if ((r!=null) && (g!=null)&&(b!=null)) {
	   
	   ImageColorModel cm = new ImageColorModel(r,g,b);
	   return (cm.getColorModel());
	}
	else {
	   // default color model
	   return ((ColorModel)getColorModel()); 
	} 

  }
    

  /** return the current image width  */
  public int getImageWidth() {
    return pWidth;
  }

 

 /** return the current image height  */
  public int getImageHeight() {
    
    return pHeight;
  }

    /**
     * Paints the component.
     * @param g the specified Graphics window
     * @see java.awt.Component#paint
     */
    public void paint(Graphics g) {
	
    	// get current Canvas size
    	int w = getSize().width;
    	int h = getSize().height;
    
    	// get the approciate position to display the image
    	int startx=0, starty=0;
 
    	// set the specified translated parameters 
    	// and the subcomponents will be relative to this origin.
    	// g.translate(-tx, -ty);
   
    
    	// If the image size is greater than the Canvas make the image shrink
    	int width;
    	int height;
    	width = getImageWidth();
    	height= getImageHeight();
    
    	if (width>w)
      	   startx = 0;
    	else
      	   startx = (w-width)/2;
    
    	if (height>h)
      	   starty = 0;
    	else
      	   starty = (h-height)/2;
       
    	if (pImage == null) {
      	   super.paint(g);
      	   // frame
      	   g.setColor(Color.red);
      	   g.drawRect(0,0,getSize().width, getSize().height);
      
      	   // info
      	   g.setColor(Color.black);
      	   FontMetrics fm = g.getFontMetrics();
      	   int x = (w - fm.stringWidth("No Image"))/2;
      	   int y = h/2;
      	   g.drawString("No image ", x, y);
      
    	} else {
  	
      	   // paint image
      	   g.drawImage(pImage, startx, starty,width, height, this);    
    	}
    	// set the specified translated parameters 
    	// and the subcomponents will be relative to this origin.
    	// g.translate(tx, ty);
  	
    }

    /**
   * Updates the component. This method is called in
   * response to a call to repaint. You can assume that
   * the background is not cleared.
   * @param g the specified Graphics window
   * @see java.awt.Component#update
   */
  public void update(Graphics g) {
  
    Dimension d = getSize();
    
    if (offScreenImage == null) {
      // offScreenImage not created; create it.
      // make the off-screen image big enough
      if ((d.width*d.height) < 500 * 500)
	  offScreenImage = createImage(500, 500);
      else
          offScreenImage = createImage(d.width, d.height);	
      
      // get the off-screen graphics context    
      offGraphics    = offScreenImage.getGraphics();
      
      // set the font for offGraphics
      offGraphics.setFont(getFont());	 
    }
    
    // paint the background on the off-screen graphics context
    offGraphics.setColor(getBackground());
    offGraphics.fillRect(0,0,d.width,d.height);    
    offGraphics.setColor(getForeground());
    
    
    // draw the current frame to the off-screen 
    paint(offGraphics);
    
    //then draw the image to the on-screen 
    g.drawImage(offScreenImage, 0, 0, null);
    
  }

    /**
     * java.util.Observer stuff
     */
    public void update(Observable o, Object cm)  {
    }

    // this instance let you flip the palette value */
    public void flipPalette() {

	if (fiddleFlag) { // use newRed,...
	   // flip array");
	   flipDataValue(newReds);
	   flipDataValue(newGreens);
	   flipDataValue(newBlues);
	}
	else {
	   // flip array");
	   flipDataValue(reds);
	   flipDataValue(greens);
	   flipDataValue(blues);
	}

	// repaint image
	setImage(getPaletteImage());

    }

    // this instance let you undo the palette value */
    public void undoPalette() {

	RGBValues   rgb = popPaletteValue();
	if (rgb == null)
	   return;

	// set rgb value
	setRGBValues(rgb.getRed(), rgb.getGreen(), rgb.getBlue());

    }

    // swap the data value 
    public void flipDataValue(byte[] data) {

	if (data != null) {

	   // data size
	   int size = data.length;

	   byte[] tmp = new byte[size];

	   for (int i=0; i<size; i++) 
		tmp[i] = data[size-i-1];
 
	   for (int i=0; i<size; i++) 
		data[i] = tmp[i];

	}

    }

    // this instance let you set the palette value randomly */
    public void setRandomPalette() {
	
	// set values

	Random rgbRandom = new Random();

	int rf = (int)(Math.random()*255);
	int gf = (int)(Math.random()*255);
	int bf = (int)(Math.random()*255);

	ImageColorModel icm = new ImageColorModel(rf,gf,bf);

	reds   = icm.getRed();
	greens = icm.getGreen();
	blues  = icm.getBlue();
	
	// repaint image
	setImage(getPaletteImage());

    }

    // this instance let you shift  the palette value to left or right*/
    public void shiftPalette(int deta) {

	reds   = shiftDataValue(reds,   deta);
  	greens = shiftDataValue(greens, deta);
	blues  = shiftDataValue(blues,  deta);
	
	// repaint image
	setImage(getPaletteImage());

    }

    // shift the data value 
    public byte[] shiftDataValue(byte[] data, int deta) {

	byte[] retVal;

	if (data != null) {
 	
	   // data size
	   int size = data.length;

	    retVal = new  byte[size];

	   if (deta > 0) {  // shift to right
			
		// fill the left part
	   	for (int i=0; i<deta; i++) 
		    retVal[i] = data[size-deta+i];

		// shift the data to right(deta)
		for (int i=deta; i<size; i++) 
		    retVal[i] = data[i-deta];
	   }
	   else { // shift to left

		deta = Math.abs(deta);

		// fill the left part
	   	for (int i=0; i<(size-deta); i++) 
		    retVal[i] = data[deta+i];

		// shift the data to right(deta)
		for (int i=(size-deta); i<size; i++) 
		    retVal[i] = data[i-(size-deta)];

	   }
	   // return value
	   return retVal;
	}
	else
	   return null;
    }

    // this instance let you transform  the palette value 
    // by magnification or reduction
    public void transPalette(int factor) {

	// set data value
	newReds   = transDataValue(reds,   factor);
  	newGreens = transDataValue(greens, factor);
	newBlues  = transDataValue(blues,  factor);

	// repaint image
	setImage(getPaletteImage(newReds, newGreens, newBlues));


    }

    // transform  the data value 
    public byte[] transDataValue(byte[] data, int factor) {

	byte[] retVal;

	if (data != null) {
 	
	   // data size
	   int size = data.length;
	   int pos = size/2; // spreaded by the central point
	   int pFactor = Math.abs(factor);
	   // valid?
	   if (pFactor>10) {
		this.fiddleFactor = 0;
		return null;	    
	   }

	   retVal = new  byte[size];

	   if (factor > 0) {  // amplification
			
		// fill the left part
	   	int kk = pos, i=pos;
 		while(kk>=0) {

		    for (int j=0; j<factor; j++) {  // repeat 
			if (kk>=0)
		    	   retVal[kk--] = data[i];
			else
			   break;
		     }

		     // one position to left
		     --i;

		}

		// fill the right part
	   	int pp = pos+1; i=pos+1;
 		while(pp<size) {

		    for (int j=0; j<factor; j++) {  // repeat 
			if (pp<size)
		    	    retVal[pp++] = data[i];
			else
			    break;
		     }
			
		     // one position to left
		     ++i;
		}

	   }
	   else { // shrinkage
		
		// fill the left part
	   	int kk = pos, i=pos;
		int pVal = 0;
 		while((i>0)&&(kk>0)) {

		    pVal = 0;
		    int j=0;
		    for ( j=0; j<pFactor; j++) { // repeat 
			if (i>0)
		    	   pVal += data[i--];
			else
			   break;
		    }

		    // get palette value
		    pVal /= (j+1);

		    retVal[kk--] = (byte)pVal;

		}
		
		// fill the rest left part 
		for (int pp=kk; pp>0;pp--)
		    retVal[pp] = (byte)pVal;

		// fill the right part
	   	kk = pos+1;
		i  = pos;
 		while((i<size)&&(kk<size)) {

		    pVal = 0;
		    int j;
		    for ( j=0; j<pFactor; j++) { // repeat 
			if (i<size)
		    	   pVal += data[i++];
			else
			   break;
		    }

		    // get palette value
		    pVal /= (j+1);

		    retVal[kk++] = (byte)pVal;
		}
		
		// fill the rest left part 
		for (int pp=kk; pp<size;pp++)
		    retVal[pp] = (byte)pVal;
		
	   }
	   // return value
	   return retVal;
	}
	else
	   return null;
    }

    public void setRedValues(byte[] reds) {
	this.reds = reds;
	setImage((Image)getPaletteImage());
    }

    public void setRGBValues(byte[] r, byte[] g, byte[] b) {
	this.reds     = r;
	this.greens   = g;
	this.blues    = b;
	setImage((Image)getPaletteImage());
    }

    public void setFiddleValues() {

	if (fiddleFlag) { // from "unselect" to "select"

		// keep the rgb as the new rgb;
		this.newReds  = this.reds;
   		this.newGreens= this.greens;
		this.newBlues = this.blues ;
	}
	else { // "select" to "unselect"
		this.reds     = this.newReds;
		this.greens   = this.newGreens;
		this.blues    = this.newBlues;
	}

	// setImage((Image)getPaletteImage());
    }

    public byte[] getRedValues() {
	return reds;
    }

    public void setGreenValues(byte[] greens) {
	this.greens = greens;
	setImage((Image)getPaletteImage());
    }

    public byte[] getGreenValues() {
	return greens;
    }

    public void setBlueValues(byte[] blues) {
	this.blues = blues;
	setImage((Image)getPaletteImage());
    }

    public byte[] getBlueValues() {
	return blues;
    }

   /**
     * Called if the mouse is down.
     */
    public void mousePressed(MouseEvent evt) {
	
	// keep old rgb value
	pushPaletteValue();
 
	// keep mouse points
	xpos = evt.getX(); 
	ypos = evt.getY();

    }

    /**
     * Called if the mouse is dragged (the mouse button is down)
     */
    public void mouseDragged(MouseEvent evt) {

	int x = evt.getX();
	int y = evt.getY();

	if (fiddleFlag) {
   
	   // shift value and then get the fiddle factor 
	   // the fiddle factor will be given by the shift value divided by 10
	   int deta = (y-ypos)/10;

	   if (deta != 0) {
	   	// adjust the current transform factor
	  	fiddleFactor += deta;
		
	   	// make change of palette value
	   	transPalette(fiddleFactor);
	    }

	    // keep the current position
	    // ypos = y;

	}
	else {   // for shift
	   // shift value
	   int deta = x-xpos;

	   // make change of palette value
	   shiftPalette(deta);

	    // keep the current position
	    xpos = x;
	}
    	
    }

    /**
     * Called if the mouse is up.
     */
    public void mouseReleased(MouseEvent evt) {

	if (parent == null)
	   ((PalettePanel)getParent()).PaletteCanvasMouseUp(evt);
 	else
	   parent.PaletteCanvasMouseUp(evt);

    }

    // Put RGB Values into stack    
    public void pushPaletteValue() {
	
	// size of the stack
	int size = paletteStack.size();

	if (size > PALETTESTACKSIZE) { // WHich size is better?

	   // nothing to do
	   ;
	}
	else {

	   byte[] r = getRedValues();
	   byte[] g = getGreenValues();
	   byte[] b = getBlueValues();

	   if ((r!=null) && (g!=null)&&(b!=null)) {
	   	// current RGB value
	        RGBValues	rgb = new RGBValues(r,    // red
						    g,    // green
						    b);   // blue
		
	  	 // put the current RGB into stack	   
	   	paletteStack.push(rgb);
	   }
	}
	
    }

    // Put RGB Values into stack    
    // pop up the  rgb value from stack
    public RGBValues popPaletteValue() {

	RGBValues   rgb = null;
	
	if (!paletteStack.empty()) // stack has at least one elment
	    rgb = (RGBValues)paletteStack.pop();

	return rgb;
    }

    /**
     * Called when the mouse exits the component.
     */
    public void mouseExited(MouseEvent evt) {
	
		// set cursor type
		setCursor(Cursor.getDefaultCursor());
	
		// A generic  Toolkit component. 
		Toolkit	   tk = getToolkit();

		// Syncs the graphics state;
		tk.sync();
    }

    /**
     * Called when the mouse enters the component.
     */
   public void mouseEntered(MouseEvent evt) {

	// set cursor type (for JDK-1.1)
	setCursor(new Cursor(Cursor.HAND_CURSOR));

	// A generic  Toolkit component. 
	Toolkit	   tk = getToolkit();

	// Syncs the graphics state;
	tk.sync();	
    }

    /**
     * Called automatically by the system the application is started.
     */
    public static void main(String args[]) {

	Frame myFrame = new Frame();

	myFrame.setLayout(new BorderLayout());

	PaletteCanvas p = new PaletteCanvas();

	myFrame.add("Center", p);
	myFrame.setSize(300,300);
	myFrame.setVisible(true);
	
    }

     protected void processEvent(AWTEvent e) {

       if (e instanceof MouseEvent) {
            switch(e.getID()) {
              case MouseEvent.MOUSE_PRESSED:
              case MouseEvent.MOUSE_RELEASED:
              case MouseEvent.MOUSE_CLICKED:
              case MouseEvent.MOUSE_ENTERED:
              case MouseEvent.MOUSE_EXITED:
                processMouseEvent((MouseEvent)e);
                break;
              case MouseEvent.MOUSE_MOVED:
              case MouseEvent.MOUSE_DRAGGED:
                processMouseMotionEvent((MouseEvent)e);
                break;

            }	
      } else
	super.processEvent(e);

     }

 protected void processMouseEvent(MouseEvent e) {
       
            int id = e.getID();
            switch(id) {
              case MouseEvent.MOUSE_PRESSED:
                mousePressed(e);
                break;
              case MouseEvent.MOUSE_RELEASED:
                mouseReleased(e);
                break;
               case MouseEvent.MOUSE_EXITED:
                mouseExited(e);
                break;
              case MouseEvent.MOUSE_ENTERED:
                mouseEntered(e);
                break;
            }
         
    }

 protected void processMouseMotionEvent(MouseEvent e) {
       
            int id = e.getID();
            switch(id) {
              case MouseEvent.MOUSE_MOVED:
                // mouseMoved(e);
                break;
              case MouseEvent.MOUSE_DRAGGED:
               mouseDragged(e);
                break;
            }
        
    }
}
